/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import java.util.Arrays;
import java.util.HashMap;

public class ResourceTable {
    private HashMap table;

    public ResourceTable() {
        this.table = new HashMap();
    }

    public ResourceTable(int n) {
        this.table = new HashMap(n);
    }

    public synchronized boolean acquire(String[] objectArray, int n) throws InterruptedException {
        long l;
        if (n <= 0) {
            throw new IllegalArgumentException("timeout required");
        }
        if (objectArray.length > 1) {
            Object[] objectArray2 = new String[objectArray.length];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray2.length);
            Arrays.sort(objectArray2);
            objectArray = objectArray2;
        }
        long l2 = l = System.currentTimeMillis();
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                String string = objectArray[i];
                Object var9_9 = null;
                while (true) {
                    Object v = this.table.get(string);
                    var9_9 = v;
                    if (v == null) break;
                    long l3 = l + (long)n - l2;
                    if (l3 < 0L) {
                        this.release((String[])objectArray);
                        return false;
                    }
                    this.wait(l3);
                    l2 = System.currentTimeMillis();
                }
                this.table.put(string, Thread.currentThread());
            }
            return true;
        }
        catch (InterruptedException interruptedException) {
            this.release((String[])objectArray);
            throw interruptedException;
        }
    }

    public synchronized void release(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            Object v = this.table.get(stringArray[i]);
            if (v != Thread.currentThread()) continue;
            this.table.remove(stringArray[i]);
        }
        this.notifyAll();
    }
}

