/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.JavaTestError;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.util.Hashtable;

class TRT_TreeNode
implements TestResultTable.TreeNode {
    private Object[] childs = null;
    private TRT_TreeNode parent;
    private TestResultTable table;
    private int counter = 0;
    private int[] childStats;
    private String name = null;
    private long lastScanDate;
    private static Hashtable observerTable = new Hashtable(16);
    private String[] filesToScan;
    protected static int debug = Debug.getInt(class$com$sun$javatest$TRT_TreeNode == null ? (class$com$sun$javatest$TRT_TreeNode = TRT_TreeNode.class$("com.sun.javatest.TRT_TreeNode")) : class$com$sun$javatest$TRT_TreeNode);
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$TRT_TreeNode == null ? (class$com$sun$javatest$TRT_TreeNode = TRT_TreeNode.class$("com.sun.javatest.TRT_TreeNode")) : class$com$sun$javatest$TRT_TreeNode);
    static /* synthetic */ Class class$com$sun$javatest$TRT_TreeNode;

    public synchronized void addObserver(TestResultTable.TreeNodeObserver treeNodeObserver) {
        Object[] objectArray = (TestResultTable.TreeNodeObserver[])observerTable.get(this);
        if (objectArray == null) {
            objectArray = new TestResultTable.TreeNodeObserver[]{};
        }
        objectArray = (TestResultTable.TreeNodeObserver[])DynamicArray.append(objectArray, treeNodeObserver);
        observerTable.put(this, objectArray);
    }

    public synchronized void removeObserver(TestResultTable.TreeNodeObserver treeNodeObserver) {
        Object[] objectArray = (TestResultTable.TreeNodeObserver[])observerTable.get(this);
        if (objectArray == null) {
            return;
        }
        if ((objectArray = (TestResultTable.TreeNodeObserver[])DynamicArray.remove(objectArray, treeNodeObserver)) == null) {
            observerTable.remove(this);
        } else {
            observerTable.put(this, objectArray);
        }
    }

    public int getSize() {
        this.scanSubtree(this);
        return this.counter;
    }

    public TestResultTable.TreeNode getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public TestResultTable getEnclosingTable() {
        return this.table;
    }

    public boolean isUpToDate() {
        return this.lastScanDate != 0L;
    }

    public int getChildCount() {
        this.scanIfNeeded();
        if (this.childs == null) {
            return 0;
        }
        return this.childs.length;
    }

    public Object getChild(int n) {
        return this.getChild(n, false);
    }

    Object getChild(int n, boolean bl) {
        if (!bl) {
            this.scanIfNeeded();
        }
        if (this.childs == null || n >= this.childs.length) {
            return null;
        }
        return this.childs[n];
    }

    public TestResult[] getTestResults() {
        this.scanIfNeeded();
        TestResult[] testResultArray = null;
        if (this.childs != null && this.childs.length != 0) {
            for (int i = 0; i < this.childs.length; ++i) {
                if (!(this.childs[i] instanceof TestResult)) continue;
                testResultArray = (TestResult[])DynamicArray.append(testResultArray, this.childs[i]);
            }
        }
        return testResultArray;
    }

    public TestResultTable.TreeNode[] getTreeNodes() {
        this.scanIfNeeded();
        if (this.childs == null) {
            return null;
        }
        TestResultTable.TreeNode[] treeNodeArray = null;
        for (int i = 0; i < this.childs.length; ++i) {
            if (!(this.childs[i] instanceof TestResultTable.TreeNode)) continue;
            treeNodeArray = (TestResultTable.TreeNode[])DynamicArray.append(treeNodeArray, this.childs[i]);
        }
        return treeNodeArray;
    }

    public String getName() {
        return this.name;
    }

    public boolean isLeaf(int n) {
        this.scanIfNeeded();
        if (n < 0 || n >= this.childs.length) {
            return false;
        }
        if (this.childs[n] instanceof TestResult) {
            return true;
        }
        if (this.childs[n] instanceof TRT_TreeNode) {
            return this.childs == null || this.childs.length == 0;
        }
        return false;
    }

    public int[] getChildStatus() {
        this.scanSubtree(this);
        if (this.childStats == null) {
            TRT_TreeNode.refreshChildStats(this);
        }
        return this.childStats;
    }

    public int getIndex(Object object) {
        return this.getIndex(object, false);
    }

    int getIndex(Object object, boolean bl) {
        if (!bl) {
            this.scanIfNeeded();
        }
        if (object == null) {
            return -2;
        }
        for (int i = 0; i < this.childs.length; ++i) {
            if (this.childs[i] != object) continue;
            return i;
        }
        return -1;
    }

    public TestResult matchTest(String string) {
        this.scanIfNeeded();
        if (debug > 1) {
            Debug.println("Matching Test URL: " + this.name + " in " + this);
        }
        TestResult testResult = null;
        if (this.childs == null || this.childs.length == 0) {
            return null;
        }
        for (int i = 0; i < this.childs.length; ++i) {
            if (!(this.childs[i] instanceof TestResult)) continue;
            TestResult testResult2 = (TestResult)this.childs[i];
            try {
                String string2 = testResult2.getDescription().getRootRelativeURL();
            }
            catch (TestResult.Fault fault) {
                throw new JavaTestError(i18n, "trttn.noTd", fault);
            }
            if (debug > 1) {
                Debug.println("   -> trying to match against " + this.name);
            }
            if (this.name.equals(string)) {
                testResult = (TestResult)this.childs[i];
                i = this.childs.length;
                continue;
            }
            testResult = null;
        }
        return testResult;
    }

    TRT_TreeNode(TestResultTable testResultTable, TestResultTable.TreeNode treeNode) {
        this.table = testResultTable;
        this.parent = (TRT_TreeNode)treeNode;
    }

    int getCurrentSize() {
        return this.counter;
    }

    void incChildStat(int n) {
        int n2 = n;
        this.childStats[n2] = this.childStats[n2] + 1;
    }

    void decChildStat(int n) {
        int n2 = n;
        this.childStats[n2] = this.childStats[n2] - 1;
    }

    void invalidateChildStats() {
        this.childStats = null;
        this.notifyCounterChange();
        TRT_TreeNode tRT_TreeNode = (TRT_TreeNode)this.getParent();
        if (tRT_TreeNode != null) {
            tRT_TreeNode.invalidateChildStats();
        }
    }

    boolean isChildStatsValid() {
        return this.childStats == null;
    }

    static void bubbleUpChildStat(TRT_TreeNode tRT_TreeNode, int n) {
        int n2 = n;
        tRT_TreeNode.childStats[n2] = tRT_TreeNode.childStats[n2] + 1;
        TRT_TreeNode tRT_TreeNode2 = (TRT_TreeNode)tRT_TreeNode.getParent();
        if (tRT_TreeNode2 != null) {
            TRT_TreeNode.bubbleUpChildStat(tRT_TreeNode2, n);
        }
    }

    static void swapChildStat(TRT_TreeNode tRT_TreeNode, int n, int n2) {
        int n3 = n;
        tRT_TreeNode.childStats[n3] = tRT_TreeNode.childStats[n3] - 1;
        int n4 = n2;
        tRT_TreeNode.childStats[n4] = tRT_TreeNode.childStats[n4] + 1;
        TRT_TreeNode tRT_TreeNode2 = (TRT_TreeNode)tRT_TreeNode.getParent();
        if (tRT_TreeNode2 != null) {
            TRT_TreeNode.swapChildStat(tRT_TreeNode2, n, n2);
        }
    }

    void incNodeCounter() {
        ++this.counter;
    }

    TestResult getTestResult(String string) {
        int n = this.getTestIndex(string);
        if (n != -1) {
            try {
                return (TestResult)this.getChild(n);
            }
            catch (ClassCastException classCastException) {
                throw new JavaTestError(i18n, "trttn.badCast");
            }
        }
        return null;
    }

    TRT_TreeNode getTreeNode(String string, boolean bl) {
        int n;
        if (!bl) {
            this.scanIfNeeded();
        }
        if ((n = this.getNodeIndex(string, bl)) != -1) {
            try {
                return (TRT_TreeNode)this.getChild(n, bl);
            }
            catch (ClassCastException classCastException) {
                throw new JavaTestError(i18n, "trttn.badCast");
            }
        }
        return null;
    }

    int getTestIndex(String string) {
        if (string == null) {
            throw new JavaTestError(i18n, "trttn.nullSearch");
        }
        int n = this.getResultIndex(TestResult.getWorkRelativePath(string), false);
        return n;
    }

    synchronized int getResultIndex(String string, boolean bl) {
        if (string == null) {
            throw new JavaTestError(i18n, "trttn.nullSearch");
        }
        if (!bl) {
            this.scanIfNeeded();
        }
        int n = -1;
        if (this.childs != null && this.childs.length != 0) {
            for (int i = 0; i < this.childs.length; ++i) {
                TestResult testResult;
                if (!(this.childs[i] instanceof TestResult) || !(testResult = (TestResult)this.childs[i]).getWorkRelativePath().equals(string)) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    int getTestIndex(TestResult testResult, boolean bl) {
        if (testResult == null) {
            throw new JavaTestError(i18n, "trttn.nullSearch");
        }
        int n = this.getResultIndex(testResult.getWorkRelativePath(), bl);
        return n;
    }

    synchronized int getNodeIndex(String string, boolean bl) {
        if (!bl) {
            this.scanIfNeeded();
        }
        int n = -1;
        if (string == null) {
            throw new JavaTestError(i18n, "trttn.nullSearch");
        }
        if (this.childs == null || this.childs.length == 0) {
            n = -1;
        } else {
            for (int i = 0; i < this.childs.length; ++i) {
                TRT_TreeNode tRT_TreeNode;
                if (!(this.childs[i] instanceof TRT_TreeNode) || !(tRT_TreeNode = (TRT_TreeNode)this.childs[i]).getName().equals(string)) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    synchronized void scanIfNeeded() {
        if (debug > 0) {
            Debug.println("starting scanIfNeeded() on node " + this.getName());
        }
        if (this.table.getTestFinder() == null || this.isUpToDate()) {
            return;
        }
        if (this.childs == null) {
            this.childs = new Object[0];
        }
        if (this.isRoot() && this.filesToScan == null) {
            File file = this.table.getTestSuiteRoot();
            this.lastScanDate = this.table.getLastModifiedTime(file);
            this.processFile(file);
            if (this.filesToScan == null) {
                this.filesToScan = new String[0];
            }
        }
        if (this.filesToScan != null) {
            for (int i = 0; i < this.filesToScan.length; ++i) {
                File file = new File(this.getTestSuiteRootPathPrefix() + File.separator + TestResultTable.getRootRelativePath(this));
                this.lastScanDate = this.table.getLastModifiedTime(file);
                if (this.filesToScan[i] == this.name) {
                    this.processFile(file);
                    continue;
                }
                this.processFile(new File(this.getTestSuiteRootPathPrefix() + File.separator + TestResultTable.getRootRelativePath(this), this.filesToScan[i]));
            }
        } else {
            if (debug > 0) {
                Debug.println("refreshing contents of " + this.getName() + this.lastScanDate);
            }
            this.refreshIfNeeded();
        }
    }

    synchronized TestResult resetTest(int n, TestResult testResult) {
        if (this.childs[n] != testResult) {
            return null;
        }
        File file = testResult.getFile();
        if (file == null && this.table.getWorkDirectory() != null) {
            file = this.table.getWorkDirectory().getFile(testResult.getWorkRelativePath());
        }
        if (file != null) {
            boolean bl = file.delete();
        }
        String string = testResult.getTestName();
        String string2 = null;
        int n2 = string.lastIndexOf(47);
        int n3 = string.lastIndexOf(35);
        string2 = n3 > n2 ? string.substring(0, n3) : string;
        TestResult testResult2 = null;
        TestDescription testDescription = null;
        try {
            testDescription = testResult.getDescription();
        }
        catch (TestResult.Fault fault) {
            // empty catch block
        }
        TestDescription testDescription2 = this.updateTestDescription(string, testDescription);
        testResult2 = TestResult.notRun(testDescription2);
        if (testResult2 != null) {
            return this.replaceTest(testResult2, n);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean refreshIfNeeded() {
        if (this.filesToScan != null || this.table != null && this.table.isFinderScanSuppressed() && this.lastScanDate == 0L) {
            File file = new File(this.getTestSuiteRootPathPrefix() + File.separator + TestResultTable.getRootRelativePath(this));
            TestFinder testFinder = this.table.getTestFinder();
            File[] fileArray = null;
            long l = this.table.getLastModifiedTime(file);
            TestFinder testFinder2 = testFinder;
            synchronized (testFinder2) {
                testFinder.read(file);
                File[] fileArray2 = testFinder.getFiles();
                fileArray = new File[fileArray2.length];
                System.arraycopy(fileArray2, 0, fileArray, 0, fileArray2.length);
            }
            this.lastScanDate = l;
            for (int i = 0; i < fileArray.length; ++i) {
                if (this.table.isBranchFile(fileArray[i])) {
                    this.updateDirectory(fileArray[i]);
                    continue;
                }
                if (this.table.getLastModifiedTime(fileArray[i]) <= this.lastScanDate) continue;
                this.updateFile(fileArray[i]);
            }
        } else if (debug > 0) {
            Debug.println("nothing to refresh in " + this.getName());
        }
        return true;
    }

    synchronized TestResult refreshIfNeeded(TestResult testResult) {
        TestResult testResult2 = null;
        try {
            TestDescription testDescription = testResult.getDescription();
            TestDescription testDescription2 = this.updateTestDescription(testResult.getTestName(), testDescription);
            if (testDescription == testDescription2) {
                testResult2 = testResult;
            } else {
                TestResult testResult3 = TestResult.notRun(testDescription2);
                if (testResult3 != null) {
                    this.addChild(testResult3, false);
                    testResult2 = testResult3;
                }
            }
        }
        catch (TestResult.Fault fault) {
            if (debug > 0) {
                fault.printStackTrace(Debug.getWriter());
            }
            testResult2 = testResult;
        }
        return testResult2;
    }

    synchronized boolean updateDirectory(File file) {
        boolean bl;
        block7: {
            TestResultTable.TreeNode[] treeNodeArray = this.getTreeNodes();
            String string = this.makeNodeRelative(file);
            bl = false;
            if (treeNodeArray != null) {
                for (int i = 0; i < treeNodeArray.length; ++i) {
                    if (!treeNodeArray[i].getName().equals(string)) continue;
                    bl = true;
                    break;
                }
            } else {
                bl = false;
            }
            if (!bl) {
                try {
                    TRT_TreeNode tRT_TreeNode = this.createDirNode(this, string);
                    int n = this.getIndex(tRT_TreeNode);
                    this.notifyInsBranch(tRT_TreeNode, n);
                    TestResultTable.TreeNode[] treeNodeArray2 = TestResultTable.getObjectPath(tRT_TreeNode);
                    TestResultTable.TreeNode[] treeNodeArray3 = new TRT_TreeNode[treeNodeArray2.length - 1];
                    System.arraycopy(treeNodeArray2, 0, treeNodeArray3, 0, treeNodeArray2.length - 1);
                    this.table.notifyNewBranch(treeNodeArray3, tRT_TreeNode, n);
                    tRT_TreeNode.scanIfNeeded();
                }
                catch (Fault fault) {
                    if (debug <= 0) break block7;
                    fault.printStackTrace(Debug.getWriter());
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean updateFile(File file) {
        Object object;
        if (debug > 1) {
            System.out.println("Updating file " + file.getPath());
        }
        TestFinder testFinder = this.table.getTestFinder();
        TestDescription[] testDescriptionArray = null;
        TestFinder testFinder2 = testFinder;
        synchronized (testFinder2) {
            testFinder.read(file);
            object = testFinder.getTests();
            testDescriptionArray = new TestDescription[((TestDescription[])object).length];
            System.arraycopy(object, 0, testDescriptionArray, 0, ((TestDescription[])object).length);
        }
        for (int i = 0; i < testDescriptionArray.length; ++i) {
            object = this.getTestResult(testDescriptionArray[i].getRootRelativeURL());
            TestDescription testDescription = null;
            try {
                if (object != null) {
                    testDescription = ((TestResult)object).getDescription();
                }
            }
            catch (TestResult.Fault fault) {
                // empty catch block
            }
            if (object != null && testDescription != null && testDescriptionArray[i].equals(testDescription)) continue;
            TestResult testResult = TestResult.notRun(testDescriptionArray[i]);
            this.table.update(testResult, false);
            if (debug > 1) {
                System.out.println("New test added");
            }
            TestResultTable.TreeNode[] treeNodeArray = TestResultTable.getObjectPath(this);
            int n = this.getTestIndex(testResult, false);
            if (object == null) {
                this.table.notifyNewLeaf(treeNodeArray, testResult, n);
                continue;
            }
            this.table.notifyRemoveLeaf(treeNodeArray, (TestResult)object, n);
            this.table.notifyNewLeaf(treeNodeArray, testResult, n);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized TestDescription updateTestDescription(String string, TestDescription testDescription) {
        String string2 = string;
        if (string2 == null) {
            string2 = testDescription.getRootRelativeURL();
        }
        String string3 = null;
        int n = string2.lastIndexOf(47);
        int n2 = string2.lastIndexOf(35);
        TestDescription testDescription2 = null;
        string3 = n2 > n ? string2.substring(0, n2) : string2;
        File file = new File(this.getTestSuiteRootPathPrefix() + File.separator + string3);
        if (this.table.getLastModifiedTime(file) > this.lastScanDate || testDescription == null) {
            TestFinder testFinder;
            TestFinder testFinder2 = testFinder = this.table.getTestFinder();
            synchronized (testFinder2) {
                testFinder.read(file);
                TestDescription[] testDescriptionArray = testFinder.getTests();
                for (int i = 0; i < testDescriptionArray.length; ++i) {
                    if (!testDescriptionArray[i].getRootRelativeURL().equals(string2)) continue;
                    testDescription2 = testDescriptionArray[i];
                    break;
                }
            }
        }
        if (testDescription2 == null) {
            return testDescription;
        }
        if (testDescription == null || !testDescription.equals(testDescription2)) {
            return testDescription2;
        }
        return testDescription;
    }

    private TestResult replaceTest(TestResult testResult, int n) {
        TestResult testResult2 = (TestResult)this.childs[n];
        this.childs[n] = testResult;
        this.notifyReplacedResult(testResult2, testResult, n);
        testResult.setParent(this);
        testResult2.setParent(null);
        return testResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(File file) {
        Object object;
        TestFinder testFinder;
        if (debug > 0) {
            Debug.println("--- Entering processFile() ---");
            Debug.println("This node's name: " + TestResultTable.getRootRelativePath(this));
            Debug.println("Processing file : " + file.getPath());
        }
        TestDescription[] testDescriptionArray = null;
        File[] fileArray = null;
        TestFinder testFinder2 = testFinder = this.table.getTestFinder();
        synchronized (testFinder2) {
            testFinder.read(file);
            object = testFinder.getTests();
            File[] fileArray2 = testFinder.getFiles();
            if (object != null && ((TestDescription[])object).length != 0) {
                testDescriptionArray = new TestDescription[((TestDescription[])object).length];
                System.arraycopy(object, 0, testDescriptionArray, 0, ((TestDescription[])object).length);
            } else {
                testDescriptionArray = new TestDescription[]{};
            }
            if (fileArray2 != null && fileArray2.length != 0) {
                fileArray = new File[fileArray2.length];
                System.arraycopy(fileArray2, 0, fileArray, 0, fileArray2.length);
            } else {
                fileArray = new File[]{};
            }
            if (debug > 0) {
                Debug.println("Read " + testDescriptionArray.length + " tests, and " + fileArray.length + " files.");
            }
        }
        for (int i = 0; i < testDescriptionArray.length; ++i) {
            object = TestResult.notRun(testDescriptionArray[i]);
            this.addChild((TestResult)object, true);
        }
        if (debug > 0) {
            Debug.println("processFile() done scanning, now inserting");
        }
        this.insertFinderFiles(this, fileArray);
    }

    private synchronized void insertFinderFiles(TRT_TreeNode tRT_TreeNode, File[] fileArray) {
        for (int i = 0; i < fileArray.length; ++i) {
            if (debug > 1) {
                Debug.print("   => into ");
                Debug.println(tRT_TreeNode.getName());
                Debug.print("   => original file is: ");
                Debug.println(fileArray[i].getAbsolutePath());
            }
            String string = this.makeNodeRelative(fileArray[i]);
            if (debug > 1) {
                Debug.println("   => stripped file is: " + string);
            }
            if (string.charAt(string.length() - 1) == '/') {
                string = string.substring(0, string.length() - 1);
            }
            if (string.indexOf(47) == -1) {
                if (this.getEnclosingTable().isBranchFile(fileArray[i])) {
                    if (debug > 1) {
                        Debug.println("   => directory, creating node");
                    }
                    try {
                        TRT_TreeNode tRT_TreeNode2 = this.createDirNode(tRT_TreeNode, string);
                    }
                    catch (Fault fault) {
                        throw new JavaTestError(i18n, "trttn.nameClash", fault);
                    }
                } else {
                    if (debug > 1) {
                        Debug.println("   => file, adding to scan list");
                    }
                    TRT_TreeNode.addToScanList(this, string, fileArray[i]);
                }
            } else {
                this.recursiveFinderInsert(this, fileArray[i], string);
            }
            if (debug <= 1) continue;
            Debug.println("**");
        }
    }

    private synchronized void recursiveFinderInsert(TRT_TreeNode tRT_TreeNode, File file, String string) {
        String string2;
        if (debug > 0) {
            Debug.println("Recursive insert: " + string + " into " + tRT_TreeNode.getName());
        }
        if (string == (string2 = TestResultTable.behead(string))) {
            if (this.getEnclosingTable().isBranchFile(file)) {
                if (debug > 0) {
                    Debug.println("    -> Creating empty node and leaving.");
                }
                TRT_TreeNode tRT_TreeNode2 = new TRT_TreeNode(this.table, tRT_TreeNode);
                tRT_TreeNode2.setName(string2);
                tRT_TreeNode.addChild(tRT_TreeNode2, false);
            } else {
                TRT_TreeNode.addToScanList(tRT_TreeNode, string, file);
            }
        } else {
            String string3 = TestResultTable.getDirName(string);
            try {
                TRT_TreeNode tRT_TreeNode3 = this.createDirNode(tRT_TreeNode, string3);
                this.recursiveFinderInsert(tRT_TreeNode3, file, string2);
            }
            catch (Fault fault) {
                throw new JavaTestError(i18n, "trttn.nameClash", fault);
            }
        }
    }

    private TRT_TreeNode createDirNode(TRT_TreeNode tRT_TreeNode, String string) throws Fault {
        if (debug > 1) {
            Debug.println("   => Trying to create dir node for: " + string);
        }
        int n = tRT_TreeNode.getResultIndex(string, true);
        if (debug > 1) {
            Debug.println("   => TR index in parent: " + n);
        }
        if (n != -1) {
            throw new Fault(i18n, "trttn.alreadyExists", string);
        }
        int n2 = tRT_TreeNode.getNodeIndex(string, true);
        TRT_TreeNode tRT_TreeNode2 = null;
        if (debug > 1) {
            Debug.println("   => index in parent: " + n2);
        }
        if (n2 == -1) {
            if (debug > 1) {
                Debug.println("   => Creating " + string);
                Debug.println("   => Local node is : " + tRT_TreeNode);
            }
            tRT_TreeNode2 = new TRT_TreeNode(this.table, tRT_TreeNode);
            tRT_TreeNode2.setName(string);
            if (debug > 1) {
                Debug.println("   => New child node is : " + tRT_TreeNode2);
            }
            TRT_TreeNode.addToScanList(tRT_TreeNode2, tRT_TreeNode2.name, new File(string));
            tRT_TreeNode.addChild(tRT_TreeNode2, true);
        } else {
            if (debug > 1) {
                Debug.println("   => Node exists, delegating.");
                Debug.println("   => index " + n2 + " in node " + tRT_TreeNode.getName());
            }
            try {
                tRT_TreeNode2 = (TRT_TreeNode)tRT_TreeNode.getChild(n2, true);
                if (debug > 1) {
                    Debug.println("   => " + tRT_TreeNode2);
                }
            }
            catch (ClassCastException classCastException) {
                throw new JavaTestError(i18n, "trttn.unexpecCast", classCastException);
            }
        }
        return tRT_TreeNode2;
    }

    void scanSubtree(TRT_TreeNode tRT_TreeNode) {
        if (this.table.getTestFinder() == null) {
            return;
        }
        tRT_TreeNode.scanIfNeeded();
        TRT_TreeNode[] tRT_TreeNodeArray = (TRT_TreeNode[])tRT_TreeNode.getTreeNodes();
        if (tRT_TreeNodeArray != null && tRT_TreeNodeArray.length != 0) {
            for (int i = 0; i < tRT_TreeNodeArray.length; ++i) {
                this.scanSubtree(tRT_TreeNodeArray[i]);
            }
        }
    }

    private String makeNodeRelative(File file) {
        if (debug > 1) {
            Debug.println("relativising: " + file.getPath());
        }
        if (file.isAbsolute()) {
            int n = this.getTestSuitePathLen();
            if (debug > 1) {
                Debug.println("  -> URL is absolute (" + file.getPath().length() + " chars), stripping.");
                Debug.println("  -> Stripping " + n + " characters.");
            }
            String string = TestResultTable.getRootRelativePath(this);
            if (debug > 1) {
                Debug.println("  -> removing rrp: " + string);
            }
            String string2 = file.getPath().substring(n += string == null || string.length() == 0 ? 0 : string.length() + 1);
            if (debug > 1) {
                Debug.println("  -> final node path: " + string2);
            }
            return string2.replace(File.separatorChar, '/');
        }
        String string = TestResultTable.getRootRelativePath(this);
        String string3 = file.getPath().replace(File.separatorChar, '/');
        if (debug > 1) {
            Debug.println("  -> check for RRP against: " + string);
        }
        if (string != null && string.length() != 0 && string3.startsWith(string)) {
            if (debug > 1) {
                Debug.println("  -> URL is root relative, stripping");
            }
            int n = string == null ? 0 : string.length();
            String string4 = string3.substring(n + 1);
            return string4;
        }
        if (debug > 1) {
            Debug.println("  -> relative, continue");
        }
        return string3;
    }

    private static void addToScanList(TRT_TreeNode tRT_TreeNode, String string, File file) {
        if (debug > 1) {
            Debug.println("   => Adding " + string + " to scan list and leaving.");
            Debug.println("   => Local node is : " + tRT_TreeNode);
            Debug.println("   -> local size b4: " + (tRT_TreeNode.filesToScan == null ? 0 : tRT_TreeNode.filesToScan.length));
        }
        int n = 0;
        if (tRT_TreeNode.filesToScan != null) {
            if (tRT_TreeNode.filesToScan.length > 0 && tRT_TreeNode.filesToScan[0].equals(tRT_TreeNode.getName())) {
                n = 1;
            }
            while (n < tRT_TreeNode.filesToScan.length && !tRT_TreeNode.filesToScan[n].equals(string)) {
                ++n;
            }
        }
        if (tRT_TreeNode.filesToScan == null || n >= tRT_TreeNode.filesToScan.length) {
            tRT_TreeNode.filesToScan = (String[])DynamicArray.append(tRT_TreeNode.filesToScan, string);
        } else if (debug > 1) {
            Debug.println("Warning: File " + file.getPath() + " may be referenced more than once in the test suite.  Ignoring.");
        }
        if (debug > 1) {
            Debug.println("   -> local size after: " + (tRT_TreeNode.filesToScan == null ? 0 : tRT_TreeNode.filesToScan.length));
        }
    }

    synchronized TestResult addChild(TestResult testResult, boolean bl) {
        if (!bl) {
            this.scanIfNeeded();
        }
        if (testResult == null) {
            throw new JavaTestError(i18n, "trttn.nullNode");
        }
        if (debug > 1) {
            Debug.println("Adding test " + testResult.getTestName());
            Debug.println("   -> " + testResult.getStatus().toString());
            Debug.println("   -> local node ref: " + this);
            Debug.println("   -> local node name: " + this.getName());
            Debug.println("   -> local size: " + (this.childs == null ? 0 : this.childs.length));
        }
        int n = this.getTestIndex(testResult, bl);
        TestResult testResult2 = null;
        if (n == -1) {
            if (debug > 1) {
                Debug.println("   -> no old entry, adding.");
            }
            try {
                this.childs = DynamicArray.append(this.childs, testResult, Class.forName("java.lang.Object"));
                testResult.setParent(this);
                this.bubbleUpCounterInc();
                this.notifyInsResult(testResult, this.childs.length - 1);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JavaTestError(i18n, "trttn.noObject", classNotFoundException);
            }
        } else if (this.shouldReplaceTest(n, testResult, bl)) {
            testResult2 = (TestResult)this.childs[n];
            this.childs[n] = testResult;
            if (debug > 1) {
                Debug.println("   -> ** replacing existing TR with " + testResult);
                Debug.println("   -> " + testResult.getTestName());
                Debug.println("   -> old status " + testResult2.getStatus().toString());
                Debug.println("   -> node: " + this);
            }
            testResult2.setParent(null);
            testResult.setParent(this);
            this.notifyReplacedResult(testResult2, testResult, n);
        } else {
            if (debug > 1) {
                Debug.println("   -> ** TRT selectively ignoring insert of " + testResult);
                Debug.println("   -> old status: " + ((TestResult)this.childs[n]).getStatus().toString());
                Debug.println("   -> curr. ref in TRT: " + this.childs[n]);
                Debug.println("   -> ignored new ref.: " + testResult);
            }
            return testResult;
        }
        this.invalidateChildStats();
        return testResult2;
    }

    synchronized void addChild(TRT_TreeNode tRT_TreeNode, boolean bl) {
        if (tRT_TreeNode == null) {
            throw new JavaTestError(i18n, "trttn.nullNode");
        }
        if (!bl) {
            this.scanIfNeeded();
        }
        try {
            this.childs = DynamicArray.append(this.childs, tRT_TreeNode, Class.forName("java.lang.Object"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JavaTestError(i18n, "trttn.noObject", classNotFoundException);
        }
    }

    void setName(String string) {
        this.name = string;
    }

    private boolean shouldReplaceTest(int n, TestResult testResult, boolean bl) {
        Object object;
        Object object2;
        if (!(this.childs[n] instanceof TestResult) || testResult == null || n < 0 || n >= this.childs.length) {
            return false;
        }
        TestResult testResult2 = (TestResult)this.childs[n];
        if (!testResult2.getTestName().equals(testResult.getTestName())) {
            return false;
        }
        if (this.table != null && this.table.getWorkDirectory() != null && this.table.getWorkDirectory().getTestSuite() != null && this.table.getWorkDirectory().getTestSuite().getTestRefreshBehavior(2)) {
            try {
                object2 = testResult.getDescription();
                object = testResult2.getDescription();
                if (object2 == null && object != null) {
                    return false;
                }
                if (object2 != null && object == null) {
                    return true;
                }
                if (!(object2 == null && object == null || ((TestDescription)object2).equals(object))) {
                    return false;
                }
            }
            catch (TestResult.Fault fault) {
                // empty catch block
            }
        }
        object2 = testResult.getStatus();
        object = testResult2.getStatus();
        if (((Status)object2).getType() == 3 && ((Status)object).getType() != 3) {
            return false;
        }
        if (((Status)object).getType() != ((Status)object2).getType()) {
            return true;
        }
        if (!((Status)object).getReason().equals(((Status)object2).getReason())) {
            return true;
        }
        boolean bl2 = testResult2.isShrunk();
        boolean bl3 = testResult.isShrunk();
        if (bl2 && !bl3) {
            return true;
        }
        return !bl2 && !bl3;
    }

    private static void refreshChildStats(TRT_TreeNode tRT_TreeNode) {
        if (tRT_TreeNode.childStats != null) {
            return;
        }
        tRT_TreeNode.childStats = new int[4];
        for (int i = 0; i < tRT_TreeNode.childs.length; ++i) {
            Object object;
            if (tRT_TreeNode.childs[i] instanceof TRT_TreeNode) {
                object = (TRT_TreeNode)tRT_TreeNode.childs[i];
                int[] nArray = ((TRT_TreeNode)object).getChildStatus();
                for (int j = 0; j < nArray.length; ++j) {
                    int n = j;
                    tRT_TreeNode.childStats[n] = tRT_TreeNode.childStats[n] + nArray[j];
                }
                continue;
            }
            object = (TestResult)tRT_TreeNode.childs[i];
            int n = ((TestResult)object).getStatus().getType();
            tRT_TreeNode.childStats[n] = tRT_TreeNode.childStats[n] + 1;
        }
    }

    void bubbleUpCounterInc() {
        ++this.counter;
        this.notifyCounterChange();
        TRT_TreeNode tRT_TreeNode = (TRT_TreeNode)this.getParent();
        if (tRT_TreeNode != null) {
            tRT_TreeNode.bubbleUpCounterInc();
        }
    }

    private int getTestSuitePathLen() {
        if (this.table.getTestSuiteRoot().isFile()) {
            return this.table.getTestSuiteRoot().getParent().length() + 1;
        }
        return this.table.getTestSuiteRoot().getAbsolutePath().length() + 1;
    }

    private String getTestSuiteRootPathPrefix() {
        File file = this.table.getTestSuiteRoot();
        if (file.isFile()) {
            return file.getParent();
        }
        return file.getPath();
    }

    private void notifyInsBranch(TRT_TreeNode tRT_TreeNode, int n) {
        TestResultTable.TreeNodeObserver[] treeNodeObserverArray = (TestResultTable.TreeNodeObserver[])observerTable.get(this);
        if (treeNodeObserverArray != null) {
            for (int i = 0; i < treeNodeObserverArray.length; ++i) {
                treeNodeObserverArray[i].insertedBranch(this, tRT_TreeNode, n);
            }
        }
    }

    private void notifyInsResult(TestResult testResult, int n) {
        TestResultTable.TreeNodeObserver[] treeNodeObserverArray = (TestResultTable.TreeNodeObserver[])observerTable.get(this);
        if (treeNodeObserverArray != null) {
            for (int i = 0; i < treeNodeObserverArray.length; ++i) {
                treeNodeObserverArray[i].insertedResult(this, testResult, n);
            }
        }
    }

    private void notifyReplacedResult(TestResult testResult, TestResult testResult2, int n) {
        TestResultTable.TreeNodeObserver[] treeNodeObserverArray = (TestResultTable.TreeNodeObserver[])observerTable.get(this);
        if (treeNodeObserverArray != null) {
            for (int i = 0; i < treeNodeObserverArray.length; ++i) {
                treeNodeObserverArray[i].replacedResult(this, testResult, testResult2, n);
            }
        }
    }

    private void notifyRemovedBranch(int n) {
        TestResultTable.TreeNodeObserver[] treeNodeObserverArray = (TestResultTable.TreeNodeObserver[])observerTable.get(this);
        if (treeNodeObserverArray != null) {
            for (int i = 0; i < treeNodeObserverArray.length; ++i) {
                treeNodeObserverArray[i].removedBranch(this, n);
            }
        }
    }

    private void notifyRemovedResult(TestResult testResult, int n) {
        TestResultTable.TreeNodeObserver[] treeNodeObserverArray = (TestResultTable.TreeNodeObserver[])observerTable.get(this);
        if (treeNodeObserverArray != null) {
            for (int i = 0; i < treeNodeObserverArray.length; ++i) {
                treeNodeObserverArray[i].removedResult(this, testResult, n);
            }
        }
    }

    private void notifyCounterChange() {
        TestResultTable.TreeNodeObserver[] treeNodeObserverArray = (TestResultTable.TreeNodeObserver[])observerTable.get(this);
        if (treeNodeObserverArray != null) {
            for (int i = 0; i < treeNodeObserverArray.length; ++i) {
                treeNodeObserverArray[i].countersInvalidated(this);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18NResourceBundle, String string) {
            super(i18NResourceBundle.getString(string));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle.getString(string, object));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
            super(i18NResourceBundle.getString(string, objectArray));
        }
    }
}

