/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.JavaTestSecurityManager;
import com.sun.javatest.Status;
import com.sun.javatest.agent.Agent;
import com.sun.javatest.agent.Connection;
import com.sun.javatest.agent.ConnectionFactory;
import com.sun.javatest.agent.Map;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.constant.Constable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class AgentMain {
    private boolean helpRequested = false;
    private int mode = 0;
    private int modeCheck = 0;
    private String activeHost = null;
    private int activePort = 1907;
    private int passivePort = 1908;
    private String serialPort = null;
    private int concurrency = 1;
    private String mapFile = null;
    private String observerClassName;
    private static final int ACTIVE = 1;
    private static final int PASSIVE = 2;
    private static final int SERIAL = 3;
    static /* synthetic */ Class class$com$sun$javatest$agent$AgentMain;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sun$javatest$agent$Agent$Observer;

    public static void main(String[] stringArray) {
        AgentMain agentMain = new AgentMain();
        agentMain.runAndExit(stringArray);
    }

    protected void runAndExit(String[] stringArray) {
        int n;
        JavaTestSecurityManager.install();
        try {
            this.run(stringArray);
            n = 0;
        }
        catch (BadArgs badArgs) {
            System.err.println("Error: Bad arguments");
            String[] stringArray2 = badArgs.getMessages();
            for (int i = 0; i < stringArray2.length; ++i) {
                System.err.println(stringArray2[i]);
            }
            System.err.println();
            this.usage(System.err);
            n = 1;
        }
        catch (Fault fault) {
            String[] stringArray3 = fault.getMessages();
            for (int i = 0; i < stringArray3.length; ++i) {
                System.err.println(stringArray3[i]);
            }
            n = 2;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            n = 3;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager instanceof JavaTestSecurityManager) {
            ((JavaTestSecurityManager)securityManager).setAllowExit(true);
        }
        System.exit(n);
    }

    public void run(String[] stringArray) throws BadArgs, Fault {
        this.decodeAllArgs(stringArray);
        if (this.helpRequested) {
            this.usage(System.err);
            return;
        }
        this.validateArgs();
        Agent agent = this.createAgent();
        agent.addObserver(new ErrorObserver());
        agent.run();
    }

    protected void decodeAllArgs(String[] stringArray) throws BadArgs, Fault {
        int n;
        for (int i = 0; i < stringArray.length; i += n) {
            n = this.decodeArg(stringArray, i);
            if (n != 0) continue;
            throw new BadArgs("Unrecognised option: " + stringArray[i]);
        }
    }

    protected int decodeArg(String[] stringArray, int n) throws BadArgs, Fault {
        int n2 = n;
        try {
            if (stringArray[n2].equalsIgnoreCase("-active")) {
                this.mode = 1;
                this.modeCheck |= 1 << this.mode;
                return 1;
            }
            if (stringArray[n2].equalsIgnoreCase("-passive")) {
                this.mode = 2;
                this.modeCheck |= 1 << this.mode;
                return 1;
            }
            if (stringArray[n2].equalsIgnoreCase("-activeHost")) {
                this.mode = 1;
                this.modeCheck |= 1 << this.mode;
                this.activeHost = stringArray[++n2];
                return 2;
            }
            if (stringArray[n2].equalsIgnoreCase("-activePort")) {
                this.mode = 1;
                this.modeCheck |= 1 << this.mode;
                this.activePort = Integer.parseInt(stringArray[++n2]);
                return 2;
            }
            if (stringArray[n2].equalsIgnoreCase("-passivePort")) {
                this.mode = 2;
                this.modeCheck |= 1 << this.mode;
                this.passivePort = Integer.parseInt(stringArray[++n2]);
                return 2;
            }
            if (stringArray[n2].equalsIgnoreCase("-serialPort")) {
                this.mode = 3;
                this.modeCheck = this.modeCheck |= 1 << this.mode;
                this.serialPort = stringArray[++n2];
                return 2;
            }
            if (stringArray[n2].equalsIgnoreCase("-concurrency")) {
                this.concurrency = Integer.parseInt(stringArray[++n2]);
                return 2;
            }
            if (stringArray[n2].equalsIgnoreCase("-map")) {
                this.mapFile = stringArray[++n2];
                return 2;
            }
            if (stringArray[n2].equalsIgnoreCase("-trace")) {
                Agent.tracing = true;
                return 1;
            }
            if ("-observer".equalsIgnoreCase(stringArray[n2]) && n2 < stringArray.length - 1) {
                if (this.observerClassName != null) {
                    throw new BadArgs("duplicate use of -observer");
                }
                this.observerClassName = stringArray[++n2];
                return 2;
            }
            if (stringArray[n2].equalsIgnoreCase("-help") || stringArray[n2].equalsIgnoreCase("-usage")) {
                this.helpRequested = true;
                return stringArray.length - n;
            }
            return 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new BadArgs("Missing argument for " + stringArray[stringArray.length - 1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadArgs("Number expected: " + stringArray[n2]);
        }
    }

    protected void validateArgs() throws BadArgs, Fault {
        if (this.modeCheck == 0) {
            throw new BadArgs("no connection options given");
        }
        if (this.modeCheck != 1 << this.mode) {
            throw new BadArgs("conflicting options for connection to JavaTest harness");
        }
        switch (this.mode) {
            case 1: {
                if (this.activeHost == null || this.activeHost.length() == 0) {
                    throw new BadArgs("no active host specified");
                }
                if (this.activePort > 0) break;
                throw new BadArgs("no active port specified");
            }
            case 3: {
                if (this.serialPort != null) break;
                throw new BadArgs("no serial port specified");
            }
        }
        if (this.concurrency <= 0 || this.concurrency > 100) {
            throw new BadArgs("Bad value for concurrency: " + this.concurrency);
        }
    }

    protected ConnectionFactory createConnectionFactory() throws Fault {
        String string = (class$com$sun$javatest$agent$AgentMain == null ? (class$com$sun$javatest$agent$AgentMain = AgentMain.class$("com.sun.javatest.agent.AgentMain")) : class$com$sun$javatest$agent$AgentMain).getName();
        String string2 = string.substring(0, string.lastIndexOf(46));
        switch (this.mode) {
            case 1: {
                try {
                    Class<?> clazz = Class.forName(string2 + ".ActiveConnectionFactory");
                    Constructor<?> constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = AgentMain.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
                    Object[] objectArray = new Object[]{this.activeHost, new Integer(this.activePort)};
                    return (ConnectionFactory)constructor.newInstance(objectArray);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = AgentMain.unwrapInvocationTargetException(throwable);
                    String[] stringArray = new String[]{"Error occurred while trying to start an active agent", throwable2.toString(), "Are the java.net classes available?"};
                    throw new Fault(stringArray);
                }
            }
            case 2: {
                try {
                    Class<?> clazz = Class.forName(string2 + ".PassiveConnectionFactory");
                    Constructor<?> constructor = clazz.getConstructor(Integer.TYPE, Integer.TYPE);
                    Object[] objectArray = new Object[]{new Integer(this.passivePort), new Integer(this.concurrency + 1)};
                    return (ConnectionFactory)constructor.newInstance(objectArray);
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = AgentMain.unwrapInvocationTargetException(throwable);
                    if (throwable3 instanceof IOException) {
                        throw new Fault("Cannot create socket on port " + this.passivePort);
                    }
                    String[] stringArray = new String[]{"Error occurred while trying to start a passive agent", throwable3.toString(), "Are the java.net classes available?"};
                    throw new Fault(stringArray);
                }
            }
            case 3: {
                try {
                    Class<?> clazz = Class.forName(string2 + ".SerialPortConnectionFactory");
                    Constructor<?> constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = AgentMain.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = AgentMain.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
                    Object[] objectArray = new Object[]{this.serialPort, "JavaTest Agent", new Integer(10000)};
                    return (ConnectionFactory)constructor.newInstance(objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    if (throwable instanceof IllegalArgumentException || throwable.getClass().getName().equals("javax.comm.NoSuchPortException")) {
                        throw new Fault(this.serialPort + " is not a valid port");
                    }
                    String[] stringArray = new String[]{"Error occurred while trying to access the communication ports", throwable.toString(), "Is the javax.comm extension installed?"};
                    throw new Fault(stringArray);
                }
                catch (Throwable throwable) {
                    String[] stringArray = new String[]{"Error occurred while trying to access the communication ports", throwable.toString(), "Is the javax.comm extension installed?"};
                    throw new Fault(stringArray);
                }
            }
        }
        throw new Error("unexpected mode");
    }

    protected Agent createAgent() throws Fault {
        String[] stringArray;
        Constable constable;
        ConnectionFactory connectionFactory = this.createConnectionFactory();
        Agent agent = new Agent(connectionFactory, this.concurrency);
        if (this.observerClassName != null) {
            try {
                constable = Class.forName(this.observerClassName);
                stringArray = (String[])((Class)constable).newInstance();
                agent.addObserver((Agent.Observer)stringArray);
            }
            catch (ClassCastException classCastException) {
                throw new Fault("observer is not of type " + (class$com$sun$javatest$agent$Agent$Observer == null ? (class$com$sun$javatest$agent$Agent$Observer = AgentMain.class$("com.sun.javatest.agent.Agent$Observer")) : class$com$sun$javatest$agent$Agent$Observer).getName() + ": " + this.observerClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Fault("cannot find observer class: " + this.observerClassName);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Fault("problem instantiating observer: " + illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new Fault("problem instantiating observer: " + instantiationException);
            }
        }
        if (this.mapFile != null) {
            try {
                agent.setMap(Map.readFileOrURL(this.mapFile));
            }
            catch (IOException iOException) {
                stringArray = new String[]{"Problem reading map file", iOException.toString()};
                throw new Fault(stringArray);
            }
        }
        if ((constable = Integer.getInteger("agent.retry.delay")) != null) {
            agent.setRetryDelay((Integer)constable);
        }
        return agent;
    }

    public void usage(PrintStream printStream) {
        String string = this.getClass().getName();
        printStream.println("Usage:");
        printStream.println("    java " + string + " [options]");
        printStream.println("        -help             print this message");
        printStream.println("        -usage            print this message");
        printStream.println("        -active           set mode to be active");
        printStream.println("        -activeHost host  set the host for active connections (implies -active)");
        printStream.println("        -activePort port  set the port for active connections (implies -active)");
        printStream.println("        -passive          set mode to be passive");
        printStream.println("        -passivePort port set the port for passive connections (implies -passive)");
        printStream.println("        -serialPort port  set the port for serial port connections");
        printStream.println("        -map file         map file for translating arguments of incoming requests");
        printStream.println("        -concurrency num  set the maximum number of simultaneous connections");
        printStream.println("        -trace            trace the execution of the agent");
        printStream.println("        -observer class   add an observer to the agent");
    }

    protected static Throwable unwrapInvocationTargetException(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        return throwable;
    }

    private static final int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ int access$000(int n, int n2) {
        return AgentMain.max(n, n2);
    }

    private static class ErrorObserver
    implements Agent.Observer {
        private long lastNotRespondMsgTime = 0L;
        private int lastNotRespondMsgInterval = AgentMain.access$000(Integer.getInteger("notResponding.message.interval", 60), 10) * 1000;
        private Class connectExceptionClass;
        private Class unknownHostExceptionClass;

        ErrorObserver() {
            try {
                this.connectExceptionClass = Class.forName("java.net.ConnectException");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.unknownHostExceptionClass = Class.forName("java.net.UnknownHostException");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void started(Agent agent) {
        }

        public void errorOpeningConnection(Agent agent, Exception exception) {
            if (this.connectExceptionClass != null && this.connectExceptionClass.isInstance(exception)) {
                long l = System.currentTimeMillis();
                if (this.lastNotRespondMsgTime + (long)this.lastNotRespondMsgInterval < l) {
                    System.err.println("host not responding: " + exception.getMessage());
                    this.lastNotRespondMsgTime = l;
                }
            } else if (this.unknownHostExceptionClass != null && this.unknownHostExceptionClass.isInstance(exception)) {
                System.err.println("unknown host: " + exception.getMessage());
            } else {
                System.err.println("error connecting to host: " + exception);
            }
        }

        public void finished(Agent agent) {
        }

        public void openedConnection(Agent agent, Connection connection) {
        }

        public void execTest(Agent agent, Connection connection, String string, String string2, String[] stringArray) {
        }

        public void execCommand(Agent agent, Connection connection, String string, String string2, String[] stringArray) {
        }

        public void execMain(Agent agent, Connection connection, String string, String string2, String[] stringArray) {
        }

        public void result(Agent agent, Connection connection, Status status) {
        }

        public void exception(Agent agent, Connection connection, Throwable throwable) {
        }

        public void completed(Agent agent, Connection connection) {
        }
    }

    public static class Fault
    extends Exception {
        private String[] msgs;

        public Fault(String string) {
            this(new String[]{string});
        }

        public Fault(String[] stringArray) {
            super(stringArray[0]);
            this.msgs = stringArray;
        }

        public String[] getMessages() {
            return this.msgs;
        }
    }

    public static class BadArgs
    extends Exception {
        private String[] msgs;

        public BadArgs(String string) {
            this(new String[]{string});
        }

        public BadArgs(String[] stringArray) {
            super(stringArray[0]);
            this.msgs = stringArray;
        }

        public String[] getMessages() {
            return this.msgs;
        }
    }
}

