/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.ActiveAgentPool;
import com.sun.javatest.agent.AgentManager;
import com.sun.javatest.agent.AgentMonitorToolManager;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.CommandManager;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.IOException;
import java.util.ListIterator;

public class AgentMonitorCommandManager
extends CommandManager {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$agent$AgentMonitorCommandManager == null ? (class$com$sun$javatest$agent$AgentMonitorCommandManager = AgentMonitorCommandManager.class$("com.sun.javatest.agent.AgentMonitorCommandManager")) : class$com$sun$javatest$agent$AgentMonitorCommandManager);
    static /* synthetic */ Class class$com$sun$javatest$agent$AgentMonitorCommandManager;
    static /* synthetic */ Class class$com$sun$javatest$agent$AgentMonitorToolManager;

    public HelpTree.Node getHelp() {
        String[] stringArray = new String[]{AgentPoolPortCommand.getName(), AgentPoolTimeoutCommand.getName(), StartAgentPoolCommand.getName(), ShowMonitorCommand.getName()};
        return new HelpTree.Node(i18n, "cmgr.help", stringArray);
    }

    public boolean parseCommand(String string, ListIterator listIterator, CommandContext commandContext) throws Command.Fault {
        if (string.equalsIgnoreCase(AgentPoolPortCommand.getName())) {
            commandContext.addCommand(new AgentPoolPortCommand(listIterator));
            return true;
        }
        if (string.equalsIgnoreCase(AgentPoolTimeoutCommand.getName())) {
            commandContext.addCommand(new AgentPoolTimeoutCommand(listIterator));
            return true;
        }
        if (string.equalsIgnoreCase(ShowMonitorCommand.getName())) {
            commandContext.addCommand(new ShowMonitorCommand());
            return true;
        }
        if (string.equalsIgnoreCase(StartAgentPoolCommand.getName())) {
            commandContext.addCommand(new StartAgentPoolCommand(listIterator));
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ShowMonitorCommand
    extends Command {
        static String getName() {
            return "monitorAgent";
        }

        ShowMonitorCommand() {
            super(ShowMonitorCommand.getName());
        }

        public int getDesktopMode() {
            return 2;
        }

        public void run(CommandContext commandContext) {
            Desktop desktop = commandContext.getDesktop();
            AgentMonitorToolManager agentMonitorToolManager = (AgentMonitorToolManager)desktop.getToolManager(class$com$sun$javatest$agent$AgentMonitorToolManager == null ? (class$com$sun$javatest$agent$AgentMonitorToolManager = AgentMonitorCommandManager.class$("com.sun.javatest.agent.AgentMonitorToolManager")) : class$com$sun$javatest$agent$AgentMonitorToolManager);
            agentMonitorToolManager.startTool();
        }
    }

    private static class StartAgentPoolCommand
    extends Command {
        private AgentPoolPortCommand portSubcommand;
        private AgentPoolTimeoutCommand timeoutSubcommand;

        static String getName() {
            return "startAgentPool";
        }

        StartAgentPoolCommand(ListIterator listIterator) throws Command.Fault {
            super(StartAgentPoolCommand.getName());
            while (listIterator.hasNext()) {
                String string = this.nextArg(listIterator);
                if (string.equalsIgnoreCase("-" + AgentPoolPortCommand.getName())) {
                    this.portSubcommand = new AgentPoolPortCommand(listIterator);
                    this.addArgs(this.portSubcommand);
                    continue;
                }
                if (string.equalsIgnoreCase("-" + AgentPoolTimeoutCommand.getName())) {
                    this.timeoutSubcommand = new AgentPoolTimeoutCommand(listIterator);
                    this.addArgs(this.timeoutSubcommand);
                    continue;
                }
                this.putbackArg(listIterator);
                break;
            }
        }

        public void run(CommandContext commandContext) throws Command.Fault {
            if (this.portSubcommand != null) {
                this.portSubcommand.run(commandContext);
            }
            if (this.timeoutSubcommand != null) {
                this.timeoutSubcommand.run(commandContext);
            }
            try {
                AgentManager agentManager = AgentManager.access();
                ActiveAgentPool activeAgentPool = agentManager.getActiveAgentPool();
                activeAgentPool.setListening(true);
            }
            catch (IOException iOException) {
                AgentManager agentManager = AgentManager.access();
                ActiveAgentPool activeAgentPool = agentManager.getActiveAgentPool();
                throw new Command.Fault((Command)this, i18n, "cmgr.listenOn.err", new Object[]{Integer.toString(activeAgentPool.getPort()), iOException});
            }
        }

        private void addArgs(Command command) {
            String[] stringArray = command.getArgs();
            for (int i = 1; i < stringArray.length; ++i) {
                this.addArg(stringArray[i]);
            }
        }
    }

    private static class AgentPoolTimeoutCommand
    extends Command {
        private int timeout;

        static String getName() {
            return "agentPoolTimeout";
        }

        AgentPoolTimeoutCommand(ListIterator listIterator) throws Command.Fault {
            super(AgentPoolTimeoutCommand.getName());
            if (!listIterator.hasNext()) {
                throw new Command.Fault(this, i18n, "cmgr.missingArg.err");
            }
            try {
                this.timeout = Integer.parseInt(this.nextArg(listIterator));
            }
            catch (NumberFormatException numberFormatException) {
                throw new Command.Fault(this, i18n, "cmgr.badNumber.err");
            }
        }

        public void run(CommandContext commandContext) {
            AgentManager agentManager = AgentManager.access();
            ActiveAgentPool activeAgentPool = agentManager.getActiveAgentPool();
            activeAgentPool.setTimeout(this.timeout * 1000);
        }
    }

    private static class AgentPoolPortCommand
    extends Command {
        private int port;

        static String getName() {
            return "agentPoolPort";
        }

        AgentPoolPortCommand(ListIterator listIterator) throws Command.Fault {
            super(AgentPoolPortCommand.getName());
            if (!listIterator.hasNext()) {
                throw new Command.Fault(this, i18n, "cmgr.missingArg.err");
            }
            try {
                this.port = Integer.parseInt(this.nextArg(listIterator));
            }
            catch (NumberFormatException numberFormatException) {
                throw new Command.Fault(this, i18n, "cmgr.badNumber.err");
            }
        }

        public void run(CommandContext commandContext) {
            AgentManager agentManager = AgentManager.access();
            ActiveAgentPool activeAgentPool = agentManager.getActiveAgentPool();
            activeAgentPool.setPort(this.port);
        }
    }
}

