/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import java.awt.AWTEventMulticaster;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;

class Folder
extends Panel
implements ItemSelectable {
    private ItemListener itemListener;
    private Vector entries = new Vector();
    private int border;
    private int slant;
    private int tabSpace;
    private int hgap;
    private int vgap;
    private int tabpad;

    public Folder() {
        this(0, 0);
    }

    public Folder(int n, int n2) {
        this(n, n2, 10, 5, 5);
    }

    Folder(int n, int n2, int n3, int n4, int n5) {
        this.hgap = n;
        this.vgap = n2;
        this.border = n3;
        this.slant = n4;
        this.tabSpace = n5;
        this.tabpad = 10;
        this.setLayout(new CardLayout());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Folder.this.mousePressed(mouseEvent.getX(), mouseEvent.getY());
            }
        };
        this.addMouseListener(mouseAdapter);
    }

    public Insets getInsets() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = this.border + this.hgap;
        int n2 = this.border + (fontMetrics == null ? 0 : fontMetrics.getHeight()) + this.tabpad + this.vgap;
        int n3 = this.border + this.vgap;
        return new Insets(n2, n, n3, n);
    }

    public Component add(String string, Component component) {
        this.entries.addElement(new Entry(component, string, null, true));
        return super.add(string, component);
    }

    public Component add(String string, Component component, Color color) {
        this.entries.addElement(new Entry(component, string, color, true));
        return super.add(string, component);
    }

    public Component add(String string, Component component, Color color, boolean bl) {
        this.entries.addElement(new Entry(component, string, color, bl));
        return super.add(string, component);
    }

    public void showTab(String string) {
        this.showTab(string, true);
    }

    public void hideTab(String string) {
        this.showTab(string, false);
    }

    public void showTab(String string, boolean bl) {
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry entry = (Entry)this.entries.elementAt(i);
            if (!entry.name.equals(string)) continue;
            if (entry.visibleTab != bl) {
                entry.visibleTab = bl;
                this.repaint();
            }
            return;
        }
    }

    public String getNextVisibleTab() {
        int n = Math.max(0, this.getCurrentIndex());
        for (int i = n + 1; i < this.entries.size(); ++i) {
            Entry entry = (Entry)this.entries.elementAt(i);
            if (!entry.visibleTab) continue;
            return entry.name;
        }
        return null;
    }

    public String getPrevVisibleTab() {
        int n = this.getCurrentIndex();
        for (int i = n - 1; i >= 0; --i) {
            Entry entry = (Entry)this.entries.elementAt(i);
            if (!entry.visibleTab) continue;
            return entry.name;
        }
        return null;
    }

    public Component current() {
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry entry = (Entry)this.entries.elementAt(i);
            if (!entry.comp.isVisible()) continue;
            return entry.comp;
        }
        return null;
    }

    public void show(Component component) {
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry entry = (Entry)this.entries.elementAt(i);
            if (entry.comp != component) continue;
            this.show(entry);
            return;
        }
    }

    public void show(String string) {
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry entry = (Entry)this.entries.elementAt(i);
            if (!entry.name.equals(string)) continue;
            this.show(entry);
            return;
        }
    }

    public void paint(Graphics graphics) {
        int n;
        Dimension dimension = this.getSize();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.getHeight() + this.tabpad;
        Entry entry = null;
        for (n = 0; n < this.entries.size(); ++n) {
            Entry entry2 = (Entry)this.entries.elementAt(n);
            if (!entry2.comp.isVisible()) continue;
            entry = entry2;
            break;
        }
        graphics.setColor(entry.color != null ? entry.color : this.getBackground());
        graphics.fillRoundRect(this.hgap, n2 + this.vgap, dimension.width - 2 * this.hgap - 1, dimension.height - n2 - 2 * this.vgap - 1, this.border, this.border);
        graphics.setColor(this.getForeground());
        graphics.drawRoundRect(this.hgap, n2 + this.vgap, dimension.width - 2 * this.hgap - 1, dimension.height - n2 - 2 * this.vgap - 1, this.border, this.border);
        n = this.border + this.hgap;
        int n3 = n2 + this.vgap;
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry entry3 = (Entry)this.entries.elementAt(i);
            int n4 = entry3.visibleTab || entry3.comp.isVisible() ? n2 : n2 / 3;
            int n5 = fontMetrics.stringWidth(entry3.name);
            Polygon polygon = new Polygon();
            polygon.addPoint(n, n3);
            polygon.addPoint(n + this.slant, n3 - n4);
            polygon.addPoint(n + this.slant + n5, n3 - n4);
            polygon.addPoint(n + this.slant + n5 + this.slant, n3);
            if (entry3.color != null) {
                graphics.setColor(entry3.color);
                graphics.fillPolygon(polygon);
            }
            graphics.setColor(this.getForeground());
            graphics.drawLine(polygon.xpoints[0], polygon.ypoints[0], polygon.xpoints[1], polygon.ypoints[1]);
            graphics.drawLine(polygon.xpoints[1], polygon.ypoints[1], polygon.xpoints[2], polygon.ypoints[2]);
            graphics.drawLine(polygon.xpoints[2], polygon.ypoints[2], polygon.xpoints[3], polygon.ypoints[3]);
            if (entry3.visibleTab || entry3.comp.isVisible()) {
                graphics.drawString(entry3.name, n + this.slant, n3 - this.tabpad / 2 - fontMetrics.getDescent());
            }
            if (entry3.comp.isVisible()) {
                graphics.setColor(entry3.color != null ? entry3.color : this.getBackground());
                graphics.drawLine(polygon.xpoints[0], polygon.ypoints[0], polygon.xpoints[3], polygon.ypoints[3]);
            }
            n = polygon.xpoints[3] + this.tabSpace;
        }
        super.paint(graphics);
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public Object[] getSelectedObjects() {
        Entry entry = this.getCurrentEntry();
        if (entry == null) {
            return null;
        }
        return new Object[]{entry.comp};
    }

    int getMinimumWidth() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = this.border + 2 * this.hgap + this.tabSpace;
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry entry = (Entry)this.entries.elementAt(i);
            n += this.slant + (fontMetrics == null ? 0 : fontMetrics.stringWidth(entry.name)) + this.slant + this.tabSpace;
        }
        return n;
    }

    private void show(Entry entry) {
        Entry entry2 = this.getCurrentEntry();
        Component component = entry2 == null ? null : entry2.comp;
        ((CardLayout)this.getLayout()).show(this, entry.name);
        this.repaint();
        if (this.itemListener != null) {
            ItemEvent itemEvent = new ItemEvent(this, 701, component, 2);
            ItemEvent itemEvent2 = new ItemEvent(this, 701, entry.comp, 1);
            this.itemListener.itemStateChanged(itemEvent);
            this.itemListener.itemStateChanged(itemEvent2);
        }
    }

    private int getCurrentIndex() {
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry entry = (Entry)this.entries.elementAt(i);
            if (!entry.comp.isVisible()) continue;
            return i;
        }
        return -1;
    }

    private Entry getCurrentEntry() {
        int n = this.getCurrentIndex();
        return n == -1 ? null : (Entry)this.entries.elementAt(n);
    }

    void mousePressed(int n, int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (this.vgap < n2 && n2 < this.border + fontMetrics.getHeight() + this.vgap) {
            int n3 = this.border + this.hgap;
            for (int i = 0; i < this.entries.size(); ++i) {
                Entry entry = (Entry)this.entries.elementAt(i);
                int n4 = fontMetrics.stringWidth(entry.name);
                if (n >= (n3 += this.slant + n4 + this.slant + this.tabSpace)) continue;
                this.show(entry);
                break;
            }
        }
    }

    private class Layout
    extends CardLayout {
        private Layout() {
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = super.minimumLayoutSize(container);
            int n = Math.max(dimension.width, ((Folder)container).getMinimumWidth());
            return new Dimension(n, dimension.height);
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = super.preferredLayoutSize(container);
            int n = Math.max(dimension.width, ((Folder)container).getMinimumWidth());
            return new Dimension(n, dimension.height);
        }
    }

    private class Entry {
        Component comp;
        String name;
        Color color;
        boolean visibleTab;

        Entry(Component component, String string, Color color, boolean bl) {
            this.comp = component;
            this.name = string;
            this.color = color;
            this.visibleTab = bl;
        }
    }
}

