/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.audit;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import com.sun.javatest.audit.Audit;
import com.sun.javatest.audit.AuditPane;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.HTMLWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

class SummaryPane
extends AuditPane {
    private JEditorPane htmlPane = new JEditorPane();
    private Audit currAudit;
    private HTMLWriter out;
    private String OK;
    private String ERROR;

    SummaryPane(UIFactory uIFactory) {
        super("smry", uIFactory);
        this.htmlPane.setName("smry.html");
        this.htmlPane.setContentType("text/html");
        this.htmlPane.setEditable(false);
        this.htmlPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        uIFactory.setAccessibleInfo(this.htmlPane, "smry.html");
        JScrollPane jScrollPane = uIFactory.createScrollPane(this.htmlPane, 20, 31);
        this.setBody(jScrollPane);
        CSH.setHelpIDString(this, "audit.summaryTab.csh");
        this.OK = uIFactory.getI18NString("smry.state.OK");
        this.ERROR = uIFactory.getI18NString("smry.state.error");
    }

    void show(Audit audit) {
        if (audit == this.currAudit) {
            this.showBody();
        } else {
            this.currAudit = audit;
            StringWriter stringWriter = new StringWriter();
            try {
                this.out = new HTMLWriter((Writer)stringWriter, this.uif.getI18NResourceBundle());
                this.writeReport();
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.htmlPane.setText(stringWriter.toString());
            this.showBody();
        }
    }

    private void writeReport() throws IOException {
        this.out.startTag("html");
        this.out.startTag("head");
        this.out.endTag("head");
        this.out.startTag("body");
        this.out.writeStyleAttr("font-family: SansSerif; font-size: 12pt");
        this.out.startTag("table");
        this.out.startTag("tr");
        this.out.startTag("th");
        this.out.writeAttr("align", "right");
        this.out.writeI18N("smry.category");
        this.out.startTag("th");
        this.out.writeAttr("align", "left");
        this.out.writeI18N("smry.state");
        this.out.startTag("th");
        this.out.writeAttr("align", "left");
        this.out.writeI18N("smry.details");
        this.writeResultFileDetails();
        this.writeChecksumDetails();
        this.writeTestDescriptionDetails();
        this.writeTestCaseDetails();
        this.writeStatusDetails();
        this.writeDateStampDetails();
        this.out.endTag("table");
        this.out.endTag("body");
        this.out.endTag("html");
    }

    private void writeResultFileDetails() throws IOException {
        int n;
        this.out.startTag("tr");
        this.out.startTag("td");
        this.out.writeAttr("align", "right");
        this.out.writeAttr("valign", "top");
        this.out.startTag("b");
        this.out.writeI18N("smry.tr.head");
        this.out.endTag("b");
        this.out.startTag("td");
        this.out.writeAttr("valign", "top");
        this.out.write(this.currAudit.isAllTestsOK() ? this.OK : this.ERROR);
        this.out.startTag("td");
        TestDescription[] testDescriptionArray = this.currAudit.getBadTests();
        int n2 = n = testDescriptionArray == null ? 0 : testDescriptionArray.length;
        if (n == 0) {
            this.out.writeI18N("smry.tr.allOK");
        } else {
            this.out.writeI18N("smry.tr.count", new Integer(n));
        }
    }

    private void writeChecksumDetails() throws IOException {
        this.out.startTag("tr");
        this.out.startTag("td");
        this.out.writeAttr("align", "right");
        this.out.writeAttr("valign", "top");
        this.out.startTag("b");
        this.out.writeI18N("smry.cs.head");
        this.out.endTag("b");
        this.out.startTag("td");
        this.out.writeAttr("valign", "top");
        this.out.write(this.currAudit.isChecksumCountsOK() ? this.OK : this.ERROR);
        this.out.startTag("td");
        int[] nArray = this.currAudit.getChecksumCounts();
        int n = nArray[2];
        int n2 = nArray[1];
        int n3 = nArray[0];
        if (n2 == 0 && n3 == 0) {
            this.out.writeI18N("smry.cs.allOK");
        } else {
            this.out.writeI18N("smry.cs.count", new Object[]{new Integer(n), new Integer(n > 0 && n2 + n3 > 0 ? 1 : 0), new Integer(n2), new Integer(n2 > 0 && n3 > 0 ? 1 : 0), new Integer(n3)});
        }
    }

    private void writeTestDescriptionDetails() throws IOException {
        int n;
        this.out.startTag("tr");
        this.out.startTag("td");
        this.out.writeAttr("align", "right");
        this.out.writeAttr("valign", "top");
        this.out.startTag("b");
        this.out.writeI18N("smry.td.head");
        this.out.endTag("b");
        this.out.startTag("td");
        this.out.writeAttr("valign", "top");
        this.out.write(this.currAudit.isAllTestDescriptionsOK() ? this.OK : this.ERROR);
        this.out.startTag("td");
        TestResult[] testResultArray = this.currAudit.getBadTestDescriptions();
        int n2 = n = testResultArray == null ? 0 : testResultArray.length;
        if (n == 0) {
            this.out.writeI18N("smry.td.allOK");
        } else {
            this.out.writeI18N("smry.td.count", new Integer(n));
        }
    }

    private void writeTestCaseDetails() throws IOException {
        int n;
        this.out.startTag("tr");
        this.out.startTag("td");
        this.out.writeAttr("align", "right");
        this.out.writeAttr("valign", "top");
        this.out.startTag("b");
        this.out.writeI18N("smry.tc.head");
        this.out.endTag("b");
        this.out.startTag("td");
        this.out.writeAttr("valign", "top");
        this.out.write(this.currAudit.isAllTestsOK() ? this.OK : this.ERROR);
        this.out.startTag("td");
        TestResult[] testResultArray = this.currAudit.getBadTestCaseTests();
        int n2 = n = testResultArray == null ? 0 : testResultArray.length;
        if (n == 0) {
            this.out.writeI18N("smry.tc.allOK");
        } else {
            this.out.writeI18N("smry.tc.count", new Integer(n));
        }
    }

    private void writeStatusDetails() throws IOException {
        this.out.startTag("tr");
        this.out.startTag("td");
        this.out.writeAttr("align", "right");
        this.out.writeAttr("valign", "top");
        this.out.startTag("b");
        this.out.writeI18N("smry.status.head");
        this.out.endTag("b");
        this.out.startTag("td");
        this.out.writeAttr("valign", "top");
        this.out.write(this.currAudit.isStatusCountsOK() ? this.OK : this.ERROR);
        this.out.startTag("td");
        int[] nArray = this.currAudit.getStatusCounts();
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        if (n + n2 + n3 + n4 == 0) {
            this.out.writeI18N("smry.status.noTests");
        } else if (n2 + n3 + n4 == 0) {
            this.out.writeI18N("smry.status.allOK");
        } else {
            this.out.writeI18N("smry.status.count", new Object[]{new Integer(n), new Integer(n > 0 && n2 + n3 + n4 > 0 ? 1 : 0), new Integer(n2), new Integer(n2 > 0 && n3 + n4 > 0 ? 1 : 0), new Integer(n3), new Integer(n3 > 0 && n4 > 0 ? 1 : 0), new Integer(n4)});
        }
    }

    private void writeDateStampDetails() throws IOException {
        this.out.startTag("tr");
        this.out.startTag("td");
        this.out.writeAttr("align", "right");
        this.out.writeAttr("valign", "top");
        this.out.startTag("b");
        this.out.writeI18N("smry.dates.head");
        this.out.endTag("b");
        this.out.startTag("td");
        this.out.writeAttr("valign", "top");
        this.out.write(this.currAudit.isDateStampsOK() ? this.OK : this.ERROR);
        this.out.startTag("td");
        Date date = this.currAudit.getEarliestStartTime();
        Date date2 = this.currAudit.getLatestStartTime();
        boolean bl = this.currAudit.hasBadStartTimes();
        if (date == null || date2 == null) {
            this.out.writeI18N("smry.dates.noStamps");
        } else {
            Integer n = new Integer(bl ? 1 : 0);
            this.out.writeI18N("smry.dates.earliest", new Object[]{date, n});
            this.out.startTag("br");
            this.out.writeI18N("smry.dates.latest", new Object[]{date2, n});
            if (bl) {
                this.out.startTag("br");
                this.out.writeI18N("smry.dates.badDatesFound");
            }
        }
    }

    private void writeEnvDetails() throws IOException {
    }
}

