/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.cof;

import com.sun.javatest.cof.COFData;
import com.sun.javatest.cof.COFItem;
import com.sun.javatest.cof.COFOS;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class COFEnvironment
extends COFItem {
    static String[] propOrder = new String[]{"machine", "os", "jdk", "systemLocale", "userLocale", "encoding", "timezone", "bits", "displaydepth", "description", "sw"};
    static String[] propTags = new String[]{"machine", "os", "jdk", "system-locale", "user-locale", "encoding", "timezone", "bits", "displaydepth", "description", "sw"};
    static LinkedHashMap xmlAttributes;
    static LinkedHashMap xmlElements;
    static String xmlTagName;
    private static I18NResourceBundle i18n;
    protected Integer bits;
    protected String description;
    protected Integer displaydepth;
    private String domainName;
    protected String encoding;
    private String hostName;
    protected String id = "env:0";
    protected String jdk;
    protected String machine;
    protected COFOS os;
    protected List sw;
    protected String systemLocale;
    protected String timezone;
    protected String userLocale;
    static /* synthetic */ Class class$com$sun$javatest$cof$Main;

    COFEnvironment(COFData cOFData) {
        this.initDefaultHostInfo();
        this.initDefaultOSInfo();
        this.hostName = cOFData.get("environment.host", this.hostName);
        this.domainName = cOFData.get("environment.domain", this.domainName);
        this.setMachine(cOFData.get("environment.machine", this.hostName + "." + this.domainName));
        this.os.setName(cOFData.get("environment.os.name", this.os.getName()));
        this.os.setVersion(cOFData.get("environment.os.version", this.os.getVersion()));
        this.os.setArch(cOFData.get("environment.os.arch", this.os.getArch()));
        this.setJdk(cOFData.get("environment.jdk", this.jdk));
        this.setUserLocale(cOFData.get("environment.user-locale", Locale.getDefault().toString()));
        this.setSystemLocale(cOFData.get("environment.system-locale", cOFData.get("LOCALE")));
        this.setEncoding(cOFData.get("environment.encoding", new InputStreamReader(System.in).getEncoding()));
        this.setTimezone(cOFData.get("environment.timezone", TimeZone.getDefault().getID()));
        this.setBits(cOFData.get("environment.bits", null) == null ? null : new Integer(cOFData.get("environment.bits")));
        this.setDisplaydepth(cOFData.get("environment.displaydepth", null) == null ? null : new Integer(cOFData.get("environment.displaydepth")));
        this.setDescription(cOFData.get("environment.description"));
    }

    public Integer getBits() {
        return this.bits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getCalderaLinuxVersionInfo() {
        var1_1 = "N/A";
        var2_2 = null;
        try {
            try {
                var2_2 = new RandomAccessFile("/etc/issue", "r");
                while ((var3_3 = var2_2.readLine()) != null) {
                    var4_5 = new StringTokenizer(var3_3, " ");
                    if (var4_5.countTokens() < 2 || !var4_5.nextToken().toUpperCase().equals("VERSION")) continue;
                    var1_1 = var4_5.nextToken();
                    break;
                }
            }
            catch (Exception var3_4) {
                var6_7 = null;
                if (var2_2 == null) return var1_1;
                try {
                    var2_2.close();
                    return var1_1;
                }
                catch (Exception var7_10) {
                    return var1_1;
                }
            }
            var6_6 = null;
            if (var2_2 == null) return var1_1;
        }
        catch (Throwable var5_12) {
            var6_8 = null;
            if (var2_2 == null) throw var5_12;
            ** try [egrp 2[TRYBLOCK] [4 : 99->106)] { 
lbl30:
            // 1 sources

            var2_2.close();
            throw var5_12;
lbl32:
            // 1 sources

            catch (Exception var7_11) {
                // empty catch block
            }
            throw var5_12;
        }
        try {}
        catch (Exception var7_9) {}
        var2_2.close();
        return var1_1;
        return var1_1;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getDisplaydepth() {
        return this.displaydepth;
    }

    public String getEncoding() {
        return this.encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getGenericLinuxVersionInfo(String var1_1) {
        var2_2 = "N/A";
        var3_3 = null;
        try {
            try {
                var3_3 = new RandomAccessFile(var1_1, "r");
                var4_4 = new StringTokenizer(var3_3.readLine(), " ");
                while (var4_4.hasMoreElements()) {
                    var5_6 = var4_4.nextToken();
                    if (!Character.isDigit(var5_6.charAt(0))) continue;
                    var2_2 = var5_6;
                    break;
                }
            }
            catch (Exception var4_5) {
                var7_8 = null;
                if (var3_3 == null) return var2_2;
                try {
                    var3_3.close();
                    return var2_2;
                }
                catch (Exception var8_11) {
                    return var2_2;
                }
            }
            var7_7 = null;
            if (var3_3 == null) return var2_2;
        }
        catch (Throwable var6_13) {
            var7_9 = null;
            if (var3_3 == null) throw var6_13;
            ** try [egrp 2[TRYBLOCK] [4 : 92->99)] { 
lbl31:
            // 1 sources

            var3_3.close();
            throw var6_13;
lbl33:
            // 1 sources

            catch (Exception var8_12) {
                // empty catch block
            }
            throw var6_13;
        }
        try {}
        catch (Exception var8_10) {}
        var3_3.close();
        return var2_2;
        return var2_2;
    }

    public String getId() {
        return this.id;
    }

    LinkedHashMap getItemAttributes() {
        return xmlAttributes;
    }

    LinkedHashMap getItemElements() {
        return xmlElements;
    }

    String getItemTagName() {
        return xmlTagName;
    }

    public String getJdk() {
        return this.jdk;
    }

    public String getMachine() {
        return this.machine;
    }

    public COFOS getOs() {
        return this.os;
    }

    String[] getPropOrder() {
        return propOrder;
    }

    public List getSw() {
        if (this.sw == null) {
            this.sw = new ArrayList();
        }
        return this.sw;
    }

    public String getSystemLocale() {
        return this.systemLocale;
    }

    String getTagName() {
        return this.itemTagName;
    }

    String[] getTags() {
        return propTags;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public String getUserLocale() {
        return this.userLocale;
    }

    private void initDefaultHostInfo() {
        this.domainName = "unknown";
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            this.hostName = "unknown";
        }
    }

    private void initDefaultOSInfo() {
        this.os = new COFOS();
        this.os.setName(System.getProperty("os.name"));
        this.os.setVersion(System.getProperty("os.version"));
        this.os.setArch(System.getProperty("os.arch"));
    }

    public void setBits(Integer n) {
        this.bits = n;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setDisplaydepth(Integer n) {
        this.displaydepth = n;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setJdk(String string) {
        this.jdk = string;
    }

    public void setMachine(String string) {
        if (string.endsWith(".unknown")) {
            try {
                this.machine = InetAddress.getLocalHost().getCanonicalHostName();
                if (this.machine.indexOf(".") == -1) {
                    System.err.println(i18n.getString("environment.badMachineName", this.machine));
                }
                return;
            }
            catch (UnknownHostException unknownHostException) {
                System.err.println(i18n.getString("environment.cantGetLocalhostName", unknownHostException.getMessage()));
                string = string.substring(0, string.indexOf(".unknown") - 1);
                System.err.println(i18n.getString("environment.badMachineName", string));
            }
        }
        this.machine = string;
    }

    public void setOs(COFOS cOFOS) {
        this.os = cOFOS;
    }

    public void setSystemLocale(String string) {
        this.systemLocale = string;
    }

    public void setTimezone(String string) {
        this.timezone = string;
    }

    public void setUserLocale(String string) {
        this.userLocale = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$cof$Main == null ? (class$com$sun$javatest$cof$Main = COFEnvironment.class$("com.sun.javatest.cof.Main")) : class$com$sun$javatest$cof$Main);
        xmlElements = new LinkedHashMap();
        for (int i = 0; i < propOrder.length; ++i) {
            xmlElements.put(propOrder[i], propTags[i]);
        }
        xmlAttributes = new LinkedHashMap();
        xmlAttributes.put("id", "id");
        xmlTagName = "environment";
    }
}

