/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.cof;

import com.sun.javatest.Status;
import com.sun.javatest.TestResult;
import com.sun.javatest.cof.COFData;
import com.sun.javatest.cof.COFItem;
import com.sun.javatest.cof.COFStatus;
import com.sun.javatest.cof.COFTestAttribute;
import com.sun.javatest.cof.COFTestAttributes;
import com.sun.javatest.cof.COFTestCase;
import com.sun.javatest.cof.COFTestCases;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class COFTest
extends COFItem {
    private static final Date badDate = new Date(0L);
    private static final String[] cofStatus = new String[4];
    static long count = 0L;
    private static DateFormat[] dateFormats;
    protected static Pattern idPattern;
    static boolean noTestCases;
    protected static Pattern testCasePattern;
    static LinkedHashMap xmlAttributes;
    static LinkedHashMap xmlElements;
    static String xmlTagName;
    protected String analysis;
    protected List appuse;
    protected COFTestAttributes attributes;
    protected String description;
    protected Date endtime;
    protected String id;
    final long idNum = count++;
    protected String name;
    protected Date starttime;
    protected COFStatus status;
    protected COFTestCases testcases;
    private COFData cofData;

    COFTest(TestResult testResult, COFData cOFData) {
        this.cofData = cOFData;
        this.initDateFormats();
        this.status = new COFStatus();
        this.status.setValue(cofStatus[testResult.getStatus().getType()]);
        this.status.setActual(testResult.getStatus().getReason());
        this.fillTestCases(testResult);
        this.setName(testResult.getTestName());
        this.setStarttime(this.parseDate(testResult, "start"));
        this.setEndtime(this.parseDate(testResult, "end"));
        this.attributes = new COFTestAttributes();
        this.attributes.getAttribute().add(new COFTestAttribute("logfile", testResult.getWorkRelativePath()));
        String string = this.cofData.get("jvmopt", null);
        if (string != null) {
            this.attributes.getAttribute().add(new COFTestAttribute("javaopt", string));
        }
    }

    protected void fillTestCases(TestResult testResult) {
        if (noTestCases) {
            return;
        }
        this.testcases = new COFTestCases();
        int n = testResult.getSectionCount();
        if (n == 0 && testResult.getStatus().getType() != 3) {
            try {
                testResult = new TestResult(new File(this.cofData.get("workdir") + File.separator + testResult.getWorkRelativePath()));
                n = testResult.getSectionCount();
            }
            catch (TestResult.ResultFileNotFoundFault resultFileNotFoundFault) {
                System.err.println(resultFileNotFoundFault.getMessage());
            }
            catch (TestResult.ReloadFault reloadFault) {
                System.err.println(testResult.getFile());
            }
        }
        for (int i = 0; i < n; ++i) {
            try {
                String string = testResult.getSection(i).getOutput("out1");
                if (string == null) continue;
                BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    Matcher matcher = testCasePattern.matcher(string2);
                    if (matcher.matches()) {
                        COFTestCase cOFTestCase = new COFTestCase();
                        COFStatus cOFStatus = new COFStatus();
                        cOFTestCase.setName(matcher.group(1));
                        cOFStatus.setValue(cofStatus[Status.parse(matcher.group(2)).getType()]);
                        cOFStatus.setActual(matcher.group(3));
                        cOFTestCase.setStatus(cOFStatus);
                        this.testcases.getTestcase().add(cOFTestCase);
                    }
                    string2 = bufferedReader.readLine();
                }
                continue;
            }
            catch (TestResult.ReloadFault reloadFault) {
                reloadFault.printStackTrace();
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public String getAnalysis() {
        if (this.analysis == null) {
            return "accept";
        }
        return this.analysis;
    }

    public List getAppuse() {
        if (this.appuse == null) {
            this.appuse = new ArrayList();
        }
        return this.appuse;
    }

    public COFTestAttributes getAttributes() {
        return this.attributes;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getEndtime() {
        return this.endtime;
    }

    public String getId() {
        if (this.id != null) {
            return this.id;
        }
        if (this.name == null) {
            throw new IllegalStateException("Name was not set.");
        }
        Matcher matcher = idPattern.matcher(this.name);
        this.id = matcher.matches() ? matcher.group(1) + ":" + this.idNum : "test:" + this.idNum;
        return this.id;
    }

    LinkedHashMap getItemAttributes() {
        return xmlAttributes;
    }

    LinkedHashMap getItemElements() {
        return xmlElements;
    }

    String getItemTagName() {
        return xmlTagName;
    }

    public String getName() {
        return this.name;
    }

    public Date getStarttime() {
        return this.starttime;
    }

    public COFStatus getStatus() {
        return this.status;
    }

    public COFTestCases getTestcases() {
        return this.testcases;
    }

    private void initDateFormats() {
        Vector<DateFormat> vector = new Vector<DateFormat>();
        vector.addElement(DateFormat.getDateTimeInstance());
        vector.addElement(new SimpleDateFormat("EEE, dd MMMM yyyy HH:mm:ss zzz"));
        vector.addElement(new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy"));
        vector.addElement(new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSS"));
        String string = System.getProperty("javatest.date.format");
        if (string != null) {
            vector.addElement(new SimpleDateFormat(string));
        }
        dateFormats = new DateFormat[vector.size()];
        vector.copyInto(dateFormats);
    }

    private Date parseDate(String string) {
        for (int i = 0; i < dateFormats.length; ++i) {
            try {
                Date date = dateFormats[i].parse(string);
                if (i > 0) {
                    DateFormat dateFormat = dateFormats[i];
                    System.arraycopy(dateFormats, 0, dateFormats, 1, i);
                    COFTest.dateFormats[0] = dateFormat;
                }
                return date;
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return badDate;
    }

    private Date parseDate(TestResult testResult, String string) {
        try {
            String string2 = testResult.getProperty(string);
            if (string2 != null && string2.length() > 0) {
                return this.parseDate(string2);
            }
        }
        catch (TestResult.Fault fault) {
            System.err.println(fault);
        }
        return badDate;
    }

    public void setAnalysis(String string) {
        this.analysis = string;
    }

    public void setAttributes(COFTestAttributes cOFTestAttributes) {
        this.attributes = cOFTestAttributes;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setEndtime(Date date) {
        this.endtime = date;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setStarttime(Date date) {
        this.starttime = date;
    }

    public void setStatus(COFStatus cOFStatus) {
        this.status = cOFStatus;
    }

    public void setTestcases(COFTestCases cOFTestCases) {
        this.testcases = cOFTestCases;
    }

    static {
        idPattern = Pattern.compile(".*[^\\w\\.\\[\\]\\(\\)\\{\\},_\\-]([\\w\\.\\[\\]\\(\\)\\{\\},_\\-]+)");
        noTestCases = false;
        testCasePattern = Pattern.compile("^(\\S+): (Passed\\.|Failed\\.|Error\\.|Not\\ run\\.)(.*)");
        xmlElements = new LinkedHashMap();
        xmlAttributes = new LinkedHashMap();
        xmlElements.put("name", "name");
        xmlElements.put("appuse", "appuse");
        xmlElements.put("status", "status");
        xmlElements.put("testcases", "testcases");
        xmlElements.put("starttime", "starttime");
        xmlElements.put("endtime", "endtime");
        xmlElements.put("attributes", "attributes");
        xmlElements.put("description", "description");
        xmlAttributes.put("id", "id");
        xmlTagName = "test";
        COFTest.cofStatus[0] = "pass";
        COFTest.cofStatus[1] = "fail";
        COFTest.cofStatus[2] = "error";
        COFTest.cofStatus[3] = "did_not_run";
    }
}

