/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.cof;

import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.cof.COFApplication;
import com.sun.javatest.cof.COFApplications;
import com.sun.javatest.cof.COFData;
import com.sun.javatest.cof.COFEnvironment;
import com.sun.javatest.cof.COFItem;
import com.sun.javatest.cof.COFSWEntities;
import com.sun.javatest.cof.COFSWEntity;
import com.sun.javatest.cof.COFTest;
import com.sun.javatest.cof.COFTestSuite;
import com.sun.javatest.cof.Report;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.XMLWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.util.Vector;

public class Main {
    private static final String COF_SCHEMA = "COF2_0_2.xsd";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$cof$Main == null ? (class$com$sun$javatest$cof$Main = Main.class$("com.sun.javatest.cof.Main")) : class$com$sun$javatest$cof$Main);
    private static File suiteCopy;
    File dir = null;
    File tsPath = null;
    Vector data = new Vector();
    static /* synthetic */ Class class$com$sun$javatest$cof$Main;

    private static void exit(int n) {
        System.exit(n);
        throw new Error();
    }

    public static void main(String[] stringArray) {
        PrintWriter printWriter = new PrintWriter(System.err);
        try {
            Main main = new Main();
            main.run(stringArray, printWriter);
            printWriter.flush();
            Main.exit(0);
        }
        catch (BadArgs badArgs) {
            printWriter.println(badArgs.getMessage());
            printWriter.flush();
            Main.exit(1);
        }
        catch (Fault fault) {
            printWriter.println(fault.getMessage());
            printWriter.flush();
            Main.exit(2);
        }
    }

    private static TestSuite openTestSuite(File file) throws Fault {
        try {
            return TestSuite.open(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Fault(i18n, "main.cantFindTestSuite", file);
        }
        catch (TestSuite.Fault fault) {
            throw new Fault(i18n, "main.cantOpenTestSuite", new Object[]{file, fault});
        }
    }

    private static WorkDirectory openWorkDirectory(File file, File file2) throws Fault {
        try {
            WorkDirectory workDirectory;
            if (file2 == null) {
                workDirectory = WorkDirectory.open(file);
            } else {
                File file3 = new File(file.getPath() + "/jtData/testsuite");
                suiteCopy = File.createTempFile("cof", ".tmp");
                Main.copyFile(file3, suiteCopy);
                workDirectory = WorkDirectory.open(file, Main.openTestSuite(file2));
            }
            return workDirectory;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Fault(i18n, "main.cantFindWorkDir", file);
        }
        catch (WorkDirectory.Fault fault) {
            throw new Fault(i18n, "main.cantOpenWorkDir", new Object[]{file, fault});
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static void showCommandLineHelp(PrintWriter printWriter) {
        String string = System.getProperty("program", "java " + (class$com$sun$javatest$cof$Main == null ? (class$com$sun$javatest$cof$Main = Main.class$("com.sun.javatest.cof.Main")) : class$com$sun$javatest$cof$Main).getName());
        printWriter.println(i18n.getString("main.cmdLine.proto", string));
        printWriter.println();
        printWriter.println(i18n.getString("main.cmdLine.optHead"));
        printWriter.println(i18n.getString("main.cmdLine.file"));
        printWriter.println(i18n.getString("main.cmdLine.help"));
        printWriter.println(i18n.getString("main.cmdLine.out"));
        printWriter.println(i18n.getString("main.cmdLine.ts"));
        printWriter.println(i18n.getString("main.cmdLine.xsd"));
        printWriter.println(i18n.getString("main.cmdLine.no-testcases"));
        printWriter.println(i18n.getString("main.cmdLine.data"));
        printWriter.println();
        printWriter.println(i18n.getString("main.cmdLine.filesHead"));
        printWriter.println(i18n.getString("main.cmdLine.dir"));
        printWriter.println();
        printWriter.println(i18n.getString("main.copyright.txt"));
    }

    void run(String[] stringArray, PrintWriter printWriter) throws BadArgs, Fault {
        Object object;
        Object object2;
        COFData cOFData;
        boolean bl = false;
        boolean bl2 = false;
        File file = null;
        if (stringArray.length == 0) {
            bl = true;
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-o") && i + 1 < stringArray.length) {
                    file = new File(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equals("-f") && i + 1 < stringArray.length) {
                    this.data.add(new File(stringArray[++i]));
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-help") || stringArray[i].equalsIgnoreCase("-usage") || stringArray[i].equalsIgnoreCase("/?")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-no-testcases")) {
                    COFTest.noTestCases = true;
                    COFTest.xmlElements.remove("testcases");
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-xsd")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-ts") && i + 1 < stringArray.length) {
                    this.tsPath = new File(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].startsWith("-")) {
                    throw new BadArgs(i18n, "main.badOpt", stringArray[i]);
                }
                if (stringArray[i].indexOf("=") != -1) {
                    this.data.add(stringArray[i]);
                    continue;
                }
                if (i == stringArray.length - 1) {
                    this.dir = new File(stringArray[i]);
                    continue;
                }
                throw new BadArgs(i18n, "main.badArg", stringArray[i]);
            }
        }
        if (bl) {
            Main.showCommandLineHelp(printWriter);
            if (this.dir == null && file == null) {
                return;
            }
        }
        if (file == null) {
            throw new BadArgs(i18n, "main.noOutputFile");
        }
        if (this.dir == null) {
            throw new BadArgs(i18n, "main.noResults");
        }
        if (!this.dir.exists()) {
            throw new BadArgs(i18n, "main.cantFindResults");
        }
        try {
            cOFData = new COFData(this.data);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Fault(i18n, "main.badOpt", illegalArgumentException.toString());
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "main.cantReadFile", iOException);
        }
        try {
            object2 = this.fillReport(cOFData);
            object = new XMLWriter(new FileWriter(file));
            ((COFItem)object2).write((XMLWriter)object);
            ((XMLWriter)object).close();
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "main.cantWriteFile", new Object[]{file, iOException});
        }
        if (bl2) {
            object2 = new File(file.getAbsoluteFile().getParent(), COF_SCHEMA);
            try {
                int n;
                object = new BufferedInputStream(this.getClass().getResourceAsStream(COF_SCHEMA));
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream((File)object2));
                byte[] byArray = new byte[4096];
                while ((n = ((InputStream)object).read(byArray, 0, byArray.length)) != -1) {
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                }
                ((InputStream)object).close();
                ((OutputStream)bufferedOutputStream).close();
            }
            catch (IOException iOException) {
                throw new Fault(i18n, "main.cantWriteFile", new Object[]{object2, iOException});
            }
        }
        if (suiteCopy != null) {
            object2 = new File(this.dir.getPath() + "/jtData/testsuite");
            Main.copyFile(suiteCopy, (File)object2);
            suiteCopy.delete();
        }
    }

    private Report fillReport(COFData cOFData) throws Fault {
        COFTestSuite cOFTestSuite;
        COFEnvironment cOFEnvironment = new COFEnvironment(cOFData);
        cOFEnvironment.setId(cOFData.get("environment.id", "env:0"));
        if (WorkDirectory.isWorkDirectory(this.dir)) {
            cOFData.put("workdir", this.dir.getAbsolutePath());
            cOFTestSuite = new COFTestSuite(Main.openWorkDirectory(this.dir, this.tsPath), cOFData);
        } else {
            cOFTestSuite = new COFTestSuite(this.dir, cOFData);
        }
        Report report = new Report(cOFEnvironment, cOFTestSuite);
        report.setHarness(cOFData.get("report.harness"));
        COFSWEntities cOFSWEntities = new COFSWEntities();
        COFSWEntity cOFSWEntity = new COFSWEntity();
        cOFSWEntity.setId(cOFData.get("swentity.id", "sw:0"));
        cOFSWEntity.setName(cOFData.get("swentity.name", "JDK"));
        cOFSWEntity.setType(cOFData.get("swentity.type", "java"));
        cOFSWEntity.setVersion(cOFData.get("swentity.version"));
        cOFSWEntity.setDescription(cOFData.get("swentity.description"));
        cOFSWEntities.getSwentity().add(cOFSWEntity);
        report.setSwentities(cOFSWEntities);
        COFApplications cOFApplications = new COFApplications();
        COFApplication cOFApplication = new COFApplication();
        cOFApplication.setEnvironmentid(cOFEnvironment.getId());
        cOFApplication.setSwentityid(cOFSWEntity.getId());
        cOFApplications.getApplication().add(cOFApplication);
        report.setApplications(cOFApplications);
        return report;
    }

    public static void copyFile(File file, File file2) {
        try {
            FileChannel fileChannel = new FileInputStream(file).getChannel();
            FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
            fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
            fileChannel.close();
            fileChannel2.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            System.out.println(iOException.getLocalizedMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Fault
    extends Exception {
        private static final long serialVersionUID = -4066018402688615825L;

        Fault(I18NResourceBundle i18NResourceBundle, String string) {
            super(i18NResourceBundle.getString(string));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle.getString(string, object));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
            super(i18NResourceBundle.getString(string, objectArray));
        }
    }

    public static class BadArgs
    extends Exception {
        private static final long serialVersionUID = 4638654313770205243L;

        BadArgs(I18NResourceBundle i18NResourceBundle, String string) {
            super(i18NResourceBundle.getString(string));
        }

        BadArgs(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle.getString(string, object));
        }

        BadArgs(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
            super(i18NResourceBundle.getString(string, objectArray));
        }
    }
}

