/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.Harness;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.exec.BP_BranchSubpanel;
import com.sun.javatest.exec.BP_FilteredOutSubpanel;
import com.sun.javatest.exec.BP_Model;
import com.sun.javatest.exec.BP_SummarySubpanel;
import com.sun.javatest.exec.BP_TestListSubpanel;
import com.sun.javatest.exec.FilterSelectionHandler;
import com.sun.javatest.exec.TT_NodeCache;
import com.sun.javatest.exec.TestTreeModel;
import com.sun.javatest.exec.TreePanelModel;
import com.sun.javatest.tool.IconFactory;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.Debug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;

class BranchPanel
extends JPanel
implements FilterSelectionHandler.Observer {
    private TestTreeModel ttm;
    private JTabbedPane bPane;
    private JTextField statusTf;
    private TestResultTable.TreeNode currNode;
    private TreePanelModel tpm;
    private Harness harness;
    private FilterSelectionHandler filterHandler;
    private TT_NodeCache cache;
    private CacheObserver cacheWatcher = new CacheObserver();
    private UIFactory uif;
    private BP_BranchSubpanel currPanel;
    private BranchModel bModel = new BranchModel();
    private volatile boolean needToUpdateGUIWhenShown;
    private volatile boolean needToUpdateData;
    protected Parameters params;
    protected static final int NUM_TABS = 6;
    static final int STATUS_FILTERED = 4;
    private BP_SummarySubpanel summPanel;
    private BP_FilteredOutSubpanel foPanel;
    private BP_TestListSubpanel[] lists;
    private boolean[] listDisplayStatus;
    private BP_BranchSubpanel[] allPanels;
    private static boolean debug = Debug.getBoolean(class$com$sun$javatest$exec$BranchPanel == null ? (class$com$sun$javatest$exec$BranchPanel = BranchPanel.class$("com.sun.javatest.exec.BranchPanel")) : class$com$sun$javatest$exec$BranchPanel);
    static /* synthetic */ Class class$com$sun$javatest$exec$BranchPanel;

    BranchPanel(UIFactory uIFactory, TreePanelModel treePanelModel, Harness harness, FilterSelectionHandler filterSelectionHandler, TestTreeModel testTreeModel) {
        this.uif = uIFactory;
        this.tpm = treePanelModel;
        this.harness = harness;
        this.filterHandler = filterSelectionHandler;
        this.ttm = testTreeModel;
        this.initGUI();
        filterSelectionHandler.addObserver(this);
    }

    void setNode(TestResultTable.TreeNode treeNode) {
        if (treeNode == this.currNode) {
            return;
        }
        this.updatePanel(treeNode, this.currPanel);
    }

    void setParameters(Parameters parameters) {
        this.params = parameters;
        TestResultTable testResultTable = null;
        if (parameters.getWorkDirectory() != null) {
            testResultTable = parameters.getWorkDirectory().getTestResultTable();
        }
    }

    void dispose() {
        this.summPanel.dispose();
    }

    protected void initGUI() {
        this.setName("branch");
        this.allPanels = new BP_BranchSubpanel[6];
        this.summPanel = new BP_SummarySubpanel(this.uif, this.bModel, this.ttm);
        this.allPanels[0] = this.summPanel;
        this.lists = new BP_TestListSubpanel[4];
        for (int i = 0; i < this.lists.length; ++i) {
            this.lists[i] = new BP_TestListSubpanel(this.uif, this.bModel, this.ttm, i);
            this.allPanels[i + 1] = this.lists[i];
        }
        this.foPanel = new BP_FilteredOutSubpanel(this.uif, this.bModel, this.ttm);
        this.allPanels[this.allPanels.length - 1] = this.foPanel;
        this.listDisplayStatus = new boolean[this.allPanels.length];
        JComponent[] jComponentArray = new JComponent[2 + this.lists.length];
        jComponentArray[0] = this.summPanel;
        jComponentArray[jComponentArray.length - 1] = this.foPanel;
        System.arraycopy(this.lists, 0, jComponentArray, 1, this.lists.length);
        this.bPane = this.uif.createTabbedPane("br.tabs", jComponentArray);
        this.bPane.setTabPlacement(1);
        this.bPane.setBorder(BorderFactory.createEmptyBorder());
        this.bPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Component component = BranchPanel.this.bPane.getSelectedComponent();
                if (component instanceof BP_BranchSubpanel) {
                    BP_BranchSubpanel bP_BranchSubpanel = (BP_BranchSubpanel)component;
                    bP_BranchSubpanel.updateSubpanel(BranchPanel.this.currNode);
                    if (BranchPanel.this.bPane.isEnabledAt(BranchPanel.this.bPane.indexOfComponent(component))) {
                        BranchPanel.this.updatePanel(BranchPanel.this.currNode, bP_BranchSubpanel);
                        BranchPanel.this.statusTf.setText(bP_BranchSubpanel.getLastMessage());
                    }
                }
            }
        });
        Icon[] iconArray = new Icon[6];
        for (int i = 1; i < 6; ++i) {
            this.bPane.setIconAt(i, IconFactory.getTestIcon(i - 1, false, true));
        }
        this.currPanel = this.summPanel;
        CSH.setHelpIDString(this.bPane, CSH.getHelpIDString(this.currPanel));
        this.setLayout(new BorderLayout());
        this.add((Component)this.bPane, "Center");
        ComponentListener componentListener = new ComponentListener(){

            public void componentResized(ComponentEvent componentEvent) {
                BranchPanel.this.currPanel.invalidate();
                BranchPanel.this.bPane.invalidate();
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
                if (BranchPanel.this.needToUpdateGUIWhenShown) {
                    BranchPanel.this.updateGUI();
                    BranchPanel.this.needToUpdateGUIWhenShown = false;
                }
            }

            public void componentHidden(ComponentEvent componentEvent) {
            }
        };
        this.addComponentListener(componentListener);
        this.statusTf = this.uif.createOutputField("br.status");
        this.statusTf.setEnabled(true);
        this.statusTf.setEditable(false);
        this.add((Component)this.statusTf, "South");
    }

    protected void updatePanel(TestResultTable.TreeNode treeNode, BP_BranchSubpanel bP_BranchSubpanel) {
        if (bP_BranchSubpanel != this.currPanel) {
            CSH.setHelpIDString(this.bPane, CSH.getHelpIDString(bP_BranchSubpanel));
            this.currPanel = bP_BranchSubpanel;
        }
        if (treeNode != this.currNode) {
            if (debug) {
                Debug.println("BP - setting node to " + treeNode.getName() + "  " + treeNode);
                Debug.println("   -> old node " + (this.currNode == null ? "[null]" : this.currNode.getName()) + "  " + this.currNode);
            }
            this.currNode = treeNode;
            if (this.isVisible()) {
                this.updateGUI();
            } else {
                this.needToUpdateGUIWhenShown = true;
            }
        }
    }

    TestResultTable.TreeNode getNode() {
        return this.currNode;
    }

    protected void updateGUI() {
        if (this.currNode == null) {
            for (int i = 1; i < this.bPane.getComponentCount(); ++i) {
                this.bPane.setEnabledAt(i, false);
            }
        } else {
            if (this.cache != null) {
                this.cache.removeObserver(this.cacheWatcher);
            }
            this.cache = this.ttm.getNodeInfo(this.currNode, false);
            this.cache.addObserver(this.cacheWatcher, false);
            this.summPanel.updateSubpanel(this.currNode);
            this.foPanel.reset(this.cache);
            for (int i = 0; i < this.lists.length; ++i) {
                this.lists[i].reset(this.cache);
            }
            if (this.currPanel != this.summPanel) {
                this.currPanel.updateSubpanel(this.currNode);
            }
        }
    }

    private static boolean isAlongPath(TestResultTable.TreeNode[] treeNodeArray, TestResultTable.TreeNode treeNode) {
        for (int i = 0; i < treeNodeArray.length; ++i) {
            if (treeNodeArray[i] != treeNode) continue;
            return true;
        }
        return false;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void filterUpdated(TestFilter testFilter) {
        for (int i = 0; i < this.allPanels.length; ++i) {
            this.allPanels[i].invalidateFilters();
        }
        this.updateGUI();
    }

    public void filterSelected(TestFilter testFilter) {
        for (int i = 0; i < this.allPanels.length; ++i) {
            this.allPanels[i].invalidateFilters();
        }
        this.updateGUI();
    }

    public void filterAdded(TestFilter testFilter) {
    }

    public void filterRemoved(TestFilter testFilter) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CacheObserver
    extends TT_NodeCache.TT_NodeCacheObserver {
        CacheObserver() {
            this.interestList[0] = false;
            this.interestList[1] = true;
            this.interestList[2] = false;
            this.interestList[3] = false;
            this.interestList[4] = false;
            this.interestList[5] = false;
            this.interestList[6] = false;
        }

        public void testAdded(int n, TestResultTable.TreeNode[] treeNodeArray, TestResult testResult, int n2) {
        }

        public void testRemoved(int n, TestResultTable.TreeNode[] treeNodeArray, TestResult testResult, int n2) {
        }

        public void statsUpdated(int[] nArray) {
            if (!EventQueue.isDispatchThread()) {
                Runnable runnable = new Runnable(this, nArray){
                    private final /* synthetic */ int[] val$stats;
                    private final /* synthetic */ CacheObserver this$1;
                    {
                        this.this$1 = cacheObserver;
                        this.val$stats = nArray;
                    }

                    public void run() {
                        this.this$1.statsUpdated(this.val$stats);
                    }
                };
                EventQueue.invokeLater(runnable);
            } else {
                int n;
                for (n = 0; n < nArray.length; ++n) {
                    if (nArray[n] > 0 && !BranchPanel.this.listDisplayStatus[n + 1]) {
                        BranchPanel.this.bModel.setEnabled(n + 1, true);
                    }
                    if (nArray[n] != 0 || !BranchPanel.this.listDisplayStatus[n + 1]) continue;
                    BranchPanel.this.bModel.setEnabled(n + 1, false);
                }
                n = BranchPanel.this.cache.getRejectCount();
                if (n == 0) {
                    if (BranchPanel.this.listDisplayStatus[BranchPanel.this.listDisplayStatus.length - 1]) {
                        BranchPanel.this.bModel.setEnabled(BranchPanel.this.listDisplayStatus.length - 1, false);
                    }
                } else if (n > 0 && !BranchPanel.this.listDisplayStatus[BranchPanel.this.listDisplayStatus.length - 1]) {
                    BranchPanel.this.bModel.setEnabled(BranchPanel.this.listDisplayStatus.length - 1, true);
                }
            }
        }
    }

    static class TextUpdater
    implements Runnable {
        static final int UPDATE = 1;
        static final int CLEAR = 2;
        static final int WAIT = 3;
        static final int MSG = 4;
        private int type;
        private int[] values;
        private JTextComponent[] tfs;
        private JTextComponent stf;
        private String msg;
        private UIFactory uif;

        TextUpdater(int n, JTextComponent[] jTextComponentArray, int[] nArray, UIFactory uIFactory) {
            this.type = n;
            this.values = nArray;
            this.tfs = jTextComponentArray;
            this.uif = uIFactory;
        }

        TextUpdater(JTextComponent jTextComponent, String string, UIFactory uIFactory) {
            this.type = 4;
            this.stf = jTextComponent;
            this.msg = string;
            this.uif = uIFactory;
        }

        public void run() {
            switch (this.type) {
                case 1: {
                    for (int i = 0; i < this.tfs.length; ++i) {
                        if (this.values[i] >= 0) {
                            this.tfs[i].setText(Integer.toString(this.values[i]));
                            continue;
                        }
                        this.tfs[i].setText("");
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < this.tfs.length; ++i) {
                        this.tfs[i].setText("");
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < this.tfs.length; ++i) {
                        this.tfs[i].setText("wait...");
                    }
                    break;
                }
                case 4: {
                    this.stf.setText(this.msg);
                    break;
                }
                default: {
                    throw new JavaTestError(this.uif.getI18NString("br.noEType2"));
                }
            }
        }
    }

    class BranchModel
    implements BP_Model {
        BranchModel() {
        }

        public boolean isRunning() {
            return BranchPanel.this.harness.isRunning();
        }

        public void showMessage(String string) {
            EventQueue.invokeLater(new TextUpdater(BranchPanel.this.statusTf, string, BranchPanel.this.uif));
        }

        public void showTest(TestResult testResult, Object[] objectArray) {
            BranchPanel.this.tpm.showTest(testResult, new TreePath(objectArray));
        }

        public void setEnabled(Component component, boolean bl) {
            if (!EventQueue.isDispatchThread()) {
                Runnable runnable = new Runnable(this, component, bl){
                    private final /* synthetic */ Component val$c;
                    private final /* synthetic */ boolean val$state;
                    private final /* synthetic */ BranchModel this$1;
                    {
                        this.this$1 = branchModel;
                        this.val$c = component;
                        this.val$state = bl;
                    }

                    public void run() {
                        this.this$1.setEnabled(this.val$c, this.val$state);
                    }
                };
                EventQueue.invokeLater(runnable);
            } else {
                if (BranchPanel.this.bPane == null) {
                    return;
                }
                this.setEnabled(BranchPanel.this.bPane.indexOfComponent(component), bl);
            }
        }

        public boolean isEnabled(Component component) {
            int n = BranchPanel.this.bPane.indexOfComponent(component);
            if (n == -1) {
                return false;
            }
            return BranchPanel.this.listDisplayStatus[n];
        }

        public TestFilter getFilter() {
            return BranchPanel.this.filterHandler.getActiveFilter();
        }

        void setEnabled(int n, boolean bl) {
            if (BranchPanel.this.listDisplayStatus[n] == bl) {
                return;
            }
            if (!EventQueue.isDispatchThread()) {
                Runnable runnable = new Runnable(this, n, bl){
                    private final /* synthetic */ int val$index;
                    private final /* synthetic */ boolean val$newState;
                    private final /* synthetic */ BranchModel this$1;
                    {
                        this.this$1 = branchModel;
                        this.val$index = n;
                        this.val$newState = bl;
                    }

                    public void run() {
                        this.this$1.setEnabled(this.val$index, this.val$newState);
                    }
                };
                EventQueue.invokeLater(runnable);
            } else {
                if (n == -1) {
                    return;
                }
                if (debug) {
                    if (bl) {
                        Debug.print("Enabling ");
                    } else {
                        Debug.print("Disabling ");
                    }
                    Debug.println("branch tab index " + n);
                }
                ((BranchPanel)BranchPanel.this).listDisplayStatus[n] = bl;
                BranchPanel.this.bPane.setEnabledAt(n, bl);
            }
        }
    }
}

