/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Checklist;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.tool.FileChooser;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

class ChecklistBrowser
extends ToolDialog {
    private static final String SAVE_AS = "SaveAs";
    private static final String PRINT_SETUP = "PrintSetup";
    private static final String PRINT = "Print";
    private ExecModel model;
    private InterviewParameters params;
    private JScrollPane scrollPane;
    private JEditorPane body;
    private FileChooser fileChooser;
    private Listener listener;

    ChecklistBrowser(JComponent jComponent, ExecModel execModel, UIFactory uIFactory) {
        super(jComponent, uIFactory, "cb");
        if (execModel == null) {
            throw new NullPointerException();
        }
        this.model = execModel;
        this.params = execModel.getInterviewParameters();
        if (this.params == null) {
            throw new NullPointerException();
        }
        this.listener = new Listener();
    }

    protected void initGUI() {
        this.setHelp("checklist.window.csh");
        JMenuBar jMenuBar = this.uif.createMenuBar("cb");
        String[] stringArray = new String[]{SAVE_AS, PRINT_SETUP, PRINT};
        JMenu jMenu = this.uif.createMenu("cb.file", stringArray, this.listener);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        this.body = new JEditorPane();
        this.body.setContentType("text/html");
        this.body.setText("");
        this.body.setEditable(false);
        this.body.addHyperlinkListener(this.listener);
        this.body.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.uif.setAccessibleName(this.body, "cb");
        this.uif.setToolTip(this.body, "cb");
        this.scrollPane = this.uif.createScrollPane(this.body);
        int n = this.uif.getDotsPerInch();
        this.scrollPane.setPreferredSize(new Dimension(6 * n, 8 * n));
        this.setBody(this.scrollPane);
        JButton jButton = this.uif.createHelpButton("cb.help", "checklist.window.csh");
        JButton jButton2 = this.uif.createCloseButton("cb.close");
        this.setButtons(new JButton[]{jButton, jButton2}, jButton2);
        this.setComponentListener(this.listener);
    }

    private void updateContent() {
        File file;
        if (this.body == null) {
            this.initGUI();
        }
        if ((file = this.params.getFile()) == null) {
            this.setI18NTitle("cb.title");
        } else {
            this.setI18NTitle("cb.titleWithFile", file);
        }
        try {
            Checklist checklist = this.params.createChecklist();
            StringWriter stringWriter = new StringWriter();
            this.writeChecklist(checklist, stringWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeChecklist(Checklist checklist, Writer writer) throws IOException {
        writer.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n");
        writer.write("<html><body>\n");
        TestEnvironment testEnvironment = this.params.getEnv();
        if (testEnvironment != null) {
            writer.write("<h1>");
            writer.write(this.escape(this.uif.getI18NString("cb.html.title", testEnvironment.getName())));
            writer.write("</h1>\n");
        }
        if (checklist.isEmpty()) {
            writer.write(this.escape(this.uif.getI18NString("cb.html.noEntries")));
        } else {
            writer.write(this.escape(this.uif.getI18NString("cb.html.intro")));
            String[] stringArray = checklist.getSectionNames();
            for (int i = 0; i < stringArray.length; ++i) {
                this.writeSection(checklist, stringArray[i], writer);
            }
        }
        writer.write("</body></html>");
        writer.close();
        this.body.setText(writer.toString());
        this.body.getCaret().setDot(0);
    }

    private void writeSection(Checklist checklist, String string, Writer writer) throws IOException {
        writer.write("<h2>");
        writer.write(this.escape(string));
        writer.write("</h2>\n");
        writer.write("<ul>");
        String[] stringArray = checklist.getSectionMessages(string);
        for (int i = 0; i < stringArray.length; ++i) {
            writer.write("<li>");
            writer.write(this.escape(stringArray[i]));
            writer.write("\n");
        }
        writer.write("</ul>\n");
    }

    private String escape(String string) {
        for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '&': 
                case '<': 
                case '>': {
                    StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
                    block9: for (int j = 0; j < string.length(); ++j) {
                        char c = string.charAt(j);
                        switch (c) {
                            case '<': {
                                stringBuffer.append("&lt;");
                                continue block9;
                            }
                            case '>': {
                                stringBuffer.append("&gt;");
                                continue block9;
                            }
                            case '&': {
                                stringBuffer.append("&amp;");
                                continue block9;
                            }
                            default: {
                                stringBuffer.append(c);
                            }
                        }
                    }
                    return stringBuffer.toString();
                }
            }
        }
        return string;
    }

    private void doSaveAs() {
        if (this.fileChooser == null) {
            this.fileChooser = new FileChooser(true);
            this.fileChooser.addChoosableExtension(".html", this.uif.getI18NString("cb.htmlFiles"));
        }
        this.fileChooser.setDialogTitle(this.uif.getI18NString("cb.save.title"));
        File file = null;
        block6: while (file == null) {
            String string;
            int n = this.fileChooser.showDialog(this.parent, this.uif.getI18NString("cb.save.btn"));
            if (n != 0) {
                return;
            }
            file = this.fileChooser.getSelectedFile();
            if (!file.exists() && !(string = file.getPath()).endsWith(".html")) {
                file = new File(string + ".html");
            }
            if (!file.exists()) continue;
            n = this.uif.showYesNoCancelDialog("cb.save.warn");
            switch (n) {
                case 0: {
                    continue block6;
                }
                case 1: {
                    this.fileChooser.setSelectedFile(null);
                    file = null;
                    continue block6;
                }
            }
            return;
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(this.body.getText());
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            if (!file.canWrite()) {
                this.uif.showError("cb.save.cantWriteFile", file);
            }
            if (iOException instanceof FileNotFoundException) {
                this.uif.showError("cb.save.cantFindFile", file);
            }
            this.uif.showError("cb.save.error", new Object[]{file, iOException});
        }
    }

    private void doPrintSetup() {
        this.model.printSetup();
    }

    private void doPrint() {
        WorkDirectory workDirectory = this.params.getWorkDirectory();
        try {
            File file = File.createTempFile("questionLog", ".html", workDirectory.getJTData());
            file.deleteOnExit();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(this.body.getText());
            ((Writer)bufferedWriter).close();
            this.model.print(file);
        }
        catch (IOException iOException) {
            JavaTestError.unexpectedException(iOException);
        }
    }

    private class Listener
    extends ComponentAdapter
    implements ActionListener,
    HyperlinkListener,
    Interview.Observer {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(ChecklistBrowser.SAVE_AS)) {
                ChecklistBrowser.this.doSaveAs();
            } else if (string.equals(ChecklistBrowser.PRINT_SETUP)) {
                ChecklistBrowser.this.doPrintSetup();
            } else if (string.equals(ChecklistBrowser.PRINT)) {
                ChecklistBrowser.this.doPrint();
            }
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String string = hyperlinkEvent.getDescription();
                if (!string.startsWith("#")) {
                    return;
                }
                ChecklistBrowser.this.body.scrollToReference(string.substring(1));
            }
        }

        public void componentShown(ComponentEvent componentEvent) {
            ChecklistBrowser.this.params.addObserver(this);
            ChecklistBrowser.this.updateContent();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            ChecklistBrowser.this.params.removeObserver(this);
        }

        public void currentQuestionChanged(Question question) {
        }

        public void pathUpdated() {
            ChecklistBrowser.this.updateContent();
        }
    }
}

