/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.AllTestsFilter;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.ObservableTestFilter;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestSuite;
import com.sun.javatest.exec.BasicCustomTestFilter;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.FilterConfig;
import com.sun.javatest.exec.FilterSelectionHandler;
import com.sun.javatest.exec.LastRunFilter;
import com.sun.javatest.exec.ParameterFilter;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.PrefixMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

class ET_FilterHandler {
    private FilterConfig fConfig;
    private FilterSelectionHandler fHandler;
    private ExecModel model;
    private UIFactory uif;
    private JComponent parentComponent;
    private Harness harness;
    private Map map;
    private LastRunFilter ltrFilter;
    private ParameterFilter paramFilter;
    private BasicCustomTestFilter bctf;
    private AllTestsFilter allFilter;
    private TestFilter certFilter;
    private Vector allFilters;
    private TestSuite lastTs;
    private static final String FILTER_PREFIX = "exec.vfilters";
    private static final String BTF_PREFIX = "exec.vfilters.btf";
    private static final String META_ID = "meta_tsid";
    private static final String META_NAME = "meta_tsn";
    private static final String META_CLASS = "meta_class";

    ET_FilterHandler(JComponent jComponent, ExecModel execModel, Harness harness, UIFactory uIFactory, Map map) {
        this.uif = uIFactory;
        this.model = execModel;
        this.parentComponent = jComponent;
        this.harness = harness;
        this.map = map;
        this.allFilters = new Vector();
        harness.addObserver(new Watcher());
    }

    FilterConfig loadFilters() {
        if (this.fConfig != null) {
            return this.fConfig;
        }
        this.fConfig = new FilterConfig(this.model, this.parentComponent, this.uif);
        this.fHandler = this.fConfig.createFilterSelectionHandler();
        ObservableTestFilter observableTestFilter = this.ltrFilter = new LastRunFilter();
        this.allFilters.add(observableTestFilter);
        this.fConfig.add(observableTestFilter);
        this.paramFilter = new ParameterFilter();
        observableTestFilter = this.paramFilter;
        this.allFilters.add(observableTestFilter);
        this.fConfig.add(observableTestFilter);
        this.allFilter = new AllTestsFilter();
        this.allFilters.add(this.allFilter);
        this.fConfig.add(this.allFilter);
        this.updateCustomFilter();
        this.fHandler.setFilter(this.getDefaultFilter(this.map));
        return this.fConfig;
    }

    FilterSelectionHandler getFilterSelectionHandler() {
        return this.fHandler;
    }

    private TestFilter getDefaultFilter(Map map) {
        if (map != null) {
            String string = (String)map.get("filter");
            for (int i = 0; i < this.allFilters.size(); ++i) {
                if (!this.allFilters.elementAt(i).getClass().getName().equals(string)) continue;
                return (TestFilter)this.allFilters.elementAt(i);
            }
        }
        return this.allFilter;
    }

    void updateParameters() {
        TestFilter testFilter;
        this.loadFilters();
        InterviewParameters interviewParameters = this.model.getInterviewParameters();
        if (interviewParameters == null) {
            return;
        }
        this.paramFilter.update(interviewParameters);
        this.updateCustomFilter();
        if (!this.ltrFilter.isWorkDirectorySet()) {
            this.ltrFilter.setWorkDirectory(this.model.getWorkDirectory());
        }
        if ((testFilter = interviewParameters.getRelevantTestFilter()) == null) {
            if (this.certFilter != null) {
                if (this.fHandler.getActiveFilter() == this.certFilter) {
                    this.fHandler.setFilter(this.paramFilter);
                }
                this.fConfig.remove(this.certFilter);
            }
        } else if (!testFilter.equals(this.certFilter)) {
            if (testFilter == this.certFilter) {
                this.fConfig.notifyUpdated(this.certFilter);
            } else {
                this.fConfig.add(testFilter);
                if (this.fHandler.getActiveFilter() == this.certFilter) {
                    this.fHandler.setFilter(testFilter);
                }
                this.fConfig.remove(this.certFilter);
                this.certFilter = testFilter;
            }
        }
    }

    JMenu getMenu() {
        this.loadFilters();
        return this.fHandler.getFilterMenu();
    }

    FilterConfig getFilterConfig() {
        return this.fConfig;
    }

    void save(Map map) {
        Preferences preferences = Preferences.access();
        TestFilter testFilter = this.fHandler.getActiveFilter();
        map.put("filter", testFilter.getClass().getName());
        TestSuite testSuite = this.model.getTestSuite();
        String string = null;
        String string2 = null;
        if (testSuite != null) {
            string = testSuite.getID();
            string2 = testSuite.getName();
        }
        int n = this.getPreferenceIndexForWrite(preferences, string);
        ConstrainedPreferenceMap constrainedPreferenceMap = new ConstrainedPreferenceMap(preferences);
        PrefixMap prefixMap = new PrefixMap(constrainedPreferenceMap, FILTER_PREFIX + n);
        if (string != null) {
            prefixMap.put(META_ID, string);
            prefixMap.put(META_NAME, string2);
        }
        prefixMap.put(META_CLASS, this.bctf.getClass().getName());
        this.bctf.save(prefixMap);
        preferences.save();
    }

    private void updateCustomFilter() {
        Preferences preferences;
        int n;
        if (this.lastTs != null) {
            return;
        }
        this.lastTs = this.model.getTestSuite();
        String string = null;
        String string2 = null;
        if (this.lastTs != null) {
            string = this.lastTs.getID();
            string2 = this.lastTs.getName();
        }
        if ((n = this.getPreferenceIndexForRead(preferences = Preferences.access(), string)) >= 0) {
            ConstrainedPreferenceMap constrainedPreferenceMap = new ConstrainedPreferenceMap(preferences);
            PrefixMap prefixMap = new PrefixMap(constrainedPreferenceMap, FILTER_PREFIX + n);
            if (this.bctf == null) {
                this.bctf = new BasicCustomTestFilter(prefixMap, this.model, this.uif);
                this.allFilters.add(this.bctf);
                this.fConfig.add(this.bctf);
            } else {
                this.bctf.load(prefixMap);
                this.fHandler.updateFilterMetaInfo(this.bctf);
            }
        } else if (this.bctf == null) {
            this.bctf = new BasicCustomTestFilter(this.model, this.uif);
            this.allFilters.add(this.bctf);
            this.fConfig.add(this.bctf);
        }
    }

    private int getPreferenceIndexForWrite(Preferences preferences, String string) {
        int n = 0;
        int n2 = this.getPreferenceCount(preferences);
        if (string != null && n2 != 0) {
            n = this.getPreferenceIndex(preferences, string, n2);
            if (n == -1) {
                n = ++n2;
                preferences.setPreference("exec.vfilters.count", Integer.toString(n2));
            }
        } else if (string != null && n2 == 0) {
            n = 1;
            n2 = 1;
            preferences.setPreference("exec.vfilters.count", Integer.toString(n2));
        }
        return n;
    }

    private int getPreferenceIndexForRead(Preferences preferences, String string) {
        int n = this.getPreferenceCount(preferences);
        int n2 = -1;
        n2 = n == 0 ? -1 : this.getPreferenceIndex(preferences, string, n);
        return n2;
    }

    private int getPreferenceIndex(Preferences preferences, String string, int n) {
        int n2 = -1;
        for (int i = 1; i <= n; ++i) {
            String string2 = preferences.getPreference(FILTER_PREFIX + i + "." + META_ID);
            if (!string2.equals(string)) continue;
            n2 = i;
            break;
        }
        if (n2 > n) {
            return -1;
        }
        return n2;
    }

    private int getPreferenceCount(Preferences preferences) {
        int n = Integer.parseInt(preferences.getPreference("exec.vfilters.count", "0"));
        return n;
    }

    static /* synthetic */ JComponent access$500(ET_FilterHandler eT_FilterHandler) {
        return eT_FilterHandler.parentComponent;
    }

    class Watcher
    implements Harness.Observer {
        Watcher() {
        }

        public void startingTestRun(Parameters parameters) {
            Preferences preferences;
            ET_FilterHandler.this.ltrFilter.setLastStartTime(System.currentTimeMillis());
            if (ET_FilterHandler.this.fHandler.getActiveFilter() == ET_FilterHandler.this.allFilter && (preferences = Preferences.access()).getPreference("exec.filterWarn", "true").equals("true")) {
                JPanel jPanel = ET_FilterHandler.this.uif.createPanel("notagain", false);
                JCheckBox jCheckBox = ET_FilterHandler.this.uif.createCheckBox("exec.fltr.noShow", false);
                JTextArea jTextArea = ET_FilterHandler.this.uif.createMessageArea("exec.fltr.note");
                EventQueue.invokeLater(new Runnable(this, jPanel, jCheckBox, jTextArea, preferences){
                    private final /* synthetic */ JPanel val$pan;
                    private final /* synthetic */ JCheckBox val$cb;
                    private final /* synthetic */ JTextArea val$msg;
                    private final /* synthetic */ Preferences val$p;
                    private final /* synthetic */ Watcher this$1;
                    {
                        this.this$1 = watcher;
                        this.val$pan = jPanel;
                        this.val$cb = jCheckBox;
                        this.val$msg = jTextArea;
                        this.val$p = preferences;
                    }

                    public void run() {
                        this.val$pan.setLayout(new BorderLayout());
                        this.val$pan.add((Component)this.val$cb, "South");
                        this.val$pan.add((Component)this.val$msg, "Center");
                        JOptionPane jOptionPane = new JOptionPane(this.val$pan, 1, -1, null, null, null);
                        JDialog jDialog = jOptionPane.createDialog(ET_FilterHandler.access$500(Watcher.access$400(this.this$1)), ET_FilterHandler.access$300(Watcher.access$400(this.this$1)).getI18NString("exec.fltr.note.title"));
                        jDialog.show();
                        Object object = jOptionPane.getValue();
                        if (object instanceof Integer && (Integer)object >= 0) {
                            this.val$p.setPreference("exec.filterWarn", Boolean.toString(!this.val$cb.isSelected()));
                        }
                    }
                });
            }
        }

        public void startingTest(TestResult testResult) {
        }

        public void finishedTest(TestResult testResult) {
        }

        public void stoppingTestRun() {
        }

        public void finishedTesting() {
        }

        public void finishedTestRun(boolean bl) {
        }

        public void error(String string) {
        }

        static /* synthetic */ ET_FilterHandler access$400(Watcher watcher) {
            return watcher.ET_FilterHandler.this;
        }
    }

    private class FilterWatcher
    implements FilterSelectionHandler.Observer {
        private FilterWatcher() {
        }

        public void filterUpdated(TestFilter testFilter) {
        }

        public void filterSelected(TestFilter testFilter) {
        }

        public void filterAdded(TestFilter testFilter) {
        }

        public void filterRemoved(TestFilter testFilter) {
        }
    }

    private static class ConstrainedPreferenceMap
    implements Map {
        private Preferences prefs;

        ConstrainedPreferenceMap(Preferences preferences) {
            this.prefs = preferences;
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean containsValue(Object object) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            throw new UnsupportedOperationException();
        }

        public Object get(Object object) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("key must be a string");
            }
            return this.prefs.getPreference((String)object);
        }

        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        public Set keySet() {
            throw new UnsupportedOperationException();
        }

        public Object put(Object object, Object object2) {
            if (!(object instanceof String) || !(object2 instanceof String)) {
                throw new IllegalArgumentException("both args must be strings");
            }
            this.prefs.setPreference((String)object, (String)object2);
            return null;
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            throw new UnsupportedOperationException();
        }

        public Collection values() {
            throw new UnsupportedOperationException();
        }

        public void put(String string, String string2) {
            this.prefs.setPreference(string, string2);
        }

        public String get(String string) {
            return this.prefs.getPreference(string);
        }
    }
}

