/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.Harness;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestResult;
import com.sun.javatest.exec.BranchPanel;
import com.sun.javatest.exec.Monitor;
import com.sun.javatest.exec.MonitorState;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.UIFactory;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ResourceBundle;
import javax.help.CSH;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.text.JTextComponent;

class MessageStrip
extends JSplitPane
implements Harness.Observer,
ComponentListener {
    private JTextField leftField;
    private JPanel rightPanel;
    private JButton selectButt;
    private JButton magButt;
    private JComboBox selector;
    private JPopupMenu popMenu;
    private ActionListener actionListener = new SelectionListener();
    private ActionListener zoomListener;
    private Monitor[] monitors;
    private MonitorState state;
    private int currMonitor;
    private CardLayout monitorCards;
    private int runningMonitor = -1;
    private int idleMonitor = -1;
    private Timer clearTimer;
    private static final int CLEAR_TIMEOUT = 5000;
    private UIFactory uif;
    private static final String MINI_PREF = "exec.monitorstrip.mini";

    MessageStrip(UIFactory uIFactory, Monitor[] monitorArray, MonitorState monitorState, ActionListener actionListener) {
        this.uif = uIFactory;
        this.monitors = monitorArray;
        this.state = monitorState;
        this.zoomListener = actionListener;
        this.setOrientation(1);
        this.leftField = uIFactory.createOutputField("strip.msg");
        this.leftField.setOpaque(false);
        this.setLeftComponent(this.leftField);
        this.setRightComponent(this.createRightPanel());
        this.setDividerSize(5);
        this.setEnabled(true);
        this.addComponentListener(this);
        uIFactory.setAccessibleInfo(this, "strip");
        this.setDividerLocation(0.6);
    }

    void setRunningMonitor(Monitor monitor) {
        for (int i = 0; i < this.monitors.length; ++i) {
            if (this.monitors[i] != monitor) continue;
            this.runningMonitor = i;
            break;
        }
    }

    void setIdleMonitor(Monitor monitor) {
        for (int i = 0; i < this.monitors.length; ++i) {
            if (this.monitors[i] != monitor) continue;
            this.idleMonitor = i;
            break;
        }
        this.setMonitor(this.idleMonitor);
    }

    void setMonitor(final int n) {
        if (n < 0) {
            return;
        }
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    MessageStrip.this.setMonitor(n);
                }
            });
            return;
        }
        if (n < this.monitors.length) {
            this.currMonitor = n;
            this.monitorCards.show(this.rightPanel, this.monitors[n].getSmallMonitorName());
            this.selector.setSelectedItem(this.monitors[n]);
            this.validate();
            Preferences preferences = Preferences.access();
            preferences.setPreference(MINI_PREF, this.monitors[n].getClass().getName());
        }
    }

    public void startingTestRun(Parameters parameters) {
        this.setText(this.leftField, this.uif.getI18NString("strip.start"));
        this.setMonitor(this.runningMonitor);
        if (this.clearTimer == null) {
            this.clearTimer = new Timer(5000, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MessageStrip.this.setText(MessageStrip.this.leftField, "");
                }
            });
        }
        this.clearTimer.start();
    }

    public void startingTest(TestResult testResult) {
        this.setText(this.leftField, this.uif.getI18NString("strip.running", testResult.getTestName()));
    }

    public void finishedTest(TestResult testResult) {
    }

    public void stoppingTestRun() {
        this.setText(this.leftField, this.uif.getI18NString("strip.stop"));
    }

    public void finishedTesting() {
        this.setText(this.leftField, this.uif.getI18NString("strip.cleanup"));
        this.setMonitor(this.idleMonitor);
    }

    public void finishedTestRun(boolean bl) {
        this.setText(this.leftField, this.uif.getI18NString("strip.finish"));
        if (this.clearTimer != null) {
            this.clearTimer.stop();
        }
    }

    public void error(String string) {
    }

    void showMessage(ResourceBundle resourceBundle, String string) {
        this.setText(this.leftField, resourceBundle.getString(string));
    }

    private void setText(JTextComponent jTextComponent, String string) {
        if (EventQueue.isDispatchThread()) {
            jTextComponent.setText(string);
        } else {
            EventQueue.invokeLater(new BranchPanel.TextUpdater(jTextComponent, string, this.uif));
        }
    }

    private JPopupMenu createMenu() {
        JPopupMenu jPopupMenu = this.uif.createPopupMenu("strip.menu");
        for (int i = 0; i < this.monitors.length; ++i) {
            JMenuItem jMenuItem = this.uif.createLiteralMenuItem(this.monitors[i].getSmallMonitorName(), this.actionListener);
            jMenuItem.setActionCommand(Integer.toString(i));
            jPopupMenu.add(jMenuItem);
        }
        return jPopupMenu;
    }

    private JComponent createRightPanel() {
        JPanel jPanel = this.uif.createPanel("strip.right", new GridBagLayout(), false);
        this.selector = this.uif.createLiteralChoice("strip.sel", this.monitors);
        this.uif.setAccessibleName(this.selector, "strip.sel");
        this.selector.addActionListener(this.actionListener);
        this.selector.setRenderer(new BasicComboBoxRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                try {
                    JLabel jLabel = (JLabel)component;
                    if (object instanceof Monitor) {
                        jLabel.setText(((Monitor)object).getSmallMonitorName());
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                return component;
            }
        });
        CSH.setHelpIDString(this.selector, "run.testProgress");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.monitorCards = new CardLayout();
        this.rightPanel = this.uif.createPanel("strip.", this.monitorCards, false);
        for (int i = 0; i < this.monitors.length; ++i) {
            this.rightPanel.add(this.monitors[i].getSmallMonitorName(), this.monitors[i].getSmallMonitor());
        }
        this.currMonitor = this.getDefaultSmallMonitor();
        this.monitorCards.show(this.rightPanel, this.monitors[this.currMonitor].getSmallMonitorName());
        JPanel jPanel2 = this.uif.createPanel("monitor container", new BorderLayout(), false);
        jPanel2.add((Component)this.selector, "West");
        jPanel2.add((Component)this.rightPanel, "Center");
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        this.magButt = this.uif.createIconButton("strip.magnify");
        this.magButt.addActionListener(this.actionListener);
        this.uif.setAccessibleName(this.magButt, "strip.magnify");
        JToolBar jToolBar = this.uif.createToolBar("strip.tb", new JButton[]{this.magButt});
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(true);
        jPanel.add((Component)jToolBar, gridBagConstraints);
        jPanel.setEnabled(true);
        jPanel.setVisible(true);
        this.rightPanel.setEnabled(true);
        this.rightPanel.setVisible(true);
        return jPanel;
    }

    private int getDefaultSmallMonitor() {
        if (this.idleMonitor != -1) {
            return this.idleMonitor;
        }
        Preferences preferences = Preferences.access();
        String string = preferences.getPreference(MINI_PREF, null);
        int n = 0;
        if (string != null && this.monitors != null) {
            try {
                for (int i = 0; i < this.monitors.length; ++i) {
                    if (!this.monitors[i].getClass().getName().equals(string)) continue;
                    n = i;
                    break;
                }
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        return n;
    }

    private int getMonitorIndex(Monitor monitor) {
        if (this.monitors == null || this.monitors.length == 0) {
            return -1;
        }
        for (int i = 0; i < this.monitors.length; ++i) {
            if (this.monitors[i] != monitor) continue;
            return i;
        }
        return -1;
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.setDividerLocation(0.7);
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    class SelectionListener
    implements ActionListener {
        SelectionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == MessageStrip.this.magButt) {
                MessageStrip.this.zoomListener.actionPerformed(actionEvent);
            } else if (object == MessageStrip.this.selector) {
                Object object2 = MessageStrip.this.selector.getSelectedItem();
                MessageStrip.this.setMonitor(MessageStrip.this.getMonitorIndex((Monitor)object2));
            } else if (object instanceof JMenuItem) {
                try {
                    int n = Integer.parseInt(actionEvent.getActionCommand());
                    if (MessageStrip.this.currMonitor == n || n >= MessageStrip.this.monitors.length) {
                        return;
                    }
                    MessageStrip.this.setMonitor(n);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }
}

