/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.TestResult;
import com.sun.javatest.exec.BranchPanel;
import com.sun.javatest.exec.ElapsedTimeMonitor;
import com.sun.javatest.exec.MonitorState;
import com.sun.javatest.exec.ProgressMeter;
import com.sun.javatest.exec.RenderingUtilities;
import com.sun.javatest.exec.TreePanelModel;
import com.sun.javatest.tool.I18NUtils;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.Border;

class ProgressMonitor
extends ToolDialog {
    private MonitorState state;
    private TreePanelModel tpm;
    private ProgressSubpanel progressSubpanel;
    private ActivitySubpanel activitySubpanel;
    private TimeSubpanel timeSubpanel;
    private MemorySubpanel memorySubpanel;
    private StatusSubpanel[] subpanels;
    private volatile boolean running;
    private Listener listener = new Listener();
    private static final int UPDATE_FREQUENCY = 1000;
    private static int componentCount;

    ProgressMonitor(Component component, UIFactory uIFactory, MonitorState monitorState) {
        super(component, uIFactory, "pm");
        this.state = monitorState;
    }

    protected void initGUI() {
        this.setI18NTitle("pm.title");
        this.setHelp("browse.testMonitor.csh");
        this.subpanels = new StatusSubpanel[4];
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.left = 8;
        gridBagConstraints.insets.right = 8;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.progressSubpanel = new ProgressSubpanel();
        this.subpanels[0] = this.progressSubpanel;
        jPanel.add((Component)this.progressSubpanel, gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        this.timeSubpanel = new TimeSubpanel();
        this.subpanels[1] = this.timeSubpanel;
        jPanel.add((Component)this.timeSubpanel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.memorySubpanel = new MemorySubpanel();
        this.subpanels[2] = this.memorySubpanel;
        jPanel.add((Component)this.memorySubpanel, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets.right = 8;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.weighty = 1.0;
        this.activitySubpanel = new ActivitySubpanel();
        this.subpanels[3] = this.activitySubpanel;
        jPanel.add((Component)this.activitySubpanel, gridBagConstraints);
        this.setBody(jPanel);
        JButton jButton = this.uif.createHelpButton("pm.help", "browse.testMonitor.csh");
        JButton jButton2 = this.uif.createCloseButton("pm.close");
        this.setButtons(new JButton[]{jButton, jButton2}, jButton2);
        this.state.addObserver(this.listener);
        if (this.state.isRunning()) {
            this.listener.starting();
        }
        for (int i = 0; i < this.subpanels.length; ++i) {
            this.subpanels[i].update();
        }
    }

    void setTreePanelModel(TreePanelModel treePanelModel) {
        this.tpm = treePanelModel;
    }

    static /* synthetic */ TreePanelModel access$3000(ProgressMonitor progressMonitor) {
        return progressMonitor.tpm;
    }

    private class MemorySubpanel
    extends StatusSubpanel {
        private JTextField usedField;
        private JTextField totalField;
        private ProgressMeter meter;
        private int[] meterStats = new int[2];
        private Runtime runtime = Runtime.getRuntime();

        MemorySubpanel() {
            this.setLayout(new GridBagLayout());
            Border border = ProgressMonitor.this.uif.createTitledBorder("pm.memory");
            Border border2 = BorderFactory.createEmptyBorder(10, 5, 10, 5);
            this.setBorder(BorderFactory.createCompoundBorder(border, border2));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets.right = 10;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.weightx = 1.0;
            JLabel jLabel = ProgressMonitor.this.uif.createLabel("pm.memory.used");
            jLabel.setDisplayedMnemonic(ProgressMonitor.this.uif.getI18NString("pm.memory.used.mne").charAt(0));
            this.add((Component)jLabel, gridBagConstraints);
            this.usedField = ProgressMonitor.this.uif.createOutputField("pm.memory.used", 10);
            this.add((Component)this.usedField, gridBagConstraints2);
            jLabel.setLabelFor(this.usedField);
            jLabel = ProgressMonitor.this.uif.createLabel("pm.memory.ttl");
            jLabel.setDisplayedMnemonic(ProgressMonitor.this.uif.getI18NString("pm.memory.ttl.mne").charAt(0));
            this.add((Component)jLabel, gridBagConstraints);
            this.totalField = ProgressMonitor.this.uif.createOutputField("pm.memory.ttl", 10);
            this.add((Component)this.totalField, gridBagConstraints2);
            jLabel.setLabelFor(this.totalField);
            this.add(Box.createVerticalStrut(10), gridBagConstraints2);
            ProgressMonitor.this.uif.setToolTip(this, "pm.memory");
        }

        void update() {
            int n = (int)(this.runtime.freeMemory() / 1024L);
            int n2 = (int)(this.runtime.totalMemory() / 1024L);
            int n3 = n2 - n;
            this.usedField.setText(n3 + "K");
            this.totalField.setText(n2 + "K");
        }
    }

    private class TimeSubpanel
    extends StatusSubpanel {
        private JTextField elapsedField;
        private JTextField estimatedRemainingField;
        private int[] meterStats = new int[2];

        TimeSubpanel() {
            this.setLayout(new GridBagLayout());
            Border border = ProgressMonitor.this.uif.createTitledBorder("pm.time");
            Border border2 = BorderFactory.createEmptyBorder(10, 5, 10, 5);
            this.setBorder(BorderFactory.createCompoundBorder(border, border2));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets.right = 10;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.weightx = 1.0;
            JLabel jLabel = ProgressMonitor.this.uif.createLabel("pm.time.sofar");
            jLabel.setDisplayedMnemonic(ProgressMonitor.this.uif.getI18NString("pm.time.sofar.mne").charAt(0));
            this.add((Component)jLabel, gridBagConstraints);
            this.elapsedField = ProgressMonitor.this.uif.createOutputField("pm.time.sofar", 8);
            this.add((Component)this.elapsedField, gridBagConstraints2);
            this.elapsedField.setText("00:00:00");
            jLabel.setLabelFor(this.elapsedField);
            jLabel = ProgressMonitor.this.uif.createLabel("pm.time.remain");
            jLabel.setDisplayedMnemonic(ProgressMonitor.this.uif.getI18NString("pm.time.remain.mne").charAt(0));
            this.add((Component)jLabel, gridBagConstraints);
            this.estimatedRemainingField = ProgressMonitor.this.uif.createOutputField("pm.time.remain", 8);
            this.add((Component)this.estimatedRemainingField, gridBagConstraints2);
            this.estimatedRemainingField.setText("00:00:00");
            jLabel.setLabelFor(this.estimatedRemainingField);
            this.add(Box.createVerticalStrut(10), gridBagConstraints2);
            ProgressMonitor.this.uif.setToolTip(this, "pm.time");
        }

        void update() {
            long l = ProgressMonitor.this.state.getElapsedTime();
            this.elapsedField.setText(ElapsedTimeMonitor.millisToString(l));
            long l2 = ProgressMonitor.this.state.getEstimatedTime();
            this.estimatedRemainingField.setText(ElapsedTimeMonitor.millisToString(l2));
        }
    }

    private class ActivitySubpanel
    extends StatusSubpanel {
        private JComponent idleCard;
        private JComponent runningCard;
        private JTextField fileField;
        private DefaultListModel testListData;
        private JList testList;
        private String rootDir;

        ActivitySubpanel() {
            this.setBorder(ProgressMonitor.this.uif.createTitledBorder("pm.activity"));
            this.setLayout(new CardLayout());
            this.idleCard = this.createSimpleCard("pm.idle");
            this.addCard(this.idleCard);
            this.initRunningCard();
            this.showCard(this.idleCard);
        }

        void starting() {
            this.showCard(this.runningCard);
        }

        void postProcessing() {
            this.showCard(this.idleCard);
        }

        void stopping() {
        }

        void update() {
            this.testListData.removeAllElements();
            TestResult[] testResultArray = ProgressMonitor.this.state.getRunningTests();
            for (int i = 0; i < testResultArray.length; ++i) {
                this.testListData.addElement(testResultArray[i]);
            }
        }

        private JComponent createSimpleCard(String string) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 10;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            JTextField jTextField = ProgressMonitor.this.uif.createHeading(string);
            ProgressMonitor.this.uif.setAccessibleInfo(jTextField, string);
            jPanel.add((Component)jTextField, gridBagConstraints);
            JLabel jLabel = ProgressMonitor.this.uif.createIconLabel(string);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weighty = 0.0;
            jPanel.add((Component)jLabel, gridBagConstraints);
            return jPanel;
        }

        private void initRunningCard() {
            this.testListData = new DefaultListModel();
            JList jList = ProgressMonitor.this.uif.createList("pm.runlist", this.testListData);
            jList.setBorder(BorderFactory.createEtchedBorder());
            jList.setCellRenderer(RenderingUtilities.createTestListRenderer());
            jList.addMouseListener(new MouseAdapter(this, jList){
                private final /* synthetic */ JList val$list;
                private final /* synthetic */ ActivitySubpanel this$1;
                {
                    this.this$1 = activitySubpanel;
                    this.val$list = jList;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    int n = this.val$list.locationToIndex(mouseEvent.getPoint());
                    E e = this.val$list.getModel().getElementAt(n);
                    if (e instanceof TestResult && ProgressMonitor.access$3000(ActivitySubpanel.access$2900(this.this$1)) != null) {
                        ProgressMonitor.access$3000(ActivitySubpanel.access$2900(this.this$1)).showTest(((TestResult)e).getTestName());
                    }
                }
            });
            this.runningCard = ProgressMonitor.this.uif.createScrollPane(jList, 20, 30);
            this.addCard(this.runningCard);
        }

        private void addCard(JComponent jComponent) {
            String string = jComponent.getName();
            if (string == null) {
                jComponent.setName("StatusDialog.component" + componentCount++);
            }
            this.add((Component)jComponent, jComponent.getName());
        }

        private void showCard(JComponent jComponent) {
            ((CardLayout)this.getLayout()).show(this, jComponent.getName());
        }

        static /* synthetic */ ProgressMonitor access$2900(ActivitySubpanel activitySubpanel) {
            return activitySubpanel.ProgressMonitor.this;
        }
    }

    private class ProgressSubpanel
    extends StatusSubpanel {
        private JTextField passTf;
        private JTextField failTf;
        private JTextField errorTf;
        private JTextField notRunTf;
        private ProgressMeter meter;
        private int[] meterStats;

        ProgressSubpanel() {
            this.setBorder(ProgressMonitor.this.uif.createTitledBorder("pm.prog"));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets.right = 10;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets.right = 5;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.insets.right = 15;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.gridwidth = 0;
            JTextField jTextField = ProgressMonitor.this.uif.createHeading("pm.tests");
            ProgressMonitor.this.uif.setAccessibleInfo(jTextField, "pm.tests");
            this.add((Component)jTextField, gridBagConstraints);
            JLabel jLabel = ProgressMonitor.this.uif.createLabel("pm.tests.pass");
            this.add((Component)jLabel, gridBagConstraints2);
            this.passTf = ProgressMonitor.this.uif.createOutputField("pm.tests.pass", 6);
            this.passTf.setHorizontalAlignment(4);
            jLabel.setLabelFor(this.passTf);
            jLabel.setDisplayedMnemonic(ProgressMonitor.this.uif.getI18NString("pm.tests.pass.mne").charAt(0));
            this.add((Component)this.passTf, gridBagConstraints3);
            jLabel = ProgressMonitor.this.uif.createLabel("pm.tests.fail");
            jLabel.setDisplayedMnemonic(ProgressMonitor.this.uif.getI18NString("pm.tests.fail.mne").charAt(0));
            this.add((Component)jLabel, gridBagConstraints2);
            this.failTf = ProgressMonitor.this.uif.createOutputField("pm.tests.fail", 6);
            this.failTf.setHorizontalAlignment(4);
            jLabel.setLabelFor(this.failTf);
            this.add((Component)this.failTf, gridBagConstraints3);
            jLabel = ProgressMonitor.this.uif.createLabel("pm.tests.err");
            this.add((Component)jLabel, gridBagConstraints2);
            this.errorTf = ProgressMonitor.this.uif.createOutputField("pm.tests.err", 6);
            jLabel.setDisplayedMnemonic(ProgressMonitor.this.uif.getI18NString("pm.tests.err.mne").charAt(0));
            this.errorTf.setHorizontalAlignment(4);
            jLabel.setLabelFor(this.errorTf);
            this.add((Component)this.errorTf, gridBagConstraints3);
            jLabel = ProgressMonitor.this.uif.createLabel("pm.tests.nr");
            jLabel.setDisplayedMnemonic(ProgressMonitor.this.uif.getI18NString("pm.tests.nr.mne").charAt(0));
            this.add((Component)jLabel, gridBagConstraints2);
            this.notRunTf = ProgressMonitor.this.uif.createOutputField("pm.tests.nr", 6);
            this.notRunTf.setHorizontalAlignment(4);
            jLabel.setLabelFor(this.notRunTf);
            this.add((Component)this.notRunTf, gridBagConstraints4);
            this.add(Box.createVerticalStrut(10), gridBagConstraints4);
            Color[] colorArray = new Color[]{I18NUtils.getStatusBarColor(0), I18NUtils.getStatusBarColor(1), I18NUtils.getStatusBarColor(2), I18NUtils.getStatusBarColor(3)};
            jTextField = ProgressMonitor.this.uif.createHeading("pm.tests.mtr");
            ProgressMonitor.this.uif.setAccessibleInfo(jTextField, "pm.tests.mtr");
            this.add((Component)jTextField, gridBagConstraints);
            this.meter = new ProgressMeter(colorArray, ProgressMonitor.this.state);
            this.add((Component)this.meter, gridBagConstraints4);
            ProgressMonitor.this.uif.setAccessibleInfo(this.meter, "pm.tests.bar");
            ProgressMonitor.this.uif.setToolTip(this, "pm.tests");
        }

        public void update() {
            this.updateAll();
        }

        private void updateAll() {
            this.meter.update();
            int[] nArray = ProgressMonitor.this.state.getStats();
            this.setCount(this.passTf, nArray[0]);
            this.setCount(this.failTf, nArray[1]);
            this.setCount(this.errorTf, nArray[2]);
            this.setCount(this.notRunTf, ProgressMonitor.this.state.getTestsRemainingCount());
        }

        private final void setCount(JTextField jTextField, int n) {
            if (EventQueue.isDispatchThread()) {
                jTextField.setText(Integer.toString(n));
            } else {
                try {
                    EventQueue.invokeAndWait(new BranchPanel.TextUpdater(jTextField, Integer.toString(n), ProgressMonitor.this.uif));
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }

    private abstract class StatusSubpanel
    extends JPanel {
        private StatusSubpanel() {
        }

        abstract void update();

        void starting() {
        }

        void postProcessing() {
        }

        void stopping() {
        }
    }

    class Listener
    implements MonitorState.Observer,
    ActionListener {
        private Timer timer = new Timer(1000, this);

        Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.timer) {
                for (int i = 0; i < ProgressMonitor.this.subpanels.length; ++i) {
                    ProgressMonitor.this.subpanels[i].update();
                }
            }
        }

        public void starting() {
            ProgressMonitor.this.running = true;
            for (int i = 0; i < ProgressMonitor.this.subpanels.length; ++i) {
                ProgressMonitor.this.subpanels[i].starting();
            }
            this.timer.start();
        }

        public void postProcessing() {
            for (int i = 0; i < ProgressMonitor.this.subpanels.length; ++i) {
                ProgressMonitor.this.subpanels[i].update();
                ProgressMonitor.this.subpanels[i].postProcessing();
            }
        }

        public void stopping() {
        }

        public void finished(boolean bl) {
            ProgressMonitor.this.running = false;
            for (int i = 0; i < ProgressMonitor.this.subpanels.length; ++i) {
                ProgressMonitor.this.subpanels[i].update();
                ProgressMonitor.this.subpanels[i].stopping();
            }
            this.timer.stop();
        }
    }
}

