/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.WizPrint;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.tool.FileChooser;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

class QuestionLogBrowser
extends ToolDialog {
    private static final String SAVE_AS = "SaveAs";
    private static final String PRINT_SETUP = "PrintSetup";
    private static final String PRINT = "Print";
    private ExecModel model;
    private InterviewParameters params;
    private JScrollPane scrollPane;
    private JEditorPane body;
    private FileChooser fileChooser;
    private Listener listener;

    QuestionLogBrowser(JComponent jComponent, ExecModel execModel, UIFactory uIFactory) {
        super(jComponent, uIFactory, "qlb");
        if (execModel == null) {
            throw new NullPointerException();
        }
        this.model = execModel;
        this.params = execModel.getInterviewParameters();
        if (this.params == null) {
            throw new NullPointerException();
        }
        this.listener = new Listener();
    }

    protected void initGUI() {
        this.setHelp("quLog.window.csh");
        JMenuBar jMenuBar = this.uif.createMenuBar("qlb");
        String[] stringArray = new String[]{SAVE_AS, PRINT_SETUP, PRINT};
        JMenu jMenu = this.uif.createMenu("qlb.file", stringArray, this.listener);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        this.body = new JEditorPane();
        this.body.setContentType("text/html");
        this.body.setText("");
        this.body.setEditable(false);
        this.body.addHyperlinkListener(this.listener);
        this.body.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.body.setName("qlb.body");
        this.uif.setAccessibleName(this.body, "qlb.body");
        this.uif.setToolTip(this.body, "qlb");
        this.scrollPane = this.uif.createScrollPane(this.body);
        int n = this.uif.getDotsPerInch();
        this.scrollPane.setPreferredSize(new Dimension(6 * n, 9 * n));
        this.setBody(this.scrollPane);
        JButton jButton = this.uif.createHelpButton("qlb.help", "quLog.window.csh");
        JButton jButton2 = this.uif.createCloseButton("qlb.close");
        this.setButtons(new JButton[]{jButton, jButton2}, jButton2);
        this.setComponentListener(this.listener);
    }

    private void updateContent() {
        File file;
        if (this.body == null) {
            this.initGUI();
        }
        if ((file = this.params.getFile()) == null) {
            this.setI18NTitle("qlb.title");
        } else {
            this.setI18NTitle("qlb.titleWithFile", file);
        }
        try {
            WizPrint wizPrint = new WizPrint(this.params);
            wizPrint.setShowResponses(true);
            wizPrint.setShowResponseTypes(false);
            wizPrint.setShowTags(true);
            StringWriter stringWriter = new StringWriter();
            wizPrint.write(stringWriter);
            this.body.setText(stringWriter.toString());
            this.body.getCaret().setDot(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void doSaveAs() {
        if (this.fileChooser == null) {
            this.fileChooser = new FileChooser(true);
            this.fileChooser.addChoosableExtension(".html", this.uif.getI18NString("qlb.htmlFiles"));
        }
        this.fileChooser.setDialogTitle(this.uif.getI18NString("qlb.save.title"));
        File file = null;
        block6: while (file == null) {
            String string;
            int n = this.fileChooser.showDialog(this.parent, this.uif.getI18NString("qlb.save.btn"));
            if (n != 0) {
                return;
            }
            file = this.fileChooser.getSelectedFile();
            if (!file.exists() && !(string = file.getPath()).endsWith(".html")) {
                file = new File(string + ".html");
            }
            if (!file.exists()) continue;
            n = this.uif.showYesNoCancelDialog("qlb.save.warn", file);
            switch (n) {
                case 0: {
                    continue block6;
                }
                case 1: {
                    this.fileChooser.setSelectedFile(null);
                    file = null;
                    continue block6;
                }
            }
            return;
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(this.body.getText());
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            if (!file.canWrite()) {
                this.uif.showError("qlb.save.cantWriteFile", file);
            }
            if (iOException instanceof FileNotFoundException) {
                this.uif.showError("qlb.save.cantFindFile", file);
            }
            this.uif.showError("qlb.save.error", new Object[]{file, iOException});
        }
    }

    private void doPrintSetup() {
        this.model.printSetup();
    }

    private void doPrint() {
        WorkDirectory workDirectory = this.params.getWorkDirectory();
        try {
            File file = File.createTempFile("questionLog", ".html", workDirectory.getJTData());
            file.deleteOnExit();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(this.body.getText());
            ((Writer)bufferedWriter).close();
            this.model.print(file);
        }
        catch (IOException iOException) {
            JavaTestError.unexpectedException(iOException);
        }
    }

    private class Listener
    extends ComponentAdapter
    implements ActionListener,
    HyperlinkListener,
    Interview.Observer {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(QuestionLogBrowser.SAVE_AS)) {
                QuestionLogBrowser.this.doSaveAs();
            } else if (string.equals(QuestionLogBrowser.PRINT_SETUP)) {
                QuestionLogBrowser.this.doPrintSetup();
            } else if (string.equals(QuestionLogBrowser.PRINT)) {
                QuestionLogBrowser.this.doPrint();
            }
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String string = hyperlinkEvent.getDescription();
                if (!string.startsWith("#")) {
                    return;
                }
                QuestionLogBrowser.this.body.scrollToReference(string.substring(1));
            }
        }

        public void componentShown(ComponentEvent componentEvent) {
            QuestionLogBrowser.this.params.addObserver(this);
            QuestionLogBrowser.this.updateContent();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            QuestionLogBrowser.this.params.removeObserver(this);
        }

        public void currentQuestionChanged(Question question) {
        }

        public void pathUpdated() {
            QuestionLogBrowser.this.updateContent();
        }
    }
}

