/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.ConfigHandler;
import com.sun.javatest.exec.ElapsedTimeMonitor;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.MessageStrip;
import com.sun.javatest.exec.Monitor;
import com.sun.javatest.exec.MonitorState;
import com.sun.javatest.exec.ProgressMonitor;
import com.sun.javatest.exec.RunProgressMonitor;
import com.sun.javatest.exec.TestTreePanel;
import com.sun.javatest.exec.TreePanelModel;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.ListModel;

class RunTestsHandler {
    private JComponent parent;
    private ExecModel model;
    private ConfigHandler configHandler;
    private UIFactory uif;
    private TreePanelModel tpm;
    private TestSuite testSuite;
    private WorkDirectory workDir;
    private InterviewParameters interviewParams;
    private Action showProgressAction;
    private Action startAction;
    private Action stopAction;
    private Harness harness;
    private HarnessObserver observer;
    private MonitorState mState;
    private MessageStrip messageStrip;
    private ProgressMonitor progMonitor;

    RunTestsHandler(JComponent jComponent, ExecModel execModel, ConfigHandler configHandler, UIFactory uIFactory) {
        this.parent = jComponent;
        this.model = execModel;
        this.configHandler = configHandler;
        this.uif = uIFactory;
        this.initActions();
        this.initHarness();
    }

    void setTreePanelModel(TreePanelModel treePanelModel) {
        this.tpm = treePanelModel;
        if (this.progMonitor != null) {
            this.progMonitor.setTreePanelModel(treePanelModel);
        }
    }

    JMenu getMenu() {
        JMenu jMenu = this.uif.createMenu("rh");
        jMenu.add(this.uif.createMenuItem(this.startAction));
        jMenu.add(this.uif.createMenuItem(this.stopAction));
        jMenu.addSeparator();
        jMenu.add(this.uif.createMenuItem(this.showProgressAction));
        return jMenu;
    }

    Action[] getToolBarActions() {
        return new Action[]{this.startAction, this.stopAction};
    }

    Harness getHarness() {
        return this.harness;
    }

    MessageStrip getMessageStrip() {
        if (this.messageStrip == null) {
            Monitor[] monitorArray = new Monitor[]{new ElapsedTimeMonitor(this.mState, this.uif), new RunProgressMonitor(this.mState, this.uif)};
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RunTestsHandler.this.setProgressMonitorVisible(!RunTestsHandler.this.isProgressMonitorVisible());
                }
            };
            this.messageStrip = new MessageStrip(this.uif, monitorArray, this.mState, actionListener);
            this.messageStrip.setRunningMonitor(monitorArray[1]);
            this.messageStrip.setIdleMonitor(monitorArray[0]);
            this.harness.addObserver(this.messageStrip);
        }
        return this.messageStrip;
    }

    synchronized void dispose() {
        if (this.harness != null) {
            this.harness.stop();
            this.harness = null;
        }
        this.parent = null;
        this.model = null;
        this.configHandler = null;
        this.tpm = null;
        if (this.progMonitor != null) {
            this.progMonitor.dispose();
        }
    }

    void updateGUI() {
        boolean bl;
        this.testSuite = this.model.getTestSuite();
        this.workDir = this.model.getWorkDirectory();
        this.interviewParams = this.model.getInterviewParameters();
        boolean bl2 = bl = this.testSuite != null;
        if (bl) {
            if (!this.startAction.isEnabled() && !this.stopAction.isEnabled()) {
                this.startAction.setEnabled(true);
            }
        } else {
            this.startAction.setEnabled(false);
        }
    }

    void start() {
        this.startAction.setEnabled(false);
        if (this.workDir == null) {
            this.model.showWorkDirDialog();
            if (this.workDir == null) {
                this.startAction.setEnabled(true);
                return;
            }
        }
        this.configHandler.ensureInterviewUpToDate();
        if (this.interviewParams.isFinishable()) {
            this.startHarness(this.interviewParams);
        } else {
            int n = this.interviewParams.isStarted() ? this.uif.showOKCancelDialog("rh.completeConfigure") : this.uif.showOKCancelDialog("rh.startConfigure");
            if (n != 0) {
                this.startAction.setEnabled(true);
                return;
            }
            this.configHandler.showConfigEditor(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = RunTestsHandler.this.uif.showOKCancelDialog("rh.configDone");
                    if (n != 0) {
                        RunTestsHandler.this.startAction.setEnabled(true);
                        return;
                    }
                    RunTestsHandler.this.startHarness(RunTestsHandler.this.interviewParams);
                }
            });
        }
    }

    void executeImmediate(String[] stringArray) throws Interview.Fault, TestSuite.Fault {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        this.startAction.setEnabled(false);
        if (this.workDir == null) {
            this.model.showWorkDirDialog();
            if (this.workDir == null) {
                this.startAction.setEnabled(true);
                return;
            }
        }
        this.configHandler.ensureInterviewUpToDate();
        if (!this.interviewParams.isFinishable()) {
            int n = this.uif.showOKCancelDialog("rh.mustConfigure");
            if (n == 0) {
                this.configHandler.showConfigEditor(null);
            }
            this.startAction.setEnabled(true);
            return;
        }
        Object[] objectArray = new Object[]{this.interviewParams.getEnv().getName(), TestTreePanel.createNodeListString(TestTreePanel.createNodeList(stringArray))};
        int n = 0;
        if (stringArray[0].equals("")) {
            n = this.uif.showYesNoDialog("rh.confirmQuickAll", new Object[]{this.interviewParams.getEnv().getName()});
        } else {
            object3 = this.uif.createPanel("rh.confirmPanel", false);
            serializable = this.uif.createMessageArea("rh.confirmQuick", new Object[]{this.interviewParams.getEnv().getName()});
            ((Container)object3).setLayout(new BorderLayout());
            ((Container)object3).add((Component)serializable, "North");
            object2 = new DefaultListModel<String>();
            for (int i = stringArray.length; i > 0; --i) {
                ((DefaultListModel)object2).add(((DefaultListModel)object2).getSize(), stringArray[((DefaultListModel)object2).getSize()]);
            }
            object = this.uif.createList("rh.confirmList", (ListModel)object2);
            ((Container)object3).add((Component)this.uif.createScrollPane((JComponent)object, 20, 30), "Center");
            n = this.uif.showCustomYesNoDialog("rh.confirmQuick", (Component)object3);
        }
        if (n != 0) {
            this.startAction.setEnabled(true);
            return;
        }
        object3 = this.workDir.getTestSuite().createInterview();
        ((InterviewParameters)object3).setWorkDirectory(this.interviewParams.getWorkDirectory());
        serializable = new HashMap();
        this.interviewParams.save((Map)((Object)serializable));
        ((InterviewParameters)object3).load((Map)((Object)serializable), false);
        object2 = object3.getTestsParameters();
        object = (Parameters.MutableTestsParameters)object2;
        if (stringArray == null || stringArray.length == 0 || stringArray[0].equals("")) {
            object.setTestsMode(1);
        } else {
            object.setTestsMode(2);
            object.setTests(stringArray);
        }
        this.startHarness((InterviewParameters)object3);
    }

    private void startHarness(InterviewParameters interviewParameters) {
        if (this.getNeedToAutoCheckExcludeList()) {
            this.configHandler.checkExcludeListUpdate(this.parent, false);
        }
        try {
            if (!this.interviewParams.getWorkDirectory().getTestResultTable().isReady()) {
                I18NResourceBundle i18NResourceBundle = this.uif.getI18NResourceBundle();
                this.messageStrip.showMessage(i18NResourceBundle, "rh.waitToStart.txt");
            }
            this.harness.start(interviewParameters);
        }
        catch (Harness.Fault fault) {
            this.uif.showError("rh", fault.toString());
        }
    }

    private boolean getNeedToAutoCheckExcludeList() {
        Parameters.ExcludeListParameters excludeListParameters = this.interviewParams.getExcludeListParameters();
        if (!(excludeListParameters instanceof Parameters.MutableExcludeListParameters)) {
            return false;
        }
        Parameters.MutableExcludeListParameters mutableExcludeListParameters = (Parameters.MutableExcludeListParameters)excludeListParameters;
        if (mutableExcludeListParameters.getExcludeMode() != 3) {
            return false;
        }
        if (this.interviewParams.getTestSuite().getLatestExcludeList() == null) {
            return false;
        }
        if (!mutableExcludeListParameters.isLatestExcludeAutoCheckEnabled()) {
            return false;
        }
        if (mutableExcludeListParameters.getLatestExcludeAutoCheckMode() == 2) {
            return true;
        }
        File file = this.workDir.getSystemFile("latest.jtx");
        if (!file.exists()) {
            return true;
        }
        long l = file.lastModified();
        long l2 = System.currentTimeMillis();
        int n = mutableExcludeListParameters.getLatestExcludeAutoCheckInterval();
        long l3 = n * 24 * 60 * 60 * 1000;
        return n > 0 && l2 > l + l3;
    }

    private void initHarness() {
        this.harness = new Harness();
        BackupPolicy backupPolicy = new BackupPolicy(){
            private int numBackupsToKeep = Integer.getInteger("javatest.backup.count", 5);
            private String[] ignoreExtns = StringArray.split(System.getProperty("javatest.backup.ignore", ".jtr"));

            public int getNumBackupsToKeep(File file) {
                return this.numBackupsToKeep;
            }

            public boolean isBackupRequired(File file) {
                if (this.ignoreExtns != null) {
                    for (int i = 0; i < this.ignoreExtns.length; ++i) {
                        if (!file.getPath().endsWith(this.ignoreExtns[i])) continue;
                        return false;
                    }
                }
                return true;
            }
        };
        this.harness.setBackupPolicy(backupPolicy);
        this.observer = new HarnessObserver();
        this.harness.addObserver(this.observer);
        this.mState = new MonitorState(this.harness);
    }

    private boolean isProgressMonitorVisible() {
        return this.progMonitor != null && this.progMonitor.isVisible();
    }

    private void setProgressMonitorVisible(boolean bl) {
        if (this.progMonitor == null) {
            this.progMonitor = new ProgressMonitor((Component)this.parent, this.uif, this.mState);
            this.progMonitor.setTreePanelModel(this.tpm);
        }
        this.progMonitor.setVisible(bl);
    }

    private void initActions() {
        this.showProgressAction = new ToolAction(this.uif, "rh.progress"){

            public void actionPerformed(ActionEvent actionEvent) {
                RunTestsHandler.this.setProgressMonitorVisible(true);
            }
        };
        this.startAction = new ToolAction(this.uif, "rh.start", true){

            public void actionPerformed(ActionEvent actionEvent) {
                RunTestsHandler.this.start();
            }
        };
        this.stopAction = new ToolAction(this.uif, "rh.stop", true){
            {
                this.setEnabled(false);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                RunTestsHandler.this.harness.stop();
            }
        };
    }

    static /* synthetic */ Action access$900(RunTestsHandler runTestsHandler) {
        return runTestsHandler.stopAction;
    }

    static /* synthetic */ MessageStrip access$1000(RunTestsHandler runTestsHandler) {
        return runTestsHandler.messageStrip;
    }

    private class HarnessObserver
    implements Harness.Observer {
        private HarnessObserver() {
        }

        public void startingTestRun(Parameters parameters) {
            EventQueue.invokeLater(new Runnable(this){
                private final /* synthetic */ HarnessObserver this$1;
                {
                    this.this$1 = harnessObserver;
                }

                public void run() {
                    RunTestsHandler.access$300(HarnessObserver.access$800(this.this$1)).setEnabled(false);
                    RunTestsHandler.access$900(HarnessObserver.access$800(this.this$1)).setEnabled(true);
                    I18NResourceBundle i18NResourceBundle = RunTestsHandler.access$200(HarnessObserver.access$800(this.this$1)).getI18NResourceBundle();
                    RunTestsHandler.access$1000(HarnessObserver.access$800(this.this$1)).showMessage(i18NResourceBundle, "rh.starting.txt");
                }
            });
        }

        public void startingTest(TestResult testResult) {
        }

        public void finishedTest(TestResult testResult) {
        }

        public void stoppingTestRun() {
        }

        public void finishedTesting() {
        }

        public void finishedTestRun(boolean bl) {
            EventQueue.invokeLater(new Runnable(this){
                private final /* synthetic */ HarnessObserver this$1;
                {
                    this.this$1 = harnessObserver;
                }

                public void run() {
                    RunTestsHandler.access$300(HarnessObserver.access$800(this.this$1)).setEnabled(true);
                    RunTestsHandler.access$900(HarnessObserver.access$800(this.this$1)).setEnabled(false);
                }
            });
        }

        public void error(String string) {
            EventQueue.invokeLater(new Runnable(this, string){
                private final /* synthetic */ String val$msg;
                private final /* synthetic */ HarnessObserver this$1;
                {
                    this.this$1 = harnessObserver;
                    this.val$msg = string;
                }

                public void run() {
                    RunTestsHandler.access$200(HarnessObserver.access$800(this.this$1)).showError("rh.error", this.val$msg);
                }
            });
        }

        static /* synthetic */ RunTestsHandler access$800(HarnessObserver harnessObserver) {
            return harnessObserver.RunTestsHandler.this;
        }
    }
}

