/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.JavaTestError;
import com.sun.javatest.Status;
import com.sun.javatest.TestResult;
import com.sun.javatest.exec.TP_Subpanel;
import com.sun.javatest.tool.IconFactory;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.HTMLWriter;
import com.sun.javatest.util.StringArray;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

class TP_OutputSubpanel
extends TP_Subpanel {
    private Icon streamIcon;
    private JList toc;
    private JTextField titleField;
    private JPanel body;
    private JPanel main;
    private JTextArea textArea;
    private JEditorPane htmlArea;
    private TestResult currTest;
    private DefaultListModel tocEntries;
    private Listener listener = new Listener();
    private TRObserver observer = new TRObserver();
    private static StyleSheet styleSheet;
    private static HTMLEditorKit htmlEditorKit;

    TP_OutputSubpanel(UIFactory uIFactory) {
        super(uIFactory, "out");
        this.initGUI();
    }

    protected synchronized void updateSubpanel(TestResult testResult) {
        if (this.subpanelTest != null) {
            this.subpanelTest.removeObserver(this.observer);
        }
        super.updateSubpanel(testResult);
        this.updateTOC();
        if (this.subpanelTest.isMutable()) {
            this.subpanelTest.addObserver(this.observer);
        }
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.tocEntries = new DefaultListModel();
        this.toc = this.uif.createList("test.out.toc", this.tocEntries);
        this.toc.setCellRenderer(new TOCRenderer());
        this.toc.setSelectionMode(0);
        this.toc.setPrototypeCellValue("12345678901234567890");
        this.toc.setVisibleRowCount(10);
        this.toc.addListSelectionListener(this.listener);
        JScrollPane jScrollPane = this.uif.createScrollPane(this.toc, 20, 31);
        this.main = new JPanel(new BorderLayout());
        this.titleField = this.uif.createOutputField("test.out.title");
        this.titleField.setBackground(MetalLookAndFeel.getPrimaryControlDarkShadow());
        this.titleField.setForeground(MetalLookAndFeel.getWindowBackground());
        this.main.add((Component)this.titleField, "North");
        this.body = new JPanel(new CardLayout()){

            public Dimension getPreferredSize() {
                int n = TP_OutputSubpanel.this.uif.getDotsPerInch();
                return new Dimension(3 * n, 3 * n);
            }
        };
        this.textArea = this.uif.createTextArea("test.out.textbody");
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.body.add((Component)this.uif.createScrollPane(this.textArea, 20, 31), "text");
        this.htmlArea = new JEditorPane();
        this.htmlArea.setDocument(new HTMLDocument(TP_OutputSubpanel.getStyleSheet()){});
        this.htmlArea.setEditable(false);
        this.htmlArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.htmlArea.addHyperlinkListener(this.listener);
        this.body.add((Component)this.uif.createScrollPane(this.htmlArea, 20, 31), "html");
        this.main.add((Component)this.body, "Center");
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, this.main);
        jSplitPane.setBorder(BorderFactory.createLoweredBevelBorder());
        jSplitPane.setResizeWeight(0.0);
        this.add(jSplitPane);
        CSH.setHelpIDString(this, "browse.outputTab.csh");
        this.initIcons();
    }

    private void initIcons() {
        this.streamIcon = this.uif.createIcon("test.out.sect.stream");
    }

    private String getStatusKey(int n) {
        switch (n) {
            case 0: {
                return "passed";
            }
            case 1: {
                return "failed";
            }
            case 2: {
                return "error";
            }
            case 3: {
                return "notRun";
            }
        }
        return "unknown";
    }

    private String createNotRunSummary() {
        StringWriter stringWriter = new StringWriter();
        try {
            HTMLWriter hTMLWriter = new HTMLWriter((Writer)stringWriter, this.uif.getI18NResourceBundle());
            hTMLWriter.startTag("html");
            hTMLWriter.startTag("body");
            hTMLWriter.writeI18N("test.out.smry.testNotRun");
            hTMLWriter.endTag("body");
            hTMLWriter.endTag("html");
            hTMLWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    private String createSummary() {
        StringWriter stringWriter = new StringWriter();
        try {
            Object object;
            TestResult.Section section;
            int n;
            String[] stringArray;
            HTMLWriter hTMLWriter = new HTMLWriter((Writer)stringWriter, this.uif.getI18NResourceBundle());
            hTMLWriter.startTag("html");
            hTMLWriter.startTag("body");
            try {
                stringArray = StringArray.split(this.subpanelTest.getProperty("script"));
            }
            catch (TestResult.Fault fault) {
                stringArray = null;
            }
            String string = stringArray == null || stringArray.length == 0 ? this.uif.getI18NString("test.out.smry.unknownScript") : stringArray[0];
            hTMLWriter.writeI18N("test.out.script");
            hTMLWriter.startTag("table");
            hTMLWriter.writeAttr("border", "0");
            hTMLWriter.startTag("tr");
            hTMLWriter.startTag("td");
            hTMLWriter.startTag("code");
            hTMLWriter.write(string);
            hTMLWriter.endTag("code");
            hTMLWriter.endTag("td");
            hTMLWriter.endTag("tr");
            hTMLWriter.endTag("table");
            if (stringArray != null && stringArray.length > 1) {
                hTMLWriter.writeI18N("test.out.scriptArgs");
                hTMLWriter.startTag("table");
                hTMLWriter.writeAttr("border", "0");
                for (n = 1; n < stringArray.length; ++n) {
                    hTMLWriter.startTag("tr");
                    hTMLWriter.startTag("td");
                    hTMLWriter.startTag("code");
                    hTMLWriter.write(stringArray[n]);
                    hTMLWriter.endTag("code");
                    hTMLWriter.endTag("td");
                    hTMLWriter.endTag("tr");
                }
                hTMLWriter.endTag("table");
            }
            if (this.subpanelTest.getSectionCount() > 0 && (section = this.subpanelTest.getSection(0)).getTitle().equals("script_messages")) {
                hTMLWriter.writeI18N("test.out.smry.scriptLog.txt");
                hTMLWriter.startTag("table");
                hTMLWriter.writeAttr("border", "0");
                object = section.getOutputNames();
                for (int i = 0; i < ((String[])object).length; ++i) {
                    String string2 = object[i];
                    String string3 = section.getOutput(string2);
                    hTMLWriter.startTag("tr");
                    hTMLWriter.startTag("td");
                    hTMLWriter.writeLink("#" + string2, string2);
                    hTMLWriter.endTag("td");
                    hTMLWriter.endTag("tr");
                }
                hTMLWriter.endTag("table");
            }
            if (this.subpanelTest.getSectionCount() > 0) {
                hTMLWriter.startTag("h3");
                hTMLWriter.writeI18N("test.out.smry.sections.head");
                hTMLWriter.endTag("h3");
                hTMLWriter.writeI18N("test.out.smry.sections.txt");
                hTMLWriter.startTag("table");
                hTMLWriter.writeAttr("border", "0");
                for (n = 0; n < this.subpanelTest.getSectionCount(); ++n) {
                    object = this.subpanelTest.getSection(n);
                    if (((TestResult.Section)object).getTitle().equals("script_messages")) continue;
                    hTMLWriter.startTag("tr");
                    hTMLWriter.startTag("td");
                    hTMLWriter.startTag("object");
                    hTMLWriter.writeAttr("classid", "com.sun.javatest.tool.IconLabel");
                    hTMLWriter.writeParam("type", "testSection");
                    hTMLWriter.writeParam("state", this.getStatusKey(((TestResult.Section)object).getStatus().getType()));
                    hTMLWriter.endTag("object");
                    hTMLWriter.writeLink(String.valueOf(n), ((TestResult.Section)object).getTitle());
                    hTMLWriter.endTag("td");
                    hTMLWriter.endTag("tr");
                }
                hTMLWriter.endTag("table");
                hTMLWriter.startTag("h3");
                hTMLWriter.writeI18N("test.out.outcome.head");
                hTMLWriter.endTag("h3");
                hTMLWriter.writeI18N("test.out.testResultForOutput.txt");
            } else {
                hTMLWriter.startTag("h3");
                hTMLWriter.writeI18N("test.out.outcome.head");
                hTMLWriter.endTag("h3");
                hTMLWriter.writeI18N("test.out.testResultNoOutput.txt");
            }
            Status status = this.subpanelTest.getStatus();
            hTMLWriter.startTag("table");
            hTMLWriter.writeAttr("border", "0");
            hTMLWriter.startTag("tr");
            hTMLWriter.startTag("td");
            hTMLWriter.startTag("object");
            hTMLWriter.writeAttr("classid", "com.sun.javatest.tool.IconLabel");
            hTMLWriter.writeParam("type", "test");
            hTMLWriter.writeParam("state", this.getStatusKey(status.getType()));
            hTMLWriter.endTag("object");
            hTMLWriter.endTag("td");
            hTMLWriter.startTag("td");
            hTMLWriter.write(status.toString());
            hTMLWriter.endTag("td");
            hTMLWriter.endTag("tr");
            hTMLWriter.endTag("table");
            hTMLWriter.endTag("body");
            hTMLWriter.endTag("html");
            hTMLWriter.close();
        }
        catch (IOException iOException) {
        }
        catch (TestResult.ReloadFault reloadFault) {
            throw new JavaTestError("Error loading result file for " + this.subpanelTest.getTestName());
        }
        return stringWriter.toString();
    }

    private String createSectionSummary(TestResult.Section section) {
        StringWriter stringWriter = new StringWriter();
        try {
            HTMLWriter hTMLWriter = new HTMLWriter((Writer)stringWriter, this.uif.getI18NResourceBundle());
            hTMLWriter.startTag("html");
            hTMLWriter.startTag("body");
            hTMLWriter.startTag("h3");
            hTMLWriter.writeStyleAttr("margin-top: 0");
            hTMLWriter.writeI18N("test.out.outputSummary.head");
            hTMLWriter.endTag("h3");
            hTMLWriter.writeI18N("test.out.outputSummary.txt");
            hTMLWriter.startTag("table");
            hTMLWriter.writeAttr("border", "0");
            hTMLWriter.startTag("tr");
            hTMLWriter.startTag("th");
            hTMLWriter.writeAttr("align", "left");
            hTMLWriter.writeI18N("test.out.outputName.txt");
            hTMLWriter.endTag("th");
            hTMLWriter.startTag("th");
            hTMLWriter.writeAttr("align", "left");
            hTMLWriter.writeStyleAttr("margin-left:10");
            hTMLWriter.writeI18N("test.out.outputSize.txt");
            hTMLWriter.endTag("th");
            hTMLWriter.endTag("tr");
            String[] stringArray = section.getOutputNames();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = section.getOutput(string);
                hTMLWriter.startTag("tr");
                hTMLWriter.startTag("td");
                if (string2.length() == 0) {
                    hTMLWriter.write(string);
                } else {
                    hTMLWriter.writeLink("#" + string, string);
                }
                hTMLWriter.endTag("td");
                hTMLWriter.startTag("td");
                hTMLWriter.writeStyleAttr("margin-left:10");
                if (string2.length() == 0) {
                    hTMLWriter.writeI18N("test.out.empty.txt");
                } else {
                    hTMLWriter.write(String.valueOf(string2.length()));
                }
                hTMLWriter.endTag("td");
                hTMLWriter.endTag("tr");
            }
            hTMLWriter.endTag("table");
            Status status = section.getStatus();
            if (status != null) {
                hTMLWriter.startTag("h3");
                hTMLWriter.writeI18N("test.out.outcome.head");
                hTMLWriter.endTag("h3");
                hTMLWriter.writeI18N("test.out.sectionResult.txt");
                hTMLWriter.startTag("p");
                hTMLWriter.writeStyleAttr("margin-left:30; margin-top:0; font-size: 12pt");
                hTMLWriter.startTag("object");
                hTMLWriter.writeAttr("classid", "com.sun.javatest.tool.IconLabel");
                hTMLWriter.writeParam("type", "testSection");
                hTMLWriter.writeParam("state", this.getStatusKey(status.getType()));
                hTMLWriter.endTag("object");
                hTMLWriter.write(status.toString());
                hTMLWriter.endTag("p");
            }
            hTMLWriter.endTag("body");
            hTMLWriter.endTag("html");
            hTMLWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    private String createStatusSummary() {
        StringWriter stringWriter = new StringWriter();
        try {
            HTMLWriter hTMLWriter = new HTMLWriter((Writer)stringWriter, this.uif.getI18NResourceBundle());
            hTMLWriter.startTag("html");
            hTMLWriter.startTag("body");
            if (this.subpanelTest.getSectionCount() > 0) {
                hTMLWriter.writeI18N("test.out.testResultForOutput.txt");
            } else {
                hTMLWriter.writeI18N("test.out.testResultNoOutput.txt");
            }
            Status status = this.subpanelTest.getStatus();
            hTMLWriter.startTag("table");
            hTMLWriter.writeAttr("border", "0");
            hTMLWriter.startTag("tr");
            hTMLWriter.startTag("td");
            hTMLWriter.startTag("object");
            hTMLWriter.writeAttr("classid", "com.sun.javatest.tool.IconLabel");
            hTMLWriter.writeParam("type", "test");
            hTMLWriter.writeParam("state", this.getStatusKey(status.getType()));
            hTMLWriter.endTag("object");
            hTMLWriter.endTag("td");
            hTMLWriter.startTag("td");
            hTMLWriter.write(status.toString());
            hTMLWriter.endTag("td");
            hTMLWriter.endTag("tr");
            hTMLWriter.endTag("table");
            hTMLWriter.endTag("body");
            hTMLWriter.endTag("html");
            hTMLWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    void updateTOC() {
        try {
            TOCEntry tOCEntry = null;
            this.tocEntries.setSize(0);
            for (int i = 0; i < this.subpanelTest.getSectionCount(); ++i) {
                TestResult.Section section = this.subpanelTest.getSection(i);
                TOCEntry tOCEntry2 = new TOCEntry(section);
                if (tOCEntry2.isScriptMessagesSection()) {
                    tOCEntry = tOCEntry2;
                }
                this.tocEntries.addElement(tOCEntry2);
                String[] stringArray = section.getOutputNames();
                for (int j = 0; j < stringArray.length; ++j) {
                    this.tocEntries.addElement(new TOCEntry(section, stringArray[j]));
                }
            }
            TOCEntry tOCEntry3 = new TOCEntry();
            if (tOCEntry == null) {
                tOCEntry = tOCEntry3;
            }
            this.tocEntries.addElement(tOCEntry3);
            this.toc.setSelectedValue(tOCEntry, true);
        }
        catch (TestResult.ReloadFault reloadFault) {
            throw new JavaTestError("Error loading result file for " + this.subpanelTest.getTestName());
        }
    }

    private void updateTOCLater() {
        if (EventQueue.isDispatchThread()) {
            this.updateTOC();
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    TP_OutputSubpanel.this.updateTOC();
                }
            });
        }
    }

    private void showHTML(String string) {
        this.htmlArea.setContentType("text/html");
        HTMLDocument hTMLDocument = new HTMLDocument(TP_OutputSubpanel.getStyleSheet()){};
        this.htmlArea.setDocument(hTMLDocument);
        this.htmlArea.setText(string);
        ((CardLayout)this.body.getLayout()).show(this.body, "html");
    }

    private void showText(String string) {
        if (string.length() == 0) {
            this.textArea.setText(this.uif.getI18NString("test.out.empty.txt"));
            this.textArea.setEnabled(false);
        } else {
            this.textArea.setText(string);
            this.textArea.setEnabled(true);
        }
        ((CardLayout)this.body.getLayout()).show(this.body, "text");
    }

    private static StyleSheet getStyleSheet() {
        if (htmlEditorKit == null) {
            htmlEditorKit = new HTMLEditorKit();
        }
        if (styleSheet == null) {
            styleSheet = new StyleSheet();
            styleSheet.addStyleSheet(htmlEditorKit.getStyleSheet());
            styleSheet.addRule("body  { font-family: SansSerif; font-size: 12pt }");
            styleSheet.addRule("h3    { margin-top:15 }");
            styleSheet.addRule("table { margin-left:30; margin-top:0 }");
        }
        return styleSheet;
    }

    private class TOCRenderer
    extends DefaultListCellRenderer {
        private TOCRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, (Object)null, n, bl, bl2);
            if (object instanceof TOCEntry) {
                TOCEntry tOCEntry = (TOCEntry)object;
                jLabel.setText(tOCEntry.getText());
                jLabel.setIcon(tOCEntry.getIcon());
            } else {
                jLabel.setText(object.toString());
            }
            return jLabel;
        }
    }

    private class TOCEntry {
        private TestResult.Section section;
        private String outputName;

        TOCEntry() {
            this.section = null;
            this.outputName = null;
        }

        TOCEntry(TestResult.Section section) {
            this.section = section;
            this.outputName = null;
        }

        TOCEntry(TestResult.Section section, String string) {
            this.section = section;
            this.outputName = string;
        }

        boolean isScriptMessagesSection() {
            return this.section != null && this.section.getTitle().equals("script_messages");
        }

        TestResult.Section getSection() {
            return this.section;
        }

        String getOutputName() {
            return this.outputName;
        }

        String getTitle() {
            if (this.section == null) {
                if (TP_OutputSubpanel.this.subpanelTest.getStatus().getType() == 3) {
                    return TP_OutputSubpanel.this.uif.getI18NString("test.out.notRunTitle");
                }
                return TP_OutputSubpanel.this.uif.getI18NString("test.out.statusTitle");
            }
            if (this.isScriptMessagesSection()) {
                if (this.outputName == null) {
                    return TP_OutputSubpanel.this.uif.getI18NString("test.out.summary");
                }
                return TP_OutputSubpanel.this.uif.getI18NString("test.out.scriptMessages");
            }
            if (this.outputName == null) {
                return TP_OutputSubpanel.this.uif.getI18NString("test.out.sectionTitle", this.section.getTitle());
            }
            return TP_OutputSubpanel.this.uif.getI18NString("test.out.streamTitle", new Object[]{this.section.getTitle(), this.outputName});
        }

        String getText() {
            if (this.section == null) {
                if (TP_OutputSubpanel.this.subpanelTest.getStatus().getType() == 3) {
                    return TP_OutputSubpanel.this.uif.getI18NString("test.out.notRunTitle");
                }
                return TP_OutputSubpanel.this.uif.getI18NString("test.out.statusTitle");
            }
            if (this.isScriptMessagesSection()) {
                if (this.outputName == null) {
                    return TP_OutputSubpanel.this.uif.getI18NString("test.out.summary");
                }
                return TP_OutputSubpanel.this.uif.getI18NString("test.out.scriptMessages");
            }
            if (this.outputName == null) {
                return this.section.getTitle();
            }
            return this.outputName;
        }

        Icon getIcon() {
            if (this.section == null) {
                return IconFactory.getTestIcon(TP_OutputSubpanel.this.subpanelTest.getStatus().getType(), false, true);
            }
            if (this.outputName != null) {
                return TP_OutputSubpanel.this.streamIcon;
            }
            Status status = this.section.getStatus();
            return status == null ? null : IconFactory.getTestSectionIcon(status.getType());
        }
    }

    private class TRObserver
    implements TestResult.Observer {
        private TRObserver() {
        }

        public void completed(TestResult testResult) {
            TP_OutputSubpanel.this.updateTOCLater();
            testResult.removeObserver(this);
        }

        public void createdSection(TestResult testResult, TestResult.Section section) {
        }

        public void completedSection(TestResult testResult, TestResult.Section section) {
            TP_OutputSubpanel.this.updateTOCLater();
        }

        public void createdOutput(TestResult testResult, TestResult.Section section, String string) {
        }

        public void completedOutput(TestResult testResult, TestResult.Section section, String string) {
        }

        public void updatedOutput(TestResult testResult, TestResult.Section section, String string, int n, int n2, String string2) {
        }

        public void updatedProperty(TestResult testResult, String string, String string2) {
        }
    }

    private class Listener
    implements HyperlinkListener,
    ListSelectionListener {
        private Listener() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            block4: {
                String string;
                block5: {
                    TOCEntry tOCEntry;
                    String string2;
                    if (!hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) break block4;
                    string = hyperlinkEvent.getDescription();
                    if (!string.startsWith("#")) break block5;
                    String string3 = string.substring(1);
                    int n = TP_OutputSubpanel.this.toc.getSelectedIndex();
                    if (n == -1) break block4;
                    for (int i = n + 1; i < TP_OutputSubpanel.this.tocEntries.size() && (string2 = (tOCEntry = (TOCEntry)TP_OutputSubpanel.this.tocEntries.get(i)).getOutputName()) != null; ++i) {
                        if (!string2.equals(string3)) continue;
                        TP_OutputSubpanel.this.toc.setSelectedIndex(i);
                        return;
                    }
                    break block4;
                }
                try {
                    int n = Integer.parseInt(string);
                    TestResult.Section section = TP_OutputSubpanel.this.subpanelTest.getSection(n);
                    for (int i = 0; i < TP_OutputSubpanel.this.tocEntries.size(); ++i) {
                        TOCEntry tOCEntry = (TOCEntry)TP_OutputSubpanel.this.tocEntries.get(i);
                        if (tOCEntry.getSection() != section) continue;
                        TP_OutputSubpanel.this.toc.setSelectedIndex(i);
                        return;
                    }
                }
                catch (TestResult.ReloadFault reloadFault) {
                    throw new JavaTestError("Error loading result file for " + TP_OutputSubpanel.this.subpanelTest.getTestName());
                }
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JList jList = (JList)listSelectionEvent.getSource();
            TOCEntry tOCEntry = (TOCEntry)jList.getSelectedValue();
            if (tOCEntry == null) {
                return;
            }
            TP_OutputSubpanel.this.titleField.setText(tOCEntry.getTitle());
            String string = tOCEntry.getOutputName();
            if (tOCEntry.section == null) {
                if (TP_OutputSubpanel.this.subpanelTest.getStatus().getType() == 3) {
                    TP_OutputSubpanel.this.showHTML(TP_OutputSubpanel.this.createNotRunSummary());
                } else {
                    TP_OutputSubpanel.this.showHTML(TP_OutputSubpanel.this.createStatusSummary());
                }
            } else if (string != null) {
                TP_OutputSubpanel.this.showText(tOCEntry.getSection().getOutput(string));
            } else if (tOCEntry.isScriptMessagesSection()) {
                TP_OutputSubpanel.this.showHTML(TP_OutputSubpanel.this.createSummary());
            } else {
                TP_OutputSubpanel.this.showHTML(TP_OutputSubpanel.this.createSectionSummary(tOCEntry.getSection()));
            }
        }
    }
}

