/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.DynamicArray;
import java.util.Hashtable;
import java.util.Vector;

class TT_NodeCache
implements Runnable {
    private TestResultTable.TreeNode node;
    private TestResultTable.TreeIterator it;
    private TestFilter filter;
    private int[] stats = new int[4];
    private int localRejectCount;
    private Hashtable rejectReasons = new Hashtable();
    private FilterObserver fObs = new FilterObserver();
    private TT_NodeCacheObserver[] observers = new TT_NodeCacheObserver[0];
    private Vector[] testLists;
    private volatile int state;
    private volatile boolean valid = true;
    private volatile Object UPDATE_LOCK = new Object();
    private static final int NOT_COMPUTED = 0;
    private static final int COMPUTING = 1;
    private static final int COMPLETED = 2;
    private static final int PAUSED = 3;
    private static final int ABORTED = 4;
    private static final boolean debug = Debug.getBoolean(class$com$sun$javatest$exec$TT_NodeCache == null ? (class$com$sun$javatest$exec$TT_NodeCache = TT_NodeCache.class$("com.sun.javatest.exec.TT_NodeCache")) : class$com$sun$javatest$exec$TT_NodeCache);
    static /* synthetic */ Class class$com$sun$javatest$exec$TT_NodeCache;

    TT_NodeCache(TestResultTable.TreeNode treeNode, TestFilter testFilter) {
        this.filter = testFilter;
        this.node = treeNode;
        this.testLists = new Vector[5];
        for (int i = 0; i < 5; ++i) {
            this.testLists[i] = new Vector();
        }
    }

    public void run() {
        if (debug) {
            Debug.println("TT_NodeCache starting");
            Debug.println("   -> " + this);
            Debug.println("   -> node " + this.node + "(" + this.node.getName() + ")");
            Debug.println("   -> filter=" + this.filter);
            Debug.println("   -> old state=" + this.state);
        }
        if (this.it == null) {
            this.it = this.init();
        }
        if (debug) {
            Debug.println("   -> iterator= " + this.it);
        }
        this.state = 1;
        this.process();
    }

    void pause() {
        if (this.state < 2) {
            this.state = 3;
            if (debug) {
                Debug.println("TT_NodeCache for " + this.node.getName() + " pausing...");
            }
        }
    }

    void resume() {
        if (this.state != 3) {
            throw new IllegalStateException("Cache node not previously paused.");
        }
        this.state = 1;
        this.process();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean add(TestResultTable.TreeNode[] treeNodeArray, TestResult testResult, int n) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.it == null) {
            return false;
        }
        try {
            TestDescription testDescription = testResult.getDescription();
            TestFilter testFilter = null;
            Object object = this.fObs;
            synchronized (object) {
                bl2 = this.filter.accepts(testDescription, this.fObs);
                if (!bl2 && this.fObs.lastTd == testDescription) {
                    testFilter = this.fObs.lastRejector;
                    this.fObs.clear();
                }
            }
            boolean bl4 = bl3 = !this.it.isPending(testResult);
            if (!bl3 && (object = this.it.peek()) instanceof TestResult && ((TestResult)object).getTestName().equals(testResult.getTestName())) {
                TestResult testResult2 = (TestResult)this.it.next();
                bl3 = true;
            }
            if (bl3) {
                if (!bl2) {
                    ++this.localRejectCount;
                    this.testLists[this.testLists.length - 1].add(testResult);
                    this.rejectReasons.put(testResult, testFilter);
                } else {
                    int n2 = testResult.getStatus().getType();
                    if (!this.testLists[n2].contains(testResult)) {
                        int n3 = n2;
                        this.stats[n3] = this.stats[n3] + 1;
                        this.testLists[n2].add(testResult);
                    }
                }
                bl = true;
            } else {
                bl = false;
            }
            this.notify(bl2 ? testResult.getStatus().getType() + 2 : 6, true, treeNodeArray, testResult, n);
            if (bl) {
                this.notifyStats();
            }
        }
        catch (TestResult.Fault fault) {
            if (debug) {
                fault.printStackTrace(Debug.getWriter());
                Debug.println("TT_NC - TR fault, purging old info. " + testResult.getTestName());
            }
            testResult = this.node.getEnclosingTable().resetTest(testResult.getTestName());
            bl = false;
        }
        catch (TestFilter.Fault fault) {
            if (debug) {
                fault.printStackTrace(Debug.getWriter());
            }
            if (bl3) {
                ++this.localRejectCount;
                this.testLists[this.testLists.length - 1].add(testResult);
            }
            bl = false;
        }
        return bl;
    }

    synchronized boolean remove(TestResultTable.TreeNode[] treeNodeArray, TestResult testResult, int n) {
        boolean bl = false;
        if (this.it == null) {
            return false;
        }
        boolean bl2 = false;
        int n2 = testResult.getStatus().getType();
        if (!this.it.isPending(testResult)) {
            int[] nArray = this.locateTestInLists(testResult, n2, -1);
            if (nArray[0] != -1) {
                Object e = this.testLists[nArray[0]].remove(nArray[1]);
                if (nArray[0] < this.stats.length) {
                    int n3 = nArray[0];
                    this.stats[n3] = this.stats[n3] - 1;
                } else {
                    --this.localRejectCount;
                }
                this.notify(nArray[0] + 2, false, treeNodeArray, testResult, n);
                bl = true;
            }
        } else {
            Object object = this.it.peek();
            if (object instanceof TestResult && ((TestResult)object).getTestName().equals(testResult.getTestName())) {
                TestResult testResult2 = (TestResult)this.it.next();
                bl = this.remove(treeNodeArray, testResult, n);
            }
        }
        if (bl) {
            this.notifyStats();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean replace(TestResultTable.TreeNode[] treeNodeArray, TestResult testResult, int n, TestResult testResult2) {
        boolean bl = false;
        if (this.it == null) {
            return false;
        }
        if (!this.it.isPending(testResult)) {
            Object object;
            int n2 = testResult.getStatus().getType();
            int n3 = testResult2.getStatus().getType();
            boolean bl2 = false;
            TestFilter testFilter = null;
            try {
                TestDescription testDescription = testResult.getDescription();
                object = this.fObs;
                synchronized (object) {
                    bl2 = this.filter.accepts(testDescription, this.fObs);
                    if (!bl2 && this.fObs.lastTd == testDescription) {
                        testFilter = this.fObs.lastRejector;
                        this.fObs.clear();
                    }
                }
            }
            catch (TestResult.Fault fault) {
                if (debug) {
                    fault.printStackTrace(Debug.getWriter());
                }
                return false;
            }
            catch (TestFilter.Fault fault) {
                if (debug) {
                    fault.printStackTrace(Debug.getWriter());
                }
                return false;
            }
            int n4 = bl2 ? n2 : this.testLists.length - 1;
            object = null;
            if (testResult == testResult2) {
                if (n3 != n2) {
                    object = new int[]{-1, -1};
                } else {
                    object = this.locateTestInLists(testResult2, 3, n4);
                    if (object[0] == n4) {
                        object[0] = -1;
                        object[1] = -1;
                    }
                }
            } else {
                object = this.locateTestInLists(testResult2, n3, n4);
            }
            if (object[0] != -1) {
                Object e = this.testLists[object[0]].remove((int)object[1]);
                this.testLists[n4].add(testResult);
                if (object[0] < this.stats.length) {
                    Object object2 = object[0];
                    this.stats[object2] = this.stats[object2] - 1;
                } else {
                    --this.localRejectCount;
                    this.rejectReasons.remove(testResult);
                }
                if (n4 < this.stats.length) {
                    int n5 = n4;
                    this.stats[n5] = this.stats[n5] + 1;
                } else {
                    ++this.localRejectCount;
                    this.rejectReasons.put(testResult, testFilter);
                }
                this.notify((int)(object[0] + 2), false, treeNodeArray, testResult2, n);
                this.notify(n4 + 2, true, treeNodeArray, testResult, n);
                bl = true;
            }
        } else {
            bl = false;
        }
        if (bl) {
            this.notifyStats();
        }
        return bl;
    }

    boolean isPaused() {
        return this.state == 3;
    }

    boolean canRun() {
        return (this.state == 3 || this.state == 0) && this.valid;
    }

    void halt() {
        if (debug) {
            Debug.println("TT_NodeCache thread stopping");
            Debug.println("   -> " + this);
        }
        this.state = 4;
        this.valid = false;
    }

    boolean isActive() {
        return this.state == 1;
    }

    boolean isComplete() {
        return this.state == 2;
    }

    void invalidate() {
        this.valid = false;
    }

    boolean isValid() {
        return this.valid;
    }

    TestResultTable.TreeNode getNode() {
        return this.node;
    }

    TestFilter getFilter() {
        return this.filter;
    }

    int[] getStats() {
        return this.stats;
    }

    int getRejectCount() {
        if (this.it != null) {
            return this.it.getRejectCount() + this.localRejectCount;
        }
        return this.localRejectCount;
    }

    TestFilter getRejectReason(TestResult testResult) {
        return (TestFilter)this.rejectReasons.get(testResult);
    }

    synchronized Vector[] addObserver(TT_NodeCacheObserver tT_NodeCacheObserver, boolean bl) {
        Vector[] vectorArray = null;
        if (bl) {
            vectorArray = new Vector[this.testLists.length];
            for (int i = 0; i < this.testLists.length; ++i) {
                vectorArray[i] = (Vector)this.testLists[i].clone();
            }
        }
        if (tT_NodeCacheObserver != null) {
            this.observers = (TT_NodeCacheObserver[])DynamicArray.append(this.observers, tT_NodeCacheObserver);
        }
        return vectorArray;
    }

    synchronized void removeObserver(TT_NodeCacheObserver tT_NodeCacheObserver) {
        this.observers = (TT_NodeCacheObserver[])DynamicArray.remove((Object[])this.observers, tT_NodeCacheObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() {
        while (this.state != 4 && this.state != 3 && this.it.hasNext()) {
            block18: {
                try {
                    TT_NodeCache tT_NodeCache = this;
                    synchronized (tT_NodeCache) {
                        if (!this.it.hasNext()) {
                            continue;
                        }
                        TestResult testResult = (TestResult)this.it.next();
                        TestDescription testDescription = testResult.getDescription();
                        TestFilter testFilter = null;
                        boolean bl = false;
                        FilterObserver filterObserver = this.fObs;
                        synchronized (filterObserver) {
                            try {
                                bl = this.filter.accepts(testDescription, this.fObs);
                            }
                            catch (TestFilter.Fault fault) {
                                if (debug) {
                                    fault.printStackTrace(Debug.getWriter());
                                }
                                bl = true;
                            }
                            if (!bl && this.fObs.lastTd == testDescription) {
                                testFilter = this.fObs.lastRejector;
                                this.fObs.clear();
                            }
                        }
                        if (bl) {
                            int n = testResult.getStatus().getType();
                            if (!this.testLists[n].contains(testResult)) {
                                int n2 = n;
                                this.stats[n2] = this.stats[n2] + 1;
                                this.testLists[n].add(testResult);
                                this.notify(n + 2, true, null, testResult, -1);
                            }
                        } else {
                            this.testLists[this.testLists.length - 1].add(testResult);
                            this.rejectReasons.put(testResult, testFilter);
                            ++this.localRejectCount;
                            this.notify(6, true, null, testResult, -1);
                        }
                    }
                }
                catch (TestResult.Fault fault) {
                    if (!debug) break block18;
                    fault.printStackTrace(Debug.getWriter());
                }
            }
            this.notifyStats();
        }
        if (this.state != 3) {
            this.cleanup();
        }
    }

    private int[] locateTestInLists(TestResult testResult, int n, int n2) {
        int n3;
        int[] nArray = new int[]{-1, -1};
        if (n >= 0 && (n3 = this.testLists[n].indexOf(testResult)) != -1) {
            nArray[0] = n;
            nArray[1] = n3;
        }
        if (nArray[0] == -1) {
            for (n3 = 0; n3 < this.testLists.length; ++n3) {
                int n4;
                if (n3 == n || n3 == n2 || (n4 = this.testLists[n3].indexOf(testResult)) == -1) continue;
                nArray[0] = n3;
                nArray[1] = n4;
                break;
            }
        }
        if (nArray[0] == -1 && n2 >= 0 && (n3 = this.testLists[n2].indexOf(testResult)) != -1) {
            nArray[0] = n2;
            nArray[1] = n3;
        }
        return nArray;
    }

    private int searchList(TestResult testResult, Vector vector) {
        int n = vector.indexOf(testResult);
        return n;
    }

    private void cleanup() {
        if (this.state == 4) {
            return;
        }
        this.state = 2;
    }

    private TestResultTable.TreeIterator init() {
        if (this.node == null) {
            this.valid = false;
            this.state = 4;
            return null;
        }
        return TestResultTable.getIterator(this.node);
    }

    private synchronized void notify(int n, boolean bl, TestResultTable.TreeNode[] treeNodeArray, TestResult testResult, int n2) {
        if (this.observers.length == 0) {
            return;
        }
        for (int i = 0; i < this.observers.length; ++i) {
            boolean[] blArray = this.observers[i].getEventMasks();
            if (!blArray[0] && !blArray[n]) continue;
            if (bl) {
                this.observers[i].testAdded(n, treeNodeArray, testResult, n2);
                continue;
            }
            this.observers[i].testRemoved(n, treeNodeArray, testResult, n2);
        }
    }

    private synchronized void notifyStats() {
        if (this.observers.length == 0) {
            return;
        }
        for (int i = 0; i < this.observers.length; ++i) {
            boolean[] blArray = this.observers[i].getEventMasks();
            if (!blArray[0] && !blArray[1]) continue;
            this.observers[i].statsUpdated(this.stats);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class FilterObserver
    implements TestFilter.Observer {
        TestDescription lastTd;
        TestFilter lastRejector;

        FilterObserver() {
        }

        public void rejected(TestDescription testDescription, TestFilter testFilter) {
            this.lastTd = testDescription;
            this.lastRejector = testFilter;
        }

        public void clear() {
            this.lastTd = null;
            this.lastRejector = null;
        }
    }

    static abstract class TT_NodeCacheObserver {
        protected boolean[] interestList = new boolean[7];
        public static final int EVENT_LIST_SIZE = 7;
        public static final int MSGS_ALL = 0;
        public static final int MSGS_STATS = 1;
        public static final int MSGS_PASSED = 2;
        public static final int MSGS_FAILED = 3;
        public static final int MSGS_ERRORS = 4;
        public static final int MSGS_NOT_RUNS = 5;
        public static final int MSGS_FILTERED = 6;
        public static final int OFFSET_FROM_STATUS = 2;

        public boolean[] getEventMasks() {
            return this.interestList;
        }

        public abstract void testAdded(int var1, TestResultTable.TreeNode[] var2, TestResult var3, int var4);

        public abstract void testRemoved(int var1, TestResultTable.TreeNode[] var2, TestResult var3, int var4);

        public abstract void statsUpdated(int[] var1);
    }
}

