/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.finder;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFinder;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class BinaryTestWriter {
    private static final TestDescription[] noTests = new TestDescription[0];
    private PrintStream log = System.out;
    private boolean strictFinder = false;
    private int numFinderErrors = 0;
    static /* synthetic */ Class class$com$sun$javatest$finder$BinaryTestWriter;

    public static void main(String[] stringArray) {
        int n = 0;
        try {
            BinaryTestWriter binaryTestWriter = new BinaryTestWriter();
            n = binaryTestWriter.run(stringArray);
        }
        catch (BadArgs badArgs) {
            System.err.println("Bad Arguments: " + badArgs.getMessage());
            BinaryTestWriter.usage(System.err);
            System.exit(1);
        }
        catch (Fault fault) {
            System.err.println("Error: " + fault.getMessage());
            System.exit(2);
        }
        catch (IOException iOException) {
            System.err.println("Error: " + iOException);
            System.exit(3);
        }
        System.exit(n);
    }

    private static void usage(PrintStream printStream) {
        String string = System.getProperty("program", "java " + (class$com$sun$javatest$finder$BinaryTestWriter == null ? (class$com$sun$javatest$finder$BinaryTestWriter = BinaryTestWriter.class$("com.sun.javatest.finder.BinaryTestWriter")) : class$com$sun$javatest$finder$BinaryTestWriter).getName());
        printStream.println("Usage:");
        printStream.println("  " + string + " [options]  test-suite [tests...]");
        printStream.println("Options:");
        printStream.println("  -finder finderClass finderArgs... -end");
        printStream.println("  -o output-file");
        printStream.println("  -strictFinder");
    }

    public int run(String[] stringArray) throws BadArgs, Fault, IOException {
        File file = null;
        String string = "com.sun.javatest.finder.TagTestFinder";
        String[] stringArray2 = new String[]{};
        File file2 = null;
        File[] fileArray = null;
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            if (stringArray[i].equalsIgnoreCase("-finder") && i + 1 < stringArray.length) {
                string = stringArray[++i];
                n = ++i;
                while (i < stringArray.length - 1 && !stringArray[i].equalsIgnoreCase("-end")) {
                    ++i;
                }
                stringArray2 = new String[i - n];
                System.arraycopy(stringArray, n, stringArray2, 0, stringArray2.length);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-o") && i + 1 < stringArray.length) {
                file2 = new File(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-strictFinder")) {
                this.strictFinder = true;
                continue;
            }
            if (stringArray[i].startsWith("-")) {
                throw new BadArgs(stringArray[i]);
            }
            file = new File(stringArray[i++]);
            if (i >= stringArray.length) break;
            fileArray = new File[stringArray.length - i];
            for (n = 0; n < fileArray.length; ++n) {
                fileArray[n] = new File(stringArray[i + n]);
            }
            break;
        }
        if (file == null) {
            throw new BadArgs("testsuite.html file not specified");
        }
        TestFinder testFinder = this.initializeTestFinder(string, stringArray2, file);
        if (fileArray == null) {
            fileArray = new File[]{testFinder.getRoot()};
        }
        if (file2 == null) {
            file2 = new File(testFinder.getRootDir(), "testsuite.jtd");
        }
        if (this.strictFinder) {
            testFinder.setErrorHandler(new TestFinder.ErrorHandler(){

                public void error(String string) {
                    BinaryTestWriter.this.numFinderErrors++;
                    System.err.println("Finder reported error:\n" + string);
                    System.err.println("");
                }
            });
        }
        StringTable stringTable = new StringTable();
        TestTable testTable = new TestTable(stringTable);
        TestTree testTree = new TestTree(testTable);
        if (this.log != null) {
            this.log.println("Reading tests...");
        }
        this.read(testFinder, fileArray, testTree);
        if (testTree.getSize() == 0) {
            throw new Fault("No tests found -- check arguments.");
        }
        if (this.log != null) {
            this.log.println("Writing " + file2);
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
        zipOutputStream.setMethod(8);
        zipOutputStream.setLevel(9);
        ZipEntry zipEntry = stringTable.write(zipOutputStream);
        ZipEntry zipEntry2 = testTable.write(zipOutputStream);
        ZipEntry zipEntry3 = testTree.write(zipOutputStream);
        zipOutputStream.close();
        if (this.log != null) {
            this.log.println("strings: " + stringTable.getSize() + " entries, " + this.zipStats(zipEntry));
            this.log.println("tests: " + testTable.getSize() + " tests, " + this.zipStats(zipEntry2));
            this.log.println("tree: " + testTree.getSize() + " nodes, " + this.zipStats(zipEntry3));
        }
        if (this.strictFinder && this.numFinderErrors > 0) {
            System.err.println("*** Source finder reported " + this.numFinderErrors + " errors during execution. ***");
            return 4;
        }
        return 0;
    }

    private TestFinder initializeTestFinder(String string, String[] stringArray, File file) throws Fault {
        TestFinder testFinder;
        if (file == null) {
            throw new NullPointerException();
        }
        try {
            Class<?> clazz = Class.forName(string);
            testFinder = (TestFinder)clazz.newInstance();
            testFinder.init(stringArray, file, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Fault("Error: Can't find class for test finder specified: " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new Fault("Error: Can't create new instance of test finder: " + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Fault("Error: Can't access test finder: " + illegalAccessException);
        }
        catch (TestFinder.Fault fault) {
            throw new Fault("Error: Can't initialize test-finder: " + fault.getMessage());
        }
        return testFinder;
    }

    private File getTestSuiteFile(String string) throws Fault {
        File file = new File(string);
        if (file.isFile()) {
            return file;
        }
        File file2 = new File(file, "testsuite.html");
        if (file2.exists()) {
            return file2;
        }
        File file3 = new File(file, "tests/testsuite.html");
        if (file3.exists()) {
            return file3;
        }
        throw new Fault("Bad input. " + string + " is not a JCK");
    }

    private String zipStats(ZipEntry zipEntry) {
        long l = zipEntry.getSize();
        long l2 = zipEntry.getCompressedSize();
        return l + " bytes (" + l2 + " compressed, " + l2 * 100L / l + "%)";
    }

    void read(TestFinder testFinder, File[] fileArray, TestTree testTree) throws Fault {
        if (fileArray.length < 1) {
            throw new IllegalArgumentException();
        }
        File file = testFinder.getRootDir();
        HashSet hashSet = new HashSet();
        TestTree.Node node = null;
        for (int i = 0; i < fileArray.length; ++i) {
            TestTree.Node node2;
            File file2 = fileArray[i];
            if (!file2.isAbsolute()) {
                file2 = new File(file, file2.getPath());
            }
            if ((node2 = this.read0(testFinder, file2, testTree, hashSet)) == null) continue;
            while (!file2.equals(file)) {
                file2 = file2.getParentFile();
                TestTree testTree2 = testTree;
                testTree2.getClass();
                node2 = testTree2.new TestTree.Node(file2.getName(), noTests, new TestTree.Node[]{node2});
            }
            node = node == null ? node2 : node.merge(node2);
        }
        if (node == null) {
            throw new Fault("No tests found");
        }
        testTree.setRoot(node);
    }

    private TestTree.Node read0(TestFinder testFinder, File file, TestTree testTree, Set set) {
        if (set.contains(file)) {
            return null;
        }
        set.add(file);
        testFinder.read(file);
        TestDescription[] testDescriptionArray = testFinder.getTests();
        Object[] objectArray = testFinder.getFiles();
        if (testDescriptionArray.length == 0 && objectArray.length == 0) {
            return null;
        }
        Arrays.sort(objectArray);
        Arrays.sort(testDescriptionArray, new Comparator(){

            public int compare(Object object, Object object2) {
                TestDescription testDescription = (TestDescription)object;
                TestDescription testDescription2 = (TestDescription)object2;
                return testDescription.getRootRelativeURL().compareTo(testDescription2.getRootRelativeURL());
            }
        });
        Vector<TestTree.Node> vector = new Vector<TestTree.Node>();
        for (int i = 0; i < objectArray.length; ++i) {
            TestTree.Node node = this.read0(testFinder, (File)objectArray[i], testTree, set);
            if (node == null) continue;
            vector.addElement(node);
        }
        Object[] objectArray2 = new TestTree.Node[vector.size()];
        vector.copyInto(objectArray2);
        TestTree testTree2 = testTree;
        testTree2.getClass();
        return testTree2.new TestTree.Node(file.getName(), testDescriptionArray, (TestTree.Node[])objectArray2);
    }

    private static void writeInt(DataOutputStream dataOutputStream, int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        boolean bl = true;
        for (int i = 28; i > 0; i -= 7) {
            int n2 = n >> i & 0x7F;
            boolean bl2 = bl = bl && n2 == 0;
            if (bl) continue;
            dataOutputStream.writeByte(0x80 | n2);
        }
        dataOutputStream.writeByte(n & 0x7F);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class TestTree {
        private Node root;
        private TestTable testTable;

        TestTree(TestTable testTable) {
            this.testTable = testTable;
        }

        void setRoot(Node node) {
            this.root = node;
        }

        int getSize() {
            return this.root == null ? 0 : this.root.getSize();
        }

        ZipEntry write(ZipOutputStream zipOutputStream) throws IOException {
            ZipEntry zipEntry = new ZipEntry("tree");
            zipOutputStream.putNextEntry(zipEntry);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(zipOutputStream));
            this.write(dataOutputStream);
            dataOutputStream.flush();
            zipOutputStream.closeEntry();
            return zipEntry;
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            this.root.write(dataOutputStream);
        }

        class Node {
            private String name;
            private TestDescription[] tests;
            private Node[] children;

            Node(String string, TestDescription[] testDescriptionArray, Node[] nodeArray) {
                this.name = string;
                this.tests = testDescriptionArray;
                this.children = nodeArray;
                for (int i = 0; i < testDescriptionArray.length; ++i) {
                    TestTree.this.testTable.add(testDescriptionArray[i]);
                }
            }

            int getSize() {
                int n = 1;
                if (this.children != null) {
                    for (int i = 0; i < this.children.length; ++i) {
                        n += this.children[i].getSize();
                    }
                }
                return n;
            }

            Node merge(Node node) {
                TestDescription[] testDescriptionArray;
                int n;
                if (!node.name.equals(this.name)) {
                    throw new IllegalArgumentException(this.name + ":" + node.name);
                }
                TreeMap<String, TestDescription[]> treeMap = new TreeMap<String, TestDescription[]>();
                for (n = 0; n < this.children.length; ++n) {
                    testDescriptionArray = this.children[n];
                    treeMap.put(testDescriptionArray.name, testDescriptionArray);
                }
                for (n = 0; n < node.children.length; ++n) {
                    testDescriptionArray = node.children[n];
                    Node node2 = (Node)treeMap.get(testDescriptionArray.name);
                    treeMap.put(testDescriptionArray.name, (TestDescription[])(node2 == null ? testDescriptionArray : testDescriptionArray.merge(node2)));
                }
                Node[] nodeArray = treeMap.values().toArray(new Node[treeMap.size()]);
                if (this.tests.length + node.tests.length == 0) {
                    testDescriptionArray = noTests;
                } else {
                    testDescriptionArray = new TestDescription[this.tests.length + node.tests.length];
                    System.arraycopy(this.tests, 0, testDescriptionArray, 0, this.tests.length);
                    System.arraycopy(node.tests, 0, testDescriptionArray, this.tests.length, node.tests.length);
                }
                return new Node(this.name, testDescriptionArray, nodeArray);
            }

            void write(DataOutputStream dataOutputStream) throws IOException {
                int n;
                dataOutputStream.writeUTF(this.name);
                BinaryTestWriter.writeInt(dataOutputStream, this.tests.length);
                for (n = 0; n < this.tests.length; ++n) {
                    BinaryTestWriter.writeInt(dataOutputStream, TestTree.this.testTable.getIndex(this.tests[n]));
                }
                BinaryTestWriter.writeInt(dataOutputStream, this.children.length);
                for (n = 0; n < this.children.length; ++n) {
                    this.children[n].write(dataOutputStream);
                }
            }
        }
    }

    static class TestTable {
        private HashMap testMap = new HashMap();
        private Vector tests = new Vector();
        private StringTable stringTable;

        TestTable(StringTable stringTable) {
            this.stringTable = stringTable;
        }

        void add(TestDescription testDescription) {
            this.tests.addElement(testDescription);
            this.testMap.put(testDescription, new Entry());
            this.stringTable.add(testDescription);
        }

        int getSize() {
            return this.tests.size();
        }

        int getIndex(TestDescription testDescription) {
            Entry entry = (Entry)this.testMap.get(testDescription);
            if (entry == null) {
                throw new IllegalArgumentException();
            }
            return entry.index;
        }

        ZipEntry write(ZipOutputStream zipOutputStream) throws IOException {
            ZipEntry zipEntry = new ZipEntry("tests");
            zipOutputStream.putNextEntry(zipEntry);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(zipOutputStream));
            this.write(dataOutputStream);
            dataOutputStream.flush();
            zipOutputStream.closeEntry();
            return zipEntry;
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            BinaryTestWriter.writeInt(dataOutputStream, this.tests.size());
            for (int i = 0; i < this.tests.size(); ++i) {
                TestDescription testDescription = (TestDescription)this.tests.elementAt(i);
                Entry entry = (Entry)this.testMap.get(testDescription);
                entry.index = dataOutputStream.size();
                this.write(testDescription, dataOutputStream);
            }
        }

        private void write(TestDescription testDescription, DataOutputStream dataOutputStream) throws IOException {
            BinaryTestWriter.writeInt(dataOutputStream, testDescription.getParameterCount());
            Iterator iterator = testDescription.getParameterKeys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = testDescription.getParameter(string);
                this.stringTable.writeRef(string, dataOutputStream);
                this.stringTable.writeRef(string2, dataOutputStream);
            }
        }

        class Entry {
            int index = -1;

            Entry() {
            }
        }
    }

    static class StringTable {
        private TreeMap map = new TreeMap();
        private int writtenSize;

        StringTable() {
        }

        void add(String string) {
            Entry entry = (Entry)this.map.get(string);
            if (entry == null) {
                entry = new Entry();
                this.map.put(string, entry);
            }
            ++entry.useCount;
        }

        void add(TestDescription testDescription) {
            Iterator iterator = testDescription.getParameterKeys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = testDescription.getParameter(string);
                this.add(string);
                this.add(string2);
            }
        }

        int getSize() {
            return this.map.size();
        }

        int getWrittenSize() {
            return this.writtenSize;
        }

        int getIndex(String string) {
            Entry entry = (Entry)this.map.get(string);
            if (entry == null) {
                throw new IllegalArgumentException();
            }
            return entry.index;
        }

        ZipEntry write(ZipOutputStream zipOutputStream) throws IOException {
            ZipEntry zipEntry = new ZipEntry("strings");
            zipOutputStream.putNextEntry(zipEntry);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(zipOutputStream));
            this.write(dataOutputStream);
            dataOutputStream.flush();
            zipOutputStream.closeEntry();
            return zipEntry;
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            Vector<String> vector = new Vector<String>(this.map.size());
            vector.addElement("");
            int n = 1;
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                Entry entry2 = (Entry)entry.getValue();
                if (!entry2.isFrequent()) continue;
                entry2.index = n++;
                vector.addElement(string);
            }
            BinaryTestWriter.writeInt(dataOutputStream, vector.size());
            for (int i = 0; i < vector.size(); ++i) {
                dataOutputStream.writeUTF((String)vector.elementAt(i));
            }
            this.writtenSize = n;
        }

        void writeRef(String string, DataOutputStream dataOutputStream) throws IOException {
            Entry entry = (Entry)this.map.get(string);
            if (entry == null) {
                throw new IllegalArgumentException();
            }
            if (entry.isFrequent()) {
                BinaryTestWriter.writeInt(dataOutputStream, entry.index);
            } else {
                BinaryTestWriter.writeInt(dataOutputStream, 0);
                dataOutputStream.writeUTF(string);
            }
        }

        static class Entry {
            int useCount = 0;
            int index = 0;

            Entry() {
            }

            boolean isFrequent() {
                return this.useCount > 1;
            }
        }
    }

    public class Fault
    extends Exception {
        Fault(String string) {
            super(string);
        }
    }

    public class BadArgs
    extends Exception {
        BadArgs(String string) {
            super(string);
        }
    }
}

