/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.httpd;

import com.sun.javatest.util.I18NResourceBundle;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.TimeZone;

public class PageGenerator {
    private static DateFormat dateFormat;
    private static String swBuildDate;
    private static String swName;
    private static String swVersion;
    private static I18NResourceBundle i18n;
    private static final String TIMEZONE = "UTC";
    public static final int HTML32 = 0;
    public static final int HTML40_TRANS = 1;
    private static final String HTML32_ID = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">";
    private static final String HTML40_TRANS_ID = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">";
    private static final String HTTP_CONTENT_TYPE = "Content-Type: ";
    private static final String HTTP_OK = "HTTP/1.1 200 OK";
    private static final String HTTP_BAD = "HTTP/1.1 400 Bad Request";
    private static final String HTTP_CONTENT_HTML = "Content-Type: text/html";
    static /* synthetic */ Class class$com$sun$javatest$httpd$PageGenerator;

    public static void generateOkHttp(PrintWriter printWriter) {
        printWriter.println(HTTP_OK);
        PageGenerator.genServerHdr(printWriter);
        printWriter.println(HTTP_CONTENT_HTML);
        printWriter.println();
    }

    public static void generateBadHttp(PrintWriter printWriter) {
        printWriter.println(HTTP_BAD);
        PageGenerator.genServerHdr(printWriter);
        printWriter.println(HTTP_CONTENT_HTML);
    }

    public static void generateDocType(PrintWriter printWriter, int n) {
        switch (n) {
            case 0: {
                printWriter.println(HTML32_ID);
                break;
            }
            case 1: {
                printWriter.println(HTML40_TRANS_ID);
            }
        }
    }

    public static void writeHeader(PrintWriter printWriter, String string) {
        printWriter.println("<Head>");
        printWriter.print("<Title>");
        printWriter.print(string);
        printWriter.println("</Title>");
        printWriter.println("</Head>");
    }

    public static void writeBeginDoc(PrintWriter printWriter) {
        printWriter.println("<html>");
    }

    public static void writeEndDoc(PrintWriter printWriter) {
        printWriter.println("</html>");
    }

    public static void startBody(PrintWriter printWriter) {
        printWriter.println("<Body>");
    }

    public static void endBody(PrintWriter printWriter) {
        printWriter.println("</Body>");
    }

    public static void writeFooter(PrintWriter printWriter) {
        printWriter.println(dateFormat.format(new Date()));
        printWriter.println("<Address>");
        printWriter.print(i18n.getString("generator.produced.txt"));
        printWriter.print(swName);
        printWriter.print(" ");
        printWriter.println(swVersion);
        printWriter.print(i18n.getString("generator.built.txt"));
        printWriter.println(swBuildDate);
        printWriter.println("</Address>");
    }

    public static void writeDictionary(PrintWriter printWriter, Dictionary dictionary, String string, String string2) {
        if (string == null) {
            string = "Key";
        }
        if (string2 == null) {
            string2 = "Value";
        }
        printWriter.println("<Table Border>");
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("<tr><th>");
        stringBuffer.append(string);
        stringBuffer.append("<th>");
        stringBuffer.append(string2);
        stringBuffer.append("</tr>");
        printWriter.println(stringBuffer.toString());
        if (dictionary == null || dictionary.size() == 0) {
            stringBuffer.setLength(0);
            stringBuffer.append("<tr><td colspan=2>");
            stringBuffer.append("-EMPTY-");
            stringBuffer.append("</tr>");
        } else {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                printWriter.println("<tr>");
                stringBuffer.setLength(0);
                stringBuffer.append("<td>");
                stringBuffer.append(k.toString());
                stringBuffer.append("<td>");
                stringBuffer.append(dictionary.get(k).toString());
                printWriter.println(stringBuffer.toString());
                printWriter.println("</tr>");
            }
        }
        printWriter.println("</Table>");
    }

    public static void startTable(PrintWriter printWriter, boolean bl) {
        printWriter.print("<Table");
        if (bl) {
            printWriter.print(" Border");
        }
        printWriter.println(">");
    }

    public static void endTable(PrintWriter printWriter) {
        printWriter.println("</Table>");
    }

    public static String getSWBuildDate() {
        return swBuildDate;
    }

    public static String getSWName() {
        return swName;
    }

    public static String getSWVersion() {
        return swVersion;
    }

    public static void setSWBuildDate(String string) {
        swBuildDate = string;
    }

    public static void setSWName(String string) {
        swName = string;
    }

    public static void setSWVersion(String string) {
        swVersion = string;
    }

    private static void genServerHdr(PrintWriter printWriter) {
        if (swName != null) {
            printWriter.print("Server: ");
            printWriter.print(swName);
            if (swVersion != null) {
                printWriter.print("/");
                printWriter.print(swVersion);
            }
            if (swBuildDate != null) {
                printWriter.print("  built ");
                printWriter.print(swBuildDate);
            }
        }
        printWriter.println();
        printWriter.print("Date: ");
        printWriter.println(dateFormat.format(new Date()));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$httpd$PageGenerator == null ? (class$com$sun$javatest$httpd$PageGenerator = PageGenerator.class$("com.sun.javatest.httpd.PageGenerator")) : class$com$sun$javatest$httpd$PageGenerator);
        dateFormat = DateFormat.getDateTimeInstance(0, 1);
        dateFormat.setTimeZone(TimeZone.getTimeZone(TIMEZONE));
    }
}

