/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.interview;

import com.sun.interview.ChoiceQuestion;
import com.sun.interview.ErrorQuestion;
import com.sun.interview.ExtensionFileFilter;
import com.sun.interview.FileListQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.IntQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.YesNoQuestion;
import com.sun.javatest.ExcludeList;
import com.sun.javatest.ExcludeListFilter;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Vector;

public class ExcludeListInterview
extends Interview
implements Parameters.MutableExcludeListParameters {
    private InterviewParameters parent;
    private boolean initializedForTestSuite;
    private boolean hasInitialJTX;
    private boolean hasValidInitialJTX;
    private boolean hasLatestJTX;
    private boolean hasValidLatestJTX;
    private NeedExcludeListsQuestion qNeedExcludeLists;
    private static final String INITIAL = "initial";
    private static final String LATEST = "latest";
    private static final String CUSTOM = "custom";
    private ExcludeListTypeQuestion qExcludeListType;
    private YesNoQuestion qLatestAutoCheck = new YesNoQuestion(this, "latestAutoCheck", "No"){

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "Yes") {
                return ExcludeListInterview.this.qLatestAutoCheckMode;
            }
            return ExcludeListInterview.this.checkExcludeList();
        }
    };
    private static final String EVERY_X_DAYS = "everyXDays";
    private static final String EVERY_RUN = "everyRun";
    private ChoiceQuestion qLatestAutoCheckMode = new ChoiceQuestion(this, "latestAutoCheckMode"){
        {
            this.setChoices(new String[]{ExcludeListInterview.EVERY_X_DAYS, ExcludeListInterview.EVERY_RUN}, true);
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value.equals(ExcludeListInterview.EVERY_X_DAYS)) {
                return ExcludeListInterview.this.qLatestAutoCheckInterval;
            }
            return ExcludeListInterview.this.checkExcludeList();
        }
    };
    private IntQuestion qLatestAutoCheckInterval = new IntQuestion(this, "latestAutoCheckInterval"){
        {
            this.setBounds(1, 365);
        }

        public void clear() {
            this.setValue(7);
        }

        protected Question getNext() {
            return ExcludeListInterview.this.checkExcludeList();
        }
    };
    private FileListQuestion qCustomFiles = new FileListQuestion(this, "customFiles"){
        {
            this.setFilter(new ExtensionFileFilter(".jtx", "Exclude List"));
            this.setDuplicatesAllowed(false);
        }

        protected Question getNext() {
            if (this.value == null || this.value.length == 0) {
                return null;
            }
            return ExcludeListInterview.this.checkExcludeList();
        }

        public File getBaseDirectory() {
            TestSuite testSuite = ExcludeListInterview.this.parent.getTestSuite();
            return testSuite == null ? null : testSuite.getRootDir();
        }
    };
    private ExcludeList cachedExcludeList;
    private ExcludeListFilter cachedExcludeListFilter;
    private Question cachedExcludeListError;
    private Object[] cachedExcludeListErrorArgs;
    private TestSuite cachedExcludeList_testSuite;
    private File[] cachedExcludeList_files;
    private ErrorQuestion qExcludeListFileNotFound = new ErrorQuestion(this, "excludeListFileNotFound"){

        protected Object[] getTextArgs() {
            return ExcludeListInterview.this.cachedExcludeListErrorArgs;
        }
    };
    private ErrorQuestion qExcludeListIOError = new ErrorQuestion(this, "excludeListIOError"){

        protected Object[] getTextArgs() {
            return ExcludeListInterview.this.cachedExcludeListErrorArgs;
        }
    };
    private ErrorQuestion qExcludeListError = new ErrorQuestion(this, "excludeListError"){

        protected Object[] getTextArgs() {
            return ExcludeListInterview.this.cachedExcludeListErrorArgs;
        }
    };
    private Question qEnd = new FinalQuestion(this);

    public ExcludeListInterview(InterviewParameters interviewParameters) throws Interview.Fault {
        super(interviewParameters, "excludeList");
        this.parent = interviewParameters;
        this.setResourceBundle("i18n");
        this.setHelpSet("/com/sun/javatest/moreInfo/moreInfo.hs");
        this.qNeedExcludeLists = new NeedExcludeListsQuestion();
        this.qExcludeListType = new ExcludeListTypeQuestion();
        this.setFirstQuestion(this.qNeedExcludeLists);
    }

    public File[] getExcludeFiles() {
        if (this.qNeedExcludeLists.getValue() == "Yes") {
            TestSuite testSuite = this.parent.getTestSuite();
            String string = this.qExcludeListType.getValue();
            if (string == INITIAL) {
                File file;
                File file2 = file = testSuite == null ? null : testSuite.getInitialExcludeList();
                if (file == null) {
                    return null;
                }
                return new File[]{file};
            }
            if (string == LATEST) {
                URL uRL;
                URL uRL2 = uRL = testSuite == null ? null : testSuite.getLatestExcludeList();
                if (uRL == null) {
                    return null;
                }
                WorkDirectory workDirectory = this.parent.getWorkDirectory();
                return new File[]{workDirectory.getSystemFile("latest.jtx")};
            }
            return this.qCustomFiles.getValue();
        }
        return null;
    }

    public void setExcludeFiles(File[] fileArray) {
        if (fileArray == null || fileArray.length == 0) {
            this.setExcludeMode(1);
        } else {
            this.setExcludeMode(4);
            this.setCustomExcludeFiles(fileArray);
        }
    }

    public int getExcludeMode() {
        if (this.qNeedExcludeLists.getValue() == "Yes") {
            String string = this.qExcludeListType.getValue();
            if (string == INITIAL) {
                return 2;
            }
            if (string == LATEST) {
                return 3;
            }
            return 4;
        }
        return 1;
    }

    public void setExcludeMode(int n) {
        if (n == 1) {
            this.qNeedExcludeLists.setValue("No");
        } else {
            this.qNeedExcludeLists.setValue("Yes");
            switch (n) {
                case 2: {
                    this.qExcludeListType.setValue(INITIAL);
                    break;
                }
                case 3: {
                    this.qExcludeListType.setValue(LATEST);
                    break;
                }
                default: {
                    this.qExcludeListType.setValue(CUSTOM);
                }
            }
        }
    }

    public File[] getCustomExcludeFiles() {
        return this.qCustomFiles.getValue();
    }

    public void setCustomExcludeFiles(File[] fileArray) {
        this.qCustomFiles.setValue(fileArray);
    }

    public boolean isLatestExcludeAutoCheckEnabled() {
        return this.qLatestAutoCheck.getValue() == "Yes";
    }

    public void setLatestExcludeAutoCheckEnabled(boolean bl) {
        this.qLatestAutoCheck.setValue(bl ? "Yes" : "No");
    }

    public int getLatestExcludeAutoCheckMode() {
        return this.qLatestAutoCheckMode.getValue() == EVERY_X_DAYS ? 1 : 2;
    }

    public void setLatestExcludeAutoCheckMode(int n) {
        if (n == 1) {
            this.qLatestAutoCheckMode.setValue(EVERY_X_DAYS);
        } else {
            this.qLatestAutoCheckMode.setValue(EVERY_RUN);
        }
    }

    public int getLatestExcludeAutoCheckInterval() {
        return this.qLatestAutoCheckInterval.getValue();
    }

    public void setLatestExcludeAutoCheckInterval(int n) {
        this.qLatestAutoCheckInterval.setValue(n);
    }

    public ExcludeList getExcludeList() {
        this.updateCachedExcludeListData();
        return this.cachedExcludeList;
    }

    public TestFilter getExcludeFilter() {
        this.updateCachedExcludeListData();
        return this.cachedExcludeListFilter;
    }

    private void ensureInitializedForTestSuite() {
        WorkDirectory workDirectory;
        if (this.initializedForTestSuite) {
            return;
        }
        TestSuite testSuite = this.parent.getTestSuite();
        if (testSuite == null) {
            return;
        }
        File file = testSuite.getInitialExcludeList();
        this.hasInitialJTX = file != null;
        this.hasValidInitialJTX = this.hasInitialJTX && file.exists();
        URL uRL = testSuite.getLatestExcludeList();
        boolean bl = this.hasLatestJTX = uRL != null;
        this.hasValidLatestJTX = this.hasLatestJTX ? (workDirectory = this.parent.getWorkDirectory()) != null && workDirectory.getSystemFile("latest.jtx").exists() : false;
        this.initializedForTestSuite = true;
    }

    private void updateCachedExcludeListData() {
        TestSuite testSuite = this.parent.getTestSuite();
        File file = testSuite == null ? null : testSuite.getRootDir();
        File[] fileArray = ExcludeListInterview.getAbsoluteFiles(file, this.getExcludeFiles());
        if (!ExcludeListInterview.equal(this.cachedExcludeList_files, fileArray) || this.cachedExcludeList_testSuite != testSuite) {
            try {
                if (testSuite == null || fileArray == null || fileArray.length == 0) {
                    this.setCachedExcludeList(new ExcludeList());
                } else {
                    this.setCachedExcludeList(new ExcludeList(fileArray));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.setCachedExcludeListError(this.qExcludeListFileNotFound, fileNotFoundException.getMessage());
            }
            catch (IOException iOException) {
                this.setCachedExcludeListError(this.qExcludeListIOError, iOException.toString());
            }
            catch (ExcludeList.Fault fault) {
                this.setCachedExcludeListError(this.qExcludeListError, fault.getMessage());
            }
            this.cachedExcludeList_files = fileArray;
            this.cachedExcludeList_testSuite = testSuite;
        }
    }

    private void setCachedExcludeList(ExcludeList excludeList) {
        this.cachedExcludeList = excludeList;
        this.cachedExcludeListFilter = excludeList.isEmpty() ? null : new ExcludeListFilter(excludeList);
        this.cachedExcludeListError = null;
        this.cachedExcludeListErrorArgs = null;
    }

    private void setCachedExcludeListError(Question question, String string) {
        this.cachedExcludeList = new ExcludeList();
        this.cachedExcludeListFilter = null;
        this.cachedExcludeListError = question;
        this.cachedExcludeListErrorArgs = new String[]{string};
    }

    private Question checkExcludeList() {
        this.updateCachedExcludeListData();
        if (this.cachedExcludeListError != null) {
            return this.cachedExcludeListError;
        }
        return this.qEnd;
    }

    private static File[] getAbsoluteFiles(File file, File[] fileArray) {
        if (fileArray == null) {
            return null;
        }
        if (file == null) {
            return fileArray;
        }
        boolean bl = true;
        for (int i = 0; i < fileArray.length && bl; ++i) {
            bl = fileArray[i].isAbsolute();
        }
        if (bl) {
            return fileArray;
        }
        File[] fileArray2 = new File[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            fileArray2[i] = file2.isAbsolute() ? file2 : new File(file, file2.getPath());
        }
        return fileArray2;
    }

    private static boolean equal(File file, File file2) {
        return file == null ? file2 == null : file.equals(file2);
    }

    private static boolean equal(File[] fileArray, File[] fileArray2) {
        if (fileArray == null || fileArray2 == null) {
            return fileArray == fileArray2;
        }
        if (fileArray.length != fileArray2.length) {
            return false;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i] == fileArray2[i]) continue;
            return false;
        }
        return true;
    }

    private class ExcludeListTypeQuestion
    extends ChoiceQuestion {
        private boolean initialized;
        private String defaultValue;

        ExcludeListTypeQuestion() {
            super(ExcludeListInterview.this, "excludeListType");
            this.setChoices(new String[]{null, ExcludeListInterview.INITIAL, ExcludeListInterview.LATEST, ExcludeListInterview.CUSTOM}, true);
            this.clear();
        }

        public void clear() {
            this.ensureInitialized();
            this.setValue(this.defaultValue);
        }

        public String[] getChoices() {
            this.ensureInitialized();
            return super.getChoices();
        }

        public void save(Map map) {
            this.ensureInitialized();
            super.save(map);
        }

        public boolean isHidden() {
            return this.getChoices().length == 2;
        }

        public String getValue() {
            return this.isHidden() ? ExcludeListInterview.CUSTOM : super.getValue();
        }

        protected Question getNext() {
            if (this.isHidden()) {
                return ExcludeListInterview.this.qCustomFiles;
            }
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            if (this.value.equals(ExcludeListInterview.INITIAL)) {
                return ExcludeListInterview.this.checkExcludeList();
            }
            if (this.value.equals(ExcludeListInterview.LATEST)) {
                return ExcludeListInterview.this.qLatestAutoCheck;
            }
            return ExcludeListInterview.this.qCustomFiles;
        }

        private void ensureInitialized() {
            if (this.initialized) {
                return;
            }
            if (ExcludeListInterview.this.parent.getTestSuite() == null) {
                return;
            }
            ExcludeListInterview.this.ensureInitializedForTestSuite();
            String string = ExcludeListInterview.CUSTOM;
            Vector<String> vector = new Vector<String>(4);
            vector.add(null);
            if (ExcludeListInterview.this.hasValidInitialJTX) {
                vector.add(ExcludeListInterview.INITIAL);
            }
            if (ExcludeListInterview.this.hasLatestJTX) {
                vector.add(ExcludeListInterview.LATEST);
            }
            vector.add(ExcludeListInterview.CUSTOM);
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            this.setChoices((String[])objectArray, true);
            string = ExcludeListInterview.this.hasValidLatestJTX ? ExcludeListInterview.LATEST : (ExcludeListInterview.this.hasValidInitialJTX ? ExcludeListInterview.INITIAL : null);
            this.setValue(string);
            this.initialized = true;
        }
    }

    private class NeedExcludeListsQuestion
    extends YesNoQuestion {
        private boolean doneSuper = true;

        NeedExcludeListsQuestion() {
            super(ExcludeListInterview.this, "needExcludeList");
            this.clear();
        }

        public void clear() {
            if (!this.doneSuper) {
                return;
            }
            ExcludeListInterview.this.ensureInitializedForTestSuite();
            this.setValue(ExcludeListInterview.this.hasValidInitialJTX || ExcludeListInterview.this.hasValidLatestJTX ? "Yes" : "No");
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "Yes") {
                return ExcludeListInterview.this.qExcludeListType;
            }
            return ExcludeListInterview.this.qEnd;
        }
    }
}

