/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.interview;

import com.sun.interview.ChoiceQuestion;
import com.sun.interview.ErrorQuestion;
import com.sun.interview.FileQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.TreeQuestion;
import com.sun.interview.YesNoQuestion;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.WorkDirectory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.Vector;

public class TestsInterview
extends Interview
implements Parameters.MutableTestsParameters {
    private YesNoQuestion qNeedTests = new YesNoQuestion(this, "needTests", "No"){

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "Yes") {
                return TestsInterview.this.qTreeOrFile;
            }
            return TestsInterview.this.qEnd;
        }
    };
    private static final String FILE = "file";
    private static final String TREE = "tree";
    private ChoiceQuestion qTreeOrFile = new ChoiceQuestion(this, "treeOrFile"){
        {
            this.setChoices(new String[]{TestsInterview.TREE, TestsInterview.FILE}, true);
        }

        protected Question getNext() {
            if (this.value == TestsInterview.TREE) {
                return TestsInterview.this.qTestTree;
            }
            return TestsInterview.this.qTestFile;
        }
    };
    private FileQuestion qTestFile = new FileQuestion(this, "testFile"){

        public boolean isValueValid() {
            return this.value != null && this.value.getPath().length() > 0;
        }

        protected Question getNext() {
            if (this.value == null || this.value.getPath().length() == 0) {
                return null;
            }
            String[] stringArray = TestsInterview.this.getTests(this.value);
            if (stringArray == null) {
                return TestsInterview.this.cachedTestsError;
            }
            TestsInterview.this.validateTests(stringArray);
            if (TestsInterview.this.cachedTestsError != null) {
                return TestsInterview.this.cachedTestsError;
            }
            return TestsInterview.this.qEnd;
        }
    };
    private Question qCantFindFileError = new ErrorQuestion(this, "cantFindFile"){

        protected Object[] getTextArgs() {
            return TestsInterview.this.cachedTestsErrorArgs;
        }
    };
    private Question qCantReadFileError = new ErrorQuestion(this, "cantReadFile"){

        protected Object[] getTextArgs() {
            return TestsInterview.this.cachedTestsErrorArgs;
        }
    };
    private TreeQuestion.Model model = new TreeQuestion.Model(){

        public Object getRoot() {
            return TestsInterview.this.parent.getWorkDirectory().getTestResultTable().getRoot();
        }

        public int getChildCount(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (object instanceof TestResultTable.TreeNode) {
                return ((TestResultTable.TreeNode)object).getChildCount();
            }
            if (object instanceof TestResult) {
                return 0;
            }
            throw new IllegalArgumentException();
        }

        public Object getChild(Object object, int n) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (object instanceof TestResultTable.TreeNode) {
                return ((TestResultTable.TreeNode)object).getChild(n);
            }
            if (object instanceof TestResult) {
                return null;
            }
            throw new IllegalArgumentException();
        }

        public String getName(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (object instanceof TestResultTable.TreeNode) {
                return ((TestResultTable.TreeNode)object).getName();
            }
            if (object instanceof TestResult) {
                TestResult testResult = (TestResult)object;
                String string = testResult.getTestName();
                int n = string.lastIndexOf("/");
                return n == -1 ? string : string.substring(n + 1);
            }
            throw new IllegalArgumentException();
        }

        public String getPath(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (object instanceof TestResult) {
                return ((TestResult)object).getTestName();
            }
            if (object instanceof TestResultTable.TreeNode) {
                TestResultTable.TreeNode treeNode = (TestResultTable.TreeNode)object;
                if (treeNode.isRoot()) {
                    return treeNode.getName();
                }
                return this.getPath(treeNode.getParent() + "/" + treeNode.getName());
            }
            throw new IllegalArgumentException();
        }

        public boolean isLeaf(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (object instanceof TestResult) {
                return true;
            }
            if (object instanceof TestResultTable.TreeNode) {
                return false;
            }
            throw new IllegalArgumentException();
        }
    };
    private TreeQuestion qTestTree = new TreeQuestion(this, "tests", this.model){

        protected Question getNext() {
            TestsInterview.this.validateTests(this.value);
            if (TestsInterview.this.cachedTestsError != null) {
                return TestsInterview.this.cachedTestsError;
            }
            return TestsInterview.this.qEnd;
        }
    };
    private Question qNoTestsError = new ErrorQuestion(this, "noTests");
    private ErrorQuestion qBadTestsError = new ErrorQuestion(this, "badTests"){

        protected Object[] getTextArgs() {
            return TestsInterview.this.cachedTestsErrorArgs;
        }
    };
    private String[] cachedTestsValue;
    private Question cachedTestsError;
    private Object[] cachedTestsErrorArgs;
    private Question qEnd = new FinalQuestion(this);
    private InterviewParameters parent;

    public TestsInterview(InterviewParameters interviewParameters) throws Interview.Fault {
        super(interviewParameters, "tests");
        this.parent = interviewParameters;
        this.setResourceBundle("i18n");
        this.setHelpSet("/com/sun/javatest/moreInfo/moreInfo.hs");
        this.setFirstQuestion(this.qNeedTests);
    }

    public String[] getTests() {
        if (this.qNeedTests.getValue() == "Yes") {
            if (this.qTreeOrFile.getValue() == TREE) {
                return this.qTestTree.getValue();
            }
            return this.getTests(this.qTestFile.getValue());
        }
        return null;
    }

    public void setTests(String[] stringArray) {
        if (stringArray == null) {
            this.setTestsMode(1);
        } else {
            this.setTestsMode(2);
            this.setSpecifiedTests(stringArray);
        }
    }

    public int getTestsMode() {
        return this.qNeedTests.getValue() == "Yes" ? 2 : 1;
    }

    public void setTestsMode(int n) {
        switch (n) {
            case 1: {
                this.qNeedTests.setValue("No");
                break;
            }
            case 2: {
                this.qNeedTests.setValue("Yes");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public String[] getSpecifiedTests() {
        String[] stringArray = this.qTreeOrFile.getValue() == TREE ? this.qTestTree.getValue() : this.getTests(this.qTestFile.getValue());
        if (stringArray == null) {
            return null;
        }
        TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(stringArray));
        return treeSet.toArray(new String[treeSet.size()]);
    }

    public void setSpecifiedTests(String[] stringArray) {
        this.qTreeOrFile.setValue(TREE);
        this.qTestTree.setValue(stringArray);
    }

    private String[] getTests(File file) {
        Vector<String> vector = new Vector<String>();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).length() == 0 || string.startsWith("#")) continue;
                int n = string.indexOf(32);
                vector.add(n == -1 ? string : string.substring(0, n));
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.cachedTestsError = this.qCantFindFileError;
            this.cachedTestsErrorArgs = new Object[]{file};
            return null;
        }
        catch (IOException iOException) {
            this.cachedTestsError = this.qCantFindFileError;
            this.cachedTestsErrorArgs = new Object[]{file, iOException.toString()};
            return null;
        }
        return vector.toArray(new String[vector.size()]);
    }

    private void validateTests(String[] stringArray) {
        if (TestsInterview.equal(stringArray, this.cachedTestsValue)) {
            return;
        }
        this.cachedTestsValue = stringArray;
        this.cachedTestsError = null;
        WorkDirectory workDirectory = this.parent.getWorkDirectory();
        if (workDirectory == null) {
            return;
        }
        TestResultTable testResultTable = workDirectory.getTestResultTable();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (vector.contains(string) || testResultTable.validatePath(string)) continue;
            if (stringBuffer.length() > 32) {
                stringBuffer.append("...");
                break;
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(string);
            vector.add(string);
        }
        if (stringBuffer.length() > 0) {
            this.cachedTestsError = this.qBadTestsError;
            this.cachedTestsErrorArgs = new Object[]{new Integer(vector.size()), stringBuffer.toString()};
        }
    }

    private static boolean equal(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null) {
            return stringArray == stringArray2;
        }
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == stringArray2[i]) continue;
            return false;
        }
        return true;
    }
}

