/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.report.ConfigSection;
import com.sun.javatest.report.HTMLSection;
import com.sun.javatest.report.Report;
import com.sun.javatest.report.ReportFormat;
import com.sun.javatest.report.ReportWriter;
import com.sun.javatest.report.ResultSection;
import com.sun.javatest.report.StatisticsSection;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;

class HTMLReport
implements ReportFormat {
    File reportDir;
    private BackupPolicy backupPolicy;
    private I18NResourceBundle i18n;
    static final String REPORT_NAME = "report.html";
    static final String NEW_REPORT_NAME = "index.html";
    static final String[] anchors = new String[]{"selection", "execution", "locations", "keywordSummary"};
    static final int SELECT_ANCHOR = 0;
    static final int EXEC_ANCHOR = 1;
    static final int LOC_ANCHOR = 2;
    static final int KEYWORD_ANCHOR = 3;
    static final String[] files = new String[]{"report.html", "index.html", "config.html", "env.html", "excluded.html", "passed.html", "failed.html", "error.html", "notRun.html"};
    static final int REPORT_HTML = 0;
    static final int INDEX_HTML = 1;
    static final int CONFIG_HTML = 2;
    static final int ENV_HTML = 3;
    static final int EXCLUDED_HTML = 4;
    static final int PASSED_HTML = 5;
    static final int FAILED_HTML = 6;
    static final int ERROR_HTML = 7;
    static final int NOTRUN_HTML = 8;

    HTMLReport(I18NResourceBundle i18NResourceBundle) {
        this.i18n = i18NResourceBundle;
        HTMLSection.i18n = i18NResourceBundle;
    }

    public void write(Report.Settings settings, File file) throws IOException {
        this.reportDir = file;
        this.backupPolicy = settings.isBackupsEnabled() ? BackupPolicy.simpleBackups(settings.backups) : BackupPolicy.noBackups();
        Vector<HTMLSection> vector = new Vector<HTMLSection>(3);
        Vector<HTMLSection> vector2 = new Vector<HTMLSection>(3);
        ConfigSection configSection = new ConfigSection(this, settings, file);
        if (settings.isConfigSectionEnabled()) {
            vector.addElement(configSection);
            vector2.addElement(configSection);
        }
        ResultSection resultSection = null;
        if (settings.isResultsEnabled()) {
            resultSection = new ResultSection(this, settings, file);
            vector.addElement(resultSection);
        }
        if (settings.isStateFileEnabled(0) || settings.isStateFileEnabled(2) || settings.isStateFileEnabled(3) || settings.isStateFileEnabled(1)) {
            if (resultSection == null) {
                resultSection = new ResultSection(this, settings, file);
            }
            vector2.addElement(resultSection);
        }
        if (settings.isKeywordSummaryEnabled()) {
            vector.addElement(new StatisticsSection(this, settings, file));
            vector2.addElement(new StatisticsSection(this, settings, file));
        }
        Object[] objectArray = new HTMLSection[vector.size()];
        vector.copyInto(objectArray);
        Object[] objectArray2 = new HTMLSection[vector2.size()];
        vector2.copyInto(objectArray2);
        Writer writer = null;
        if (settings.reportHtml && settings.indexHtml) {
            writer = new DuplexWriter(this.openWriter(this.reportDir, 0), this.openWriter(this.reportDir, 1));
        } else if (settings.reportHtml) {
            writer = this.openWriter(this.reportDir, 0);
        } else if (settings.indexHtml) {
            writer = this.openWriter(this.reportDir, 1);
        }
        ReportWriter.initializeDirectory(this.reportDir);
        if (writer != null) {
            int n;
            ReportWriter reportWriter = new ReportWriter(writer, this.i18n.getString("report.title"), this.i18n);
            String string = settings.ip.getTestSuite().getName();
            if (string != null) {
                reportWriter.startTag("h2");
                reportWriter.writeI18N("report.testSuite", string);
                reportWriter.endTag("h2");
            }
            reportWriter.startTag("ul");
            for (n = 0; n < objectArray.length; ++n) {
                reportWriter.startTag("li");
                ((HTMLSection)objectArray[n]).writeContents(reportWriter);
                reportWriter.endTag("li");
            }
            reportWriter.endTag("ul");
            for (n = 0; n < objectArray.length; ++n) {
                reportWriter.startTag("p");
                reportWriter.startTag("hr");
                ((HTMLSection)objectArray[n]).writeSummary(reportWriter);
                reportWriter.newLine();
            }
            reportWriter.close();
        }
        for (int i = 0; i < objectArray2.length; ++i) {
            ((HTMLSection)objectArray2[i]).writeExtraFiles();
        }
    }

    public static String[] getReportFilenames() {
        return new String[]{REPORT_NAME, NEW_REPORT_NAME};
    }

    public static String getFile(int n) {
        return files[n];
    }

    static String[] getFilenamesUsed() {
        return files;
    }

    File getReportDirectory() {
        return this.reportDir;
    }

    Writer openWriter(File file, int n) throws IOException {
        return this.backupPolicy.backupAndOpenWriter(new File(file, files[n]));
    }

    static class DuplexWriter
    extends Writer {
        private Writer[] targets;

        public DuplexWriter(Writer[] writerArray) {
            if (writerArray == null) {
                return;
            }
            this.targets = new Writer[writerArray.length];
            System.arraycopy(writerArray, 0, this.targets, 0, writerArray.length);
        }

        public DuplexWriter(Writer writer, Writer writer2) {
            this.targets = new Writer[2];
            this.targets[0] = writer;
            this.targets[1] = writer2;
        }

        public void close() throws IOException {
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i].close();
            }
        }

        public void flush() throws IOException {
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i].flush();
            }
        }

        public void write(char[] cArray) throws IOException {
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i].write(cArray);
            }
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i].write(cArray, n, n2);
            }
        }

        public void write(int n) throws IOException {
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i].write(n);
            }
        }

        public void write(String string) throws IOException {
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i].write(string);
            }
        }

        public void write(String string, int n, int n2) throws IOException {
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i].write(string, n, n2);
            }
        }
    }
}

