/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.CompositeFilter;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.report.HTMLReport;
import com.sun.javatest.report.PlainTextReport;
import com.sun.javatest.report.ReportModel;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class Report
implements ReportModel {
    private InterviewParameters params;
    private TestResultTable resultTable;
    private TestFilter[] paramFilters;
    private String[] initUrls;
    private File[] initFiles;
    private static final String PREFS_GEN_HTML = "rpt.type.html";
    private static final String PREFS_GEN_PLAIN = "rpt.type.plain";
    private static final String PREFS_GEN_XML = "rpt.type.xml";
    private static final String PREFS_HTML_CONFIG = "rpt.html.config";
    private static final String PREFS_HTML_QL = "rpt.html.ql";
    private static final String PREFS_HTML_ENV = "rpt.html.env";
    private static final String PREFS_HTML_STD = "rpt.html.std";
    private static final String PREFS_HTML_RES = "rpt.html.res";
    private static final String PREFS_HTML_KWS = "rpt.html.kws";
    private static final String PREFS_HTML_REPORTF = "rpt.html.reportf";
    private static final String PREFS_HTML_INDEXF = "rpt.html.htmlf";
    private static final String PREFS_HTML_STATEF = "rpt.html.statef";
    private static final String PREFS_BACK = "rpt.bak.enable";
    private static final String PREFS_BACK_NUM = "rpt.bak.num";
    private static File reportDir;
    private static I18NResourceBundle i18n;
    static /* synthetic */ Class class$com$sun$javatest$report$Report;

    public Report() {
    }

    public Report(InterviewParameters interviewParameters, File file) {
        this.params = interviewParameters;
        reportDir = file.getAbsoluteFile();
    }

    public Report(InterviewParameters interviewParameters, File file, TestFilter testFilter) {
        this(interviewParameters, file);
        this.paramFilters = new TestFilter[]{testFilter};
    }

    public File[] checkExistingFiles() {
        Vector<File> vector = new Vector<File>();
        String[] stringArray = HTMLReport.getFilenamesUsed();
        String[] stringArray2 = reportDir.list();
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray[i].equals(stringArray2[j])) continue;
                vector.addElement(new File(reportDir, stringArray2[j]));
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new File[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void writeReport(Settings settings, File file) throws IOException {
        reportDir = file.getAbsoluteFile();
        settings.ip.getWorkDirectory().getTestResultTable().waitUntilReady();
        if (settings.isHtmlEnabled()) {
            this.writeReportHTML(settings);
        }
        if (settings.isPlainEnabled()) {
            this.writeSummaryTXT(settings);
        }
        Report.writePrefs(settings);
    }

    public void writeReport() throws IOException {
        Settings settings = Report.getSettingsPrefs();
        settings.ip = this.params;
        if (this.paramFilters != null) {
            settings.filter = this.paramFilters.length == 1 ? this.paramFilters[0] : new CompositeFilter(this.paramFilters);
        }
        this.params.getWorkDirectory().getTestResultTable().waitUntilReady();
        this.writeReportHTML(settings);
        this.writeSummaryTXT(settings);
    }

    public static boolean isReportDirectory(File file) {
        String[] stringArray = HTMLReport.getFilenamesUsed();
        String[] stringArray2 = PlainTextReport.getFilenamesUsed();
        String[] stringArray3 = file.list();
        if (stringArray3 == null) {
            return false;
        }
        for (int i = 0; i < stringArray3.length; ++i) {
            File file2;
            int n;
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray3[i].equals(stringArray[n]) || !(file2 = new File(file, stringArray3[i])).canRead()) continue;
                return true;
            }
            for (n = 0; n < stringArray2.length; ++n) {
                if (!stringArray3[i].equals(stringArray2[n]) || !(file2 = new File(file, stringArray3[i])).canRead()) continue;
                return true;
            }
        }
        return false;
    }

    public File getReportDir() {
        return reportDir;
    }

    public static String[] getHtmlReportFilenames() {
        return HTMLReport.getReportFilenames();
    }

    public static String[] getPlainReportFilenames() {
        return PlainTextReport.getReportFilenames();
    }

    public static String[] getFilenamesUsed() {
        return HTMLReport.getFilenamesUsed();
    }

    private void writeReportHTML(Settings settings) throws IOException {
        HTMLReport hTMLReport = new HTMLReport(i18n);
        hTMLReport.write(settings, reportDir);
    }

    private void writeSummaryTXT(Settings settings) throws IOException {
        PlainTextReport plainTextReport = new PlainTextReport(i18n);
        plainTextReport.write(settings, reportDir);
    }

    public static void writePrefs(Settings settings) {
        Preferences preferences = Preferences.access();
        settings.write(preferences);
    }

    public static Settings getSettingsPrefs() {
        Preferences preferences = Preferences.access();
        return Settings.create(preferences);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$report$Report == null ? (class$com$sun$javatest$report$Report = Report.class$("com.sun.javatest.report.Report")) : class$com$sun$javatest$report$Report);
    }

    public static class Settings {
        InterviewParameters ip;
        TestFilter filter;
        boolean genHtml = true;
        boolean genPlain = true;
        boolean genXml = false;
        boolean genConfig = true;
        boolean genQl = true;
        boolean genEnv = true;
        boolean genStd = true;
        boolean genResults = true;
        boolean genKws = true;
        boolean reportHtml = true;
        boolean indexHtml = false;
        boolean[] stateFiles = new boolean[4];
        boolean doBackups = true;
        int backups = 1;
        File[] initFiles;

        public Settings() {
            for (int i = 0; i < this.stateFiles.length; ++i) {
                this.stateFiles[i] = true;
            }
        }

        public Settings(InterviewParameters interviewParameters) {
            this();
            this.ip = interviewParameters;
        }

        public void write(Preferences preferences) {
            preferences.setPreference(Report.PREFS_GEN_HTML, Boolean.toString(this.genHtml));
            preferences.setPreference(Report.PREFS_GEN_PLAIN, Boolean.toString(this.genPlain));
            preferences.setPreference(Report.PREFS_GEN_XML, Boolean.toString(this.genXml));
            preferences.setPreference(Report.PREFS_HTML_CONFIG, Boolean.toString(this.genConfig));
            preferences.setPreference(Report.PREFS_HTML_QL, Boolean.toString(this.genQl));
            preferences.setPreference(Report.PREFS_HTML_ENV, Boolean.toString(this.genEnv));
            preferences.setPreference(Report.PREFS_HTML_STD, Boolean.toString(this.genStd));
            preferences.setPreference(Report.PREFS_HTML_RES, Boolean.toString(this.genResults));
            preferences.setPreference(Report.PREFS_HTML_KWS, Boolean.toString(this.genKws));
            preferences.setPreference(Report.PREFS_HTML_REPORTF, Boolean.toString(this.reportHtml));
            preferences.setPreference(Report.PREFS_HTML_INDEXF, Boolean.toString(this.indexHtml));
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.stateFiles.length; ++i) {
                stringBuffer.append(Boolean.toString(this.stateFiles[i]));
                if (i + 1 >= this.stateFiles.length) continue;
                stringBuffer.append(",");
            }
            preferences.setPreference(Report.PREFS_HTML_STATEF, stringBuffer.toString());
            preferences.setPreference(Report.PREFS_BACK, Boolean.toString(this.doBackups));
            preferences.setPreference(Report.PREFS_BACK_NUM, Integer.toString(this.backups));
        }

        public static Settings create(Preferences preferences) {
            Settings settings = new Settings();
            String string = preferences.getPreference(Report.PREFS_GEN_HTML);
            if (string == null) {
                return settings;
            }
            settings.genHtml = Settings.parseBoolean(string);
            settings.genPlain = Settings.parseBoolean(preferences.getPreference(Report.PREFS_GEN_PLAIN));
            settings.genXml = Settings.parseBoolean(preferences.getPreference(Report.PREFS_GEN_XML));
            settings.genConfig = Settings.parseBoolean(preferences.getPreference(Report.PREFS_HTML_CONFIG));
            settings.genQl = Settings.parseBoolean(preferences.getPreference(Report.PREFS_HTML_QL));
            settings.genEnv = Settings.parseBoolean(preferences.getPreference(Report.PREFS_HTML_ENV));
            settings.genStd = Settings.parseBoolean(preferences.getPreference(Report.PREFS_HTML_STD));
            settings.genResults = Settings.parseBoolean(preferences.getPreference(Report.PREFS_HTML_RES));
            settings.genKws = Settings.parseBoolean(preferences.getPreference(Report.PREFS_HTML_KWS));
            settings.reportHtml = Settings.parseBoolean(preferences.getPreference(Report.PREFS_HTML_REPORTF));
            settings.indexHtml = Settings.parseBoolean(preferences.getPreference(Report.PREFS_HTML_INDEXF));
            String[] stringArray = StringArray.splitList(preferences.getPreference(Report.PREFS_HTML_STATEF), ",");
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    settings.stateFiles[i] = Settings.parseBoolean(stringArray[i]);
                }
            }
            settings.doBackups = Settings.parseBoolean(preferences.getPreference(Report.PREFS_BACK));
            try {
                settings.backups = Integer.parseInt(preferences.getPreference(Report.PREFS_BACK_NUM));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return settings;
        }

        public void setInterview(InterviewParameters interviewParameters) {
            this.ip = interviewParameters;
        }

        public void setFilter(TestFilter testFilter) {
            this.filter = testFilter;
        }

        public void setEnableHtmlReport(boolean bl) {
            this.genHtml = bl;
        }

        public void setEnableXmlReport(boolean bl) {
            this.genXml = bl;
        }

        public void setEnablePlainReport(boolean bl) {
            this.genPlain = bl;
        }

        public void setShowConfigSection(boolean bl) {
            this.genConfig = bl;
        }

        public void setShowQuestionLog(boolean bl) {
            this.genQl = bl;
        }

        public void setShowEnvLog(boolean bl) {
            this.genEnv = bl;
        }

        public void setShowStdValues(boolean bl) {
            this.genStd = bl;
        }

        public void setShowResults(boolean bl) {
            this.genResults = bl;
        }

        public void setShowKeywordSummary(boolean bl) {
            this.genKws = bl;
        }

        public void setEnableHtmlStateFile(int n, boolean bl) {
            if (n >= this.stateFiles.length) {
                return;
            }
            this.stateFiles[n] = bl;
        }

        public void setHtmlMainReport(boolean bl, boolean bl2) {
            this.reportHtml = bl;
            this.indexHtml = bl2;
        }

        public void setEnableBackups(boolean bl) {
            this.doBackups = bl;
        }

        public void setBackupLevels(int n) {
            if (n > 0) {
                this.backups = n;
            }
        }

        public boolean isHtmlEnabled() {
            return this.genHtml;
        }

        public boolean isXmlEnabled() {
            return this.genXml;
        }

        public boolean isPlainEnabled() {
            return this.genPlain;
        }

        public boolean isConfigSectionEnabled() {
            return this.genConfig;
        }

        public boolean isQuestionLogEnabled() {
            return this.genQl;
        }

        public boolean isEnvEnabled() {
            return this.genEnv;
        }

        public boolean isStdEnabled() {
            return this.genStd;
        }

        public boolean isResultsEnabled() {
            return this.genResults;
        }

        public boolean isKeywordSummaryEnabled() {
            return this.genKws;
        }

        public boolean isIndexHtmlEnabled() {
            return this.indexHtml;
        }

        public boolean isReportHtmlEnabled() {
            return this.reportHtml;
        }

        public boolean isStateFileEnabled(int n) {
            if (n >= this.stateFiles.length) {
                return false;
            }
            return this.stateFiles[n];
        }

        public boolean isBackupsEnabled() {
            return this.doBackups;
        }

        public int getBackupLevel() {
            return this.backups;
        }

        public File[] getInitialFiles() {
            if (this.initFiles == null) {
                String[] stringArray = this.ip.getTests();
                if (stringArray == null) {
                    stringArray = null;
                } else {
                    this.initFiles = new File[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.initFiles[i] = new File(stringArray[i]);
                    }
                }
            }
            return this.initFiles;
        }

        public TestFilter getTestFilter() {
            return this.filter;
        }

        private static boolean parseBoolean(String string) {
            if (string == null) {
                return false;
            }
            return string.equalsIgnoreCase("true");
        }
    }
}

