/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.CompositeFilter;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.report.Report;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.CommandManager;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.ListIterator;

public class ReportManager
extends CommandManager {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$report$ReportManager == null ? (class$com$sun$javatest$report$ReportManager = ReportManager.class$("com.sun.javatest.report.ReportManager")) : class$com$sun$javatest$report$ReportManager);
    static /* synthetic */ Class class$com$sun$javatest$report$ReportManager;

    public HelpTree.Node getHelp() {
        HelpTree.Node[] nodeArray = new HelpTree.Node[]{this.getCommandHelp(ReportCommand.getName()), this.getCommandHelp(WriteReportCommand.getName())};
        return new HelpTree.Node(i18n, "rm.help", nodeArray);
    }

    private HelpTree.Node getCommandHelp(String string) {
        return new HelpTree.Node(i18n, "rm.help." + string);
    }

    public boolean parseCommand(String string, ListIterator listIterator, CommandContext commandContext) throws Command.Fault {
        if (CommandManager.isMatch(string, ReportCommand.getName())) {
            commandContext.addCommand(new ReportCommand(listIterator));
            return true;
        }
        if (CommandManager.isMatch(string, WriteReportCommand.getName())) {
            commandContext.addCommand(new WriteReportCommand(listIterator));
            return true;
        }
        return false;
    }

    public static void writeReport(File file, CommandContext commandContext) throws Command.Fault {
        WriteReportCommand writeReportCommand = new WriteReportCommand(file);
        ((Command)writeReportCommand).run(commandContext);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class WriteReportCommand
    extends Command {
        private File path;
        private boolean createFlag;

        static String getName() {
            return "writeReport";
        }

        WriteReportCommand(Iterator iterator) throws Command.Fault {
            super(WriteReportCommand.getName());
            while (iterator.hasNext()) {
                String string = this.nextArg(iterator);
                if (string.equals("-create")) {
                    this.createFlag = true;
                    continue;
                }
                if (string.startsWith("-")) {
                    throw new Command.Fault((Command)this, i18n, "rm.writeReport.badArg", string);
                }
                this.path = new File(string);
                return;
            }
            throw new Command.Fault(this, i18n, "rm.writeReport.missingArg");
        }

        WriteReportCommand(File file) {
            super(file.getPath());
            this.path = file;
        }

        public boolean isActionCommand() {
            return true;
        }

        public void run(CommandContext commandContext) throws Command.Fault {
            if (this.path.exists()) {
                if (!this.path.isDirectory()) {
                    throw new Command.Fault((Command)this, i18n, "rm.writeReport.notADir", this.path);
                }
            } else {
                if (this.createFlag) {
                    this.path.mkdirs();
                } else {
                    this.path.mkdir();
                }
                if (!this.path.exists()) {
                    throw new Command.Fault((Command)this, i18n, "rm.writeReport.cantCreate", this.path);
                }
            }
            InterviewParameters interviewParameters = this.getConfig(commandContext);
            try {
                File file;
                Report report = new Report(interviewParameters, this.path, new CompositeFilter(interviewParameters.getFilters()));
                report.writeReport();
                try {
                    file = this.path.getCanonicalFile();
                }
                catch (IOException iOException) {
                    file = this.path;
                }
                commandContext.printMessage(i18n, "rm.writeReport.done", file);
            }
            catch (IOException iOException) {
                commandContext.printMessage(i18n, "rm.writeReport.error", new Object[]{this.path, iOException});
            }
        }
    }

    static class ReportCommand
    extends Command {
        private File path;

        static String getName() {
            return "report";
        }

        ReportCommand(ListIterator listIterator) throws Command.Fault {
            super(ReportCommand.getName());
            if (!listIterator.hasNext()) {
                throw new Command.Fault(this, i18n, "rm.report.missingArg");
            }
            this.path = new File(this.nextArg(listIterator));
        }

        public void run(CommandContext commandContext) throws Command.Fault {
            commandContext.setAutoRunReportDir(this.path);
        }
    }
}

