/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.JavaTestError;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.report.HTMLReport;
import com.sun.javatest.report.HTMLSection;
import com.sun.javatest.report.Report;
import com.sun.javatest.report.ReportWriter;
import com.sun.javatest.util.StringArray;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

class StatisticsSection
extends HTMLSection {
    private TestResultTable resultTable;
    private File[] initFiles;
    private Map keywordTable = new HashMap();
    private int[] statusTotals = new int[4];
    private final String[] headings = new String[]{HTMLSection.i18n.getString("stats.heading.passed"), HTMLSection.i18n.getString("stats.heading.failed"), HTMLSection.i18n.getString("stats.heading.error"), HTMLSection.i18n.getString("stats.heading.notRun")};

    StatisticsSection(HTMLReport hTMLReport, Report.Settings settings, File file) {
        super(HTMLSection.i18n.getString("stats.title"), settings, file, hTMLReport);
        this.initFiles = this.settings.getInitialFiles();
        this.resultTable = this.settings.ip.getWorkDirectory().getTestResultTable();
        TestResultTable.TreeIterator treeIterator = null;
        try {
            treeIterator = this.initFiles == null ? this.resultTable.getIterator(new TestFilter[]{this.settings.filter}) : this.resultTable.getIterator(this.initFiles, new TestFilter[]{this.settings.filter});
        }
        catch (TestResultTable.Fault fault) {
            throw new JavaTestError(HTMLSection.i18n.getString("stats.testResult.err"));
        }
        while (treeIterator.hasNext()) {
            TestResult testResult = (TestResult)treeIterator.next();
            try {
                Status status = testResult.getStatus();
                TestDescription testDescription = testResult.getDescription();
                Object[] objectArray = testDescription.getKeywords();
                Arrays.sort(objectArray);
                String string = StringArray.join((String[])objectArray);
                int[] nArray = (int[])this.keywordTable.get(string);
                if (nArray == null) {
                    nArray = new int[4];
                    this.keywordTable.put(string, nArray);
                }
                int n = status.getType();
                nArray[n] = nArray[n] + 1;
                int n2 = status.getType();
                this.statusTotals[n2] = this.statusTotals[n2] + 1;
            }
            catch (TestResult.Fault fault) {}
        }
    }

    void writeContents(ReportWriter reportWriter) throws IOException {
        super.writeContents(reportWriter);
        reportWriter.startTag("ul");
        reportWriter.startTag("li");
        reportWriter.writeLink("#" + HTMLReport.anchors[3], HTMLSection.i18n.getString("stats.keywordValue"));
        reportWriter.endTag("ul");
        reportWriter.newLine();
    }

    void writeSummary(ReportWriter reportWriter) throws IOException {
        super.writeSummary(reportWriter);
        this.writeKeywordSummary(reportWriter);
    }

    private void writeKeywordSummary(ReportWriter reportWriter) throws IOException {
        int n = 2;
        for (int i = 0; i < this.statusTotals.length; ++i) {
            if (this.statusTotals[i] <= 0) continue;
            ++n;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        stringArray[n2++] = HTMLSection.i18n.getString("stats.keyword");
        for (int i = 0; i < this.statusTotals.length; ++i) {
            if (this.statusTotals[i] <= 0) continue;
            stringArray[n2++] = this.headings[i];
        }
        stringArray[n2] = HTMLSection.i18n.getString("stats.total");
        Vector<Object[]> vector = new Vector<Object[]>();
        Object[] objectArray = this.keywordTable.entrySet().iterator();
        block2: while (objectArray.hasNext()) {
            int n3;
            Map.Entry entry = objectArray.next();
            String string = (String)entry.getKey();
            int[] nArray = (int[])entry.getValue();
            String[] stringArray2 = new String[n];
            int n4 = 0;
            int n5 = 0;
            stringArray2[n4++] = string;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (this.statusTotals[n3] != 0) {
                    stringArray2[n4++] = nArray[n3] == 0 ? "" : Integer.toString(nArray[n3]);
                }
                n5 += nArray[n3];
            }
            stringArray2[n4] = Integer.toString(n5);
            for (n3 = 0; n3 < vector.size(); ++n3) {
                String[] stringArray3 = (String[])vector.elementAt(n3);
                if (string.compareTo(stringArray3[0]) >= 0) continue;
                vector.insertElementAt(stringArray2, n3);
                continue block2;
            }
            vector.addElement(stringArray2);
        }
        objectArray = new String[n];
        int n6 = 0;
        int n7 = 0;
        objectArray[n6++] = HTMLSection.i18n.getString("stats.total");
        for (int i = 0; i < this.statusTotals.length; ++i) {
            if (this.statusTotals[i] != 0) {
                objectArray[n6++] = Integer.toString(this.statusTotals[i]);
            }
            n7 += this.statusTotals[i];
        }
        objectArray[n6] = Integer.toString(n7);
        vector.addElement(objectArray);
        objectArray = new String[vector.size()][];
        vector.copyInto(objectArray);
        reportWriter.startTag("h3");
        reportWriter.writeLinkDestination(HTMLReport.anchors[3], HTMLSection.i18n.getString("stats.keywordValue"));
        reportWriter.endTag("h3");
        reportWriter.newLine();
        reportWriter.startTag("table");
        reportWriter.writeAttr("border", 1);
        reportWriter.startTag("tr");
        for (n6 = 0; n6 < stringArray.length; ++n6) {
            reportWriter.startTag("th");
            reportWriter.writeAttr("align", n6 == 0 ? "left" : "right");
            reportWriter.write(stringArray[n6]);
            reportWriter.endTag("th");
        }
        reportWriter.endTag("tr");
        for (n6 = 0; n6 < objectArray.length; ++n6) {
            reportWriter.startTag("tr");
            for (n7 = 0; n7 < ((Object)objectArray[n6]).length; ++n7) {
                reportWriter.startTag("td");
                reportWriter.writeAttr("align", n7 == 0 ? "left" : "right");
                reportWriter.write((String)objectArray[n6][n7]);
                reportWriter.endTag("td");
            }
            reportWriter.endTag("tr");
        }
        reportWriter.endTag("table");
    }
}

