/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.FileOpener;
import com.sun.javatest.tool.FocusMonitor;
import com.sun.javatest.tool.HelpMenu;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolManager;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.ExitCount;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.PrefixMap;
import com.sun.javatest.util.StringArray;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.help.HelpBroker;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

abstract class DeskView {
    private static final int MENU_INSERT_POINT = 3;
    private static Collection allFrames = new Vector();
    private static int frameIndex;
    private Desktop desktop;
    protected final UIFactory uif;
    private static FocusMonitor focusMonitor;
    static final String CLOSE = "close";
    private static final String EXIT = "exit";
    private static final String PREFS = "prefs";
    private static final String HISTORY = "history";
    private static final String SEPARATOR;
    private static final I18NResourceBundle i18n;
    static /* synthetic */ Class class$javax$swing$event$MenuListener;
    static /* synthetic */ Class class$com$sun$javatest$tool$DeskView;
    static /* synthetic */ Class class$javax$swing$JFrame;

    protected DeskView(Desktop desktop) {
        this.desktop = desktop;
        this.uif = new UIFactory(this.getClass(), desktop.getHelpBroker());
    }

    public Desktop getDesktop() {
        return this.desktop;
    }

    public void dispose() {
        Tool[] toolArray = this.getTools();
        for (int i = 0; i < toolArray.length; ++i) {
            toolArray[i].dispose();
        }
    }

    public abstract boolean isVisible();

    public abstract void setVisible(boolean var1);

    public abstract boolean isEmpty();

    public abstract Tool[] getTools();

    public abstract void addTool(Tool var1);

    public abstract void removeTool(Tool var1);

    public abstract Tool getSelectedTool();

    public abstract void setSelectedTool(Tool var1);

    public abstract int getStyle();

    public abstract JFrame[] getFrames();

    public Component getDialogParent() {
        JFrame[] jFrameArray = this.getFrames();
        if (jFrameArray == null || jFrameArray.length == 0) {
            return null;
        }
        return jFrameArray[0].getContentPane();
    }

    public abstract Rectangle getBounds();

    public static Rectangle getDefaultBounds() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle rectangle = graphicsEnvironment.getMaximumWindowBounds();
        int n = Math.min(rectangle.width, Math.max(640, rectangle.width * 3 / 4));
        int n2 = Math.min(rectangle.height, Math.max(480, rectangle.height * 3 / 4));
        int n3 = graphicsEnvironment.getCenterPoint().x - n / 2;
        int n4 = graphicsEnvironment.getCenterPoint().y - n2 / 2;
        return new Rectangle(n3, n4, n, n2);
    }

    protected JFrame createFrame(MenuListener menuListener, String string) {
        return this.createFrame(menuListener, null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JFrame createFrame(MenuListener menuListener, Action action, String string) {
        JFrame jFrame = new JFrame();
        jFrame.setName(string + ":" + frameIndex++);
        jFrame.setTitle(this.uif.getI18NString("dt.title.txt"));
        jFrame.setIconImage(this.uif.createImage("images/jticon.gif"));
        this.uif.setAccessibleInfo(jFrame, string);
        JRootPane jRootPane = jFrame.getRootPane();
        jRootPane.setName("root");
        this.uif.setAccessibleInfo(jRootPane, string);
        JMenuBar jMenuBar = this.uif.createMenuBar("dt.menuBar");
        JMenu jMenu = this.uif.createMenu("dt.file");
        jMenu.addMenuListener(new FileMenuListener(action));
        jMenuBar.add(jMenu);
        JMenu jMenu2 = this.uif.createMenu("dt.windows");
        jMenu2.addMenuListener(menuListener);
        jMenuBar.add(jMenu2);
        jMenuBar.add(this.uif.createHorizontalGlue("dt.pad"));
        HelpMenu helpMenu = new HelpMenu(jFrame, this.desktop, this.uif);
        jMenuBar.add(helpMenu);
        jFrame.setJMenuBar(jMenuBar);
        HelpBroker helpBroker = this.desktop.getHelpBroker();
        if (helpBroker != null) {
            helpBroker.enableHelpKey(jFrame.getRootPane(), "jthelp.csh", null);
            Desktop.addHelpDebugListener(jFrame);
        }
        Desktop.addPreferredSizeDebugListener(jFrame);
        if (focusMonitor != null) {
            focusMonitor.monitor(jFrame);
        }
        jFrame.setDefaultCloseOperation(0);
        jFrame.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void windowClosed(WindowEvent windowEvent) {
                JFrame jFrame = (JFrame)windowEvent.getSource();
                Collection collection = allFrames;
                synchronized (collection) {
                    if (allFrames.remove(jFrame) && allFrames.isEmpty()) {
                        EventQueue.invokeLater(new Runnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ExitCount.dec();
                            }
                        });
                    }
                }
            }
        });
        Collection collection = allFrames;
        synchronized (collection) {
            allFrames.add(jFrame);
            if (allFrames.size() == 1) {
                ExitCount.inc();
            }
        }
        return jFrame;
    }

    protected void addToolMenuItemsToFrameMenuBar(JFrame jFrame, Tool tool) {
        JMenuBar jMenuBar;
        JMenuBar jMenuBar2 = jFrame.getJMenuBar();
        Tool tool2 = (Tool)jMenuBar2.getClientProperty(this.getClass());
        if (tool == tool2) {
            return;
        }
        if (tool2 != null) {
            this.removeToolMenuItemsFromFrameMenuBar(jFrame, tool2);
        }
        if ((jMenuBar = tool.getMenuBar()) == null) {
            return;
        }
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            JMenu jMenu = jMenuBar.getMenu(i);
            if (jMenu == null) continue;
            int n = jMenu.getMenuComponentCount();
            JMenu jMenu2 = this.findMenu(jMenuBar2, jMenu.getText());
            if (jMenu2 == null) {
                jMenu2 = new JMenu(jMenu.getText());
                jMenu2.setName(jMenu.getName());
                jMenu2.setMnemonic(jMenu.getMnemonic());
                AccessibleContext accessibleContext = jMenu2.getAccessibleContext();
                AccessibleContext accessibleContext2 = jMenu.getAccessibleContext();
                accessibleContext.setAccessibleName(accessibleContext2.getAccessibleName());
                accessibleContext.setAccessibleDescription(accessibleContext2.getAccessibleDescription());
                this.copyMenuListeners(jMenu, jMenu2);
                for (int j = 0; j < n; ++j) {
                    jMenu2.add(jMenu.getMenuComponent(0));
                }
                jMenuBar2.add((Component)jMenu2, jMenuBar2.getMenuCount() - 3);
            } else {
                for (int j = 0; j < n; ++j) {
                    jMenu2.add(jMenu.getMenuComponent(0), j);
                }
                jMenu2.insertSeparator(n);
            }
            jMenu2.putClientProperty(this.getClass(), new Integer(n));
        }
        jMenuBar2.putClientProperty(this.getClass(), tool);
    }

    private void removeToolMenuItemsFromFrameMenuBar(JFrame jFrame) {
        JMenuBar jMenuBar = jFrame.getJMenuBar();
        Tool tool = (Tool)jMenuBar.getClientProperty(this.getClass());
        if (tool == null) {
            return;
        }
        this.removeToolMenuItemsFromFrameMenuBar(jFrame, tool);
    }

    protected void removeToolMenuItemsFromFrameMenuBar(JFrame jFrame, Tool tool) {
        JMenuBar jMenuBar = jFrame.getJMenuBar();
        JMenuBar jMenuBar2 = tool.getMenuBar();
        for (int i = 0; i < jMenuBar2.getMenuCount(); ++i) {
            JMenu jMenu = jMenuBar2.getMenu(i);
            if (jMenu == null) continue;
            JMenu jMenu2 = this.findMenu(jMenuBar, jMenu.getText());
            int n = (Integer)jMenu2.getClientProperty(this.getClass());
            for (int j = 0; j < n; ++j) {
                jMenu.add(jMenu2.getMenuComponent(0));
            }
            if (jMenu2.getItemCount() == 0) {
                jMenuBar.remove(jMenu2);
                continue;
            }
            jMenu2.remove(0);
            jMenu2.putClientProperty(this.getClass(), null);
        }
        jMenuBar.putClientProperty(this.getClass(), null);
    }

    protected JMenu getWindowOpenMenu() {
        JMenu jMenu = this.uif.createMenu("dt.windows.open");
        ToolManager[] toolManagerArray = this.desktop.getToolManagers();
        for (int i = 0; i < toolManagerArray.length; ++i) {
            Action[] actionArray = toolManagerArray[i].getWindowOpenMenuActions();
            if (actionArray == null) continue;
            for (int j = 0; j < actionArray.length; ++j) {
                jMenu.add(actionArray[j]);
            }
        }
        return jMenu;
    }

    private void copyMenuListeners(JMenu jMenu, JMenu jMenu2) {
        MenuListener[] menuListenerArray = (MenuListener[])jMenu.getListeners(class$javax$swing$event$MenuListener == null ? (class$javax$swing$event$MenuListener = DeskView.class$("javax.swing.event.MenuListener")) : class$javax$swing$event$MenuListener);
        for (int i = 0; i < menuListenerArray.length; ++i) {
            jMenu2.addMenuListener(menuListenerArray[i]);
        }
    }

    private JMenu findMenu(JMenuBar jMenuBar, String string) {
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            JMenu jMenu = jMenuBar.getMenu(i);
            if (jMenu == null || !jMenu.getText().equals(string)) continue;
            return jMenu;
        }
        return null;
    }

    public abstract Container createDialog(Tool var1, String var2, String var3, JMenuBar var4, Container var5, Rectangle var6);

    public abstract boolean isToolOwnerForDialog(Tool var1, Container var2);

    private void doPrefs(JFrame jFrame) {
        this.desktop.showPreferences(jFrame);
    }

    protected abstract void saveDesktop(Map var1);

    protected void saveTools(Map map) {
        Tool[] toolArray = this.getTools();
        map.put("tool.count", String.valueOf(toolArray.length));
        for (int i = 0; i < toolArray.length; ++i) {
            this.saveTool(new PrefixMap(map, "tool." + String.valueOf(i)), toolArray[i]);
        }
    }

    protected void saveTool(Map map, Tool tool) {
        map.put("mgr", tool.getManager().getClass().getName());
        map.put("class", tool.getClass().getName());
        map.put("selected", String.valueOf(tool == this.getSelectedTool()));
        tool.save(map);
    }

    protected abstract void restoreDesktop(Map var1);

    protected void restoreTools(Map map) {
        try {
            String string = (String)map.get("tool.count");
            if (string != null) {
                int n = Integer.parseInt(string);
                for (int i = 0; i < n; ++i) {
                    Object object;
                    try {
                        String string2 = "tool." + i;
                        object = new PrefixMap(map, string2);
                        this.restoreTool((Map)object, string2);
                        continue;
                    }
                    catch (ToolManager.Fault fault) {
                        this.uif.showError("dv.restore.cantRestoreTool", new Object[]{new Integer(i), fault.getMessage()});
                        continue;
                    }
                    catch (Fault fault) {
                        this.uif.showError("dv.restore.cantRestoreTool", new Object[]{new Integer(i), fault.getMessage()});
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.uif.showError("dv.restore.cantRestoreTool", new Object[]{new Integer(i), throwable.toString()});
                        object = this.uif.getI18NResourceBundle();
                        this.desktop.log((I18NResourceBundle)object, "dv.restore.cantRestoreTool", new Object[]{throwable, new Integer(i)});
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected Tool restoreTool(Map map, String string) throws Fault, ToolManager.Fault {
        Object object;
        Object object2;
        Object object3 = (String)map.get("mgr");
        if (object3 == null) {
            object2 = (String)map.get("class");
            if (object2 != null || ((String)object2).endsWith("Tool")) {
                object = ((String)object2).substring(0, ((String)object2).length()) + "Manager";
                try {
                    if (Class.forName((String)object) != null) {
                        object3 = object;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (object3 == null) {
                throw new Fault(i18n, "dv.restore.noMgrClass", string);
            }
        }
        if ((object2 = this.desktop.getToolManager((String)object3)) == null) {
            throw new Fault(i18n, "dv.restore.noMgr", new Object[]{string, object3});
        }
        object = ((ToolManager)object2).restoreTool(map);
        this.addTool((Tool)object);
        boolean bl = "true".equals(map.get("selected"));
        if (bl) {
            this.setSelectedTool((Tool)object);
        }
        return object;
    }

    protected static void saveBounds(Component component, Map map) {
        Rectangle rectangle = component.getBounds();
        map.put("x", String.valueOf(rectangle.x));
        map.put("y", String.valueOf(rectangle.y));
        map.put("w", String.valueOf(rectangle.width));
        map.put("h", String.valueOf(rectangle.height));
    }

    protected static void restoreBounds(Component component, Map map) {
        try {
            String string = (String)map.get("x");
            String string2 = (String)map.get("y");
            String string3 = (String)map.get("w");
            String string4 = (String)map.get("h");
            if (string != null && string2 != null && string3 != null && string4 != null) {
                component.setBounds(Integer.parseInt(string), Integer.parseInt(string2), Integer.parseInt(string3), Integer.parseInt(string4));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = System.getProperty("javatest.focus.monitor");
        if (string != null) {
            focusMonitor = FocusMonitor.access();
            if (!string.equals("true")) {
                focusMonitor.setOptions(StringArray.split(string));
            }
            focusMonitor.setActivateKey("alt 2");
            focusMonitor.setReportKey("shift alt 2");
            focusMonitor.setReportFile(System.getProperty("javatest.focus.monitor.log"));
        }
        SEPARATOR = null;
        i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$tool$DeskView == null ? (class$com$sun$javatest$tool$DeskView = DeskView.class$("com.sun.javatest.tool.DeskView")) : class$com$sun$javatest$tool$DeskView);
    }

    private class FileMenuListener
    implements MenuListener,
    ActionListener {
        private JMenu fileOpenMenu;
        private JMenuItem prefs;
        private JMenuItem close;
        private JMenuItem exit;

        FileMenuListener(Action action) {
            this.prefs = DeskView.this.uif.createMenuItem("dt.file", DeskView.PREFS, this);
            if (action != null) {
                this.close = DeskView.this.uif.createMenuItem(action);
            }
            this.exit = DeskView.this.uif.createMenuItem("dt.file", DeskView.EXIT, this);
        }

        public void menuSelected(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            jMenu.removeAll();
            ToolManager[] toolManagerArray = DeskView.this.desktop.getToolManagers();
            for (int i = 0; i < toolManagerArray.length; ++i) {
                Action[] actionArray = toolManagerArray[i].getFileMenuActions();
                if (actionArray == null) continue;
                for (int j = 0; j < actionArray.length; ++j) {
                    jMenu.add(new JMenuItem(actionArray[j]));
                }
                jMenu.addSeparator();
            }
            jMenu.add(this.prefs);
            jMenu.addSeparator();
            List list = DeskView.this.desktop.getFileHistory();
            if (!list.isEmpty()) {
                int n = 0;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Desktop.FileHistoryEntry fileHistoryEntry = (Desktop.FileHistoryEntry)iterator.next();
                    if (!fileHistoryEntry.file.exists()) continue;
                    String string = DeskView.this.uif.getI18NString("dt.file.historyX.mit", new Object[]{new Integer(n), fileHistoryEntry.file.getPath()});
                    JMenuItem jMenuItem = new JMenuItem(string);
                    jMenuItem.setActionCommand(DeskView.HISTORY);
                    jMenuItem.addActionListener(this);
                    jMenuItem.putClientProperty(this, fileHistoryEntry);
                    if (n < 10) {
                        jMenuItem.setMnemonic(Character.forDigit(n, 10));
                    }
                    ++n;
                    jMenu.add(jMenuItem);
                }
                jMenu.addSeparator();
            }
            if (this.close != null) {
                jMenu.add(this.close);
            }
            jMenu.add(this.exit);
        }

        public void menuDeselected(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            jMenu.removeAll();
        }

        public void menuCanceled(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            jMenu.removeAll();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            Component component;
            JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = DeskView.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, component = (Component)actionEvent.getSource());
            if (jFrame == null) {
                jFrame = DeskView.this.getFrames()[0];
            }
            if ((string = actionEvent.getActionCommand()).equals(DeskView.PREFS)) {
                DeskView.this.doPrefs(jFrame);
            } else if (string.equals(DeskView.HISTORY)) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                Desktop.FileHistoryEntry fileHistoryEntry = (Desktop.FileHistoryEntry)jMenuItem.getClientProperty(this);
                try {
                    fileHistoryEntry.fileOpener.open(fileHistoryEntry.file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    DeskView.this.uif.showError("dt.file.cannotFind", fileHistoryEntry.file);
                }
                catch (FileOpener.Fault fault) {
                    DeskView.this.uif.showError("dt.file.cannotOpen", new Object[]{fileHistoryEntry.file, fault.getMessage()});
                }
            } else if (string.equals(DeskView.EXIT)) {
                DeskView.this.desktop.checkToolsAndExitIfOK(jFrame);
            }
        }
    }

    static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18NResourceBundle, String string) {
            super(i18NResourceBundle.getString(string));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle.getString(string, object));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
            super(i18NResourceBundle.getString(string, objectArray));
        }
    }
}

