/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.Harness;
import com.sun.javatest.ProductInfo;
import com.sun.javatest.TestSuite;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

class HelpMenu
extends JMenu {
    private Component parent;
    private Desktop desktop;
    private UIFactory uif;
    private Listener listener;
    private static WeakHashMap docTable = new WeakHashMap();
    private static WeakHashMap helpBrokerTable = new WeakHashMap();
    private static final String HELP = "help";
    private static final String ABOUT_JAVA = "aboutJava";
    private static final String ABOUT_JAVATEST = "aboutJavaTest";

    HelpMenu(Component component, Desktop desktop, UIFactory uIFactory) {
        this.parent = component;
        this.desktop = desktop;
        this.uif = uIFactory;
        this.listener = new Listener();
        String[] stringArray = new String[]{HELP, null, ABOUT_JAVATEST, ABOUT_JAVA};
        uIFactory.initMenu(this, "hm", stringArray, this.listener);
        this.addMenuListener(this.listener);
    }

    private void addTestSuiteItems() {
        int n;
        Tool[] toolArray = this.desktop.getTools();
        if (toolArray == null || toolArray.length == 0) {
            return;
        }
        TreeSet<TestSuite> treeSet = new TreeSet<TestSuite>(new Comparator(){

            public int compare(Object object, Object object2) {
                TestSuite testSuite = (TestSuite)object;
                TestSuite testSuite2 = (TestSuite)object2;
                return testSuite.getName().compareTo(testSuite2.getName());
            }
        });
        Tool tool = this.desktop.getSelectedTool();
        if (tool != null) {
            TestSuite[] testSuiteArray = tool.getLoadedTestSuites();
            if (testSuiteArray != null) {
                treeSet.addAll(Arrays.asList(testSuiteArray));
            }
        } else {
            for (int i = 0; i < toolArray.length; ++i) {
                TestSuite[] testSuiteArray = toolArray[i].getLoadedTestSuites();
                if (testSuiteArray == null) continue;
                treeSet.addAll(Arrays.asList(testSuiteArray));
            }
        }
        for (n = this.getItemCount() - 1; n > 0 && this.getItem(n - 1) != null; --n) {
        }
        int n2 = 0;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            TestSuite testSuite = (TestSuite)iterator.next();
            JMenuItem[] jMenuItemArray = this.getMenuItems(testSuite, n2);
            if (jMenuItemArray == null || jMenuItemArray.length <= 0) continue;
            for (int i = 0; i < jMenuItemArray.length; ++i) {
                JMenuItem jMenuItem = jMenuItemArray[i];
                jMenuItem.putClientProperty(this.getClass(), this);
                this.insert(jMenuItem, n++);
            }
            this.insertSeparator(n++);
            n2 += jMenuItemArray.length;
        }
    }

    private void removeTestSuiteItems() {
        JMenuItem jMenuItem;
        int n;
        block3: {
            for (n = 0; n < this.getItemCount(); ++n) {
                jMenuItem = this.getItem(n);
                if (jMenuItem == null || jMenuItem.getClientProperty(this.getClass()) != this) {
                    continue;
                }
                break block3;
            }
            return;
        }
        while (n < this.getItemCount() && ((jMenuItem = this.getItem(n)) == null || jMenuItem.getClientProperty(this.getClass()) == this)) {
            this.remove(n);
        }
    }

    private void showAbout(String string, String string2, String string3, String string4) {
        JComponent jComponent;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = 0;
        while ((n2 = string2.indexOf(10, n)) != -1) {
            vector.addElement(string2.substring(n, n2));
            n = n2 + 1;
        }
        vector.addElement(string2.substring(n));
        JTextField[] jTextFieldArray = new JTextField[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            jComponent = new JTextField((String)vector.elementAt(i));
            jComponent.setBorder(null);
            jComponent.setHorizontalAlignment(0);
            jComponent.setOpaque(false);
            jComponent.setEditable(false);
            this.uif.setAccessibleInfo(jComponent, string4);
            jTextFieldArray[i] = jComponent;
        }
        JOptionPane jOptionPane = new JOptionPane(jTextFieldArray, 1);
        jOptionPane.setIcon(this.desktop.getLogo());
        jOptionPane.setOptionType(0);
        this.uif.setAccessibleInfo(jOptionPane, string3);
        jComponent = this.uif.createCloseButton("hm.about.ok", false);
        jOptionPane.setOptions(new Object[]{jComponent});
        JDialog jDialog = jOptionPane.createDialog(this.parent, string);
        jDialog.getRootPane().setDefaultButton((JButton)jComponent);
        jDialog.setVisible(true);
    }

    private void showHelpSet(HelpSet helpSet) {
        HelpBroker helpBroker = this.getHelpBroker(helpSet);
        helpBroker.setDisplayed(true);
        if (helpBroker instanceof DefaultHelpBroker) {
            ((DefaultHelpBroker)helpBroker).getWindowPresentation().getHelpWindow().toFront();
        }
    }

    private HelpBroker getHelpBroker(HelpSet helpSet) {
        HelpBroker helpBroker = (HelpBroker)helpBrokerTable.get(helpSet);
        if (helpBroker == null) {
            int n = this.uif.getDotsPerInch();
            helpBroker = new DefaultHelpBroker(helpSet);
            helpBroker.setSize(new Dimension(7 * n, 9 * n));
            helpBrokerTable.put(helpSet, helpBroker);
        }
        return helpBroker;
    }

    private JMenuItem[] getMenuItems(TestSuite testSuite, int n) {
        HelpSet[] helpSetArray = (HelpSet[])docTable.get(testSuite);
        if (helpSetArray == null) {
            try {
                helpSetArray = testSuite.getAdditionalDocs();
            }
            catch (TestSuite.Fault fault) {
                String string = this.uif.getI18NString("hm.cantLoadDocs", new Object[]{testSuite.getName(), fault.getMessage()});
                System.err.println(string);
            }
            if (helpSetArray == null) {
                helpSetArray = new HelpSet[]{};
            }
            docTable.put(testSuite, helpSetArray);
        }
        if (helpSetArray.length == 0) {
            return null;
        }
        Vector<JMenuItem> vector = new Vector<JMenuItem>();
        for (int i = 0; i < helpSetArray.length; ++i) {
            JMenuItem jMenuItem;
            final HelpSet helpSet = helpSetArray[i];
            if (n + i < 10) {
                jMenuItem = new JMenuItem(n + i + " " + helpSet.getTitle());
                jMenuItem.setMnemonic(48 + n + i);
            } else {
                jMenuItem = new JMenuItem("  " + helpSet.getTitle());
            }
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HelpMenu.this.showHelpSet(helpSet);
                }
            });
            vector.add(jMenuItem);
        }
        Object[] objectArray = new JMenuItem[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private class Listener
    implements MenuListener,
    ActionListener {
        private Listener() {
        }

        public void menuSelected(MenuEvent menuEvent) {
            HelpMenu.this.removeTestSuiteItems();
            HelpMenu.this.addTestSuiteItems();
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(HelpMenu.ABOUT_JAVATEST)) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                DateFormat dateFormat = DateFormat.getDateInstance(1);
                String string2 = null;
                Date date = ProductInfo.getBuildDate();
                string2 = date != null ? dateFormat.format(date) : HelpMenu.this.uif.getI18NString("hm.aboutBadDate");
                String string3 = HelpMenu.this.uif.getI18NString("hm.aboutJavaTest", new Object[]{ProductInfo.getName(), ProductInfo.getVersion(), ProductInfo.getMilestone(), ProductInfo.getBuildNumber(), Harness.getClassDir().getPath(), ProductInfo.getBuildJavaVersion(), string2});
                HelpMenu.this.showAbout(jMenuItem.getText(), string3, "hm.aboutJavaTest", "hm.aboutJavaTest.text");
            } else if (string.equals(HelpMenu.ABOUT_JAVA)) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                String string4 = HelpMenu.this.uif.getI18NString("hm.aboutJava", new Object[]{System.getProperty("java.version"), System.getProperty("java.vendor"), System.getProperty("java.home"), System.getProperty("java.vendor.url")});
                HelpMenu.this.showAbout(jMenuItem.getText(), string4, "hm.aboutJava", "hm.aboutJava.text");
            } else if (string.equals(HelpMenu.HELP)) {
                HelpBroker helpBroker = HelpMenu.this.desktop.getHelpBroker();
                helpBroker.setCurrentID("jthelp.csh");
                helpBroker.setDisplayed(true);
                if (helpBroker instanceof DefaultHelpBroker) {
                    ((DefaultHelpBroker)helpBroker).getWindowPresentation().getHelpWindow().toFront();
                }
            }
        }
    }
}

