/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.DeskView;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.ToolManager;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.PrefixMap;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.basic.BasicInternalFrameUI;

class MDIDeskView
extends DeskView {
    private JFrame mainFrame;
    private HashMap internalFrames = new HashMap(17);
    private JDesktopPane desktopPane;
    private Listener listener = new Listener();
    private static final String TILE = "tile";
    private static final String CASCADE = "cascade";
    private static final boolean useInternalDialogs = true;

    MDIDeskView(Desktop desktop) {
        this(desktop, MDIDeskView.getDefaultBounds());
    }

    MDIDeskView(DeskView deskView) {
        this(deskView.getDesktop(), deskView.getBounds());
        Tool[] toolArray = deskView.getTools();
        for (int i = 0; i < toolArray.length; ++i) {
            this.addTool(toolArray[i]);
        }
        this.setVisible(deskView.isVisible());
    }

    private MDIDeskView(Desktop desktop, Rectangle rectangle) {
        super(desktop);
        this.initMainFrame(rectangle);
        this.uif.setDialogParent(this.mainFrame);
        JDialog.setDefaultLookAndFeelDecorated(true);
    }

    public void dispose() {
        this.mainFrame.setVisible(false);
        this.mainFrame.dispose();
        super.dispose();
    }

    public boolean isVisible() {
        return this.mainFrame.isVisible();
    }

    public void setVisible(boolean bl) {
        Window[] windowArray;
        if (bl == this.mainFrame.isVisible()) {
            return;
        }
        this.mainFrame.setVisible(bl);
        if (bl && (windowArray = this.mainFrame.getOwnedWindows()) != null) {
            for (int i = 0; i < windowArray.length; ++i) {
                windowArray[i].toFront();
            }
        }
    }

    public boolean isEmpty() {
        return this.internalFrames.size() == 0;
    }

    public Tool[] getTools() {
        Tool[] toolArray = new Tool[this.internalFrames.size()];
        return this.internalFrames.keySet().toArray(toolArray);
    }

    public void addTool(Tool tool) {
        DeskView deskView = tool.getDeskView();
        if (deskView == this) {
            return;
        }
        ToolDialog[] toolDialogArray = tool.getToolDialogs();
        boolean[] blArray = new boolean[toolDialogArray.length];
        for (int i = 0; i < toolDialogArray.length; ++i) {
            blArray[i] = toolDialogArray[i].isVisible();
        }
        if (deskView != null) {
            deskView.removeTool(tool);
        }
        JInternalFrame jInternalFrame = new JInternalFrame(tool.getTitle(), true, true, true, true);
        jInternalFrame.setName(tool.getShortTitle());
        jInternalFrame.putClientProperty(this, tool);
        jInternalFrame.setJMenuBar(tool.getMenuBar());
        jInternalFrame.setContentPane(tool);
        jInternalFrame.setDefaultCloseOperation(2);
        jInternalFrame.pack();
        jInternalFrame.addInternalFrameListener(this.listener);
        jInternalFrame.getAccessibleContext().setAccessibleDescription(tool.getToolTipText());
        JRootPane jRootPane = jInternalFrame.getRootPane();
        jRootPane.setName("root");
        AccessibleContext accessibleContext = jInternalFrame.getAccessibleContext();
        AccessibleContext accessibleContext2 = jRootPane.getAccessibleContext();
        accessibleContext2.setAccessibleName(accessibleContext.getAccessibleName());
        accessibleContext2.setAccessibleDescription(accessibleContext.getAccessibleDescription());
        Dimension dimension = this.desktopPane.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            dimension = this.desktopPane.getPreferredSize();
        }
        Dimension dimension2 = jInternalFrame.getSize();
        jInternalFrame.setLocation(Math.max(0, dimension.width / 2 - dimension2.width / 2), Math.max(0, dimension.height / 2 - dimension2.height / 2));
        jInternalFrame.setVisible(true);
        this.internalFrames.put(tool, jInternalFrame);
        this.desktopPane.add(jInternalFrame);
        jInternalFrame.toFront();
        tool.addObserver(this.listener);
        tool.setDeskView(this);
        for (int i = 0; i < toolDialogArray.length; ++i) {
            toolDialogArray[i].initDialog(this, blArray[i]);
        }
    }

    public void removeTool(Tool tool) {
        JInternalFrame jInternalFrame = (JInternalFrame)this.internalFrames.get(tool);
        if (jInternalFrame != null) {
            this.desktopPane.remove(jInternalFrame);
            this.internalFrames.remove(tool);
        }
        tool.removeObserver(this.listener);
        tool.setDeskView(null);
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component component = keyboardFocusManager.getPermanentFocusOwner();
        if (component == null || !component.isShowing()) {
            this.desktopPane.requestFocusInWindow();
        }
    }

    public Tool getSelectedTool() {
        JInternalFrame jInternalFrame = this.desktopPane.getSelectedFrame();
        if (jInternalFrame == null) {
            return null;
        }
        Tool tool = (Tool)jInternalFrame.getClientProperty(this);
        return tool;
    }

    public void setSelectedTool(Tool tool) {
        JInternalFrame jInternalFrame = (JInternalFrame)this.internalFrames.get(tool);
        if (jInternalFrame != null) {
            try {
                jInternalFrame.setIcon(false);
                jInternalFrame.setSelected(true);
                this.desktopPane.moveToFront(jInternalFrame);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getStyle() {
        return 1;
    }

    public JFrame[] getFrames() {
        return new JFrame[]{this.mainFrame};
    }

    public Rectangle getBounds() {
        return this.mainFrame.getBounds();
    }

    public boolean isToolOwnerForDialog(Tool tool, Container container) {
        if (container == null) {
            return false;
        }
        return container.getParent() == this.desktopPane;
    }

    public Container createDialog(Tool tool, String string, String string2, JMenuBar jMenuBar, Container container, Rectangle rectangle) {
        UIFactory uIFactory = tool.uif;
        JInternalFrame jInternalFrame = new JInternalFrame(string2, true, true, false, false);
        jInternalFrame.putClientProperty(this, tool);
        jInternalFrame.setName(string);
        uIFactory.setAccessibleInfo(jInternalFrame, string);
        JRootPane jRootPane = jInternalFrame.getRootPane();
        jRootPane.setName(string + ".root");
        AccessibleContext accessibleContext = jInternalFrame.getAccessibleContext();
        AccessibleContext accessibleContext2 = jRootPane.getAccessibleContext();
        accessibleContext2.setAccessibleName(accessibleContext.getAccessibleName());
        accessibleContext2.setAccessibleDescription(accessibleContext.getAccessibleDescription());
        if (jMenuBar != null) {
            jInternalFrame.setJMenuBar(jMenuBar);
        }
        jInternalFrame.setContentPane(container);
        if (rectangle == null) {
            jInternalFrame.pack();
            jInternalFrame.pack();
            Dimension dimension = jInternalFrame.getSize();
            JInternalFrame jInternalFrame2 = (JInternalFrame)this.internalFrames.get(tool);
            Rectangle rectangle2 = jInternalFrame2.getBounds();
            jInternalFrame.setLocation(Math.max(0, rectangle2.x + (rectangle2.width - dimension.width) / 2), Math.max(0, rectangle2.y + (rectangle2.height - dimension.height) / 2));
        } else {
            jInternalFrame.setBounds(rectangle);
        }
        JLayeredPane.putLayer(jInternalFrame, JLayeredPane.DEFAULT_LAYER + 1);
        this.desktopPane.add(jInternalFrame);
        return jInternalFrame;
    }

    protected void saveDesktop(Map map) {
        MDIDeskView.saveBounds(this.mainFrame, new PrefixMap(map, "dt"));
        this.saveTools(map);
    }

    protected void restoreDesktop(Map map) {
        MDIDeskView.restoreBounds(this.mainFrame, new PrefixMap(map, "dt"));
        this.restoreTools(map);
    }

    protected void saveTool(Map map, Tool tool) {
        super.saveTool(map, tool);
        JInternalFrame jInternalFrame = (JInternalFrame)this.internalFrames.get(tool);
        MDIDeskView.saveBounds(jInternalFrame, new PrefixMap(map, "dt"));
    }

    protected Tool restoreTool(Map map, String string) throws DeskView.Fault, ToolManager.Fault {
        Tool tool = super.restoreTool(map, string);
        JInternalFrame jInternalFrame = (JInternalFrame)this.internalFrames.get(tool);
        MDIDeskView.restoreBounds(jInternalFrame, new PrefixMap(map, "dt"));
        jInternalFrame.setVisible(true);
        return tool;
    }

    private void initMainFrame(Rectangle rectangle) {
        this.mainFrame = this.createFrame(this.listener, "mdi.main");
        this.desktopPane = new JDesktopPane();
        this.desktopPane.setName("mdi.desk");
        this.uif.setAccessibleInfo(this.desktopPane, "mdi.desk");
        this.desktopPane.setPreferredSize(new Dimension(rectangle.width, rectangle.height));
        this.mainFrame.setContentPane(this.desktopPane);
        if (rectangle == null) {
            this.mainFrame.pack();
            Dimension dimension = this.mainFrame.getSize();
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.mainFrame.setLocation(graphicsEnvironment.getCenterPoint().x - dimension.width / 2, graphicsEnvironment.getCenterPoint().y - dimension.height / 2);
        } else {
            this.mainFrame.setBounds(rectangle);
        }
        this.mainFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MDIDeskView.this.getDesktop().checkToolsAndExitIfOK(MDIDeskView.this.mainFrame);
            }
        });
    }

    private void doCascade() {
        Point point = new Point(0, 0);
        JInternalFrame[] jInternalFrameArray = this.getVisibleInternalFrames();
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            JInternalFrame jInternalFrame = jInternalFrameArray[i];
            jInternalFrame.setLocation(point);
            this.desktopPane.moveToFront(jInternalFrame);
            if (i == jInternalFrameArray.length - 1) {
                try {
                    jInternalFrame.setSelected(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            BasicInternalFrameUI basicInternalFrameUI = (BasicInternalFrameUI)jInternalFrame.getUI();
            int n = basicInternalFrameUI.getNorthPane().getHeight();
            point.x += n;
            point.y += n;
        }
    }

    private void doTile() {
        JInternalFrame[] jInternalFrameArray = this.getVisibleInternalFrames();
        int n = jInternalFrameArray.length;
        int n2 = (int)Math.sqrt(n);
        int n3 = (n + n2 - 1) / n2;
        Dimension dimension = this.desktopPane.getSize();
        Dimension dimension2 = new Dimension(dimension.width / n2, dimension.height / n3);
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            JInternalFrame jInternalFrame = jInternalFrameArray[i];
            int n4 = i % n2;
            int n5 = i / n2;
            jInternalFrame.setBounds(n4 * dimension2.width, n5 * dimension2.height, dimension2.width, dimension2.height);
        }
    }

    private JInternalFrame[] getVisibleInternalFrames() {
        Vector<Component> vector = new Vector<Component>();
        for (int i = 0; i < this.desktopPane.getComponentCount(); ++i) {
            Component component = this.desktopPane.getComponent(i);
            if (!(component instanceof JInternalFrame) || !component.isVisible()) continue;
            vector.add(component);
        }
        Object[] objectArray = new JInternalFrame[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private class Listener
    implements ActionListener,
    AncestorListener,
    InternalFrameListener,
    MenuListener,
    Tool.Observer {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(MDIDeskView.CASCADE)) {
                MDIDeskView.this.doCascade();
            } else if (string.equals(MDIDeskView.TILE)) {
                MDIDeskView.this.doTile();
            } else {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                Object object = jMenuItem.getClientProperty(this);
                if (object instanceof Window) {
                    ((Window)object).toFront();
                }
                if (object instanceof JInternalFrame) {
                    ((JInternalFrame)object).toFront();
                } else if (object instanceof Tool) {
                    MDIDeskView.this.setSelectedTool((Tool)object);
                }
            }
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
            Tool[] toolArray = MDIDeskView.this.getTools();
            for (int i = 0; i < toolArray.length; ++i) {
                Tool tool = toolArray[i];
                tool.addObserver(MDIDeskView.this.listener);
            }
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            Tool[] toolArray = MDIDeskView.this.getTools();
            for (int i = 0; i < toolArray.length; ++i) {
                Tool tool = toolArray[i];
                tool.removeObserver(MDIDeskView.this.listener);
            }
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            JInternalFrame jInternalFrame = (JInternalFrame)internalFrameEvent.getSource();
            if (jInternalFrame.getContentPane() instanceof Tool) {
                Tool tool = (Tool)jInternalFrame.getContentPane();
                MDIDeskView.this.removeTool(tool);
                tool.removeObserver(MDIDeskView.this.listener);
                tool.dispose();
                jInternalFrame.getJMenuBar().removeAll();
                jInternalFrame.setContentPane(new Container());
            }
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
            JInternalFrame jInternalFrame = (JInternalFrame)internalFrameEvent.getSource();
            Tool tool = (Tool)jInternalFrame.getContentPane();
            if (MDIDeskView.this.getDesktop().isOKToClose(tool, MDIDeskView.this.mainFrame)) {
                jInternalFrame.dispose();
            }
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        }

        public void menuSelected(MenuEvent menuEvent) {
            Tool[] toolArray = MDIDeskView.this.getTools();
            JMenu jMenu = (JMenu)menuEvent.getSource();
            jMenu.removeAll();
            JMenuItem jMenuItem = MDIDeskView.this.uif.createMenuItem("dt.windows", MDIDeskView.TILE, this);
            jMenuItem.setEnabled(toolArray.length > 0);
            jMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = MDIDeskView.this.uif.createMenuItem("dt.windows", MDIDeskView.CASCADE, this);
            jMenuItem2.setEnabled(toolArray.length > 0);
            jMenu.add(jMenuItem2);
            JMenu jMenu2 = MDIDeskView.this.getWindowOpenMenu();
            if (jMenu2.getItemCount() > 0) {
                jMenu.addSeparator();
                jMenu.add(MDIDeskView.this.getWindowOpenMenu());
            }
            if (toolArray.length > 0) {
                jMenu.addSeparator();
            }
            int n = 0;
            for (int i = 0; i < toolArray.length; ++i) {
                Tool tool = toolArray[i];
                this.addMenuItem(jMenu, n++, tool.getTitle(), tool);
            }
            JInternalFrame[] jInternalFrameArray = MDIDeskView.this.desktopPane.getAllFrames();
            for (int i = 0; i < jInternalFrameArray.length; ++i) {
                JInternalFrame jInternalFrame = jInternalFrameArray[i];
                if (!jInternalFrame.isVisible() || jInternalFrame.getContentPane() instanceof Tool) continue;
                this.addMenuItem(jMenu, n++, jInternalFrame.getTitle(), jInternalFrame);
            }
            Window[] windowArray = MDIDeskView.this.mainFrame.getOwnedWindows();
            for (int i = 0; i < windowArray.length; ++i) {
                Window window = windowArray[i];
                if (!(window instanceof JDialog) || !window.isVisible()) continue;
                this.addMenuItem(jMenu, n++, ((JDialog)window).getTitle(), window);
            }
        }

        private void addMenuItem(JMenu jMenu, int n, String string, Object object) {
            JMenuItem jMenuItem = new JMenuItem(MDIDeskView.this.uif.getI18NString("dt.windows.toolX.mit", new Object[]{new Integer(n), string}));
            if (n < 10) {
                jMenuItem.setMnemonic(Character.forDigit(n, 10));
            }
            jMenuItem.addActionListener(this);
            jMenuItem.putClientProperty(this, object);
            jMenu.add(jMenuItem);
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void shortTitleChanged(Tool tool, String string) {
        }

        public void titleChanged(Tool tool, String string) {
            JInternalFrame jInternalFrame = (JInternalFrame)MDIDeskView.this.internalFrames.get(tool);
            jInternalFrame.setTitle(string);
        }

        public void toolDisposed(Tool tool) {
        }
    }
}

