/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.DeskView;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.ToolManager;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.PrefixMap;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

class SDIDeskView
extends DeskView {
    private static final int MENU_INSERT_POINT = 3;
    private JFrame console;
    private JFrame[] frames;
    private boolean visible;
    private Tool selectedTool;
    private Listener listener = new Listener();
    private static final String TILE = "tile";
    private static final String CASCADE = "cascade";
    static /* synthetic */ Class class$javax$swing$JFrame;

    SDIDeskView(Desktop desktop) {
        super(desktop);
        this.initFrames();
        this.uif.setDialogParent(this.console);
        JDialog.setDefaultLookAndFeelDecorated(false);
    }

    SDIDeskView(DeskView deskView) {
        this(deskView.getDesktop());
        Tool[] toolArray = deskView.getTools();
        for (int i = 0; i < toolArray.length; ++i) {
            this.addTool(toolArray[i]);
        }
        this.doCascade();
        this.setVisible(deskView.isVisible());
    }

    public void dispose() {
        int n;
        for (n = 0; n < this.frames.length; ++n) {
            this.frames[n].setVisible(false);
        }
        for (n = 0; n < this.frames.length; ++n) {
            this.frames[n].dispose();
        }
        super.dispose();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (bl != this.visible) {
            for (int i = 0; i < this.frames.length; ++i) {
                JFrame jFrame = this.frames[i];
                jFrame.setVisible(bl);
                if (!bl) continue;
                Window[] windowArray = jFrame.getOwnedWindows();
                for (int j = 0; j < windowArray.length; ++j) {
                    windowArray[j].toFront();
                }
            }
            this.visible = bl;
        }
    }

    public boolean isEmpty() {
        return this.frames.length == 1;
    }

    public Tool[] getTools() {
        Tool[] toolArray = new Tool[this.frames.length - 1];
        for (int i = 0; i < toolArray.length; ++i) {
            toolArray[i] = (Tool)this.frames[i + 1].getContentPane();
        }
        return toolArray;
    }

    public void addTool(final Tool tool) {
        DeskView deskView = tool.getDeskView();
        if (deskView == this) {
            return;
        }
        ToolDialog[] toolDialogArray = tool.getToolDialogs();
        boolean[] blArray = new boolean[toolDialogArray.length];
        for (int i = 0; i < toolDialogArray.length; ++i) {
            blArray[i] = toolDialogArray[i].isVisible();
        }
        if (deskView != null) {
            deskView.removeTool(tool);
        }
        ToolAction toolAction = new ToolAction(this.uif, "sdi.file.close"){

            public void actionPerformed(ActionEvent actionEvent) {
                SDIDeskView.this.removeTool(tool);
                tool.dispose();
            }
        };
        JFrame jFrame = this.createFrame(this.listener, toolAction, "sdi.tool");
        jFrame.setDefaultCloseOperation(0);
        this.addToolMenuItemsToFrameMenuBar(jFrame, tool);
        jFrame.setTitle(this.uif.getI18NString("dt.title.tool.txt", tool.getTitle()));
        jFrame.setContentPane(tool);
        jFrame.pack();
        tool.addObserver(this.listener);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                JFrame jFrame = (JFrame)windowEvent.getSource();
                Tool tool = (Tool)jFrame.getContentPane();
                SDIDeskView.this.selectedTool = tool;
            }

            public void windowDeactivated(WindowEvent windowEvent) {
                SDIDeskView.this.selectedTool = null;
            }

            public void windowClosing(WindowEvent windowEvent) {
                JFrame jFrame = (JFrame)windowEvent.getSource();
                Tool tool = (Tool)jFrame.getContentPane();
                if (SDIDeskView.this.getDesktop().isOKToClose(tool, jFrame)) {
                    jFrame.dispose();
                }
            }

            public void windowClosed(WindowEvent windowEvent) {
                JFrame jFrame = (JFrame)windowEvent.getSource();
                SDIDeskView.access$102(SDIDeskView.this, (JFrame[])DynamicArray.remove((Object[])SDIDeskView.this.frames, jFrame));
                if (jFrame.getContentPane() instanceof Tool) {
                    Tool tool = (Tool)jFrame.getContentPane();
                    tool.removeObserver(SDIDeskView.this.listener);
                    tool.dispose();
                    jFrame.getRootPane().removeAll();
                    if (tool == SDIDeskView.this.selectedTool) {
                        SDIDeskView.this.selectedTool = null;
                    }
                }
            }
        });
        Dimension dimension = jFrame.getSize();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        jFrame.setLocation(graphicsEnvironment.getCenterPoint().x - dimension.width / 2, graphicsEnvironment.getCenterPoint().y - dimension.height / 2);
        jFrame.setVisible(this.visible);
        this.frames = (JFrame[])DynamicArray.append(this.frames, jFrame);
        tool.setDeskView(this);
        for (int i = 0; i < toolDialogArray.length; ++i) {
            toolDialogArray[i].initDialog(this, blArray[i]);
        }
    }

    public void removeTool(Tool tool) {
        JFrame jFrame = SDIDeskView.getFrameForTool(tool);
        this.frames = (JFrame[])DynamicArray.remove((Object[])this.frames, jFrame);
        jFrame.setVisible(false);
        this.removeToolMenuItemsFromFrameMenuBar(jFrame, tool);
        jFrame.setContentPane(new Container());
        jFrame.dispose();
        tool.setDeskView(null);
    }

    public Tool getSelectedTool() {
        return this.selectedTool;
    }

    public void setSelectedTool(Tool tool) {
        JFrame jFrame = SDIDeskView.getFrameForTool(tool);
        if (jFrame.getState() == 1) {
            jFrame.setState(0);
        }
        jFrame.setVisible(this.visible);
    }

    public int getStyle() {
        return 2;
    }

    public JFrame[] getFrames() {
        return this.frames;
    }

    public Rectangle getBounds() {
        Rectangle rectangle = null;
        for (int i = 1; i < this.frames.length; ++i) {
            Rectangle rectangle2 = this.frames[i].getBounds();
            rectangle = rectangle == null ? rectangle2 : rectangle.union(rectangle2);
        }
        return rectangle == null ? SDIDeskView.getDefaultBounds() : rectangle;
    }

    public boolean isToolOwnerForDialog(Tool tool, Container container) {
        if (container == null) {
            return false;
        }
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = SDIDeskView.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, tool);
        return container.getParent() == jFrame;
    }

    public Container createDialog(Tool tool, String string, String string2, JMenuBar jMenuBar, Container container, Rectangle rectangle) {
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = SDIDeskView.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, tool);
        UIFactory uIFactory = tool.uif;
        JDialog jDialog = uIFactory.createDialog(string, jFrame, string2, container);
        if (jMenuBar != null) {
            jDialog.setJMenuBar(jMenuBar);
        }
        if (rectangle == null) {
            jDialog.pack();
            jDialog.pack();
            jDialog.setLocationRelativeTo(jFrame);
        } else {
            jDialog.setBounds(rectangle);
        }
        return jDialog;
    }

    protected void saveDesktop(Map map) {
        SDIDeskView.saveBounds(this.console, new PrefixMap(map, "dt.console"));
        this.saveTools(map);
    }

    protected void restoreDesktop(Map map) {
        SDIDeskView.restoreBounds(this.console, new PrefixMap(map, "dt.console"));
        this.restoreTools(map);
    }

    protected void saveTool(Map map, Tool tool) {
        super.saveTool(map, tool);
        SDIDeskView.saveBounds(SDIDeskView.getFrameForTool(tool), new PrefixMap(map, "dt"));
    }

    protected Tool restoreTool(Map map, String string) throws DeskView.Fault, ToolManager.Fault {
        Tool tool = super.restoreTool(map, string);
        SDIDeskView.restoreBounds(SDIDeskView.getFrameForTool(tool), new PrefixMap(map, "dt"));
        return tool;
    }

    private void initFrames() {
        this.console = this.createFrame(this.listener, "sdi.console");
        this.console.setTitle(this.uif.getI18NString("dt.title.console"));
        this.console.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SDIDeskView.this.getDesktop().checkToolsAndExitIfOK(SDIDeskView.this.console);
            }
        });
        JLabel jLabel = new JLabel(this.getDesktop().getLogo());
        jLabel.setName("sdi.console");
        jLabel.setFocusable(false);
        jLabel.setOpaque(true);
        this.console.setContentPane(jLabel);
        this.console.pack();
        this.frames = new JFrame[]{this.console};
    }

    private void doCascade() {
        int n = 0;
        int n2 = 0;
        for (int i = 1; i < this.frames.length; ++i) {
            JFrame jFrame = this.frames[i];
            Dimension dimension = jFrame.getSize();
            n = Math.max(n, i * 30 + dimension.width);
            n2 = Math.max(n2, i * 30 + dimension.height);
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        int n3 = graphicsEnvironment.getCenterPoint().x - n / 2;
        int n4 = graphicsEnvironment.getCenterPoint().y - n2 / 2;
        if (n3 <= 0) {
            n3 = 30;
        }
        if (n4 <= 0) {
            n4 = 30;
        }
        for (int i = 1; i < this.frames.length; ++i) {
            JFrame jFrame = this.frames[i];
            jFrame.setLocation(n3 + i * 30, n4 + i * 30);
            jFrame.toFront();
            Window[] windowArray = jFrame.getOwnedWindows();
            for (int j = 0; j < windowArray.length; ++j) {
                windowArray[j].toFront();
            }
        }
    }

    private void doTile() {
        int n = this.frames.length - 1;
        int n2 = (int)Math.sqrt(n);
        int n3 = (n + n2 - 1) / n2;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = new Dimension(dimension.width / n2, dimension.height / n3);
        for (int i = 0; i < n; ++i) {
            JFrame jFrame = this.frames[i + 1];
            int n4 = i % n2;
            int n5 = i / n2;
            jFrame.setBounds(n4 * dimension2.width, n5 * dimension2.height, dimension2.width, dimension2.height);
        }
    }

    private static JFrame getFrameForTool(Tool tool) {
        return (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = SDIDeskView.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, tool);
    }

    static /* synthetic */ JFrame[] access$102(SDIDeskView sDIDeskView, JFrame[] jFrameArray) {
        sDIDeskView.frames = jFrameArray;
        return jFrameArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Listener
    implements ActionListener,
    MenuListener,
    Tool.Observer {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(SDIDeskView.CASCADE)) {
                SDIDeskView.this.doCascade();
            } else if (string.equals(SDIDeskView.TILE)) {
                SDIDeskView.this.doTile();
            } else {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                Object object = jMenuItem.getClientProperty(this);
                if (object instanceof Window) {
                    ((Window)object).toFront();
                } else if (object instanceof Tool) {
                    SDIDeskView.this.setSelectedTool((Tool)object);
                }
            }
        }

        public void menuSelected(MenuEvent menuEvent) {
            Window[] windowArray;
            int n;
            Tool[] toolArray = SDIDeskView.this.getTools();
            JMenu jMenu = (JMenu)menuEvent.getSource();
            jMenu.removeAll();
            JMenuItem jMenuItem = SDIDeskView.this.uif.createMenuItem("dt.windows", SDIDeskView.TILE, this);
            jMenuItem.setEnabled(toolArray.length > 0);
            jMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = SDIDeskView.this.uif.createMenuItem("dt.windows", SDIDeskView.CASCADE, this);
            jMenuItem2.setEnabled(toolArray.length > 0);
            jMenu.add(jMenuItem2);
            jMenu.addSeparator();
            JMenu jMenu2 = SDIDeskView.this.getWindowOpenMenu();
            if (jMenu2.getItemCount() > 0) {
                jMenu.add(SDIDeskView.this.getWindowOpenMenu());
                jMenu.addSeparator();
            }
            int n2 = 0;
            for (n = 0; n < toolArray.length; ++n) {
                windowArray = toolArray[n];
                this.addMenuItem(jMenu, n2++, windowArray.getTitle(), windowArray);
            }
            for (n = 0; n < SDIDeskView.this.frames.length; ++n) {
                windowArray = SDIDeskView.this.frames[n].getOwnedWindows();
                for (int i = 0; i < windowArray.length; ++i) {
                    Window window = windowArray[i];
                    if (!(window instanceof JDialog) || !window.isVisible()) continue;
                    this.addMenuItem(jMenu, n2++, ((JDialog)window).getTitle(), window);
                }
            }
            this.addMenuItem(jMenu, n2++, SDIDeskView.this.console.getTitle(), SDIDeskView.this.console);
        }

        private void addMenuItem(JMenu jMenu, int n, String string, Object object) {
            JMenuItem jMenuItem = new JMenuItem(SDIDeskView.this.uif.getI18NString("dt.windows.toolX.mit", new Object[]{new Integer(n), string}));
            if (n < 10) {
                jMenuItem.setMnemonic(Character.forDigit(n, 10));
            }
            jMenuItem.addActionListener(this);
            jMenuItem.putClientProperty(this, object);
            jMenu.add(jMenuItem);
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void shortTitleChanged(Tool tool, String string) {
        }

        public void titleChanged(Tool tool, String string) {
            JFrame jFrame = SDIDeskView.getFrameForTool(tool);
            jFrame.setTitle(SDIDeskView.this.uif.getI18NString("dt.title.tool.txt", string));
        }

        public void toolDisposed(Tool tool) {
        }
    }
}

