/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.TestSuite;
import com.sun.javatest.tool.IconFactory;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.FileInfoCache;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;

public class TestSuiteChooser
extends JFileChooser {
    private FileInfoCache cache = new FileInfoCache(60000);
    private TestSuite selectedTestSuite;
    private UIFactory uif;
    private Icon icon;
    static /* synthetic */ Class class$com$sun$javatest$TestSuite;

    public TestSuiteChooser() {
        this(new File(System.getProperty("user.dir")));
    }

    public TestSuiteChooser(File file) {
        super(TestSuiteChooser.normalize(file));
        this.setName("tsc");
        this.uif = new UIFactory(this, null);
        this.icon = IconFactory.getSelectableFolderIcon();
        this.setDialogTitle(this.uif.getI18NString("tsc.title"));
        this.setApproveButtonText(this.uif.getI18NString("tsc.open.btn"));
        this.setApproveButtonToolTipText(this.uif.getI18NString("tsc.open.tip"));
        this.setAcceptAllFileFilterUsed(false);
        this.setFileFilter(new TSC_FileFilter());
        this.setFileView(new TSC_FileView());
        this.setFileSelectionMode(2);
    }

    public TestSuite getSelectedTestSuite() {
        return this.selectedTestSuite;
    }

    public void setSelectedTestSuite(TestSuite testSuite) {
        if (testSuite != null) {
            this.setSelectedFile(testSuite.getRoot());
        }
        this.selectedTestSuite = testSuite;
    }

    public int showDialog(Component component) {
        return this.showDialog(component, this.getApproveButtonText());
    }

    public void approveSelection() {
        File file = this.getSelectedFile();
        if (this.isTraversable(file)) {
            this.setCurrentDirectory(file);
            this.setSelectedFile(null);
            this.setSelectedFiles(null);
            return;
        }
        try {
            this.selectedTestSuite = TestSuite.open(file);
            super.approveSelection();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.uif.showError("tsc.cantFindTestSuite", fileNotFoundException.getMessage());
        }
        catch (TestSuite.Fault fault) {
            this.uif.showError("tsc.notATestSuite", fault.getMessage());
        }
    }

    private boolean isDirectory(File file) {
        return file.isDirectory();
    }

    private boolean isTestSuite(File file) {
        if (TestSuiteChooser.isIgnoreable(file)) {
            return false;
        }
        Boolean bl = (Boolean)this.cache.get(file);
        if (bl == null) {
            boolean bl2 = TestSuite.isTestSuite(file);
            this.cache.put(file, bl2 ? Boolean.TRUE : Boolean.FALSE);
            return bl2;
        }
        return bl;
    }

    private static boolean isIgnoreable(File file) {
        return file.getName().equals("");
    }

    private static File normalize(File file) {
        for (File file2 = file; file2 != null && !TestSuiteChooser.isIgnoreable(file2); file2 = file2.getParentFile()) {
            if (!TestSuite.isTestSuite(file2)) continue;
            File file3 = file2.getParentFile();
            return file3 != null ? file3 : file;
        }
        return file;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$sun$javatest$TestSuite == null ? (class$com$sun$javatest$TestSuite = TestSuiteChooser.class$("com.sun.javatest.TestSuite")) : class$com$sun$javatest$TestSuite;
    }

    private class TSC_FileFilter
    extends FileFilter {
        private TSC_FileFilter() {
        }

        public boolean accept(File file) {
            return TestSuiteChooser.this.isDirectory(file) ? true : TestSuiteChooser.this.isTestSuite(file);
        }

        public String getDescription() {
            return TestSuiteChooser.this.uif.getI18NString("tsc.ft");
        }
    }

    private class TSC_FileView
    extends FileView {
        private TSC_FileView() {
        }

        public String getDescription(File file) {
            return null;
        }

        public Icon getIcon(File file) {
            return TestSuiteChooser.this.isTestSuite(file) ? TestSuiteChooser.this.icon : null;
        }

        public String getName(File file) {
            String string = file.getName();
            return string.length() == 0 ? file.getPath() : string;
        }

        public String getTypeDescription(File file) {
            return null;
        }

        public Boolean isTraversable(File file) {
            return TestSuiteChooser.this.isDirectory(file) && !TestSuiteChooser.this.isTestSuite(file) ? Boolean.TRUE : Boolean.FALSE;
        }
    }
}

