/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.tool.DeskView;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.ToolManager;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.DynamicArray;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.help.HelpBroker;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JPanel;

public abstract class Tool
extends JPanel {
    protected final UIFactory uif;
    private ToolManager manager;
    private String title;
    private String shortTitle;
    private String helpID;
    private long creationTime;
    private List toolDialogs;
    private DeskView deskView;
    private Observer[] observers = new Observer[0];
    private static int toolIndex;

    public synchronized void addObserver(Observer observer) {
        this.observers = (Observer[])DynamicArray.append(this.observers, observer);
    }

    public synchronized void removeObserver(Observer observer) {
        this.observers = (Observer[])DynamicArray.remove((Object[])this.observers, observer);
    }

    public abstract JMenuBar getMenuBar();

    protected void setI18NTitle(String string) {
        this.setLocalizedTitle(this.uif.getI18NString(string));
    }

    protected void setI18NTitle(String string, Object object) {
        this.setLocalizedTitle(this.uif.getI18NString(string, object));
    }

    protected void setI18NTitle(String string, Object[] objectArray) {
        this.setLocalizedTitle(this.uif.getI18NString(string, objectArray));
    }

    private synchronized void setLocalizedTitle(String string) {
        if (this.title == null ? string == null : this.title.equals(string)) {
            return;
        }
        this.title = string;
        for (int i = 0; i < this.observers.length; ++i) {
            this.observers[i].titleChanged(this, this.title);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setShortTitle(String string) {
        if (this.shortTitle == null ? string == null : this.shortTitle.equals(string)) {
            return;
        }
        this.shortTitle = string;
        for (int i = 0; i < this.observers.length; ++i) {
            this.observers[i].shortTitleChanged(this, this.shortTitle);
        }
    }

    public String getShortTitle() {
        if (this.shortTitle != null) {
            return this.shortTitle;
        }
        if (this.title != null) {
            return this.title;
        }
        return this.getName();
    }

    public TestSuite[] getLoadedTestSuites() {
        return null;
    }

    public WorkDirectory[] getLoadedWorkDirectories() {
        return null;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void dispose() {
        this.removeAll();
        this.uif.dispose();
        for (int i = this.observers.length - 1; i >= 0; --i) {
            this.observers[i].toolDisposed(this);
        }
        this.observers = new Observer[0];
    }

    protected Tool(ToolManager toolManager, String string) {
        super(new BorderLayout());
        this.setName(string + ":" + toolIndex++);
        this.setFocusable(false);
        this.manager = toolManager;
        this.uif = new UIFactory(this, toolManager.getDesktop().getHelpBroker());
        this.uif.setAccessibleName(this, string);
        this.uif.setToolTip(this, string);
        this.creationTime = System.currentTimeMillis();
    }

    protected Tool(ToolManager toolManager, String string, String string2) {
        this(toolManager, string);
        HelpBroker helpBroker = this.getHelpBroker();
        if (helpBroker != null) {
            helpBroker.enableHelp(this, string2, null);
        }
    }

    public ToolManager getManager() {
        return this.manager;
    }

    public Desktop getDesktop() {
        return this.manager.getDesktop();
    }

    public HelpBroker getHelpBroker() {
        return this.manager.getDesktop().getHelpBroker();
    }

    protected abstract void save(Map var1);

    protected String[] getCloseAlerts() {
        return null;
    }

    protected void setHelp(String string) {
        this.setHelp(this, string);
    }

    protected void setHelp(Component component, String string) {
        HelpBroker helpBroker = this.getHelpBroker();
        if (helpBroker != null) {
            if (component instanceof JDialog) {
                JDialog jDialog = (JDialog)component;
                Desktop.addHelpDebugListener(jDialog);
                helpBroker.enableHelpKey(jDialog.getRootPane(), string, null);
            } else {
                helpBroker.enableHelp(component, string, null);
            }
        }
    }

    protected void setHelpOnButton(Component component, String string) {
        HelpBroker helpBroker = this.getHelpBroker();
        if (helpBroker != null) {
            helpBroker.enableHelpOnButton(component, string, null);
        }
    }

    public ToolDialog[] getToolDialogs() {
        if (this.toolDialogs == null) {
            return new ToolDialog[0];
        }
        ArrayList<ToolDialog> arrayList = new ArrayList<ToolDialog>();
        Iterator iterator = this.toolDialogs.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            ToolDialog toolDialog = (ToolDialog)weakReference.get();
            if (toolDialog == null) {
                iterator.remove();
                continue;
            }
            arrayList.add(toolDialog);
        }
        return arrayList.toArray(new ToolDialog[arrayList.size()]);
    }

    void addToolDialog(ToolDialog toolDialog) {
        if (toolDialog == null) {
            throw new NullPointerException();
        }
        if (this.toolDialogs == null) {
            this.toolDialogs = new ArrayList();
        }
        this.toolDialogs.add(new WeakReference<ToolDialog>(toolDialog));
    }

    void setDeskView(DeskView deskView) {
        this.deskView = deskView;
    }

    DeskView getDeskView() {
        return this.deskView;
    }

    public static interface Observer {
        public void titleChanged(Tool var1, String var2);

        public void shortTitleChanged(Tool var1, String var2);

        public void toolDisposed(Tool var1);
    }
}

