/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.ProductInfo;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.MissingResourceException;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.help.HelpBroker;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableModel;

public class UIFactory {
    public static final String CANCEL = "cancel";
    private static final ActionListener closeListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = (Component)actionEvent.getSource();
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof JInternalFrame) && !(container instanceof Window)) continue;
                container.setVisible(false);
                return;
            }
        }
    };
    private Class clientClass;
    private Component parent;
    private I18NResourceBundle i18n;
    private HelpBroker helpBroker;
    private static I18NResourceBundle local_i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$tool$UIFactory == null ? (class$com$sun$javatest$tool$UIFactory = UIFactory.class$("com.sun.javatest.tool.UIFactory")) : class$com$sun$javatest$tool$UIFactory);
    private static final int DOTS_PER_INCH = Toolkit.getDefaultToolkit().getScreenResolution();
    static /* synthetic */ Class class$javax$swing$JOptionPane;
    static /* synthetic */ Class class$javax$swing$JFrame;
    static /* synthetic */ Class class$com$sun$javatest$tool$UIFactory;

    public UIFactory(Class clazz, HelpBroker helpBroker) {
        this(clazz, null, helpBroker);
    }

    public UIFactory(Component component, HelpBroker helpBroker) {
        this(component.getClass(), component, helpBroker);
    }

    public UIFactory(Class clazz, Component component, HelpBroker helpBroker) {
        this.helpBroker = helpBroker;
        this.clientClass = clazz;
        this.parent = component;
        this.i18n = I18NResourceBundle.getBundleForClass(clazz);
    }

    public void setDialogParent(Component component) {
        if (this.parent != null && this.parent != component) {
            throw new IllegalStateException();
        }
        this.parent = component;
    }

    public int getDotsPerInch() {
        return DOTS_PER_INCH;
    }

    public HelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    public I18NResourceBundle getI18NResourceBundle() {
        return this.i18n;
    }

    public int getI18NMnemonic(String string) {
        String string2 = this.getI18NString(string);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(string2);
        if (keyStroke != null) {
            return keyStroke.getKeyCode();
        }
        System.err.println("WARNING: bad mnemonic keystroke for " + string + ": " + string2);
        return 0;
    }

    public Color getI18NColor(String string) {
        String string2 = this.i18n.getString(string + ".clr");
        try {
            if (string2 != null) {
                return Color.decode(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Color.BLACK;
    }

    public String getI18NString(String string) {
        return this.i18n.getString(string);
    }

    public String getI18NString(String string, Object object) {
        return this.i18n.getString(string, object);
    }

    public String getI18NString(String string, Object[] objectArray) {
        return this.i18n.getString(string, objectArray);
    }

    public void setHelp(Component component, String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (this.helpBroker != null) {
            if (component instanceof JDialog) {
                JDialog jDialog = (JDialog)component;
                Desktop.addHelpDebugListener(jDialog);
                this.helpBroker.enableHelpKey(jDialog.getRootPane(), string, null);
            } else {
                this.helpBroker.enableHelp(component, string, null);
            }
        }
    }

    public void setToolTip(JComponent jComponent, String string) {
        String string2 = this.getI18NString(string + ".tip");
        jComponent.setToolTipText(string2);
        jComponent.getAccessibleContext().setAccessibleDescription(string2);
    }

    public void setAccessibleDescription(Component component, String string) {
        this.setAccessibleDescription(component.getAccessibleContext(), string);
    }

    public void setAccessibleDescription(AccessibleContext accessibleContext, String string) {
        String string2 = this.getI18NString(string + ".desc");
        accessibleContext.setAccessibleDescription(string2);
    }

    public void setAccessibleName(Component component, String string) {
        this.setAccessibleName(component.getAccessibleContext(), string);
    }

    public void setAccessibleName(AccessibleContext accessibleContext, String string) {
        String string2 = this.getI18NString(string + ".name");
        accessibleContext.setAccessibleName(string2);
    }

    public void setAccessibleInfo(Component component, String string) {
        this.setAccessibleInfo(component.getAccessibleContext(), string);
    }

    public void setAccessibleInfo(AccessibleContext accessibleContext, String string) {
        this.setAccessibleDescription(accessibleContext, string);
        this.setAccessibleName(accessibleContext, string);
    }

    public Border createTitledBorder(String string) {
        return BorderFactory.createTitledBorder(this.getI18NString(string + ".bdr"));
    }

    public Component createHorizontalGlue(String string) {
        Component component = Box.createHorizontalGlue();
        component.setName(string);
        component.setFocusable(false);
        return component;
    }

    public Component createGlue(String string) {
        Component component = Box.createGlue();
        component.setName(string);
        component.setFocusable(false);
        return component;
    }

    public Component createHorizontalStrut(int n) {
        Component component = Box.createHorizontalStrut(n);
        component.setFocusable(false);
        return component;
    }

    public JButton createButton(String string) {
        JButton jButton = new JButton(this.getI18NString(string + ".btn"));
        jButton.setActionCommand(string);
        jButton.setName(string);
        this.setMnemonic(jButton, string);
        this.setToolTip(jButton, string);
        return jButton;
    }

    public JButton createButton(Action action) {
        JButton jButton = new JButton(action);
        jButton.setName((String)action.getValue("Name"));
        return jButton;
    }

    public JButton createButton(String string, Icon icon) {
        JButton jButton = new JButton(icon);
        jButton.setName(string);
        this.setMnemonic(jButton, string);
        this.setToolTip(jButton, string);
        return jButton;
    }

    public JButton createButton(String string, ActionListener actionListener) {
        JButton jButton = this.createButton(string);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public JButton createButton(String string, ActionListener actionListener, String string2) {
        JButton jButton = this.createButton(string);
        jButton.setActionCommand(string2);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public JButton createCancelButton(String string) {
        return this.createCancelButton(string, closeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JButton createCancelButton(String string, ActionListener actionListener) {
        JButton jButton;
        I18NResourceBundle i18NResourceBundle = this.i18n;
        try {
            this.i18n = local_i18n;
            jButton = new JButton(this.getI18NString("uif.cancel.btn"));
        }
        finally {
            this.i18n = i18NResourceBundle;
        }
        jButton.setActionCommand(CANCEL);
        jButton.addActionListener(actionListener);
        jButton.setName(string);
        this.setToolTip(jButton, string);
        return jButton;
    }

    public JButton createCloseButton(String string) {
        return this.createCloseButton(string, true);
    }

    public JButton createCloseButton(String string, boolean bl) {
        JButton jButton = new JButton(this.getI18NString(string + ".btn"));
        jButton.setName(string);
        if (bl) {
            this.setMnemonic(jButton, string);
        }
        this.setToolTip(jButton, string);
        jButton.addActionListener(closeListener);
        return jButton;
    }

    public JButton createHelpButton(String string, String string2) {
        JButton jButton = this.createButton(string);
        if (this.helpBroker == null) {
            jButton.setEnabled(false);
        } else {
            this.helpBroker.enableHelpOnButton(jButton, string2, null);
        }
        return jButton;
    }

    public JButton createIconButton(String string) {
        JButton jButton = this.createButton(string, this.createIcon(string));
        jButton.setBorder(BorderFactory.createEmptyBorder());
        return jButton;
    }

    public JButton createIconButton(String string, ActionListener actionListener) {
        JButton jButton = this.createButton(string, this.createIcon(string));
        jButton.addActionListener(actionListener);
        return jButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JButton createOptionButton(String string) {
        I18NResourceBundle i18NResourceBundle = this.i18n;
        try {
            JButton jButton;
            this.i18n = local_i18n;
            JButton jButton2 = jButton = this.createButton(string, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Component component = (Component)actionEvent.getSource();
                    JOptionPane jOptionPane = (JOptionPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JOptionPane == null ? (class$javax$swing$JOptionPane = UIFactory.class$("javax.swing.JOptionPane")) : class$javax$swing$JOptionPane, component);
                    jOptionPane.setValue(component);
                    jOptionPane.setVisible(false);
                }
            });
            return jButton2;
        }
        finally {
            this.i18n = i18NResourceBundle;
        }
    }

    public JRadioButton createRadioButton(String string, ButtonGroup buttonGroup) {
        String string2 = this.getI18NString(string + ".rb");
        JRadioButton jRadioButton = new JRadioButton(string2, true);
        jRadioButton.setName(string);
        jRadioButton.setSelected(false);
        this.setMnemonic(jRadioButton, string);
        this.setToolTip(jRadioButton, string);
        buttonGroup.add(jRadioButton);
        return jRadioButton;
    }

    public void setMnemonic(AbstractButton abstractButton, String string) {
        int n = this.getI18NMnemonic(string + ".mne");
        if (n != 0) {
            abstractButton.setMnemonic(n);
        }
    }

    public JCheckBox createCheckBox(String string) {
        return this.createCheckBox(string, false, null);
    }

    public JCheckBox createCheckBox(String string, boolean bl) {
        return this.createCheckBox(string, bl, null);
    }

    public JCheckBox createCheckBox(String string, boolean bl, ButtonGroup buttonGroup) {
        String string2 = string + ".ckb";
        JCheckBox jCheckBox = new JCheckBox(this.getI18NString(string2), bl);
        jCheckBox.setName(string);
        if (buttonGroup != null) {
            buttonGroup.add(jCheckBox);
        }
        this.setMnemonic(jCheckBox, string);
        this.setToolTip(jCheckBox, string);
        return jCheckBox;
    }

    public JComboBox createChoice(String string, String[] stringArray) {
        return this.createChoice(string, stringArray, false);
    }

    public JComboBox createChoice(String string, final String[] stringArray, boolean bl) {
        Component component;
        final String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = this.getI18NString(string + "." + stringArray[i] + ".chc");
        }
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setName(string);
        this.setToolTip(jComboBox, string);
        this.setAccessibleName(jComboBox, string);
        jComboBox.setEditable(bl);
        if (bl && (component = jComboBox.getEditor().getEditorComponent()) instanceof Accessible) {
            if (component.getName() == null) {
                component.setName(string + ".ed");
            }
            AccessibleContext accessibleContext = jComboBox.getAccessibleContext();
            AccessibleContext accessibleContext2 = component.getAccessibleContext();
            accessibleContext2.setAccessibleName(accessibleContext.getAccessibleName());
            accessibleContext2.setAccessibleDescription(accessibleContext.getAccessibleDescription());
        }
        jComboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Object object2 = object;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] != object) continue;
                    object2 = stringArray2[i];
                    break;
                }
                return super.getListCellRendererComponent((JList<?>)jList, object2, n, bl, bl2);
            }
        });
        return jComboBox;
    }

    public JComboBox createChoice(String string) {
        return this.createChoice(string, false);
    }

    public JComboBox createChoice(String string, boolean bl) {
        return this.createChoice(string, bl, null);
    }

    public JComboBox createChoice(String string, JLabel jLabel) {
        return this.createChoice(string, false, jLabel);
    }

    public JComboBox createChoice(String string, boolean bl, JLabel jLabel) {
        Component component;
        JComboBox jComboBox = new JComboBox();
        jComboBox.setName(string);
        this.setToolTip(jComboBox, string);
        if (jLabel != null) {
            jLabel.setLabelFor(jComboBox);
        } else {
            this.setAccessibleName(jComboBox, string);
        }
        jComboBox.setEditable(bl);
        if (bl && (component = jComboBox.getEditor().getEditorComponent()) instanceof Accessible) {
            if (component.getName() == null) {
                component.setName(string + ".ed");
            }
            AccessibleContext accessibleContext = jComboBox.getAccessibleContext();
            AccessibleContext accessibleContext2 = component.getAccessibleContext();
            accessibleContext2.setAccessibleName(accessibleContext.getAccessibleName());
            accessibleContext2.setAccessibleDescription(accessibleContext.getAccessibleDescription());
        }
        return jComboBox;
    }

    public JComboBox createLiteralChoice(String string, Object[] objectArray) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setName(string);
        this.setToolTip(jComboBox, string);
        return jComboBox;
    }

    public Icon createIcon(String string) {
        return new ImageIcon(this.getIconURL(string));
    }

    public URL getIconURL(String string) {
        String string2 = this.getI18NString(string + ".icon");
        URL uRL = this.clientClass.getResource(string2);
        if (uRL == null) {
            throw new MissingResourceException(string2, this.clientClass.getName(), string2);
        }
        return uRL;
    }

    public JLabel createIconLabel(String string) {
        return new JLabel(this.createIcon(string));
    }

    public Image createImage(String string) {
        URL uRL = this.getClass().getResource(string);
        if (uRL == null) {
            throw new MissingResourceException(string, this.clientClass.getName(), string);
        }
        return Toolkit.getDefaultToolkit().getImage(uRL);
    }

    public JLabel createLabel(String string) {
        return this.createLabel(string, false);
    }

    public JLabel createLabel(String string, boolean bl) {
        JLabel jLabel = new JLabel(this.getI18NString(string + ".lbl"));
        jLabel.setName(string);
        if (bl) {
            this.setToolTip(jLabel, string);
            jLabel.setDisplayedMnemonic(this.getI18NMnemonic(string + ".mne"));
        }
        return jLabel;
    }

    public JList createList(String string) {
        JList jList = new JList();
        jList.setName(string);
        this.setAccessibleInfo(jList, string);
        return jList;
    }

    public JList createList(String string, ListModel listModel) {
        JList jList = new JList(listModel);
        jList.setName(string);
        this.setAccessibleInfo(jList, string);
        return jList;
    }

    public JMenuBar createMenuBar(String string) {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setName(string);
        this.setAccessibleInfo(jMenuBar, string);
        return jMenuBar;
    }

    public JMenu createMenu(String string) {
        JMenu jMenu = new JMenu();
        this.initMenu(jMenu, string);
        return jMenu;
    }

    public void initMenu(JMenu jMenu, String string) {
        jMenu.setName(string);
        jMenu.setText(this.getI18NString(string + ".menu"));
        this.setMnemonic(jMenu, string);
        this.setAccessibleDescription(jMenu, string);
    }

    public JMenu createMenu(String string, Action[] actionArray) {
        JMenu jMenu = this.createMenu(string);
        for (int i = 0; i < actionArray.length; ++i) {
            Action action = actionArray[i];
            if (action == null) {
                jMenu.addSeparator();
                continue;
            }
            jMenu.add(this.createMenuItem(action));
        }
        return jMenu;
    }

    public JMenu createMenu(String string, String[] stringArray, ActionListener actionListener) {
        JMenu jMenu = new JMenu();
        this.initMenu(jMenu, string, stringArray, actionListener);
        return jMenu;
    }

    public void initMenu(JMenu jMenu, String string, String[] stringArray, ActionListener actionListener) {
        this.initMenu(jMenu, string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2 == null) {
                jMenu.addSeparator();
                continue;
            }
            jMenu.add(this.createMenuItem(string, string2, actionListener));
        }
    }

    public JPopupMenu createPopupMenu(String string) {
        return new JPopupMenu();
    }

    public JPopupMenu createPopupMenu(String string, String[] stringArray, ActionListener actionListener) {
        JPopupMenu jPopupMenu = this.createPopupMenu(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2 == null) {
                jPopupMenu.addSeparator();
                continue;
            }
            jPopupMenu.add(this.createMenuItem(string, string2, actionListener));
        }
        return jPopupMenu;
    }

    public JMenuItem createMenuItem(Action action) {
        JMenuItem jMenuItem = new JMenuItem(action);
        jMenuItem.setName((String)action.getValue("Name"));
        return jMenuItem;
    }

    public JMenuItem createMenuItem(String string, String string2, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(this.getI18NString(string + "." + string2 + ".mit"));
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(actionListener);
        jMenuItem.setName(string2);
        this.setMnemonic(jMenuItem, string + "." + string2);
        return jMenuItem;
    }

    public JCheckBoxMenuItem createCheckBoxMenuItem(String string, String string2, boolean bl) {
        String string3 = string + "." + string2;
        String string4 = string3 + ".ckb";
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.getI18NString(string4), bl);
        jCheckBoxMenuItem.setName(string3);
        this.setMnemonic(jCheckBoxMenuItem, string3);
        this.setToolTip(jCheckBoxMenuItem, string3);
        return jCheckBoxMenuItem;
    }

    public JMenuItem createHelpMenuItem(String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem(this.getI18NString(string + ".mit"));
        this.setMnemonic(jMenuItem, string);
        if (this.helpBroker == null) {
            jMenuItem.setEnabled(false);
        } else {
            this.helpBroker.enableHelpOnButton(jMenuItem, string2, null);
        }
        return jMenuItem;
    }

    public JMenuItem createLiteralMenuItem(String string, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    public JRadioButtonMenuItem createRadioButtonMenuItem(String string, String string2) {
        String string3 = string + "." + string2;
        String string4 = string3 + ".rad";
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(this.getI18NString(string4));
        jRadioButtonMenuItem.setName(string3);
        this.setMnemonic(jRadioButtonMenuItem, string3);
        this.setToolTip(jRadioButtonMenuItem, string3);
        return jRadioButtonMenuItem;
    }

    public JScrollPane createScrollPane(JComponent jComponent) {
        JScrollPane jScrollPane = new JScrollPane(jComponent);
        jScrollPane.setName(jComponent.getName() == null ? "sp" : jComponent.getName() + ".sp");
        jScrollPane.setFocusable(false);
        return jScrollPane;
    }

    public JScrollPane createScrollPane(JComponent jComponent, int n, int n2) {
        JScrollPane jScrollPane = new JScrollPane(jComponent, n, n2);
        jScrollPane.setName(jComponent.getName() == null ? "sp" : jComponent.getName() + ".sp");
        jScrollPane.setFocusable(false);
        return jScrollPane;
    }

    public JSlider createSlider(String string, int n, int n2, int n3) {
        JSlider jSlider = new JSlider(n, n2, n3);
        this.setToolTip(jSlider, string);
        return jSlider;
    }

    public JSplitPane createSplitPane(int n) {
        JSplitPane jSplitPane = new JSplitPane(n);
        jSplitPane.setName("split");
        this.setSplitPaneInfo(jSplitPane);
        return jSplitPane;
    }

    public JSplitPane createSplitPane(int n, Component component, Component component2) {
        JSplitPane jSplitPane = new JSplitPane(n, component, component2);
        jSplitPane.setName("split");
        this.setSplitPaneInfo(jSplitPane);
        return jSplitPane;
    }

    private void setSplitPaneInfo(JSplitPane jSplitPane) {
        AccessibleContext accessibleContext = jSplitPane.getAccessibleContext();
        if (jSplitPane.getOrientation() == 1) {
            accessibleContext.setAccessibleName(local_i18n.getString("uif.sp.hor.name"));
            accessibleContext.setAccessibleDescription(local_i18n.getString("uif.sp.hor.desc"));
        } else {
            accessibleContext.setAccessibleName(local_i18n.getString("uif.sp.vert.name"));
            accessibleContext.setAccessibleDescription(local_i18n.getString("uif.sp.vert.desc"));
        }
    }

    public JTabbedPane createTabbedPane(String string) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setName(string);
        this.setAccessibleName(jTabbedPane, string);
        this.setToolTip(jTabbedPane, string);
        return jTabbedPane;
    }

    public JTabbedPane createTabbedPane(String string, JComponent[] jComponentArray) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setName(string);
        this.setAccessibleName(jTabbedPane, string);
        for (int i = 0; i < jComponentArray.length; ++i) {
            JComponent jComponent = jComponentArray[i];
            this.addTab(jTabbedPane, string + "." + jComponent.getName(), jComponent);
        }
        this.setToolTip(jTabbedPane, string);
        return jTabbedPane;
    }

    public void addTab(JTabbedPane jTabbedPane, String string, JComponent jComponent) {
        String string2 = this.getI18NString(string + ".tab");
        String string3 = this.getI18NString(string + ".tip");
        jTabbedPane.addTab(string2, null, jComponent, string3);
    }

    public JTable createTable(String string, TableModel tableModel) {
        JTable jTable = new JTable(tableModel);
        this.setAccessibleName(jTable, string);
        this.setToolTip(jTable, string);
        return jTable;
    }

    public JTextField createHeading(String string) {
        String string2 = this.getI18NString(string + ".txt");
        JTextField jTextField = new JTextField(string2, string2.length());
        jTextField.setName(string);
        jTextField.setEditable(false);
        jTextField.setFont(jTextField.getFont().deriveFont(1));
        jTextField.setBorder(BorderFactory.createEmptyBorder());
        this.setAccessibleDescription(jTextField, string);
        return jTextField;
    }

    public JTextField createInputField(String string) {
        return this.createInputField(string, null);
    }

    public JTextField createInputField(String string, JLabel jLabel) {
        return this.createInputField(string, 10, jLabel);
    }

    public JTextField createInputField(String string, int n) {
        return this.createInputField(string, n, null);
    }

    public JTextField createInputField(String string, int n, JLabel jLabel) {
        JTextField jTextField = new JTextField("", n){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        if (jLabel != null) {
            jLabel.setLabelFor(jTextField);
        } else {
            jTextField.setName(string);
        }
        this.setToolTip(jTextField, string);
        return jTextField;
    }

    public JTextArea createMessageArea(String string) {
        return this.createLocalizedMessageArea(string, this.getI18NString(string + ".txt"), true);
    }

    public JTextArea createMessageArea(String string, Object object) {
        return this.createLocalizedMessageArea(string, this.getI18NString(string + ".txt", object), true);
    }

    public JTextArea createMessageArea(String string, Object[] objectArray) {
        return this.createLocalizedMessageArea(string, this.getI18NString(string + ".txt", objectArray), true);
    }

    private JTextArea createLocalizedMessageArea(String string, String string2, boolean bl) {
        JTextArea jTextArea = new JTextArea(string2);
        jTextArea.setName(string);
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setSize(new Dimension(7 * DOTS_PER_INCH, Integer.MAX_VALUE));
        jTextArea.setFocusTraversalKeys(0, null);
        jTextArea.setFocusTraversalKeys(1, null);
        if (bl) {
            AccessibleContext accessibleContext = jTextArea.getAccessibleContext();
            accessibleContext.setAccessibleName(local_i18n.getString("uif.message.name"));
            accessibleContext.setAccessibleDescription(local_i18n.getString("uif.message.desc"));
        } else {
            this.setAccessibleInfo(jTextArea, string);
        }
        return jTextArea;
    }

    public JTextField createOutputField(String string) {
        return this.createOutputField(string, "", 10, null);
    }

    public JTextField createOutputField(String string, JLabel jLabel) {
        return this.createOutputField(string, "", 10, jLabel);
    }

    public JTextField createOutputField(String string, int n) {
        return this.createOutputField(string, "", n, null);
    }

    public JTextField createOutputField(String string, int n, JLabel jLabel) {
        return this.createOutputField(string, "", n, jLabel);
    }

    public JTextField createOutputField(String string, String string2) {
        return this.createOutputField(string, string2, 10, null);
    }

    public JTextField createOutputField(String string, String string2, JLabel jLabel) {
        return this.createOutputField(string, string2, 10, jLabel);
    }

    public JTextField createOutputField(String string, String string2, int n) {
        return this.createOutputField(string, string2, n, null);
    }

    public JTextField createOutputField(String string, String string2, int n, JLabel jLabel) {
        JTextField jTextField = new JTextField(string2, n);
        jTextField.setName(string);
        jTextField.setEditable(false);
        if (jLabel != null) {
            jLabel.setLabelFor(jTextField);
        } else {
            this.setAccessibleName(jTextField, string);
        }
        this.setToolTip(jTextField, string);
        jTextField.setFocusTraversalKeys(0, null);
        jTextField.setFocusTraversalKeys(1, null);
        return jTextField;
    }

    public JTextArea createTextArea(String string) {
        return this.createTextArea(string, null);
    }

    public JTextArea createTextArea(String string, JLabel jLabel) {
        JTextArea jTextArea = new JTextArea(){

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(100, 100);
            }
        };
        jTextArea.setName(string);
        if (jLabel != null) {
            jLabel.setLabelFor(jTextArea);
        } else {
            this.setAccessibleName(jTextArea, string);
        }
        this.setToolTip(jTextArea, string);
        return jTextArea;
    }

    public JProgressBar createProgressBar(String string, int n) {
        JProgressBar jProgressBar = new JProgressBar(n);
        this.setToolTip(jProgressBar, string);
        this.setAccessibleName(jProgressBar, string);
        return jProgressBar;
    }

    public JProgressBar createProgressBar(String string, int n, BoundedRangeModel boundedRangeModel) {
        JProgressBar jProgressBar = this.createProgressBar(string, n);
        jProgressBar.setModel(boundedRangeModel);
        return jProgressBar;
    }

    public JToolBar createToolBar(String string) {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setName(string);
        this.setAccessibleInfo(jToolBar, string);
        return jToolBar;
    }

    public JToolBar createToolBar(String string, Action[] actionArray) {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setName(string);
        this.setAccessibleInfo(jToolBar, string);
        for (int i = 0; i < actionArray.length; ++i) {
            Action action = actionArray[i];
            if (action == null) {
                jToolBar.addSeparator();
                continue;
            }
            JButton jButton = jToolBar.add(action);
            jButton.setName((String)action.getValue("Name"));
            jButton.getAccessibleContext().setAccessibleName(jButton.getName());
        }
        return jToolBar;
    }

    public JToolBar createToolBar(String string, JButton[] jButtonArray) {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setName(string);
        this.setAccessibleInfo(jToolBar, string);
        for (int i = 0; i < jButtonArray.length; ++i) {
            JButton jButton = jButtonArray[i];
            if (jButton == null) {
                jToolBar.addSeparator();
                continue;
            }
            jToolBar.add(jButton);
        }
        return jToolBar;
    }

    public void addToolBarActions(JToolBar jToolBar, Action[] actionArray) {
        for (int i = 0; i < actionArray.length; ++i) {
            Action action = actionArray[i];
            if (action == null) {
                jToolBar.addSeparator();
                continue;
            }
            JButton jButton = jToolBar.add(action);
            jButton.setName((String)action.getValue("Name"));
            jButton.getAccessibleContext().setAccessibleName(jButton.getName());
        }
    }

    public void showError(String string) {
        this.showLocalizedError(string, this.getI18NString(string + ".err"));
    }

    public void showError(String string, Object object) {
        this.showLocalizedError(string, this.getI18NString(string + ".err", object));
    }

    public void showError(String string, Object[] objectArray) {
        this.showLocalizedError(string, this.getI18NString(string + ".err", objectArray));
    }

    private void showLocalizedError(String string, String string2) {
        String string3 = local_i18n.getString("uif.error", ProductInfo.getName());
        JButton jButton = this.createOptionButton("uif.ok");
        JOptionPane.showOptionDialog(this.parent, this.createLocalizedMessageArea(string, string2, true), string3, -1, 0, null, new Object[]{jButton}, null);
    }

    public int showOKCancelDialog(String string) {
        return this.showLocalizedOKCancelDialog(string, this.getI18NString(string + ".txt"));
    }

    public int showOKCancelDialog(String string, Object object) {
        return this.showLocalizedOKCancelDialog(string, this.getI18NString(string + ".txt", object));
    }

    public int showOKCancelDialog(String string, Object[] objectArray) {
        return this.showLocalizedOKCancelDialog(string, this.getI18NString(string + ".txt", objectArray));
    }

    private int showLocalizedOKCancelDialog(String string, String string2) {
        JButton jButton;
        JButton jButton2;
        String string3;
        JTextArea jTextArea = this.createLocalizedMessageArea(string, string2, true);
        int n = JOptionPane.showOptionDialog(this.parent, jTextArea, string3 = this.getI18NString(string + ".title"), 2, 3, null, new Object[]{jButton2 = this.createOptionButton("uif.ok"), jButton = this.createOptionButton("uif.cancel")}, null);
        return n == 0 ? 0 : (n == 1 ? 2 : n);
    }

    public int showYesNoDialog(String string) {
        return this.showLocalizedYesNoDialog(string, this.getI18NString(string + ".txt"));
    }

    public int showYesNoDialog(String string, Object object) {
        return this.showLocalizedYesNoDialog(string, this.getI18NString(string + ".txt", object));
    }

    public int showCustomYesNoDialog(String string, Component component) {
        return this.showComponentYesNoDialog(string, component);
    }

    public int showYesNoDialog(String string, Object[] objectArray) {
        return this.showLocalizedYesNoDialog(string, this.getI18NString(string + ".txt", objectArray));
    }

    private int showLocalizedYesNoDialog(String string, String string2) {
        JTextArea jTextArea = this.createLocalizedMessageArea(string, string2, true);
        return this.showComponentYesNoDialog(string, jTextArea);
    }

    private int showComponentYesNoDialog(String string, Component component) {
        String string2 = this.getI18NString(string + ".title");
        JButton jButton = this.createOptionButton("uif.yes");
        JButton jButton2 = this.createOptionButton("uif.no");
        return JOptionPane.showOptionDialog(this.parent, component, string2, 0, 3, null, new Object[]{jButton, jButton2}, null);
    }

    public int showYesNoCancelDialog(String string) {
        return this.showLocalizedYesNoCancelDialog(string, this.getI18NString(string + ".txt"));
    }

    public int showYesNoCancelDialog(String string, Object object) {
        return this.showLocalizedYesNoCancelDialog(string, this.getI18NString(string + ".txt", object));
    }

    public int showYesNoCancelDialog(String string, Object[] objectArray) {
        return this.showLocalizedYesNoCancelDialog(string, this.getI18NString(string + ".txt", objectArray));
    }

    private int showLocalizedYesNoCancelDialog(String string, String string2) {
        JTextArea jTextArea = this.createLocalizedMessageArea(string, string2, true);
        String string3 = this.getI18NString(string + ".title");
        JButton jButton = this.createOptionButton("uif.yes");
        JButton jButton2 = this.createOptionButton("uif.no");
        JButton jButton3 = this.createOptionButton("uif.cancel");
        return JOptionPane.showOptionDialog(this.parent, jTextArea, string3, 1, 3, null, new Object[]{jButton, jButton2, jButton3}, null);
    }

    public void showInformationDialog(String string, Object[] objectArray) {
        this.showLocalizedInformationDialog(string, this.getI18NString(string + ".title"), this.getI18NString(string + ".txt", objectArray));
    }

    private void showLocalizedInformationDialog(String string, String string2, String string3) {
        JTextArea jTextArea = this.createLocalizedMessageArea(string, string3, true);
        JOptionPane.showMessageDialog(this.parent, jTextArea, string2, 1, null);
    }

    public void showCustomInfoDialog(String string, Object object) {
        JOptionPane.showMessageDialog(this.parent, object, this.getI18NString(string + ".title"), 1, null);
    }

    public Box createHorizontalBox(String string) {
        Box box = Box.createHorizontalBox();
        box.setName(string);
        box.setFocusable(false);
        return box;
    }

    public JPanel createPanel(String string) {
        return this.createPanel(string, true);
    }

    public JPanel createPanel(String string, boolean bl) {
        JPanel jPanel = new JPanel();
        this.initPanel(jPanel, string, bl);
        return jPanel;
    }

    public JPanel createPanel(String string, LayoutManager layoutManager) {
        return this.createPanel(string, layoutManager, true);
    }

    public JPanel createPanel(String string, LayoutManager layoutManager, boolean bl) {
        JPanel jPanel = new JPanel();
        this.initPanel(jPanel, string, layoutManager, bl);
        return jPanel;
    }

    public void initPanel(JPanel jPanel, String string, boolean bl) {
        jPanel.setName(string);
        if (bl) {
            this.setAccessibleInfo(jPanel, string);
        } else {
            jPanel.setFocusable(false);
        }
    }

    public void initPanel(JPanel jPanel, String string, LayoutManager layoutManager, boolean bl) {
        this.initPanel(jPanel, string, bl);
        jPanel.setLayout(layoutManager);
    }

    public JDialog createDialog(String string, Component component) {
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = UIFactory.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, component);
        return this.createDialog(string, jFrame);
    }

    public JDialog createDialog(String string, JFrame jFrame) {
        JDialog jDialog = new JDialog(jFrame);
        this.initDialog(jDialog, string);
        return jDialog;
    }

    public JDialog createDialog(String string, JFrame jFrame, String string2, Container container) {
        JDialog jDialog = new JDialog(jFrame);
        this.initDialog(jDialog, string);
        jDialog.setTitle(string2);
        jDialog.setContentPane(container);
        return jDialog;
    }

    public JDialog createWaitDialog(String string, Component component) {
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = UIFactory.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, component);
        return this.createWaitDialog(string, jFrame);
    }

    public JDialog createWaitDialog(String string, JFrame jFrame) {
        JDialog jDialog = new JDialog(jFrame);
        this.initDialog(jDialog, string);
        jDialog.setTitle(this.getI18NString(string + ".title"));
        JProgressBar jProgressBar = new JProgressBar(0);
        jProgressBar.setName(string);
        jProgressBar.setIndeterminate(true);
        jProgressBar.setBorderPainted(true);
        jProgressBar.setPreferredSize(new Dimension(Math.round(2.5f * (float)DOTS_PER_INCH), 15));
        JPanel jPanel = this.createPanel(string, new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.left = 12;
        gridBagConstraints.insets.right = 12;
        gridBagConstraints.insets.top = 12;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        JTextArea jTextArea = this.createLocalizedMessageArea(string, this.getI18NString(string + ".txt"), false);
        jTextArea.setSize(new Dimension(Math.round(4.0f * (float)DOTS_PER_INCH), Integer.MAX_VALUE));
        jPanel.add((Component)jTextArea, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets.top = 11;
        gridBagConstraints.insets.bottom = 12;
        jPanel.add((Component)jProgressBar, gridBagConstraints);
        jDialog.setContentPane(jPanel);
        jDialog.pack();
        return jDialog;
    }

    public void initDialog(JDialog jDialog, String string) {
        jDialog.setName(string);
        this.setAccessibleInfo(jDialog, string);
        jDialog.setLocationRelativeTo(jDialog.getParent());
        JRootPane jRootPane = jDialog.getRootPane();
        jRootPane.setName(string + ".root");
        AccessibleContext accessibleContext = jDialog.getAccessibleContext();
        AccessibleContext accessibleContext2 = jRootPane.getAccessibleContext();
        accessibleContext2.setAccessibleName(accessibleContext.getAccessibleName());
        accessibleContext2.setAccessibleDescription(accessibleContext.getAccessibleDescription());
    }

    public void dispose() {
        this.clientClass = null;
        this.parent = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

