/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Vector;

public abstract class BackupPolicy {
    public void backup(File file) throws IOException, SecurityException {
        File file2;
        boolean bl;
        int n;
        if (!this.isBackupRequired(file)) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            throw new IOException("Cannot backup a directory");
        }
        if (!file.canWrite()) {
            throw new IOException("File is write-protected");
        }
        File file3 = new File(file.getCanonicalPath());
        String string = file3.getParent();
        if (string == null) {
            throw new IOException("Cannot determine parent directory of " + file);
        }
        File file4 = new File(string);
        String[] stringArray = file4.list();
        String string2 = file.getName() + "~";
        String string3 = "~";
        int n2 = 0;
        Vector<Integer> vector = new Vector<Integer>();
        if (stringArray != null) {
            block0: for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                if (string4.length() <= string2.length() + string3.length() || !string4.startsWith(string2) || !string4.endsWith(string3)) continue;
                String string5 = string4.substring(string2.length(), string4.length() - string3.length());
                for (n = 0; n < string5.length(); ++n) {
                    if (!Character.isDigit(string5.charAt(n))) break block0;
                }
                n = Integer.parseInt(string5);
                if (n > n2) {
                    n2 = n;
                }
                vector.addElement(new Integer(n));
            }
        }
        if (!(bl = file.renameTo(file2 = new File(file.getPath() + "~" + ++n2 + "~")))) {
            throw new IOException("failed to backup file: " + file);
        }
        int n3 = this.getNumBackupsToKeep(file);
        for (n = 0; n < vector.size(); ++n) {
            int n4 = (Integer)vector.elementAt(n);
            if (n4 > n2 - n3) continue;
            File file5 = new File(file.getPath() + "~" + n4 + "~");
            boolean bl2 = file5.delete();
        }
    }

    public void backupAndRename(File file, File file2) throws IOException, SecurityException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            throw new IOException("Cannot backup a directory.");
        }
        if (!file.canWrite()) {
            throw new IOException("Cannot rename, source file is write-protected " + file.getPath());
        }
        if (this.isBackupRequired(file2)) {
            this.backup(file2);
        } else if (file2.exists()) {
            file2.delete();
        }
        boolean bl = file.renameTo(file2);
        if (!bl) {
            throw new IOException("Rename of " + file2.getPath() + " failed.");
        }
    }

    public Writer backupAndOpenWriter(File file) throws IOException, SecurityException {
        this.backup(file);
        return new BufferedWriter(new FileWriter(file));
    }

    public OutputStream backupAndOpenStream(File file) throws IOException, SecurityException {
        this.backup(file);
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    public abstract int getNumBackupsToKeep(File var1);

    public abstract boolean isBackupRequired(File var1);

    public static BackupPolicy noBackups() {
        return new BackupPolicy(){

            public int getNumBackupsToKeep(File file) {
                return 0;
            }

            public boolean isBackupRequired(File file) {
                return false;
            }
        };
    }

    public static BackupPolicy simpleBackups(final int n) {
        return new BackupPolicy(){

            public int getNumBackupsToKeep(File file) {
                return n;
            }

            public boolean isBackupRequired(File file) {
                return true;
            }
        };
    }
}

