/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import com.sun.javatest.util.Fifo;
import java.util.Iterator;

public class ReadAheadIterator
implements Iterator {
    public static final int NONE = 0;
    public static final int LIMITED = 1;
    public static final int FULL = 2;
    private final Fifo queue = new Fifo();
    private final Iterator source;
    private boolean sourceHasNext;
    private int minQueueSize;
    private int maxQueueSize;
    private int usedCount;
    private Thread worker;
    private static int workerNum;
    private static final int DEFAULT_LIMITED_READAHEAD = 100;

    public ReadAheadIterator(Iterator iterator, int n) {
        this(iterator, n, 100);
    }

    public ReadAheadIterator(Iterator iterator, int n, int n2) {
        this.source = iterator;
        this.setMode(n, n2);
    }

    public synchronized boolean isReadAheadComplete() {
        return this.worker == null ? !this.source.hasNext() : !this.sourceHasNext;
    }

    public synchronized int getItemsFoundCount() {
        return this.usedCount + this.queue.size();
    }

    public synchronized boolean isSourceExhausted() {
        return this.worker == null ? !this.source.hasNext() : !this.sourceHasNext;
    }

    public synchronized int getUsedElementCount() {
        return this.usedCount;
    }

    public synchronized int getOutputQueueSize() {
        return this.queue.size();
    }

    synchronized void setMode(int n, int n2) {
        switch (n) {
            case 0: {
                this.minQueueSize = 0;
                this.maxQueueSize = 0;
                if (this.worker == null) break;
                this.worker = null;
                this.notifyAll();
                break;
            }
            case 1: {
                if (n2 <= 0) {
                    throw new IllegalArgumentException();
                }
                this.minQueueSize = Math.min(10, n2);
                this.maxQueueSize = n2;
                break;
            }
            case 2: {
                this.minQueueSize = 10;
                this.maxQueueSize = Integer.MAX_VALUE;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public synchronized boolean hasNext() {
        return this.queue.size() > 0 || (this.worker == null ? this.source.hasNext() : this.sourceHasNext);
    }

    public synchronized Object next() {
        Object object = this.queue.remove();
        if (object == null) {
            if (this.maxQueueSize == 0) {
                object = this.source.next();
            } else {
                if (this.worker == null) {
                    this.sourceHasNext = this.source.hasNext();
                    if (this.sourceHasNext) {
                        this.worker = new Thread("ReadAheadIterator" + workerNum++){

                            public void run() {
                                ReadAheadIterator.this.readAhead();
                            }
                        };
                        this.worker.start();
                    }
                } else {
                    this.notifyAll();
                }
                while (this.sourceHasNext && this.queue.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                object = this.queue.remove();
            }
        } else if (this.sourceHasNext && this.queue.size() < this.minQueueSize) {
            this.notifyAll();
        }
        if (object != null) {
            ++this.usedCount;
        }
        return object;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readAhead() {
        boolean bl;
        Thread thread = Thread.currentThread();
        ReadAheadIterator readAheadIterator2 = this;
        synchronized (readAheadIterator2) {
            bl = this.sourceHasNext && thread == this.worker;
        }
        try {
            try {}
            catch (InterruptedException interruptedException) {
                Object var8_8 = null;
                ReadAheadIterator readAheadIterator = this;
                synchronized (readAheadIterator) {
                    if (thread != this.worker) return;
                    this.worker = null;
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            ReadAheadIterator readAheadIterator = this;
            synchronized (readAheadIterator) {
                if (thread != this.worker) throw throwable;
                this.worker = null;
                throw throwable;
            }
        }
        while (true) {
            if (bl) {
                readAheadIterator2 = this.source.next();
                boolean bl2 = this.source.hasNext();
                ReadAheadIterator readAheadIterator = this;
                synchronized (readAheadIterator) {
                    this.queue.insert(readAheadIterator2);
                    this.sourceHasNext = bl2;
                    this.notifyAll();
                    bl = this.sourceHasNext && thread == this.worker;
                }
            } else {
                Object var8_7 = null;
                ReadAheadIterator readAheadIterator = this;
                synchronized (readAheadIterator) {
                    if (thread != this.worker) return;
                    this.worker = null;
                    return;
                }
            }
            {
                while (this.queue.size() >= this.maxQueueSize && bl) {
                    this.wait();
                    bl = this.sourceHasNext && thread == this.worker;
                }
            }
        }
    }
}

