/*
 * Copyright 1999-2001 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */
package org.omg.CORBA;


/**
* The interface for <tt>Policy</tt>.  For more information on
* Operations interfaces, see <a href="doc-files/generatedfiles.html#operations">
* "Generated Files: Operations files"</a>.
*<P>
* org/omg/CORBA/PolicyOperations.java
* Generated by the IDL-to-Java compiler (portable), version "3.0"
* from ../../../../../src/share/classes/org/omg/PortableServer/corba.idl
* Saturday, July 17, 1999 12:26:20 AM PDT
*/

/**
 * Provides the operations for a <code>Policy</code> object.
 */
public interface PolicyOperations
{

  /**
   * Returns the constant value that corresponds to the
   * type of the policy object.  The values of
   * the policy objects are allocated by the OMG.
   * New values for PolicyType should be obtained from the OMG by
   * sending mail to request@omg.org.  In general the constant
   * values that are allocated are defined in conjunction with
   * the definition of the corresponding policy object.
   *
   * @return the constant value that corresponds to the type of
   * the policy object
   */
  int policy_type ();

  /**
   * Returns a copy of the <code>Policy</code> object. The copy does not retain
   * any relationships that the policy had with any domain or object.
   *
   * @return a copy of the <code>Policy</code> object
   */
  org.omg.CORBA.Policy copy ();

  /**
   * Destroys the <code>Policy</code> object.  It is the responsibility of
   * the <code>Policy</code> object to determine whether it can be destroyed.
   */
  void destroy ();
} // interface PolicyOperations
