/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class AnnotationItem
implements Comparable {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$tdk$signaturetest$model$AnnotationItem == null ? (class$com$sun$tdk$signaturetest$model$AnnotationItem = AnnotationItem.class$("com.sun.tdk.signaturetest.model.AnnotationItem")) : class$com$sun$tdk$signaturetest$model$AnnotationItem);
    public static final String ANNOTATION_PREFIX = "anno";
    public static final String ANNOTATION_INHERITED = "java.lang.annotation.Inherited";
    public static final String ANNOTATION_DOCUMENTED = "java.lang.annotation.Documented";
    private static final String CLASS_PREFIX = "java.lang.Class";
    public static final AnnotationItem[] EMPTY_ANNOTATIONITEM_ARRAY = new AnnotationItem[0];
    private int target;
    private boolean inheritable = false;
    private String name;
    private SortedSet members = null;
    static /* synthetic */ Class class$com$sun$tdk$signaturetest$model$AnnotationItem;

    public AnnotationItem(int n, String string) {
        this.setTarget(n);
        this.setName(string);
    }

    private AnnotationItem() {
    }

    public int compareTo(Object object) {
        AnnotationItem annotationItem = (AnnotationItem)object;
        int n = this.target - annotationItem.target;
        if (n == 0 && (n = this.name.compareTo(annotationItem.name)) == 0) {
            if (this.members == annotationItem.members) {
                return 0;
            }
            if (this.members == null) {
                return -1;
            }
            if (annotationItem.members == null) {
                return 1;
            }
            n = this.members.size() - annotationItem.members.size();
            if (n == 0) {
                Iterator iterator = this.members.iterator();
                Iterator iterator2 = annotationItem.members.iterator();
                while (iterator.hasNext() && n == 0) {
                    Member member = (Member)iterator.next();
                    n = member.compareTo(iterator2.next());
                }
            }
        }
        return n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string.intern();
    }

    public int getTarget() {
        return this.target;
    }

    public void setTarget(int n) {
        this.target = n;
    }

    public void addMember(Member member) {
        if (this.members == null) {
            this.members = new TreeSet();
        }
        this.members.add(member);
    }

    public boolean isInheritable() {
        return this.inheritable;
    }

    public void removeMember(Member member) {
        this.members.remove(member);
    }

    public Member findByName(String string) {
        if (this.members != null) {
            Iterator iterator = this.members.iterator();
            while (iterator.hasNext()) {
                Member member = (Member)iterator.next();
                if (!member.name.equals(string)) continue;
                return member;
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ANNOTATION_PREFIX).append(" ").append(this.target).append(" ");
        stringBuffer.append(this.name).append('(');
        int n = 0;
        if (this.members != null) {
            Iterator iterator = this.members.iterator();
            while (iterator.hasNext()) {
                Member member = (Member)iterator.next();
                if (n++ != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(member.type).append(' ').append(member.name).append("=");
                stringBuffer.append(member.value);
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static AnnotationItem parse(String string) {
        AnnotationItem annotationItem = new AnnotationItem();
        if (!string.startsWith(ANNOTATION_PREFIX)) {
            throw new IllegalArgumentException(i18n.getString("AnnotationItem.error.bad_annotation_descr") + string);
        }
        int n = string.indexOf(32);
        string = string.substring(n).trim();
        n = string.indexOf(32);
        annotationItem.setTarget(Integer.valueOf(string.substring(0, n)));
        string = string.substring(n + 1);
        n = string.indexOf(40);
        annotationItem.setName(string.substring(0, n).trim());
        string = string.substring(n + 1, string.lastIndexOf(41));
        if (string.length() != 0) {
            while (string.length() > 0 && string.charAt(0) != ')') {
                n = AnnotationItem.parseMember(annotationItem, string);
                if ((string = string.substring(n)).length() <= 0 || string.charAt(0) != ',') continue;
                string = string.substring(1).trim();
            }
        }
        return annotationItem;
    }

    private static int parseMember(AnnotationItem annotationItem, String string) {
        int n = 0;
        Member member = new Member();
        int n2 = string.indexOf(32);
        if (string.startsWith("java.lang.Class<")) {
            char[] cArray = string.toCharArray();
            int n3 = 0;
            int n4 = CLASS_PREFIX.length();
            while (n4 < cArray.length) {
                if (cArray[n4] == '<') {
                    ++n3;
                } else if (cArray[n4] == '>') {
                    --n3;
                }
                if (n3 == 0 && cArray[n4 + 1] == ' ') {
                    n2 = n4 + 1;
                    break;
                }
                ++n4;
            }
        }
        member.type = string.substring(0, n2);
        string = string.substring(n2 + 1).trim();
        n += n2 + 1;
        n2 = string.indexOf(61);
        member.name = string.substring(0, n2);
        string = string.substring(n2 + 1).trim();
        n += n2 + 1;
        char c = string.charAt(0);
        switch (c) {
            case '[': {
                n2 = AnnotationItem.findClosingBracket(string, 1, '[', ']') + 1;
                break;
            }
            case '\"': 
            case '\'': {
                n2 = string.indexOf(c, 1) + 1;
                break;
            }
            case 'a': {
                if (string.startsWith(ANNOTATION_PREFIX)) {
                    AnnotationItem annotationItem2 = AnnotationItem.parse(string);
                    n2 = annotationItem2.toString().length();
                    break;
                }
            }
            default: {
                n2 = string.indexOf(44);
                if (n2 == -1) {
                    n2 = string.indexOf(41);
                }
                if (n2 != -1) break;
                n2 = string.length();
            }
        }
        member.value = string.substring(0, n2);
        annotationItem.addMember(member);
        return n += n2;
    }

    private static int findClosingBracket(String string, int n, char c, char c2) {
        int n2 = 0;
        int n3 = string.length();
        int n4 = n;
        while (n4 < n3) {
            char c3 = string.charAt(n4);
            if (c3 == c) {
                ++n2;
            } else if (c3 == c2) {
                if (n2 == 0) {
                    return n4;
                }
                --n2;
            }
            ++n4;
        }
        return -1;
    }

    public void setInheritable(boolean bl) {
        this.inheritable = bl;
    }

    public static AnnotationItem[] toArray(List list) {
        if (list == null || list.size() == 0) {
            return EMPTY_ANNOTATIONITEM_ARRAY;
        }
        int n = list.size();
        AnnotationItem[] annotationItemArray = new AnnotationItem[n];
        int n2 = 0;
        while (n2 < n) {
            annotationItemArray[n2] = (AnnotationItem)list.get(n2);
            ++n2;
        }
        return annotationItemArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ValueWrap {
        String value;

        public ValueWrap(String string) {
            this.value = string;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class Member
    implements Comparable {
        String type;
        String name;
        String value;

        public Member(String string, String string2, Object object) {
            this.type = string;
            this.name = string2;
            this.setValue(object);
        }

        public Member(String string, Object object) {
            this.name = string;
            this.setValue(object);
        }

        private Member() {
        }

        public int compareTo(Object object) {
            Member member = (Member)object;
            int n = 0;
            if (this.type != null && member.type != null) {
                n = this.type.compareTo(member.type);
            } else if (this.type != member.type) {
                n = this.type == null ? -1 : 1;
            }
            if (n == 0 && (n = this.name.compareTo(member.name)) == 0) {
                n = this.value.compareTo(member.value);
            }
            return n;
        }

        public void setType(String string) {
            this.type = string;
        }

        public void setValue(Object object) {
            this.value = object == null ? null : MemberDescription.valueToString(object);
        }
    }
}

