/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.util.Set;
import java.util.StringTokenizer;

public final class ConstructorDescr
extends MemberDescription {
    public static final ConstructorDescr[] EMPTY_ARRAY = new ConstructorDescr[0];

    public ConstructorDescr() {
        super(MemberType.CONSTRUCTOR, '.');
    }

    public ConstructorDescr(String string, int n) {
        super(MemberType.CONSTRUCTOR, '.');
        this.setupConstuctorName(string);
        this.setModifiers(n);
    }

    public void setupConstuctorName(String string) {
        int n = Math.max(string.lastIndexOf(46), string.lastIndexOf(36));
        this.declaringClass = string.intern();
        this.name = string.substring(n + 1).intern();
    }

    public void setupConstuctorName(String string, String string2) {
        this.declaringClass = string2.intern();
        this.name = string.intern();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConstructorDescr)) {
            return false;
        }
        ConstructorDescr constructorDescr = (ConstructorDescr)object;
        return this.name == constructorDescr.name && SwissKnife.equals(this.typeParameters, constructorDescr.typeParameters) && this.args.equals(constructorDescr.args);
    }

    public int hashCode() {
        return this.name.hashCode() + this.args.hashCode() + (this.typeParameters != null ? this.typeParameters.hashCode() : 0);
    }

    public boolean isCompatible(MemberDescription memberDescription) {
        if (!this.equals(memberDescription)) {
            throw new IllegalArgumentException("Only equal members can be checked for compatibility!");
        }
        return this.memberType.isCompatible(this.getModifiers(), memberDescription.getModifiers()) && this.throwables.equals(memberDescription.throwables);
    }

    public boolean isConstructor() {
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("constructor");
        String string = Modifier.toString(this.memberType, this.getModifiers(), true);
        if (string.length() != 0) {
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
        if (this.typeParameters != null) {
            stringBuffer.append(' ');
            stringBuffer.append(this.typeParameters);
        }
        stringBuffer.append(' ');
        stringBuffer.append(this.declaringClass);
        stringBuffer.append(this.delimiter);
        stringBuffer.append(this.name);
        stringBuffer.append('(');
        stringBuffer.append(this.args);
        stringBuffer.append(')');
        if (this.throwables.length() > 0) {
            stringBuffer.append(" throws ");
            stringBuffer.append(this.throwables);
        }
        AnnotationItem[] annotationItemArray = this.getAnnoList();
        int n = 0;
        while (n < annotationItemArray.length) {
            stringBuffer.append("\n ");
            stringBuffer.append(annotationItemArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getSignature() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.declaringClass);
        stringBuffer.append(this.delimiter);
        stringBuffer.append(this.name);
        stringBuffer.append('(');
        stringBuffer.append(this.args);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    protected void populateDependences(Set set) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.args, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.addDependency(set, stringTokenizer.nextToken());
        }
        stringTokenizer = new StringTokenizer(this.throwables, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.addDependency(set, stringTokenizer.nextToken());
        }
    }
}

