/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.Merge;
import com.sun.tdk.signaturetest.SigTest;
import com.sun.tdk.signaturetest.classpath.ClasspathImpl;
import com.sun.tdk.signaturetest.core.ClassDescriptionLoader;
import com.sun.tdk.signaturetest.core.ClassHierarchy;
import com.sun.tdk.signaturetest.core.ClassHierarchyImpl;
import com.sun.tdk.signaturetest.core.ClassSet;
import com.sun.tdk.signaturetest.core.Erasurator;
import com.sun.tdk.signaturetest.core.Exclude;
import com.sun.tdk.signaturetest.core.ExcludeException;
import com.sun.tdk.signaturetest.core.MemberCollectionBuilder;
import com.sun.tdk.signaturetest.errors.ErrorFormatter;
import com.sun.tdk.signaturetest.errors.MessageType;
import com.sun.tdk.signaturetest.errors.SortedErrorFormatter;
import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.FieldDescr;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.plugin.PluginAPI;
import com.sun.tdk.signaturetest.plugin.Transformer;
import com.sun.tdk.signaturetest.sigfile.FeaturesHolder;
import com.sun.tdk.signaturetest.sigfile.MultipleFileReader;
import com.sun.tdk.signaturetest.util.CommandLineParser;
import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import com.sun.tdk.signaturetest.util.OptionInfo;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SignatureTest
extends SigTest {
    public static final String CHECKVALUE_OPTION = "-CheckValue";
    public static final String NOCHECKVALUE_OPTION = "-NoCheckValue";
    public static final String MODE_OPTION = "-mode";
    public static final String ENABLESUPERSET_OPTION = "-EnableSuperSet";
    public static final String FILES_OPTION = "-Files";
    public static final String NOMERGE_OPTION = "-NoMerge";
    public static final String WRITE_OPTION = "-Write";
    private String logName = null;
    private String outFormat = null;
    private static I18NResourceBundle i18n;
    private boolean logFile = false;
    private Set trackedClassNames;
    private boolean isVerbose = false;
    private Boolean isValueTracked = null;
    private boolean isOneWayConstantChecking = false;
    private String writeFileName = null;
    private String mode = null;
    public static final String BINARY_MODE = "bin";
    public static final String SOURCE_MODE = "src";
    private boolean isSupersettingEnabled = false;
    private boolean isThrowsRemoved = false;
    private ClassHierarchy signatureClassesHierarchy;
    private Erasurator erasurator = new Erasurator();
    protected Exclude exclude;
    private int readMode = MultipleFileReader.MERGE_MODE;
    static /* synthetic */ Class class$com$sun$tdk$signaturetest$SignatureTest;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void main(String[] args) {
        SignatureTest t = SignatureTest.getInstance();
        t.run(args, new PrintWriter(System.err, true), null);
        t.exit();
    }

    protected static SignatureTest getInstance() {
        return new SignatureTest();
    }

    public void run(String[] args, PrintWriter log, PrintWriter ref) {
        long startTime = System.currentTimeMillis();
        SigTest.log = log;
        try {
            ClassLoader cl = (class$com$sun$tdk$signaturetest$SignatureTest == null ? (class$com$sun$tdk$signaturetest$SignatureTest = SignatureTest.class$("com.sun.tdk.signaturetest.SignatureTest")) : class$com$sun$tdk$signaturetest$SignatureTest).getClassLoader();
            this.exclude = (Exclude)cl.loadClass(System.getProperty("exclude.plugin")).newInstance();
        }
        catch (Exception e) {
            this.exclude = new DefaultExcludeList();
        }
        if (this.parseParameters(args)) {
            this.check();
            if (this.logFile) {
                SigTest.log.println(this.toString());
            }
        } else {
            this.usage();
        }
        if (this.classpath != null) {
            this.classpath.close();
        }
        long runTime = System.currentTimeMillis() - startTime;
        if (this.logFile) {
            SigTest.log.close();
            System.out.println(i18n.getString("SignatureTest.mesg.see_log", this.logName));
        }
    }

    private boolean parseParameters(String[] args) {
        CommandLineParser parser = new CommandLineParser(this, "-");
        if (args == null || args.length == 0 || args.length == 1 && (parser.isOptionSpecified(args[0], "-Help") || parser.isOptionSpecified(args[0], "-?"))) {
            return false;
        }
        args = this.exclude.parseParameters(args);
        String optionsDecoder = "decodeOptions";
        parser.addOption("-Package", OptionInfo.optionVariableParams(1, Integer.MAX_VALUE), "decodeOptions");
        parser.addOption("-Classpath", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-FileName", OptionInfo.option(1), "decodeOptions");
        parser.addOption(FILES_OPTION, OptionInfo.option(1), "decodeOptions");
        parser.addOption("-TestURL", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-PackageWithoutSubpackages", OptionInfo.optionVariableParams(1, Integer.MAX_VALUE), "decodeOptions");
        parser.addOption("-Exclude", OptionInfo.optionVariableParams(1, Integer.MAX_VALUE), "decodeOptions");
        parser.addOption("-Version", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-ApiVersion", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-out", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-Static", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-ClassCacheSize", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-FormatPlain", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Debug", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-XnoTiger", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Xverbose", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(CHECKVALUE_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(NOCHECKVALUE_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(ENABLESUPERSET_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(MODE_OPTION, OptionInfo.option(1), "decodeOptions");
        parser.addOption("-AllPublic", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Verbose", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Help", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-?", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Plugin", OptionInfo.option(1), "decodeOptions");
        parser.addOption(NOMERGE_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(WRITE_OPTION, OptionInfo.option(1), "decodeOptions");
        parser.addOption("-ErrorAll", OptionInfo.optionalFlag(), "decodeOptions");
        try {
            parser.processArgs(args);
        }
        catch (CommandLineParserException e) {
            SigTest.log.println(e.getMessage());
            return this.failed(e.getMessage());
        }
        if (this.packages.isEmpty() && this.purePackages.isEmpty()) {
            this.packages.addPackage("");
        }
        if (parser.isOptionSpecified("-FileName")) {
            this.readMode = MultipleFileReader.CLASSPATH_MODE;
        }
        if (parser.isOptionSpecified("-Static") && !parser.isOptionSpecified("-Classpath")) {
            return this.error(i18n.getString("SignatureTest.error.static.missing_option", "-Classpath"));
        }
        if (!parser.isOptionSpecified("-FileName") && !parser.isOptionSpecified(FILES_OPTION)) {
            Object[] invargs = new String[]{"-FileName", FILES_OPTION};
            return this.error(i18n.getString("SignatureTest.error.options.filename_options", invargs));
        }
        if (parser.isOptionSpecified("-FileName") && parser.isOptionSpecified(FILES_OPTION)) {
            Object[] invargs = new String[]{"-FileName", FILES_OPTION};
            return this.error(i18n.getString("Setup.error.options.cant_be_used_together", invargs));
        }
        this.logFile = false;
        if (this.logName != null) {
            try {
                SigTest.log = new PrintWriter((Writer)new FileWriter(this.logName), true);
                this.logFile = true;
            }
            catch (IOException x) {
                if (SigTest.debug) {
                    x.printStackTrace();
                }
                return this.error(i18n.getString("SignatureTest.error.out.invfile", "-out"));
            }
        }
        SigTest.errorManager = this.outFormat != null && "plain".equals(this.outFormat) ? new ErrorFormatter(SigTest.log) : new SortedErrorFormatter(SigTest.log, this.isVerbose);
        try {
            this.classpath = new ClasspathImpl(this.classpathStr);
        }
        catch (SecurityException e) {
            if (SigTest.debug) {
                e.printStackTrace();
            }
            SigTest.log.println(i18n.getString("SignatureTest.error.sec.newclasses"));
        }
        if (this.isStatic && this.classpath.isEmpty()) {
            return this.error(i18n.getString("SignatureTest.error.classpath.unspec"));
        }
        return this.passed();
    }

    public void decodeOptions(String optionName, String[] args) throws CommandLineParserException {
        if (optionName.equalsIgnoreCase("-FileName")) {
            this.sigFileName = args[0];
        } else if (optionName.equalsIgnoreCase(FILES_OPTION)) {
            this.sigFileNameList = args[0];
        } else if (optionName.equalsIgnoreCase("-FormatPlain")) {
            this.outFormat = "plain";
        } else if (optionName.equalsIgnoreCase("-Verbose")) {
            this.isVerbose = true;
        } else if (optionName.equalsIgnoreCase(CHECKVALUE_OPTION)) {
            this.isValueTracked = Boolean.TRUE;
        } else if (optionName.equalsIgnoreCase(NOCHECKVALUE_OPTION)) {
            this.isValueTracked = Boolean.FALSE;
        } else if (optionName.equalsIgnoreCase(WRITE_OPTION)) {
            this.writeFileName = args[0];
        } else if (optionName.equalsIgnoreCase(MODE_OPTION)) {
            if (!SOURCE_MODE.equalsIgnoreCase(args[0]) && !BINARY_MODE.equalsIgnoreCase(args[0])) {
                throw new CommandLineParserException(i18n.getString("SignatureTest.error.arg.invalid", MODE_OPTION));
            }
            this.mode = args[0];
        } else if (optionName.equalsIgnoreCase("-out")) {
            this.logName = args[0];
        } else if (optionName.equalsIgnoreCase(ENABLESUPERSET_OPTION)) {
            this.isSupersettingEnabled = true;
        } else if (optionName.equalsIgnoreCase(NOMERGE_OPTION)) {
            this.readMode = MultipleFileReader.CLASSPATH_MODE;
        } else {
            super.decodeCommonOptions(optionName, args);
        }
    }

    protected void usage() {
        String nl = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append(i18n.getString("SignatureTest.usage.version", "2.0"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.start"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.testurl", "-TestURL"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.filename", "-FileName"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.files", new Object[]{FILES_OPTION, File.pathSeparator}));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.package", "-Package"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.packagewithoutsubpackages", "-PackageWithoutSubpackages"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.exclude", "-Exclude"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.classpath", "-Classpath"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.out", "-out"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.static", "-Static"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.nomerge", NOMERGE_OPTION));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.apiversion", "-ApiVersion"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.checkvalue", CHECKVALUE_OPTION));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.mode", MODE_OPTION));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.classcachesize", new Object[]{"-ClassCacheSize", new Integer(1024)}));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.formatplain", "-FormatPlain"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.verbose", "-Verbose"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.debug", "-Debug"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.help", "-Help"));
        sb.append(nl).append(i18n.getString("SignatureTest.usage.end"));
        System.err.println(sb.toString());
    }

    public boolean useErasurator() {
        return !SigTest.isTigerFeaturesTracked || BINARY_MODE.equals(this.mode);
    }

    /*
     * WARNING - void declaration
     */
    private boolean check() {
        int errors;
        if (this.pluginClass != null) {
            this.pluginClass.init(this);
        }
        if (this.readMode == MultipleFileReader.MERGE_MODE && this.sigFileNameList != null && this.sigFileNameList.indexOf(File.pathSeparator) >= 0) {
            try {
                if (this.writeFileName == null) {
                    File tmpF = File.createTempFile("sigtest", "sig");
                    this.writeFileName = tmpF.getAbsolutePath();
                    tmpF.deleteOnExit();
                }
                Merge m = Merge.getInstance();
                String[] args = new String[]{FILES_OPTION, this.sigFileNameList, WRITE_OPTION, this.writeFileName};
                if (BINARY_MODE.equals(this.mode)) {
                    args = new String[]{FILES_OPTION, this.sigFileNameList, WRITE_OPTION, this.writeFileName, "-Binary"};
                }
                m.testURL = this.testURL;
                m.run(args, SigTest.log, null);
                if (!m.isPassed()) {
                    this.error(m.getReason());
                    return false;
                }
                this.readMode = MultipleFileReader.CLASSPATH_MODE;
                this.sigFileName = this.writeFileName;
                this.sigFileNameList = null;
                this.testURL = "";
            }
            catch (IOException ex) {
                ex.printStackTrace(SigTest.log);
                String msg = i18n.getString("SignatureTest.error.tmpsigfile");
                return this.error(msg);
            }
        } else {
            this.readMode = MultipleFileReader.CLASSPATH_MODE;
        }
        MultipleFileReader in = new MultipleFileReader(SigTest.log, this.readMode);
        String linesep = System.getProperty("line.separator");
        boolean result = this.sigFileNameList != null ? in.readSignatureFiles(this.testURL, this.sigFileNameList) : in.readSignatureFile(this.testURL, this.sigFileName);
        if (!result) {
            if (in != null) {
                in.close();
            }
            String msg = i18n.getString("SignatureTest.error.sigfile.invalid", this.sigFileNameList == null ? this.sigFileName : this.sigFileNameList);
            SigTest.log.println(msg);
            return this.error(msg);
        }
        if (this.isValueTracked == null) {
            Boolean bl = this.isValueTracked = this.isStatic ? Boolean.TRUE : Boolean.FALSE;
        }
        if (this.mode == null) {
            this.mode = SOURCE_MODE;
            MemberType.setMode(false);
        }
        this.isOneWayConstantChecking = this.isValueTracked != false && BINARY_MODE.equals(this.mode) || !this.isStatic;
        String msg = "";
        if (SOURCE_MODE.equals(this.mode)) {
            this.isThrowsRemoved = false;
        }
        if (BINARY_MODE.equals(this.mode)) {
            MemberType.setMode(true);
            this.isThrowsRemoved = true;
        }
        if (this.isValueTracked.booleanValue() && !in.hasFeature(FeaturesHolder.ConstInfo)) {
            String errmsg = i18n.getString("SignatureTest.mesg.sigfile.noconst");
            SigTest.log.println(errmsg);
            return this.failed(errmsg);
        }
        if (!in.hasFeature(FeaturesHolder.ConstInfo)) {
            this.isValueTracked = Boolean.FALSE;
        }
        FieldDescr.isConstantValuesTracked = SigTest.isConstantValuesTracked = this.isValueTracked.booleanValue();
        if (msg.length() != 0) {
            in.close();
            SigTest.log.println(msg);
            return this.error(msg);
        }
        SigTest.log.println(i18n.getString("SignatureTest.mesg.sigtest.report"));
        SigTest.log.println(i18n.getString("SignatureTest.mesg.sigtest.testvers", this.apiVersion));
        if (!this.isThrowsRemoved) {
            SigTest.log.println(i18n.getString("SignatureTest.mesg.sigtest.checkmode.norm", this.mode));
        } else {
            SigTest.log.println(i18n.getString("SignatureTest.mesg.sigtest.checkmode.removed", this.mode));
        }
        if (this.isValueTracked.booleanValue()) {
            SigTest.log.println(i18n.getString("SignatureTest.mesg.sigtest.constcheck", i18n.getString("SignatureTest.mesg.sigtest.constcheck.on")));
        } else {
            SigTest.log.println(i18n.getString("SignatureTest.mesg.sigtest.constcheck", i18n.getString("SignatureTest.mesg.sigtest.constcheck.off")));
        }
        if (!SigTest.isTigerFeaturesTracked) {
            SigTest.log.println(i18n.getString("SignatureTest.mesg.sigtest.tigercheck"));
        }
        SigTest.log.println();
        this.classpath.printErrors(SigTest.log);
        this.trackedClassNames = new HashSet();
        ClassDescriptionLoader loader = this.getClassDescrLoader();
        this.classHierarchy = new ClassHierarchyImpl(loader, this.trackMode);
        this.builder = new MemberCollectionBuilder(this);
        boolean buildMembers = in.hasFeature(FeaturesHolder.BuildMembers);
        MemberCollectionBuilder b = null;
        if (buildMembers) {
            b = new MemberCollectionBuilder(this);
        }
        msg = null;
        Erasurator erasurator = new Erasurator();
        try {
            ClassDescription currentClass;
            this.signatureClassesHierarchy = new ClassHierarchyImpl(in, this.trackMode);
            ClassSet closedSet = new ClassSet(this.signatureClassesHierarchy, true);
            in.rewind();
            while ((currentClass = in.nextClass()) != null) {
                void var10_16;
                closedSet.addClass(var10_16.getQualifiedName());
            }
            Set missingClasses = closedSet.getMissingClasses();
            if (!missingClasses.isEmpty()) {
                SigTest.log.print(i18n.getString("SignatureTest.error.required_classes_missing"));
                int count = 0;
                Iterator it = missingClasses.iterator();
                while (it.hasNext()) {
                    if (count != 0) {
                        SigTest.log.print(", ");
                    }
                    SigTest.log.print(it.next());
                    ++count;
                }
                SigTest.log.println();
                msg = i18n.getString("SignatureTest.error.non_transitively_closed_set");
                return this.error(msg);
            }
            in.rewind();
            while ((currentClass = in.nextClass()) != null) {
                block55: {
                    Transformer t;
                    block54: {
                        if (SigTest.Xverbose) {
                            SigTest.log.println(i18n.getString("SignatureTest.mesg.verbose.check", currentClass.getQualifiedName()));
                        }
                        if (buildMembers) {
                            try {
                                b.createMembers(currentClass, true, false, true);
                            }
                            catch (ClassNotFoundException e) {
                                if (!SigTest.debug) break block54;
                                e.printStackTrace();
                            }
                        }
                    }
                    if (this.useErasurator()) {
                        currentClass = erasurator.erasure(currentClass);
                    }
                    if ((t = PluginAPI.BEFORE_TEST.getTransformer()) != null) {
                        try {
                            t.transform(currentClass);
                        }
                        catch (ClassNotFoundException e) {
                            if (!SigTest.debug) break block55;
                            e.printStackTrace();
                        }
                    }
                }
                if (currentClass.isPackageInfo() && SigTest.isTigerFeaturesTracked) {
                    this.verifyPackageInfo(currentClass);
                } else {
                    this.verifyClass(currentClass);
                }
                currentClass.setMembers(null);
            }
        }
        catch (OutOfMemoryError e) {
            msg = i18n.getString("SignatureTest.error.sigfile.oome");
        }
        catch (StackOverflowError e) {
            msg = i18n.getString("SignatureTest.error.sigfile.soe");
        }
        catch (VirtualMachineError e) {
            msg = i18n.getString("SignatureTest.error.sigfile.vme", e.getMessage());
        }
        catch (IOException e) {
            if (SigTest.debug) {
                e.printStackTrace();
            }
            msg = i18n.getString("SignatureTest.error.sigfile.prob") + linesep + e;
        }
        catch (SecurityException e) {
            if (SigTest.debug) {
                e.printStackTrace();
            }
            msg = i18n.getString("SignatureTest.error.sigfile.sec") + linesep + e;
        }
        catch (Error e) {
            if (SigTest.debug) {
                e.printStackTrace();
            }
            msg = i18n.getString("SignatureTest.error.unknownerror") + e;
        }
        if (msg != null) {
            in.close();
            SigTest.log.println(msg);
            return this.error(msg);
        }
        in.close();
        if (!this.isSupersettingEnabled) {
            this.checkAddedClasses();
        }
        if (SigTest.isTigerFeaturesTracked) {
            this.checkAddedPackages();
        }
        int auxErrorCount = 0;
        SigTest.errorManager.printErrors();
        if (this.reportWarningAsError) {
            auxErrorCount = this.errorMessages.size();
            this.printErrors();
        }
        SigTest.log.println("");
        String repmsg = this.exclude.report();
        if (this.isVerbose) {
            System.out.println(repmsg);
        }
        if ((errors = SigTest.errorManager.getNumErrors() + auxErrorCount) == 0) {
            return this.passed();
        }
        return this.failed(i18n.getString("SignatureTest.mesg.failed", Integer.toString(errors)));
    }

    private void checkAddedClasses() {
        if (this.classpath == null) {
            return;
        }
        try {
            while (this.classpath.hasNext()) {
                String name = this.classpath.nextClassName();
                this.checkAddedClass(name);
            }
        }
        catch (SecurityException ex) {
            if (SigTest.debug) {
                ex.printStackTrace();
            }
            SigTest.log.println(i18n.getString("SignatureTest.mesg.classpath.sec"));
            SigTest.log.println(ex);
        }
    }

    private void checkAddedClass(String name) {
        block11: {
            if (!this.trackedClassNames.contains(name) && this.isPackageMember(name)) {
                try {
                    ClassDescription c = this.classHierarchy.load(name);
                    if (c.isPackageInfo()) {
                        if (SigTest.isTigerFeaturesTracked) {
                            this.checkAnnotations(null, c);
                        }
                    } else if (this.classHierarchy.isAccessible(c)) {
                        this.exclude.check(c, c);
                        SigTest.errorManager.addError(MessageType.getAddedMessageType(c.getMemberType()), c.getQualifiedName(), c.getMemberType(), null, c);
                    }
                }
                catch (ClassNotFoundException ex) {
                    if (SigTest.debug) {
                        ex.printStackTrace();
                    }
                }
                catch (LinkageError ex1) {
                    if (SigTest.debug) {
                        ex1.printStackTrace();
                    }
                }
                catch (ExcludeException e) {
                    if (!this.isVerbose) break block11;
                    SigTest.log.println(i18n.getString("SignatureTest.mesg.verbose.checkAddedClass", new Object[]{name, e.getMessage()}));
                }
            }
        }
    }

    private void checkAddedPackages() {
        ArrayList<String> wrk = new ArrayList<String>();
        Iterator it = this.trackedClassNames.iterator();
        while (it.hasNext()) {
            String pkg = ClassDescription.getPackageName((String)it.next());
            if (wrk.contains(pkg)) continue;
            wrk.add(pkg);
        }
        Collections.sort(wrk);
        Iterator it2 = wrk.iterator();
        while (it2.hasNext()) {
            String fqn = ClassDescription.getPackageInfo((String)it2.next());
            if (this.trackedClassNames.contains(fqn)) continue;
            try {
                ClassDescription c = this.classHierarchy.load(fqn);
                this.checkAnnotations(null, c);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }

    private boolean verifyClass(ClassDescription required) {
        block13: {
            String name = required.getQualifiedName();
            if (!this.isPackageMember(name)) {
                return this.passed();
            }
            try {
                this.exclude.check(required, required);
                ClassDescription found = this.classHierarchy.load(name);
                if (this.classHierarchy.isAccessible(found)) {
                    this.builder.createMembers(found, true, true, false);
                    Transformer t = PluginAPI.BEFORE_TEST.getTransformer();
                    if (t != null) {
                        t.transform(found);
                    }
                    if (this.isThrowsRemoved) {
                        required.removeThrows();
                        found.removeThrows();
                    } else {
                        this.normalizer.normThrows(found, true);
                    }
                    if (this.useErasurator()) {
                        found = this.erasurator.erasure(found);
                    }
                    this.verifyClass(required, found);
                } else {
                    SigTest.errorManager.addError(MessageType.MISS_CLASSES, name, MemberType.CLASS, null, required);
                }
            }
            catch (ClassNotFoundException ex) {
                if (SigTest.debug) {
                    ex.printStackTrace();
                }
                SigTest.errorManager.addError(MessageType.MISS_CLASSES, name, MemberType.CLASS, null, required);
            }
            catch (LinkageError er) {
                if (SigTest.debug) {
                    er.printStackTrace();
                }
                SigTest.errorManager.addError(MessageType.ERROR_LINKERR, name, MemberType.CLASS, i18n.getString("SignatureTest.mesg.linkerr.thrown", er), i18n.getString("SignatureTest.mesg.linkerr.notlink", name), required);
                this.trackedClassNames.add(name);
            }
            catch (ExcludeException e) {
                this.trackedClassNames.add(name);
                if (!this.isVerbose) break block13;
                SigTest.log.println(i18n.getString("SignatureTest.mesg.verbose.verifyClass", new Object[]{name, e.getMessage()}));
            }
        }
        return this.passed();
    }

    private void verifyPackageInfo(ClassDescription required) {
        if (!$assertionsDisabled && !SigTest.isTigerFeaturesTracked) {
            throw new AssertionError();
        }
        String name = required.getQualifiedName();
        if (!this.isPackageMember(name)) {
            return;
        }
        this.trackedClassNames.add(name);
        ClassDescription found = null;
        try {
            found = this.classHierarchy.load(name);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.checkAnnotations(required, found);
    }

    private void excluded(ClassDescription testedClass, MemberDescription md) throws ExcludeException {
        if (md != null && (md.isField() || md.isMethod() || md.isConstructor() || md.isInner())) {
            this.exclude.check(testedClass, md);
        }
    }

    private void verifyClass(ClassDescription required, ClassDescription found) {
        this.trackedClassNames.add(found.getQualifiedName());
        if (SigTest.errorManager instanceof SortedErrorFormatter) {
            ((SortedErrorFormatter)SigTest.errorManager).Tested(found);
        }
        this.checkClassDescription(required, found);
        Iterator e = required.getMembersIterator();
        while (e.hasNext()) {
            MemberDescription requiredMember = (MemberDescription)e.next();
            try {
                this.excluded(required, requiredMember);
                this.trackMember(required, found, requiredMember, found.findMember(requiredMember));
            }
            catch (ExcludeException e1) {
                if (!this.isVerbose) continue;
                SigTest.log.println(i18n.getString("SignatureTest.mesg.verbose.verifyMember", new Object[]{required.getQualifiedName(), requiredMember.toString(), e1.getMessage()}));
            }
        }
        if (!this.isSupersettingEnabled) {
            Iterator e2 = found.getMembersIterator();
            while (e2.hasNext()) {
                MemberDescription foundMember = (MemberDescription)e2.next();
                if (required.containsMember(foundMember)) continue;
                try {
                    this.excluded(found, foundMember);
                    this.trackMember(required, found, null, foundMember);
                }
                catch (ExcludeException e1) {
                    if (!this.isVerbose) continue;
                    SigTest.log.println(i18n.getString("SignatureTest.mesg.verbose.verifyMember2", new Object[]{found.getQualifiedName(), foundMember.toString(), e1.getMessage()}));
                }
            }
        }
    }

    private void checkClassDescription(ClassDescription required, ClassDescription found) {
        this.checkAnnotations(required, found);
        if (!required.isCompatible(found)) {
            SigTest.errorManager.addError(MessageType.MISS_CLASSES, required.getQualifiedName(), MemberType.CLASS, required.toString(), required);
            SigTest.errorManager.addError(MessageType.ADD_CLASSES, found.getQualifiedName(), MemberType.CLASS, found.toString(), found);
        }
    }

    private MemberDescription transformMember(ClassDescription parent, MemberDescription member) {
        MemberDescription clonedMember = member;
        if (parent.hasModifier(Modifier.FINAL) && member.isMethod() && !member.hasModifier(Modifier.FINAL) && member.getDeclaringClassName().equals(parent.getQualifiedName())) {
            clonedMember = (MemberDescription)member.clone();
            clonedMember.addModifier(Modifier.FINAL);
        }
        if (BINARY_MODE.equals(this.mode) && member.isMethod() && member.hasModifier(Modifier.STATIC) && member.hasModifier(Modifier.FINAL)) {
            clonedMember = (MemberDescription)member.clone();
            clonedMember.removeModifier(Modifier.FINAL);
        }
        return clonedMember;
    }

    private void trackMember(ClassDescription parentReq, ClassDescription parentFou, MemberDescription required, MemberDescription found) {
        String name = parentReq.getQualifiedName();
        this.checkAnnotations(required, found);
        if (required != null) {
            required = this.transformMember(parentReq, required);
        }
        if (found != null) {
            found = this.transformMember(parentFou, found);
        }
        if (required != null && found != null) {
            if (required.isCompatible(found)) {
                return;
            }
            if (this.isOneWayConstantChecking && required.isField()) {
                if (!$assertionsDisabled && !found.isField()) {
                    throw new AssertionError();
                }
                String constantValue = ((FieldDescr)required).getConstantValue();
                if (constantValue == null && ((FieldDescr)found).getConstantValue() != null && ((FieldDescr)required).isCompatible(found, true)) {
                    return;
                }
            }
        }
        if (required != null) {
            SigTest.errorManager.addError(MessageType.getMissingMessageType(required.getMemberType()), name, required.getMemberType(), required.toString(), required);
        }
        if (!this.isSupersettingEnabled && found != null) {
            SigTest.errorManager.addError(MessageType.getAddedMessageType(found.getMemberType()), name, found.getMemberType(), found.toString(), found);
        }
    }

    protected AnnotationItem[] removeUndocumentedAnnotations(AnnotationItem[] annotations, ClassHierarchy h) {
        if (annotations == null) {
            return AnnotationItem.EMPTY_ANNOTATIONITEM_ARRAY;
        }
        int len = annotations.length;
        AnnotationItem[] tempStorage = new AnnotationItem[len];
        if (len == 0) {
            return annotations;
        }
        int count = 0;
        int i = 0;
        while (i < len) {
            boolean documented = true;
            try {
                documented = h.isDocumentedAnnotation(annotations[i].getName());
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (documented) {
                tempStorage[count++] = annotations[i];
            }
            ++i;
        }
        if (count == len) {
            return annotations;
        }
        AnnotationItem[] documentedAnnotations = AnnotationItem.EMPTY_ANNOTATIONITEM_ARRAY;
        if (count != 0) {
            documentedAnnotations = new AnnotationItem[count];
            System.arraycopy(tempStorage, 0, documentedAnnotations, 0, count);
        }
        return documentedAnnotations;
    }

    private void checkAnnotations(MemberDescription base, MemberDescription test) {
        AnnotationItem[] testAnnotList;
        if (!SigTest.isTigerFeaturesTracked) {
            return;
        }
        AnnotationItem[] baseAnnotList = base == null ? AnnotationItem.EMPTY_ANNOTATIONITEM_ARRAY : this.removeUndocumentedAnnotations(base.getAnnoList(), this.signatureClassesHierarchy);
        AnnotationItem[] annotationItemArray = testAnnotList = test == null ? AnnotationItem.EMPTY_ANNOTATIONITEM_ARRAY : this.removeUndocumentedAnnotations(test.getAnnoList(), this.classHierarchy);
        if (baseAnnotList.length == 0 && testAnnotList.length == 0) {
            return;
        }
        int minLen = Math.min(baseAnnotList.length, testAnnotList.length);
        int maxLen = Math.max(baseAnnotList.length, testAnnotList.length);
        int i = 0;
        while (i < maxLen) {
            if (i < minLen) {
                if (baseAnnotList[i].compareTo(testAnnotList[i]) != 0) {
                    this.reportError(base, baseAnnotList[i].toString(), false);
                    this.reportError(test, testAnnotList[i].toString(), true);
                }
            } else {
                if (i < baseAnnotList.length) {
                    this.reportError(base, baseAnnotList[i].toString(), false);
                }
                if (i < testAnnotList.length) {
                    this.reportError(test, testAnnotList[i].toString(), true);
                }
            }
            ++i;
        }
    }

    private void reportError(MemberDescription fid, String anno, boolean added) {
        if (fid != null) {
            SigTest.errorManager.addError(added ? MessageType.ADD_ANNO : MessageType.MISS_ANNO, fid.getQualifiedName(), fid.getMemberType(), anno, fid);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$tdk$signaturetest$SignatureTest == null ? (class$com$sun$tdk$signaturetest$SignatureTest = SignatureTest.class$("com.sun.tdk.signaturetest.SignatureTest")) : class$com$sun$tdk$signaturetest$SignatureTest).desiredAssertionStatus();
        CHECKVALUE_OPTION = CHECKVALUE_OPTION;
        NOCHECKVALUE_OPTION = NOCHECKVALUE_OPTION;
        MODE_OPTION = MODE_OPTION;
        ENABLESUPERSET_OPTION = ENABLESUPERSET_OPTION;
        FILES_OPTION = FILES_OPTION;
        NOMERGE_OPTION = NOMERGE_OPTION;
        WRITE_OPTION = WRITE_OPTION;
        i18n = I18NResourceBundle.getBundleForClass(class$com$sun$tdk$signaturetest$SignatureTest == null ? (class$com$sun$tdk$signaturetest$SignatureTest = SignatureTest.class$("com.sun.tdk.signaturetest.SignatureTest")) : class$com$sun$tdk$signaturetest$SignatureTest);
        BINARY_MODE = BINARY_MODE;
        SOURCE_MODE = SOURCE_MODE;
    }

    static class DefaultExcludeList
    implements Exclude {
        public void check(ClassDescription testedClassName, MemberDescription signature) throws ExcludeException {
        }

        public String[] parseParameters(String[] args) {
            return args;
        }

        public String report() {
            return null;
        }
    }
}

