/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.errors;

import com.sun.tdk.signaturetest.errors.ErrorFormatter;
import com.sun.tdk.signaturetest.errors.MessageType;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.SuperInterface;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SortedErrorFormatter
extends ErrorFormatter {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$tdk$signaturetest$errors$SortedErrorFormatter == null ? (class$com$sun$tdk$signaturetest$errors$SortedErrorFormatter = SortedErrorFormatter.class$("com.sun.tdk.signaturetest.errors.SortedErrorFormatter")) : class$com$sun$tdk$signaturetest$errors$SortedErrorFormatter);
    private Map testedsuper = new HashMap();
    private boolean verbose = false;
    protected List failedMessages = new ArrayList();
    protected int tabSize = 20;
    static /* synthetic */ Class class$com$sun$tdk$signaturetest$errors$SortedErrorFormatter;

    public SortedErrorFormatter(PrintWriter out, boolean isv) {
        super(out);
        this.verbose = isv;
    }

    public void Tested(ClassDescription tested) {
        if (!this.getTestedsuper().containsKey(tested.getQualifiedName())) {
            SuperInterface[] items;
            if (tested.getSuperClass() != null) {
                this.getTestedsuper().put(tested.getQualifiedName(), tested.getSuperClass().getQualifiedName());
            }
            if ((items = tested.getInterfaces()) != null) {
                int i = 0;
                while (i < items.length) {
                    this.getTestedsuper().put(tested.getQualifiedName(), ((MemberDescription)items[i]).getQualifiedName());
                    ++i;
                }
            }
        }
    }

    public void addError(MessageType kind, String className, MemberType type, String def, String tail, MemberDescription errorObject) {
        ErrorFormatter.Message c = this.createError(kind, className, type, def, tail, errorObject);
        this.failedMessages.add(c);
        if (!kind.isWarning()) {
            ++this.size;
        }
    }

    public void printErrors() {
        int exmsgs = this.MsgExclude(this.getTestedsuper());
        String nl = System.getProperty("line.separator");
        this.sortErrors();
        boolean hasHeader = false;
        int length = this.failedMessages.size();
        MessageType lastType = null;
        int i = 0;
        while (i < length) {
            ErrorFormatter.Message current = (ErrorFormatter.Message)this.failedMessages.get(i);
            if (current.messageType != lastType) {
                hasHeader = true;
                this.out.println(nl + current.messageType.getLocMessage() + nl + SortedErrorFormatter.space('-', current.messageType.getLocMessage().length()) + nl);
                lastType = current.messageType;
            }
            if (hasHeader) {
                if (current.definition.equals("")) {
                    this.out.println(current.className);
                } else {
                    int currentTab = (current.className.length() + 1) / this.tabSize;
                    if ((current.className.length() + 1) % this.tabSize != 0) {
                        ++currentTab;
                    }
                    this.out.println(current.className + ":" + SortedErrorFormatter.space(' ', (currentTab *= this.tabSize) - current.className.length() - 1) + current.definition);
                    if (this.isVerbose() && current.tail.length() != 0) {
                        this.out.println(i18n.getString("SortedErrorFormatter.error.affected", current.tail));
                    }
                }
            } else {
                this.out.println(current);
            }
            ++i;
        }
        if (this.failedMessages.size() > 0) {
            this.out.println("");
        }
        if (exmsgs > 0) {
            this.out.println(i18n.getString("SortedErrorFormatter.error.dupmesg", Integer.toString(exmsgs)));
        }
    }

    protected void sortErrors() {
        Collections.sort(this.failedMessages, new Comparator(){

            public int compare(Object o1, Object o2) {
                ErrorFormatter.Message m1 = (ErrorFormatter.Message)o1;
                ErrorFormatter.Message m2 = (ErrorFormatter.Message)o2;
                int comp = m1.messageType.compareTo(m2.messageType);
                if (comp == 0) {
                    comp = m1.className.compareTo(m2.className);
                    if (comp == 0 && (comp = m1.definition.compareTo(m2.definition)) == 0) {
                        comp = m1.tail != null && m1.tail != null ? m1.tail.compareTo(m2.tail) : (m1.tail == null ? -1 : 1);
                    }
                    return comp;
                }
                return comp;
            }
        });
    }

    protected static String space(char c, int len) {
        char[] buff = new char[len];
        int i = 0;
        while (i < len) {
            buff[i] = c;
            ++i;
        }
        return new String(buff);
    }

    public int MsgExclude(Map supernames) {
        int k;
        int n;
        ArrayList<ErrorFormatter.Message> v;
        int excludedMessages = 0;
        ArrayList<ArrayList<ErrorFormatter.Message>> vv = new ArrayList<ArrayList<ErrorFormatter.Message>>();
        int i = 0;
        while (i < this.failedMessages.size()) {
            ErrorFormatter.Message msgi = (ErrorFormatter.Message)this.failedMessages.get(i);
            v = null;
            n = 0;
            while (n < vv.size()) {
                ArrayList x = (ArrayList)vv.get(n);
                if (this.MsgCompare((ErrorFormatter.Message)x.get(0), msgi)) {
                    v = (ArrayList)vv.get(n);
                    break;
                }
                ++n;
            }
            if (v == null) {
                k = i + 1;
                while (k < this.failedMessages.size()) {
                    ErrorFormatter.Message msgk = (ErrorFormatter.Message)this.failedMessages.get(k);
                    if (this.MsgCompare(msgk, msgi)) {
                        if (v == null) {
                            v = new ArrayList<ErrorFormatter.Message>();
                            vv.add(v);
                            v.add(msgi);
                        }
                        v.add(msgk);
                    }
                    ++k;
                }
            }
            ++i;
        }
        ArrayList exclude = new ArrayList();
        n = 0;
        while (n < vv.size()) {
            v = (ArrayList<ErrorFormatter.Message>)vv.get(n);
            k = 0;
            while (k < v.size()) {
                boolean flag = true;
                block5: while (flag) {
                    flag = false;
                    ErrorFormatter.Message msgk = (ErrorFormatter.Message)v.get(k);
                    String supk = (String)supernames.get(msgk.className);
                    if (supk == null) continue;
                    i = k + 1;
                    while (i < v.size()) {
                        ErrorFormatter.Message msgi = (ErrorFormatter.Message)v.get(i);
                        if (msgi.className.equals(supk)) {
                            v.set(k, msgi);
                            v.set(i, msgk);
                            flag = true;
                            continue block5;
                        }
                        ++i;
                    }
                }
                ++k;
            }
            k = v.size();
            block7: while (--k >= 0) {
                ErrorFormatter.Message msgk = (ErrorFormatter.Message)v.get(k);
                String supk = (String)supernames.get(msgk.className);
                if (supk == null) continue;
                i = k;
                while (--i >= 0) {
                    ErrorFormatter.Message msgi = (ErrorFormatter.Message)v.get(i);
                    if (!msgi.className.equals(supk)) continue;
                    if (msgi.tail.length() != 0) {
                        msgi.tail = msgi.tail + ",";
                    }
                    msgi.tail = msgi.tail + msgk.className;
                    if (msgk.tail.length() != 0) {
                        msgi.tail = msgi.tail + "," + msgk.tail;
                    }
                    exclude.add(v.get(k));
                    ++excludedMessages;
                    continue block7;
                }
            }
            ++n;
        }
        i = this.failedMessages.size();
        block9: while (--i >= 0) {
            ErrorFormatter.Message msgi = (ErrorFormatter.Message)this.failedMessages.get(i);
            k = 0;
            while (k < exclude.size()) {
                ErrorFormatter.Message msgk = (ErrorFormatter.Message)exclude.get(k);
                if (msgi == msgk) {
                    this.failedMessages.remove(i);
                    continue block9;
                }
                ++k;
            }
        }
        return excludedMessages;
    }

    protected boolean MsgCompare(ErrorFormatter.Message m1, ErrorFormatter.Message m2) {
        return m1.messageType == m2.messageType && m1.definition.equals(m2.definition);
    }

    protected Map getTestedsuper() {
        return this.testedsuper;
    }

    protected void setTestedsuper(Map testedsuper) {
        this.testedsuper = testedsuper;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

