/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.sigfile;

import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.ConstructorDescr;
import com.sun.tdk.signaturetest.model.FieldDescr;
import com.sun.tdk.signaturetest.model.InnerDescr;
import com.sun.tdk.signaturetest.model.MemberCollection;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.model.SuperClass;
import com.sun.tdk.signaturetest.model.SuperInterface;
import com.sun.tdk.signaturetest.sigfile.Parser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class F31Parser
implements Parser {
    private String line;
    private int linesz;
    private int idx;
    private char chr;
    private List elems;
    private int directInterfaceCount;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$tdk$signaturetest$sigfile$F31Parser;

    F31Parser() {
    }

    public ClassDescription parseClassDescription(String classDefinition, List members) {
        this.directInterfaceCount = 0;
        ClassDescription classDescription = (ClassDescription)this.parse(classDefinition);
        MemberCollection classMembers = new MemberCollection();
        MemberDescription member = classDescription;
        ArrayList<String> alist = new ArrayList<String>();
        Iterator it = members.iterator();
        while (it.hasNext()) {
            String str = (String)it.next();
            if (str.startsWith("anno")) {
                alist.add(str);
                continue;
            }
            this.appendAnnotations(member, alist);
            member = this.parse(str);
            classMembers.addMember(member);
        }
        this.appendAnnotations(member, alist);
        classDescription.setMembers(classMembers);
        if (this.directInterfaceCount > 0) {
            classDescription.createInterfaces(this.directInterfaceCount);
            int count = 0;
            Iterator it2 = classMembers.iterator();
            while (it2.hasNext()) {
                SuperInterface si;
                MemberDescription mr = (MemberDescription)it2.next();
                if (!mr.isSuperInterface() || !(si = (SuperInterface)mr).isDirect()) continue;
                classDescription.setInterface(count++, si);
            }
        }
        ArrayList<MemberDescription> methods = new ArrayList<MemberDescription>();
        ArrayList<MemberDescription> fields = new ArrayList<MemberDescription>();
        ArrayList<MemberDescription> constrs = new ArrayList<MemberDescription>();
        ArrayList<MemberDescription> inners = new ArrayList<MemberDescription>();
        ArrayList<MemberDescription> intfs = new ArrayList<MemberDescription>();
        Iterator it3 = classMembers.iterator();
        while (it3.hasNext()) {
            MemberDescription md = (MemberDescription)it3.next();
            if (md instanceof SuperClass) {
                classDescription.setSuperClass((SuperClass)md);
            } else if (md instanceof SuperInterface) {
                intfs.add(md);
            }
            if (!md.getDeclaringClassName().equals(classDescription.getQualifiedName())) continue;
            if (md instanceof MethodDescr) {
                methods.add(md);
                continue;
            }
            if (md instanceof ConstructorDescr) {
                constrs.add(md);
                continue;
            }
            if (md instanceof FieldDescr) {
                fields.add(md);
                continue;
            }
            if (!(md instanceof InnerDescr)) continue;
            inners.add(md);
        }
        classDescription.setConstructors(constrs.toArray(new ConstructorDescr[0]));
        classDescription.setMethods(methods.toArray(new MethodDescr[0]));
        classDescription.setFields(fields.toArray(new FieldDescr[0]));
        classDescription.setNestedClasses(inners.toArray(new InnerDescr[0]));
        classDescription.setInterfaces(intfs.toArray(new SuperInterface[0]));
        return classDescription;
    }

    private void appendAnnotations(MemberDescription fid, List alist) {
        if (alist.size() != 0) {
            AnnotationItem[] tmp = new AnnotationItem[alist.size()];
            int i = 0;
            while (i < alist.size()) {
                tmp[i] = AnnotationItem.parse((String)alist.get(i));
                ++i;
            }
            fid.setAnnoList(tmp);
            alist.clear();
        }
    }

    private MemberDescription parse(String definition) {
        MemberDescription member = null;
        MemberType type = MemberType.getItemType(definition);
        if (type == MemberType.CLASS) {
            member = this.parse(new ClassDescription(), definition);
        } else if (type == MemberType.CONSTRUCTOR) {
            member = this.parse(new ConstructorDescr(), definition);
        } else if (type == MemberType.METHOD) {
            member = this.parse(new MethodDescr(), definition);
        } else if (type == MemberType.FIELD) {
            member = this.parse(new FieldDescr(), definition);
        } else if (type == MemberType.SUPERCLASS) {
            member = this.parse(new SuperClass(), definition);
        } else if (type == MemberType.SUPERINTERFACE) {
            member = this.parse(new SuperInterface(), definition);
            if (((SuperInterface)member).isDirect()) {
                ++this.directInterfaceCount;
            }
        } else if (type == MemberType.INNER) {
            member = this.parse(new InnerDescr(), definition);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return member;
    }

    private void init(MemberDescription m, String def) {
        this.line = def.trim();
        this.linesz = this.line.length();
        this.idx = def.indexOf(32);
        this.scanElems();
    }

    protected MemberDescription parse(ClassDescription cls, String def) {
        this.init(cls, def);
        cls.setModifiers(Modifier.scanModifiers(this.elems));
        String s = this.getElem();
        cls.setupGenericClassName(s);
        return cls;
    }

    protected MemberDescription parse(ConstructorDescr ctor, String def) {
        this.init(ctor, def);
        ctor.setModifiers(Modifier.scanModifiers(this.elems));
        String s = this.getElem();
        if (s != null && s.charAt(0) == '<') {
            ctor.setTypeParameters(s);
            s = this.getElem();
        }
        ctor.setupConstuctorName(s);
        s = this.getElem();
        if (s.charAt(0) != '(') {
            this.err();
        }
        if (!"()".equals(s)) {
            ctor.setArgs(s.substring(1, s.length() - 1));
        }
        if (this.elems.size() != 0) {
            s = this.getElem();
            if (!s.equals("throws")) {
                this.err();
            }
            s = this.getElem();
            ctor.setThrowables(s);
        }
        return ctor;
    }

    protected MemberDescription parse(MethodDescr method, String def) {
        this.init(method, def);
        method.setModifiers(Modifier.scanModifiers(this.elems));
        String s = this.getElem();
        if (s != null && s.charAt(0) == '<') {
            method.setTypeParameters(s);
            s = this.getElem();
        }
        method.setType(s);
        method.setupMemberName(this.getElem());
        s = this.getElem();
        if (s.charAt(0) != '(') {
            this.err();
        }
        if (!"()".equals(s)) {
            method.setArgs(s.substring(1, s.length() - 1));
        }
        if (this.elems.size() != 0) {
            s = this.getElem();
            if (!s.equals("throws")) {
                this.err();
            }
            s = this.getElem();
            method.setThrowables(s);
        }
        return method;
    }

    protected MemberDescription parse(FieldDescr field, String def) {
        this.init(field, def);
        field.setModifiers(Modifier.scanModifiers(this.elems));
        String s = this.getElem();
        field.setType(s);
        s = this.getElem();
        field.setupMemberName(s);
        if (this.elems.size() != 0) {
            s = this.getElem();
            if (!s.startsWith("=")) {
                this.err();
            }
            field.setConstantValue(s.substring(1).trim());
        }
        return field;
    }

    protected MemberDescription parse(SuperClass superCls, String def) {
        this.init(superCls, def);
        int n = this.elems.size();
        if (n == 0) {
            this.err();
        }
        superCls.setupGenericClassName((String)this.elems.get(n - 1));
        return superCls;
    }

    protected MemberDescription parse(SuperInterface superIntf, String def) {
        this.init(superIntf, def);
        int n = this.elems.size();
        if (n == 0) {
            this.err();
        }
        if ("@".equals(this.elems.get(0))) {
            superIntf.setDirect(true);
        }
        superIntf.setupGenericClassName((String)this.elems.get(n - 1));
        return superIntf;
    }

    protected MemberDescription parse(InnerDescr inner, String def) {
        this.init(inner, def);
        inner.setModifiers(Modifier.scanModifiers(this.elems));
        String s = this.getElem();
        int i = s.lastIndexOf(36);
        if (i < 0) {
            this.err();
        }
        inner.setupClassName(s);
        return inner;
    }

    private String getElem() {
        String s = null;
        if (this.elems.size() != 0) {
            s = (String)this.elems.get(0);
            this.elems.remove(0);
        }
        if (s == null) {
            this.err();
        }
        return s;
    }

    private void scanElems() {
        this.elems = new LinkedList();
        while (true) {
            if (this.idx < this.linesz && (this.chr = this.line.charAt(this.idx)) == ' ') {
                ++this.idx;
                continue;
            }
            if (this.idx >= this.linesz) break;
            int pos = this.idx++;
            if (this.chr == '=') {
                this.idx = this.linesz;
                this.elems.add(this.line.substring(pos));
                break;
            }
            if (this.chr == '(') {
                this.skip(')');
                ++this.idx;
                this.elems.add(this.line.substring(pos, this.idx));
                continue;
            }
            if (this.chr == '<') {
                ++this.idx;
                this.skip('>');
                ++this.idx;
                this.elems.add(this.line.substring(pos, this.idx));
                continue;
            }
            ++this.idx;
            while (this.idx < this.linesz) {
                this.chr = this.line.charAt(this.idx);
                if (this.chr == '<') {
                    ++this.idx;
                    this.skip('>');
                    ++this.idx;
                    continue;
                }
                if (this.chr == ' ' || this.chr == '(') break;
                ++this.idx;
            }
            this.elems.add(this.line.substring(pos, this.idx));
        }
    }

    private void skip(char term) {
        while (true) {
            if (this.idx >= this.linesz) {
                this.err();
            }
            if ((this.chr = this.line.charAt(this.idx)) == term) {
                return;
            }
            if (this.chr == '(') {
                ++this.idx;
                this.skip(')');
                ++this.idx;
                continue;
            }
            if (this.chr == '<') {
                ++this.idx;
                this.skip('>');
                ++this.idx;
                continue;
            }
            ++this.idx;
        }
    }

    void err() {
        throw new Error(this.line);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$tdk$signaturetest$sigfile$F31Parser == null ? (class$com$sun$tdk$signaturetest$sigfile$F31Parser = F31Parser.class$("com.sun.tdk.signaturetest.sigfile.F31Parser")) : class$com$sun$tdk$signaturetest$sigfile$F31Parser).desiredAssertionStatus();
    }
}

