/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.sigfile;

import com.sun.tdk.signaturetest.sigfile.F21Format;
import com.sun.tdk.signaturetest.sigfile.F31Format;
import com.sun.tdk.signaturetest.sigfile.F40Format;
import com.sun.tdk.signaturetest.sigfile.Format;
import com.sun.tdk.signaturetest.sigfile.Reader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FileManager {
    private static final String DEFAULT_PROTOCOL = "file:";
    private static Format defaultFormat;
    private static List formats;

    public static URL getURL(String testURL, String fileName) throws MalformedURLException {
        URL result;
        File f = new File(fileName);
        if (f.isAbsolute()) {
            result = f.toURL();
        } else {
            if (testURL.indexOf(58) == -1) {
                testURL = DEFAULT_PROTOCOL + testURL;
            }
            result = new URL(new URL(testURL), fileName);
        }
        return result;
    }

    private static String getFormat(URL fileURL) {
        String currentLine;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(fileURL.openStream(), "UTF8"));
            currentLine = in.readLine();
            if (currentLine == null) {
                return null;
            }
            currentLine = currentLine.trim();
            in.close();
        }
        catch (IOException e) {
            return null;
        }
        return currentLine;
    }

    public static Reader getReader(URL fileURL) {
        String format = FileManager.getFormat(fileURL);
        if (format != null) {
            Iterator it = formats.iterator();
            while (it.hasNext()) {
                Format f = (Format)it.next();
                if (!f.isApplicable(format)) continue;
                return f.getReader();
            }
        }
        return null;
    }

    public static Format getDefaultFormat() {
        return defaultFormat;
    }

    public static void addFormat(Format frm, boolean useByDefault) {
        formats.add(frm);
        if (useByDefault) {
            defaultFormat = frm;
        }
    }

    static {
        DEFAULT_PROTOCOL = DEFAULT_PROTOCOL;
        defaultFormat = new F40Format();
        formats = new ArrayList();
        formats.add(defaultFormat);
        formats.add(new F21Format());
        formats.add(new F31Format());
    }
}

