/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.util;

import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import com.sun.tdk.signaturetest.util.OptionInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommandLineParser {
    private Object servicedObject;
    private KnownOptions knownOptions;
    private Map decoders = new HashMap();
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$tdk$signaturetest$util$CommandLineParser == null ? (class$com$sun$tdk$signaturetest$util$CommandLineParser = CommandLineParser.class$("com.sun.tdk.signaturetest.util.CommandLineParser")) : class$com$sun$tdk$signaturetest$util$CommandLineParser);
    private Map foundOptions = new HashMap();
    static /* synthetic */ Class class$com$sun$tdk$signaturetest$util$CommandLineParser;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;

    public CommandLineParser(Object servicedObject, String optionPrefix) {
        this.servicedObject = servicedObject;
        this.knownOptions = new KnownOptions(optionPrefix);
    }

    public final void addOption(String option, OptionInfo info) {
        String temp = option;
        if (!info.isCaseSentitive()) {
            temp = option.toLowerCase();
        }
        this.knownOptions.add(temp, info);
    }

    public final void addOption(String option, OptionInfo info, String decoder) {
        String temp = option;
        if (!info.isCaseSentitive()) {
            temp = option.toLowerCase();
        }
        this.knownOptions.add(temp, info);
        this.decoders.put(temp, decoder);
    }

    public final void removeKnownOption(String option) {
        this.knownOptions.remove(option);
    }

    public void processArgs(String[] args) throws CommandLineParserException {
        this.foundOptions.clear();
        String optionStr = null;
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (this.knownOptions.isKnownOption(arg)) {
                OptionInfo ki = this.knownOptions.get(arg);
                optionStr = ki.toKey(arg);
                ArrayList params = (ArrayList)this.foundOptions.get(optionStr);
                if (params == null) {
                    this.foundOptions.put(optionStr, new ArrayList());
                } else if (!ki.isMultiple()) {
                    throw new CommandLineParserException(i18n.getString("CommandLineParser.error.option.duplicate", optionStr));
                }
            } else if (!this.knownOptions.isOption(arg)) {
                if (optionStr != null) {
                    ((List)this.foundOptions.get(optionStr)).add(arg);
                }
            } else {
                throw new CommandLineParserException(i18n.getString("CommandLineParser.error.option.unknown", arg));
            }
            ++i;
        }
        this.knownOptions.validate(this.foundOptions);
        Iterator it = this.foundOptions.keySet().iterator();
        while (it.hasNext()) {
            String foundOption = (String)it.next();
            this.invokeDecoder(foundOption, (ArrayList)this.foundOptions.get(foundOption));
        }
    }

    public boolean isOptionSpecified(String arg, String checkedOption) {
        return this.knownOptions.isOption(arg) && checkedOption.equalsIgnoreCase(arg);
    }

    public boolean isOptionSpecified(String option) {
        if (!this.knownOptions.isKnownOption(option)) {
            throw new IllegalArgumentException(i18n.getString("CommandLineParser.error.option.unknown", option));
        }
        OptionInfo ki = this.knownOptions.get(option);
        String temp = ki.toKey(option);
        return this.foundOptions.get(temp) != null;
    }

    private void invokeDecoder(String option, ArrayList params) throws CommandLineParserException {
        String decoder = (String)this.decoders.get(option);
        if (decoder != null) {
            this.invokeExplicitDecoder(decoder, option, params);
        } else {
            this.invokeDefaultDecoder(option, params);
        }
    }

    private void invokeExplicitDecoder(String decoder, String option, ArrayList params) throws CommandLineParserException {
        Class<?> cl = this.servicedObject.getClass();
        String[] stemp = new String[params.size()];
        int i = 0;
        while (i < params.size()) {
            stemp[i] = (String)params.get(i);
            ++i;
        }
        try {
            Method method = cl.getMethod(decoder, class$java$lang$String == null ? (class$java$lang$String = CommandLineParser.class$("java.lang.String")) : class$java$lang$String, array$Ljava$lang$String == null ? (array$Ljava$lang$String = CommandLineParser.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            method.invoke(this.servicedObject, option, stemp);
        }
        catch (NoSuchMethodException nsme) {
            throw new CommandLineParserException(i18n.getString("CommandLineParser.error.decoder.explicit.notfound", new Object[]{decoder, option, cl.getName()}), nsme);
        }
        catch (InvocationTargetException e) {
            Throwable th = e.getTargetException();
            String message = th instanceof CommandLineParserException ? th.getMessage() : i18n.getString("CommandLineParser.error.decoder.failed", new Object[]{option, th});
            throw new CommandLineParserException(message);
        }
        catch (Exception e) {
            throw new CommandLineParserException(i18n.getString("CommandLineParser.error.decoder.failed", new Object[]{option, e}));
        }
    }

    private void invokeDefaultDecoder(String option, ArrayList params) throws CommandLineParserException {
        try {
            String[] stemp = new String[params.size()];
            int i = 0;
            while (i < params.size()) {
                stemp[i] = (String)params.get(i);
                ++i;
            }
            this.getDefaultDecoderMethod(option).invoke(this.servicedObject, new Object[]{stemp});
        }
        catch (Exception e) {
            throw new CommandLineParserException(i18n.getString("CommandLineParser.error.decoder.failed", new Object[]{option, e}));
        }
    }

    private boolean isDecoder(Method method, String option) {
        String methodName = "decode" + option;
        return method.getName().equalsIgnoreCase(methodName) && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].isAssignableFrom(array$Ljava$lang$String == null ? (array$Ljava$lang$String = CommandLineParser.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
    }

    private Method getDefaultDecoderMethod(String option) throws CommandLineParserException {
        Method m = this.getDefaultDecoderMethod(this.servicedObject.getClass().getMethods(), option);
        if (m == null) {
            throw new CommandLineParserException(i18n.getString("CommandLineParser.error.decoder.default.notfound", new Object[]{option, this.servicedObject.getClass().getName()}));
        }
        return m;
    }

    private Method getDefaultDecoderMethod(Method[] methods, String option) {
        int i = 0;
        while (i < methods.length) {
            if (this.isDecoder(methods[i], option)) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class KnownOptions {
        private Map data = new HashMap();
        private final String optionPrefix;

        public KnownOptions(String optionPrefix) {
            this.optionPrefix = optionPrefix;
        }

        private boolean isKnownOption(String arg) {
            if (this.isOption(arg)) {
                String temp = arg;
                if (!this.data.containsKey(temp)) {
                    OptionInfo ki = (OptionInfo)this.data.get(temp = temp.toLowerCase());
                    if (ki != null) {
                        return !ki.isCaseSentitive();
                    }
                } else {
                    return true;
                }
            }
            return false;
        }

        private void add(String option, OptionInfo info) {
            if (!option.startsWith(this.optionPrefix)) {
                throw new IllegalArgumentException(i18n.getString("CommandLineParser.error.option.noprefix", this.optionPrefix));
            }
            this.data.put(option, info);
        }

        private void remove(String option) {
            this.data.remove(option);
        }

        private OptionInfo get(String option) {
            String temp = option;
            OptionInfo ki = (OptionInfo)this.data.get(temp);
            if (ki == null && ((ki = (OptionInfo)this.data.get(temp = temp.toLowerCase())) == null || ki.isCaseSentitive())) {
                return null;
            }
            return ki;
        }

        private void validateRequiredOptions(Set foundKeys) throws CommandLineParserException {
            Set keySet = this.data.keySet();
            Iterator it = keySet.iterator();
            while (it.hasNext()) {
                String option = (String)it.next();
                OptionInfo ki = (OptionInfo)this.data.get(option);
                if (!ki.isRequired() || foundKeys.contains(option)) continue;
                throw new CommandLineParserException(i18n.getString("CommandLineParser.error.option.required", option));
            }
        }

        private void validateCount(String option, int paramCount) throws CommandLineParserException {
            OptionInfo info = (OptionInfo)this.data.get(option);
            int minCount = info.getMinCount();
            int maxCount = info.getMaxCount();
            if (paramCount < minCount) {
                throw new CommandLineParserException(i18n.getString("CommandLineParser.error.option.require_more_parameters", new Object[]{option, new Integer(minCount)}));
            }
            if (paramCount > maxCount) {
                String msg = i18n.getString("CommandLineParser.error.option.require_less_parameters", new Object[]{option, new Integer(maxCount)});
                if (maxCount == 0) {
                    msg = i18n.getString("CommandLineParser.error.option.require_no_parameters", option);
                }
                throw new CommandLineParserException(msg);
            }
        }

        private void validate(Map params) throws CommandLineParserException {
            this.validateRequiredOptions(params.keySet());
            Iterator it = params.keySet().iterator();
            while (it.hasNext()) {
                String option = (String)it.next();
                this.validateCount(option, ((List)params.get(option)).size());
            }
        }

        public boolean isOption(String arg) {
            return arg.startsWith(this.optionPrefix);
        }
    }
}

