/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class AnnotationItem
implements Comparable {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$tdk$signaturetest$model$AnnotationItem == null ? (class$com$sun$tdk$signaturetest$model$AnnotationItem = AnnotationItem.class$("com.sun.tdk.signaturetest.model.AnnotationItem")) : class$com$sun$tdk$signaturetest$model$AnnotationItem);
    public static final String ANNOTATION_PREFIX = "anno";
    public static final String ANNOTATION_INHERITED = "java.lang.annotation.Inherited";
    public static final String ANNOTATION_DOCUMENTED = "java.lang.annotation.Documented";
    private static final String CLASS_PREFIX = "java.lang.Class";
    public static final AnnotationItem[] EMPTY_ANNOTATIONITEM_ARRAY;
    private int target;
    private boolean inheritable = false;
    private String name;
    private SortedSet members = null;
    static /* synthetic */ Class class$com$sun$tdk$signaturetest$model$AnnotationItem;

    public AnnotationItem(int target, String name) {
        this.setTarget(target);
        this.setName(name);
    }

    private AnnotationItem() {
    }

    public int compareTo(Object o) {
        AnnotationItem that = (AnnotationItem)o;
        int diff = this.target - that.target;
        if (diff == 0 && (diff = this.name.compareTo(that.name)) == 0) {
            if (this.members == that.members) {
                return 0;
            }
            if (this.members == null) {
                return -1;
            }
            if (that.members == null) {
                return 1;
            }
            diff = this.members.size() - that.members.size();
            if (diff == 0) {
                Iterator it = this.members.iterator();
                Iterator that_it = that.members.iterator();
                while (it.hasNext() && diff == 0) {
                    Member m = (Member)it.next();
                    diff = m.compareTo(that_it.next());
                }
            }
        }
        return diff;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.intern();
    }

    public int getTarget() {
        return this.target;
    }

    public void setTarget(int t) {
        this.target = t;
    }

    public void addMember(Member m) {
        if (this.members == null) {
            this.members = new TreeSet();
        }
        this.members.add(m);
    }

    public boolean isInheritable() {
        return this.inheritable;
    }

    public void removeMember(Member m) {
        this.members.remove(m);
    }

    public Member findByName(String name) {
        if (this.members != null) {
            Iterator it = this.members.iterator();
            while (it.hasNext()) {
                Member m = (Member)it.next();
                if (!m.name.equals(name)) continue;
                return m;
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(ANNOTATION_PREFIX).append(" ").append(this.target).append(" ");
        sb.append(this.name).append('(');
        int i = 0;
        if (this.members != null) {
            Iterator it = this.members.iterator();
            while (it.hasNext()) {
                Member m = (Member)it.next();
                if (i++ != 0) {
                    sb.append(", ");
                }
                sb.append(m.type).append(' ').append(m.name).append("=");
                sb.append(m.value);
            }
        }
        sb.append(')');
        return sb.toString();
    }

    public static AnnotationItem parse(String str) {
        AnnotationItem item = new AnnotationItem();
        if (!str.startsWith(ANNOTATION_PREFIX)) {
            throw new IllegalArgumentException(i18n.getString("AnnotationItem.error.bad_annotation_descr") + str);
        }
        int pos = str.indexOf(32);
        str = str.substring(pos).trim();
        pos = str.indexOf(32);
        item.setTarget(Integer.valueOf(str.substring(0, pos)));
        str = str.substring(pos + 1);
        pos = str.indexOf(40);
        item.setName(str.substring(0, pos).trim());
        str = str.substring(pos + 1, str.lastIndexOf(41));
        if (str.length() != 0) {
            while (str.length() > 0 && str.charAt(0) != ')') {
                pos = AnnotationItem.parseMember(item, str);
                if ((str = str.substring(pos)).length() <= 0 || str.charAt(0) != ',') continue;
                str = str.substring(1).trim();
            }
        }
        return item;
    }

    private static int parseMember(AnnotationItem item, String str) {
        int result = 0;
        Member m = new Member();
        int pos = str.indexOf(32);
        if (str.startsWith("java.lang.Class<")) {
            char[] strChar = str.toCharArray();
            int level = 0;
            int i = CLASS_PREFIX.length();
            while (i < strChar.length) {
                if (strChar[i] == '<') {
                    ++level;
                } else if (strChar[i] == '>') {
                    --level;
                }
                if (level == 0 && strChar[i + 1] == ' ') {
                    pos = i + 1;
                    break;
                }
                ++i;
            }
        }
        m.type = str.substring(0, pos);
        str = str.substring(pos + 1).trim();
        result += pos + 1;
        pos = str.indexOf(61);
        m.name = str.substring(0, pos);
        str = str.substring(pos + 1).trim();
        result += pos + 1;
        char ch = str.charAt(0);
        switch (ch) {
            case '[': {
                pos = AnnotationItem.findClosingBracket(str, 1, '[', ']') + 1;
                break;
            }
            case '\"': 
            case '\'': {
                pos = str.indexOf(ch, 1) + 1;
                break;
            }
            case 'a': {
                if (str.startsWith(ANNOTATION_PREFIX)) {
                    AnnotationItem a = AnnotationItem.parse(str);
                    pos = a.toString().length();
                    break;
                }
            }
            default: {
                pos = str.indexOf(44);
                if (pos == -1) {
                    pos = str.indexOf(41);
                }
                if (pos != -1) break;
                pos = str.length();
            }
        }
        m.value = str.substring(0, pos);
        item.addMember(m);
        return result += pos;
    }

    private static int findClosingBracket(String str, int startPos, char openingChar, char closingChar) {
        int level = 0;
        int len = str.length();
        int i = startPos;
        while (i < len) {
            char ch = str.charAt(i);
            if (ch == openingChar) {
                ++level;
            } else if (ch == closingChar) {
                if (level == 0) {
                    return i;
                }
                --level;
            }
            ++i;
        }
        return -1;
    }

    public void setInheritable(boolean inh) {
        this.inheritable = inh;
    }

    public static AnnotationItem[] toArray(List alist) {
        if (alist == null || alist.size() == 0) {
            return EMPTY_ANNOTATIONITEM_ARRAY;
        }
        int asize = alist.size();
        AnnotationItem[] tmp = new AnnotationItem[asize];
        int i = 0;
        while (i < asize) {
            tmp[i] = (AnnotationItem)alist.get(i);
            ++i;
        }
        return tmp;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ANNOTATION_PREFIX = ANNOTATION_PREFIX;
        ANNOTATION_INHERITED = ANNOTATION_INHERITED;
        ANNOTATION_DOCUMENTED = ANNOTATION_DOCUMENTED;
        CLASS_PREFIX = CLASS_PREFIX;
        EMPTY_ANNOTATIONITEM_ARRAY = new AnnotationItem[0];
    }

    public static class ValueWrap {
        String value;

        public ValueWrap(String s) {
            this.value = s;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class Member
    implements Comparable {
        String type;
        String name;
        String value;

        public Member(String type, String name, Object value) {
            this.type = type;
            this.name = name;
            this.setValue(value);
        }

        public Member(String name, Object value) {
            this.name = name;
            this.setValue(value);
        }

        private Member() {
        }

        public int compareTo(Object x) {
            Member that = (Member)x;
            int result = 0;
            if (this.type != null && that.type != null) {
                result = this.type.compareTo(that.type);
            } else if (this.type != that.type) {
                result = this.type == null ? -1 : 1;
            }
            if (result == 0 && (result = this.name.compareTo(that.name)) == 0) {
                result = this.value.compareTo(that.value);
            }
            return result;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setValue(Object value) {
            this.value = value == null ? null : MemberDescription.valueToString(value);
        }
    }
}

