/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.model.AnnotationItem;

public class AnnotationItemEx
extends AnnotationItem {
    public static final String ANNOTATION_EX_PREFIX = "annoEx";
    private int targetType;
    private int[] locations;
    private int parameterIndex;
    private int boundIndex;
    private int typeIndex;
    public static final int TARGET_METHOD_RECEIVER = 6;
    public static final int TARGET_METHOD_RETURN_TYPE_GENERIC_ARRAY = 11;
    public static final int TARGET_METHOD_PARAMETER_GENERIC_ARRAY = 13;
    public static final int TARGET_FIELD_GENERIC_ARRAY = 15;
    public static final int TARGET_CLASS_TYPE_PARAMETER_BOUND = 16;
    public static final int TARGET_CLASS_TYPE_PARAMETER_BOUND_GENERIC_ARRAY = 17;
    public static final int TARGET_METHOD_TYPE_PARAMETER_BOUND = 18;
    public static final int TARGET_METHOD_TYPE_PARAMETER_BOUND_GENERIC_ARRAY = 19;
    public static final int TARGET_CLASS_EXTENDS_IMPLEMENTS = 20;
    public static final int TARGET_CLASS_EXTENDS_IMPLEMENTS_GENERIC_ARRAY = 21;
    public static final int TARGET_EXCEPTION_TYPE_IN_THROWS = 22;
    public static final int TARGET_WILDCARD_BOUND = 28;
    public static final int TARGET_WILDCARD_BOUND_GENERIC_ARRAY = 29;
    public static final int TARGET_METHOD_TYPE_PARAMETER = 32;
    public static final int TARGET_CLASS_TYPE_PARAMETER = 34;
    public static final int TARGET_TYPECAST = 0;
    public static final int TARGET_TYPECAST_GENERIC_ARRAY = 1;
    public static final int TARGET_TYPE_TEST = 2;
    public static final int TARGET_TYPE_TEST_GENERIC_ARRAY = 3;
    public static final int TARGET_OBJECT_CREATION = 4;
    public static final int TARGET_OBJECT_CREATION_GENERIC_ARRAY = 5;
    public static final int TARGET_LOCAL_VARIABLE = 8;
    public static final int TARGET_LOCAL_VARIABLE_GENERIC_ARRAY = 9;
    public static final int TARGET_TYPE_ARGUMENT_IN_CONSTRUCTOR_CALL = 24;
    public static final int TARGET_TYPE_ARGUMENT_IN_CONSTRUCTOR_CALL_GENERIC_ARRAY = 25;
    public static final int TARGET_TYPE_ARGUMENT_IN_METHOD_CALL = 26;
    public static final int TARGET_TYPE_ARGUMENT_IN_METHOD_CALL_GENERIC_ARRAY = 27;
    public static final int TARGET_CLASS_LITERAL = 30;
    public static final int TARGET_CLASS_LITERAL_GENERIC_ARRAY = 31;
    public static final String ANN_TARGET_TYPE = "type";
    public static final String ANN_TYPE_IND = "typeIndex";
    public static final String ANN_BOUND_IND = "boundIndex";
    public static final String ANN_LOCATIONS = "locations";
    public static final String ANN_PARAM_IND = "parameterIndex";

    public AnnotationItemEx(int n, String string) {
        super(n, string);
    }

    public AnnotationItemEx() {
    }

    public int getTargetType() {
        return this.targetType;
    }

    public AnnotationItemEx setTargetType(int n) {
        this.targetType = n;
        return this;
    }

    public int[] getLocations() {
        return this.locations;
    }

    public AnnotationItemEx setLocations(int[] nArray) {
        this.locations = nArray;
        return this;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public AnnotationItemEx setParameterIndex(int n) {
        this.parameterIndex = n;
        return this;
    }

    public int getBoundIndex() {
        return this.boundIndex;
    }

    public AnnotationItemEx setBoundIndex(int n) {
        this.boundIndex = n;
        return this;
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public AnnotationItemEx setTypeIndex(int n) {
        this.typeIndex = n;
        return this;
    }

    protected String getSpecificData() {
        StringBuffer stringBuffer = new StringBuffer();
        this.addTargetType(stringBuffer);
        switch (this.targetType) {
            case 11: 
            case 15: {
                this.addLocations(stringBuffer);
                break;
            }
            case 13: {
                this.addParameterInd(stringBuffer);
                this.addLocations(stringBuffer);
                break;
            }
            case 16: 
            case 18: {
                this.addParameterInd(stringBuffer);
                this.addBoundInd(stringBuffer);
                break;
            }
            case 17: 
            case 19: {
                this.addParameterInd(stringBuffer);
                this.addBoundInd(stringBuffer);
                this.addLocations(stringBuffer);
                break;
            }
            case 20: 
            case 22: {
                this.addTypeInd(stringBuffer);
                break;
            }
            case 21: {
                this.addTypeInd(stringBuffer);
                this.addLocations(stringBuffer);
                break;
            }
            case 32: 
            case 34: {
                this.addParameterInd(stringBuffer);
            }
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void addTargetType(StringBuffer stringBuffer) {
        stringBuffer.append("[type=" + this.intToHex(this.targetType) + ";");
    }

    private void addTypeInd(StringBuffer stringBuffer) {
        stringBuffer.append("typeIndex=" + this.typeIndex + ";");
    }

    private void addBoundInd(StringBuffer stringBuffer) {
        stringBuffer.append("boundIndex=" + this.boundIndex + ";");
    }

    private void addLocations(StringBuffer stringBuffer) {
        stringBuffer.append("locations=" + this.arrayToString(this.locations) + ";");
    }

    private void addParameterInd(StringBuffer stringBuffer) {
        stringBuffer.append("parameterIndex=" + this.parameterIndex + ";");
    }

    private String intToHex(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        if (string.length() == 1) {
            string = "0" + string;
        }
        return "0x" + string;
    }

    private String arrayToString(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        int n = nArray.length - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        int n2 = 0;
        while (true) {
            stringBuffer.append(nArray[n2]);
            if (n2 == n) {
                return stringBuffer.append(']').toString();
            }
            stringBuffer.append(",");
            ++n2;
        }
    }

    protected String getPrefix() {
        return ANNOTATION_EX_PREFIX;
    }
}

