/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.core.PrimitiveTypes;
import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.ExoticCharTools;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.Modifier;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Set;

public abstract class MemberDescription
implements Cloneable,
Serializable {
    public static final String EMPTY_THROW_LIST = "";
    public static final String NO_ARGS = "";
    public static final String NO_TYPE = "";
    public static final String NO_DECLARING_CLASS = "";
    public static final String THROWS_DELIMITER = ",";
    public static final String ARGS_DELIMITER = ",";
    public static final char CLASS_DELIMITER = '$';
    public static final char MEMBER_DELIMITER = '.';
    protected final char delimiter;
    private int modifiers = 0;
    String typeParameters;
    String type = "";
    String declaringClass = "";
    String args = "";
    String throwables = "";
    private AnnotationItem[] annoList = AnnotationItem.EMPTY_ANNOTATIONITEM_ARRAY;
    MemberType memberType;
    String name = "";
    private boolean marked = false;

    protected MemberDescription(MemberType memberType, char c) {
        this.memberType = memberType;
        this.delimiter = c;
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    public int hashCode() {
        return this.memberType.hashCode() + this.name.hashCode();
    }

    public MemberType getMemberType() {
        return this.memberType;
    }

    public String getName() {
        return this.name;
    }

    public boolean isClass() {
        return false;
    }

    public boolean isSuperClass() {
        return false;
    }

    public boolean isSuperInterface() {
        return false;
    }

    public boolean isField() {
        return false;
    }

    public boolean isMethod() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isInner() {
        return false;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getType() {
        return this.type;
    }

    public String getTypeParameters() {
        return this.typeParameters;
    }

    public void setupGenericClassName(String string, String string2) {
        int n = string.indexOf(60);
        String string3 = string;
        if (n != -1) {
            string3 = string.substring(0, n);
            this.typeParameters = string.substring(n);
        } else {
            this.typeParameters = null;
        }
        this.setupClassName(string3, string2);
    }

    public void setupGenericClassName(String string) {
        int n = string.indexOf(60);
        String string2 = string;
        if (n != -1) {
            string2 = string.substring(0, n);
            this.typeParameters = string.substring(n);
        } else {
            this.typeParameters = null;
        }
        this.setupClassName(string2);
    }

    public void setupClassName(String string, String string2) {
        string = ExoticCharTools.encodeExotic(string);
        string2 = ExoticCharTools.encodeExotic(string2);
        if (this.memberType == MemberType.CLASS || this.memberType == MemberType.SUPERCLASS || this.memberType == MemberType.SUPERINTERFACE) {
            this.name = string.intern();
        } else {
            if (!string2.equals("") && string.startsWith(string2) && !string2.equals(string)) {
                this.name = string.substring(string2.length());
                if (this.name.charAt(0) == this.delimiter) {
                    this.name = this.name.substring(1);
                }
            } else {
                this.name = string;
            }
            this.name = this.name.intern();
        }
        this.declaringClass = !string2.equals("") && !string2.equals(string) ? string2.intern() : "";
    }

    public void setupClassName(String string) {
        string = ExoticCharTools.encodeExotic(string);
        int n = string.lastIndexOf(this.delimiter);
        if (this.memberType == MemberType.CLASS || this.memberType == MemberType.SUPERCLASS || this.memberType == MemberType.SUPERINTERFACE) {
            this.name = string.intern();
            this.declaringClass = n != -1 ? string.substring(0, n).intern() : "";
        } else {
            if (n >= 0) {
                this.declaringClass = string.substring(0, n).intern();
            }
            this.name = string.substring(n + 1).intern();
        }
    }

    public void setupInnerClassName(String string, String string2) {
        this.declaringClass = string2.intern();
        this.name = string.intern();
    }

    public void setupMemberName(String string, String string2) {
        this.declaringClass = string2.intern();
        string = ExoticCharTools.encodeExotic(string);
        this.name = string.intern();
    }

    public void setupMemberName(String string) {
        int n = string.lastIndexOf(this.delimiter);
        this.declaringClass = string.substring(0, n).intern();
        this.name = string.substring(n + 1).intern();
    }

    public String getDeclaringClassName() {
        return this.declaringClass;
    }

    public AnnotationItem[] getAnnoList() {
        return this.annoList;
    }

    public String getQualifiedName() {
        return this.declaringClass + this.delimiter + this.name;
    }

    public String getThrowables() {
        return this.throwables;
    }

    public void mark() {
        this.marked = true;
    }

    public void unmark() {
        this.marked = false;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public boolean isProtected() {
        return Modifier.hasModifier(this.modifiers, Modifier.PROTECTED);
    }

    public boolean isPublic() {
        return Modifier.hasModifier(this.modifiers, Modifier.PUBLIC);
    }

    public boolean isPrivate() {
        return Modifier.hasModifier(this.modifiers, Modifier.PRIVATE);
    }

    public boolean isAbstract() {
        return Modifier.hasModifier(this.modifiers, Modifier.ABSTRACT);
    }

    public boolean isStatic() {
        return Modifier.hasModifier(this.modifiers, Modifier.STATIC);
    }

    public boolean isFinal() {
        return Modifier.hasModifier(this.modifiers, Modifier.FINAL);
    }

    public boolean isInterface() {
        return Modifier.hasModifier(this.modifiers, Modifier.INTERFACE);
    }

    public static String valueToString(Object object) {
        if (object == null) {
            return "";
        }
        if (object.getClass().isArray()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            int n = Array.getLength(object);
            int n2 = 0;
            while (n2 < n) {
                if (n2 != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(MemberDescription.valueToString(Array.get(object, n2)));
                ++n2;
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
        if (object instanceof Character) {
            return "'" + MemberDescription.stuffOut(object.toString()) + "'";
        }
        if (object instanceof String) {
            return "\"" + MemberDescription.stuffOut(object.toString()) + "\"";
        }
        if (object instanceof Long) {
            return object.toString();
        }
        if (object instanceof Float) {
            Float f = (Float)object;
            return f.toString();
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            return d.toString();
        }
        return object.toString();
    }

    private static String stuffOut(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (' ' <= c && c <= '~' && c != '\"' && c != '\\') {
                stringBuffer.append(c);
            } else if (c == '\r') {
                stringBuffer.append("\\r");
            } else if (c == '\n') {
                stringBuffer.append("\\n");
            } else {
                stringBuffer.append(MemberDescription.esc(c));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String esc(char c) {
        String string = Integer.toHexString(c);
        int n = string.length();
        if (n == 1) {
            return "\\u000" + string;
        }
        if (n == 2) {
            return "\\u00" + string;
        }
        if (n == 3) {
            return "\\u0" + string;
        }
        return "\\u" + string;
    }

    public void setModifiers(int n) {
        int n2 = this.memberType.getModifiersMask();
        if ((n & n2) != n) {
            throw new ClassFormatError("Unknown modifier(s) found " + (n & ~n2));
        }
        this.modifiers = n;
        if (Modifier.hasModifier(this.modifiers, Modifier.INTERFACE)) {
            this.modifiers = Modifier.addModifier(this.modifiers, Modifier.ABSTRACT);
        }
    }

    public void addModifier(Modifier modifier) {
        this.modifiers = Modifier.addModifier(this.modifiers, modifier);
    }

    public void removeModifier(Modifier modifier) {
        this.modifiers = Modifier.removeModifier(this.modifiers, modifier);
    }

    public static String getTypeName(Class clazz) {
        String string = clazz.getName();
        if (!string.startsWith("[")) {
            return string;
        }
        return MemberDescription.getTypeName(string);
    }

    public static String getTypeName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (string.charAt(n) == '[') {
            ++n;
        }
        String string2 = string.charAt(n) == 'L' ? string.substring(n + 1, string.length() - 1) : PrimitiveTypes.getPrimitiveType(string.charAt(n));
        stringBuffer.append(string2);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("[]");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String getArgs() {
        return this.args;
    }

    public boolean setType(String string) {
        if (this.type.equals(string)) {
            return false;
        }
        this.type = string.intern();
        return true;
    }

    public boolean setArgs(String string) {
        if (this.args.equals(string)) {
            return false;
        }
        this.args = string.indexOf(",") == -1 ? string.intern() : string;
        return true;
    }

    public boolean setThrowables(String string) {
        if (this.throwables.equals(string)) {
            return false;
        }
        this.throwables = string.indexOf(",") == -1 ? string.intern() : string;
        return true;
    }

    public void setAnnoList(AnnotationItem[] annotationItemArray) {
        this.annoList = annotationItemArray;
        if (annotationItemArray.length > 1) {
            Arrays.sort(this.annoList);
        }
    }

    public void setTypeParameters(String string) {
        this.typeParameters = string;
    }

    public void setDeclaringClass(String string) {
        if (string == null || "".equals(string)) {
            throw new IllegalArgumentException();
        }
        this.declaringClass = string.intern();
    }

    public void setNoDeclaringClass() {
        this.declaringClass = "";
    }

    public static String getThrows(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        if (stringArray.length > 1) {
            Arrays.sort(stringArray);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean hasModifier(Modifier modifier) {
        return Modifier.hasModifier(this.modifiers, modifier);
    }

    public abstract boolean isCompatible(MemberDescription var1);

    protected void populateDependences(Set set) {
    }

    protected void addDependency(Set set, String string) {
        if (string.charAt(0) == '{') {
            return;
        }
        String string2 = string;
        int n = string2.indexOf(60);
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        if ((n = string2.indexOf(91)) != -1) {
            string2 = string2.substring(0, n);
        }
        if (PrimitiveTypes.isPrimitive(string)) {
            return;
        }
        set.add(string2);
    }

    protected static String getClassShortName(String string) {
        String string2 = string;
        int n = Math.max(string.lastIndexOf(46), string.lastIndexOf(36));
        if (n != -1) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.memberType = MemberType.getItemType(this.memberType.toString());
        this.setupMemberName(this.name, this.declaringClass);
        this.setArgs(this.args);
        this.setThrowables(this.throwables);
    }
}

