/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.MemberDescription;
import java.util.ArrayList;
import java.util.List;

public class PackageDescr {
    private List classes;
    private List subpackages;
    private String fqname;
    private String name = "";

    public String getQualifiedName() {
        return this.fqname;
    }

    public String getName() {
        return this.name;
    }

    public PackageDescr(String string) {
        this.fqname = string;
        this.name = string.lastIndexOf(".") > 0 ? string.substring(string.lastIndexOf(".") + 1) : string;
        this.classes = new ArrayList();
        this.subpackages = new ArrayList();
    }

    public void add(ClassDescription classDescription) {
        int n = 0;
        while (n < this.classes.size()) {
            if (((ClassDescription)this.classes.get(n)).getQualifiedName().compareTo(classDescription.getQualifiedName()) > 0) {
                this.classes.add(n, classDescription);
                return;
            }
            ++n;
        }
        this.classes.add(classDescription);
    }

    public void add(PackageDescr packageDescr) {
        int n = 0;
        while (n < this.subpackages.size()) {
            if (((PackageDescr)this.subpackages.get(n)).getQualifiedName().compareTo(packageDescr.getQualifiedName()) > 0) {
                this.subpackages.add(n, packageDescr);
                return;
            }
            ++n;
        }
        this.subpackages.add(packageDescr);
    }

    public void addAll(List list) {
        this.classes.addAll(list);
    }

    public void clear() {
        this.classes.clear();
    }

    public List getDeclaredClasses() {
        return this.classes;
    }

    public List getDeclaredPackages() {
        return this.subpackages;
    }

    public String toString() {
        return this.fqname;
    }

    public boolean equals(Object object) {
        return object instanceof PackageDescr && this.fqname.equals(((PackageDescr)object).getQualifiedName());
    }

    public int hashCode() {
        int n = 7;
        n = 59 * n + (this.fqname != null ? this.fqname.hashCode() : 0);
        return n;
    }

    public boolean isCompatible(MemberDescription memberDescription) {
        return this.equals(memberDescription);
    }
}

