/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.aether;

import com.sun.tdk.signaturetest.SigTest;
import com.sun.tdk.signaturetest.core.ClassDescriptionLoader;
import com.sun.tdk.signaturetest.loaders.LoadingHints;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.MemberCollection;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.plugin.Filter;
import com.sun.tdk.signaturetest.plugin.FormatAdapter;
import com.sun.tdk.signaturetest.plugin.PluginAPI;
import com.sun.tdk.signaturetest.plugin.Transformer;
import com.sun.tdk.signaturetest.sigfile.FeaturesHolder;
import com.sun.tdk.signaturetest.sigfile.Format;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

class MUtil {
    static Logger logger = Logger.getLogger(MUtil.class.getName());
    private static Filter emptyFilter = new Filter(){

        public boolean accept(ClassDescription classDescription) {
            return true;
        }
    };
    private static Transformer emptyTransformer = new Transformer(){

        public ClassDescription transform(ClassDescription classDescription) throws ClassNotFoundException {
            return classDescription;
        }
    };
    private static Transformer cleanTransformer = new Transformer(){

        public ClassDescription transform(ClassDescription classDescription) {
            MemberCollection memberCollection = new MemberCollection();
            Iterator iterator = classDescription.getMembersIterator();
            while (iterator.hasNext()) {
                MemberDescription memberDescription = (MemberDescription)iterator.next();
                if (!memberDescription.getDeclaringClassName().equals(classDescription.getQualifiedName())) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("Member removed: " + memberDescription);
                    continue;
                }
                memberCollection.addMember(memberDescription);
            }
            classDescription.setMembers(memberCollection);
            return classDescription;
        }
    };

    MUtil() {
    }

    void initFormat(SigTest sigTest) {
        FormatAdapter formatAdapter = new FormatAdapter("#Aether file v4.1");
        formatAdapter.removeSupportedFeature(FeaturesHolder.ListOfHiders);
        sigTest.setFormat((Format)formatAdapter);
    }

    static void setUpLoader(ClassDescriptionLoader classDescriptionLoader) {
        if (classDescriptionLoader instanceof LoadingHints) {
            LoadingHints loadingHints = (LoadingHints)classDescriptionLoader;
            loadingHints.addLoadingHint(LoadingHints.READ_BRIDGE);
            loadingHints.addLoadingHint(LoadingHints.READ_SYNTETHIC);
            loadingHints.addLoadingHint(LoadingHints.READ_ANY_ANNOTATIONS);
        }
    }

    static {
        PluginAPI.IS_CLASS_ACCESSIBLE.setFilter(emptyFilter);
        PluginAPI.AFTER_BUILD_MEMBERS.setTransformer(cleanTransformer);
        PluginAPI.CLASS_CORRECTOR.setTransformer(emptyTransformer);
        Modifier.ACC_SYNTHETIC.setTracked(true);
        Modifier.BRIDGE.setTracked(true);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Initialized");
        }
    }
}

