/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.core;

public class PrimitiveTypes {
    private static Pair[] types = new Pair[]{new Pair('Z', "boolean"), new Pair('V', "void"), new Pair('I', "int"), new Pair('J', "long"), new Pair('C', "char"), new Pair('B', "byte"), new Pair('D', "double"), new Pair('S', "short"), new Pair('F', "float")};

    private PrimitiveTypes() {
    }

    public static boolean isPrimitive(String string) {
        int n = 0;
        while (n < types.length) {
            if (PrimitiveTypes.types[n].JLSNotation.equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static String getPrimitiveType(char c) {
        int n = 0;
        while (n < types.length) {
            if (c == PrimitiveTypes.types[n].VMNotation) {
                return PrimitiveTypes.types[n].JLSNotation;
            }
            ++n;
        }
        return null;
    }

    public static String getVMPrimitiveType(String string) {
        int n = 0;
        while (n < types.length) {
            if (PrimitiveTypes.types[n].JLSNotation.equals(string)) {
                return String.valueOf(PrimitiveTypes.types[n].VMNotation);
            }
            ++n;
        }
        return null;
    }

    private static class Pair {
        char VMNotation;
        String JLSNotation;

        Pair(char c, String string) {
            this.VMNotation = c;
            this.JLSNotation = string;
        }
    }
}

