/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.util.Set;

public final class FieldDescr
extends MemberDescription {
    private static boolean isConstantValuesTracked = true;
    public static final FieldDescr[] EMPTY_ARRAY = new FieldDescr[0];
    private String constantValue;

    public static void setConstantValuesTracked(boolean bl) {
        isConstantValuesTracked = bl;
    }

    public FieldDescr() {
        super(MemberType.FIELD, '.');
    }

    public FieldDescr(String string, String string2, int n) {
        super(MemberType.FIELD, '.');
        this.setupMemberName(string, string2);
        this.setModifiers(n);
    }

    public boolean isField() {
        return true;
    }

    public boolean isConstant() {
        return this.isFinal() && this.constantValue != null;
    }

    public void setConstantValue(String string) {
        this.constantValue = string;
    }

    public String getConstantValue() {
        return this.constantValue;
    }

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("field");
        String string2 = Modifier.toString(this.memberType, this.getModifiers(), true);
        if (string2.length() != 0) {
            stringBuffer.append(' ');
            stringBuffer.append(string2);
        }
        if (this.type.length() != 0) {
            stringBuffer.append(' ');
            stringBuffer.append(this.type);
        }
        stringBuffer.append(' ');
        stringBuffer.append(this.declaringClass);
        stringBuffer.append(this.delimiter);
        stringBuffer.append(this.name);
        if (this.typeParameters != null) {
            stringBuffer.append(this.typeParameters);
        }
        if ((string = this.getConstantValue()) != null) {
            stringBuffer.append(" = ");
            stringBuffer.append(string);
        }
        AnnotationItem[] annotationItemArray = this.getAnnoList();
        int n = 0;
        while (n < annotationItemArray.length) {
            stringBuffer.append("\n ");
            stringBuffer.append(annotationItemArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        return object instanceof FieldDescr && this.name == ((FieldDescr)object).name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isCompatible(MemberDescription memberDescription) {
        return this.isCompatible(memberDescription, false);
    }

    public boolean isCompatible(MemberDescription memberDescription, boolean bl) {
        if (!this.equals(memberDescription)) {
            throw new IllegalArgumentException("Only equal members can be checked for compatibility!");
        }
        FieldDescr fieldDescr = (FieldDescr)memberDescription;
        boolean bl2 = this.memberType.isCompatible(this.getModifiers(), fieldDescr.getModifiers());
        if (bl2) {
            boolean bl3 = bl2 = this.type.equals(fieldDescr.type) && SwissKnife.equals(this.typeParameters, fieldDescr.typeParameters);
            if (bl2 && isConstantValuesTracked && !bl) {
                bl2 = SwissKnife.equals(this.constantValue, fieldDescr.constantValue);
            }
        }
        return bl2;
    }

    protected void populateDependences(Set set) {
        this.addDependency(set, this.type);
    }
}

